# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
+    public sealed class EndpointDescriptionAttribute : Attribute, IEndpointDescriptionMetadata {
+        public EndpointDescriptionAttribute(string description);
+        public string Description { get; }
+    }
+    public sealed class EndpointSummaryAttribute : Attribute, IEndpointSummaryMetadata {
+        public EndpointSummaryAttribute(string summary);
+        public string Summary { get; }
+    }
     public static class OpenApiRouteHandlerBuilderExtensions {
+        public static RouteHandlerBuilder WithDescription(this RouteHandlerBuilder builder, string description);
+        public static RouteHandlerBuilder WithSummary(this RouteHandlerBuilder builder, string summary);
     }
     public static class Results {
+        public static IResult Bytes(ReadOnlyMemory<byte> contents, string? contentType = null, string? fileDownloadName = null, bool enableRangeProcessing = false, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static IResult Stream(Func<Stream, Task> streamWriterCallback, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null);
+        public static IResult Stream(PipeReader pipeReader, string? contentType = null, string? fileDownloadName = null, DateTimeOffset? lastModified = default(DateTimeOffset?), EntityTagHeaderValue? entityTag = null, bool enableRangeProcessing = false);
     }
 }
```

