# Microsoft.AspNetCore.Identity

``` diff
 namespace Microsoft.AspNetCore.Identity {
     public class DefaultPersonalDataProtector : IPersonalDataProtector {
-        public virtual string Protect(string data);
+        public virtual string? Protect(string? data);
-        public virtual string Unprotect(string data);
+        public virtual string? Unprotect(string? data);
     }
     public class ExternalLoginInfo : UserLoginInfo {
-        public AuthenticationProperties AuthenticationProperties { get; set; }
+        public AuthenticationProperties? AuthenticationProperties { get; set; }
-        public IEnumerable<AuthenticationToken> AuthenticationTokens { get; set; }
+        public IEnumerable<AuthenticationToken>? AuthenticationTokens { get; set; }
     }
     public class IdentityBuilder {
-        public Type RoleType { get; }
+        public Type? RoleType { get; }
     }
     public class IdentityCookiesBuilder {
-        public OptionsBuilder<CookieAuthenticationOptions> ApplicationCookie { get; set; }
+        public OptionsBuilder<CookieAuthenticationOptions>? ApplicationCookie { get; set; }
-        public OptionsBuilder<CookieAuthenticationOptions> ExternalCookie { get; set; }
+        public OptionsBuilder<CookieAuthenticationOptions>? ExternalCookie { get; set; }
-        public OptionsBuilder<CookieAuthenticationOptions> TwoFactorRememberMeCookie { get; set; }
+        public OptionsBuilder<CookieAuthenticationOptions>? TwoFactorRememberMeCookie { get; set; }
-        public OptionsBuilder<CookieAuthenticationOptions> TwoFactorUserIdCookie { get; set; }
+        public OptionsBuilder<CookieAuthenticationOptions>? TwoFactorUserIdCookie { get; set; }
     }
     public class IdentityErrorDescriber {
-        public virtual IdentityError InvalidEmail(string email);
+        public virtual IdentityError InvalidEmail(string? email);
-        public virtual IdentityError InvalidRoleName(string role);
+        public virtual IdentityError InvalidRoleName(string? role);
-        public virtual IdentityError InvalidUserName(string userName);
+        public virtual IdentityError InvalidUserName(string? userName);
     }
     public class IdentityUserClaim<TKey> where TKey : IEquatable<TKey> {
-        public virtual string ClaimType { get; set; }
+        public virtual string? ClaimType { get; set; }
-        public virtual string ClaimValue { get; set; }
+        public virtual string? ClaimValue { get; set; }
     }
     public class IdentityUserLogin<TKey> where TKey : IEquatable<TKey> {
-        public virtual string ProviderDisplayName { get; set; }
+        public virtual string? ProviderDisplayName { get; set; }
     }
     public class IdentityUserToken<TKey> where TKey : IEquatable<TKey> {
-        public virtual string Value { get; set; }
+        public virtual string? Value { get; set; }
     }
     public interface IPasswordValidator<TUser> where TUser : class {
-        Task<IdentityResult> ValidateAsync(UserManager<TUser> manager, TUser user, string password);
+        Task<IdentityResult> ValidateAsync(UserManager<TUser> manager, TUser user, string? password);
     }
     public interface IRoleStore<TRole> : IDisposable where TRole : class {
-        Task<TRole> FindByIdAsync(string roleId, CancellationToken cancellationToken);
+        Task<TRole?> FindByIdAsync(string roleId, CancellationToken cancellationToken);
-        Task<TRole> FindByNameAsync(string normalizedRoleName, CancellationToken cancellationToken);
+        Task<TRole?> FindByNameAsync(string normalizedRoleName, CancellationToken cancellationToken);
-        Task<string> GetNormalizedRoleNameAsync(TRole role, CancellationToken cancellationToken);
+        Task<string?> GetNormalizedRoleNameAsync(TRole role, CancellationToken cancellationToken);
-        Task<string> GetRoleNameAsync(TRole role, CancellationToken cancellationToken);
+        Task<string?> GetRoleNameAsync(TRole role, CancellationToken cancellationToken);
-        Task SetNormalizedRoleNameAsync(TRole role, string normalizedName, CancellationToken cancellationToken);
+        Task SetNormalizedRoleNameAsync(TRole role, string? normalizedName, CancellationToken cancellationToken);
-        Task SetRoleNameAsync(TRole role, string roleName, CancellationToken cancellationToken);
+        Task SetRoleNameAsync(TRole role, string? roleName, CancellationToken cancellationToken);
     }
     public interface IUserAuthenticationTokenStore<TUser> : IDisposable, IUserStore<TUser> where TUser : class {
-        Task<string> GetTokenAsync(TUser user, string loginProvider, string name, CancellationToken cancellationToken);
+        Task<string?> GetTokenAsync(TUser user, string loginProvider, string name, CancellationToken cancellationToken);
-        Task SetTokenAsync(TUser user, string loginProvider, string name, string value, CancellationToken cancellationToken);
+        Task SetTokenAsync(TUser user, string loginProvider, string name, string? value, CancellationToken cancellationToken);
     }
     public interface IUserAuthenticatorKeyStore<TUser> : IDisposable, IUserStore<TUser> where TUser : class {
-        Task<string> GetAuthenticatorKeyAsync(TUser user, CancellationToken cancellationToken);
+        Task<string?> GetAuthenticatorKeyAsync(TUser user, CancellationToken cancellationToken);
     }
     public interface IUserEmailStore<TUser> : IDisposable, IUserStore<TUser> where TUser : class {
-        Task<TUser> FindByEmailAsync(string normalizedEmail, CancellationToken cancellationToken);
+        Task<TUser?> FindByEmailAsync(string normalizedEmail, CancellationToken cancellationToken);
-        Task<string> GetEmailAsync(TUser user, CancellationToken cancellationToken);
+        Task<string?> GetEmailAsync(TUser user, CancellationToken cancellationToken);
-        Task<string> GetNormalizedEmailAsync(TUser user, CancellationToken cancellationToken);
+        Task<string?> GetNormalizedEmailAsync(TUser user, CancellationToken cancellationToken);
-        Task SetEmailAsync(TUser user, string email, CancellationToken cancellationToken);
+        Task SetEmailAsync(TUser user, string? email, CancellationToken cancellationToken);
-        Task SetNormalizedEmailAsync(TUser user, string normalizedEmail, CancellationToken cancellationToken);
+        Task SetNormalizedEmailAsync(TUser user, string? normalizedEmail, CancellationToken cancellationToken);
     }
     public interface IUserLoginStore<TUser> : IDisposable, IUserStore<TUser> where TUser : class {
-        Task<TUser> FindByLoginAsync(string loginProvider, string providerKey, CancellationToken cancellationToken);
+        Task<TUser?> FindByLoginAsync(string loginProvider, string providerKey, CancellationToken cancellationToken);
     }
     public interface IUserPasswordStore<TUser> : IDisposable, IUserStore<TUser> where TUser : class {
-        Task<string> GetPasswordHashAsync(TUser user, CancellationToken cancellationToken);
+        Task<string?> GetPasswordHashAsync(TUser user, CancellationToken cancellationToken);
-        Task SetPasswordHashAsync(TUser user, string passwordHash, CancellationToken cancellationToken);
+        Task SetPasswordHashAsync(TUser user, string? passwordHash, CancellationToken cancellationToken);
     }
     public interface IUserPhoneNumberStore<TUser> : IDisposable, IUserStore<TUser> where TUser : class {
-        Task<string> GetPhoneNumberAsync(TUser user, CancellationToken cancellationToken);
+        Task<string?> GetPhoneNumberAsync(TUser user, CancellationToken cancellationToken);
-        Task SetPhoneNumberAsync(TUser user, string phoneNumber, CancellationToken cancellationToken);
+        Task SetPhoneNumberAsync(TUser user, string? phoneNumber, CancellationToken cancellationToken);
     }
     public interface IUserSecurityStampStore<TUser> : IDisposable, IUserStore<TUser> where TUser : class {
-        Task<string> GetSecurityStampAsync(TUser user, CancellationToken cancellationToken);
+        Task<string?> GetSecurityStampAsync(TUser user, CancellationToken cancellationToken);
     }
     public interface IUserStore<TUser> : IDisposable where TUser : class {
-        Task<TUser> FindByIdAsync(string userId, CancellationToken cancellationToken);
+        Task<TUser?> FindByIdAsync(string userId, CancellationToken cancellationToken);
-        Task<TUser> FindByNameAsync(string normalizedUserName, CancellationToken cancellationToken);
+        Task<TUser?> FindByNameAsync(string normalizedUserName, CancellationToken cancellationToken);
-        Task<string> GetNormalizedUserNameAsync(TUser user, CancellationToken cancellationToken);
+        Task<string?> GetNormalizedUserNameAsync(TUser user, CancellationToken cancellationToken);
-        Task<string> GetUserNameAsync(TUser user, CancellationToken cancellationToken);
+        Task<string?> GetUserNameAsync(TUser user, CancellationToken cancellationToken);
-        Task SetNormalizedUserNameAsync(TUser user, string normalizedName, CancellationToken cancellationToken);
+        Task SetNormalizedUserNameAsync(TUser user, string? normalizedName, CancellationToken cancellationToken);
-        Task SetUserNameAsync(TUser user, string userName, CancellationToken cancellationToken);
+        Task SetUserNameAsync(TUser user, string? userName, CancellationToken cancellationToken);
     }
     public class PasswordHasher<TUser> : IPasswordHasher<TUser> where TUser : class {
-        public PasswordHasher(IOptions<PasswordHasherOptions> optionsAccessor = null);
+        public PasswordHasher(IOptions<PasswordHasherOptions>? optionsAccessor = null);
     }
     public class PasswordValidator<TUser> : IPasswordValidator<TUser> where TUser : class {
-        public PasswordValidator(IdentityErrorDescriber errors = null);
+        public PasswordValidator(IdentityErrorDescriber? errors = null);
-        public virtual Task<IdentityResult> ValidateAsync(UserManager<TUser> manager, TUser user, string password);
+        public virtual Task<IdentityResult> ValidateAsync(UserManager<TUser> manager, TUser user, string? password);
     }
     public class RoleManager<TRole> : IDisposable where TRole : class {
-        public virtual Task<TRole> FindByIdAsync(string roleId);
+        public virtual Task<TRole?> FindByIdAsync(string roleId);
-        public virtual Task<TRole> FindByNameAsync(string roleName);
+        public virtual Task<TRole?> FindByNameAsync(string roleName);
-        public virtual Task<string> GetRoleNameAsync(TRole role);
+        public virtual Task<string?> GetRoleNameAsync(TRole role);
-        public virtual string NormalizeKey(string key);
+        public virtual string? NormalizeKey(string? key);
-        public virtual Task<IdentityResult> SetRoleNameAsync(TRole role, string name);
+        public virtual Task<IdentityResult> SetRoleNameAsync(TRole role, string? name);
     }
     public abstract class RoleStoreBase<TRole, TKey, TUserRole, TRoleClaim> : IDisposable, IQueryableRoleStore<TRole>, IRoleClaimStore<TRole>, IRoleStore<TRole> where TRole : IdentityRole<TKey> where TKey : IEquatable<TKey> where TUserRole : IdentityUserRole<TKey>, new() where TRoleClaim : IdentityRoleClaim<TKey>, new() {
-        public virtual TKey ConvertIdFromString(string id);
+        public virtual TKey? ConvertIdFromString(string? id);
-        public virtual string ConvertIdToString(TKey id);
+        public virtual string? ConvertIdToString(TKey id);
-        public abstract Task<TRole> FindByIdAsync(string id, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract Task<TRole?> FindByIdAsync(string id, CancellationToken cancellationToken = default(CancellationToken));
-        public abstract Task<TRole> FindByNameAsync(string normalizedName, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract Task<TRole?> FindByNameAsync(string normalizedName, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<string> GetNormalizedRoleNameAsync(TRole role, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetNormalizedRoleNameAsync(TRole role, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<string> GetRoleNameAsync(TRole role, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetRoleNameAsync(TRole role, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task SetNormalizedRoleNameAsync(TRole role, string normalizedName, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task SetNormalizedRoleNameAsync(TRole role, string? normalizedName, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task SetRoleNameAsync(TRole role, string roleName, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task SetRoleNameAsync(TRole role, string? roleName, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class RoleValidator<TRole> : IRoleValidator<TRole> where TRole : class {
-        public RoleValidator(IdentityErrorDescriber errors = null);
+        public RoleValidator(IdentityErrorDescriber? errors = null);
     }
     public class SecurityStampValidator<TUser> : ISecurityStampValidator where TUser : class {
-        protected virtual Task<TUser> VerifySecurityStamp(ClaimsPrincipal principal);
+        protected virtual Task<TUser?> VerifySecurityStamp(ClaimsPrincipal? principal);
     }
     public class SecurityStampValidatorOptions {
-        public Func<SecurityStampRefreshingPrincipalContext, Task> OnRefreshingPrincipal { get; set; }
+        public Func<SecurityStampRefreshingPrincipalContext, Task>? OnRefreshingPrincipal { get; set; }
     }
     public class SignInManager<TUser> where TUser : class {
-        public virtual AuthenticationProperties ConfigureExternalAuthenticationProperties(string provider, string redirectUrl, string userId = null);
+        public virtual AuthenticationProperties ConfigureExternalAuthenticationProperties(string? provider, string? redirectUrl, string? userId = null);
-        public virtual Task<ExternalLoginInfo> GetExternalLoginInfoAsync(string expectedXsrf = null);
+        public virtual Task<ExternalLoginInfo?> GetExternalLoginInfoAsync(string? expectedXsrf = null);
-        public virtual Task<TUser> GetTwoFactorAuthenticationUserAsync();
+        public virtual Task<TUser?> GetTwoFactorAuthenticationUserAsync();
-        protected virtual Task<SignInResult> PreSignInCheck(TUser user);
+        protected virtual Task<SignInResult?> PreSignInCheck(TUser user);
-        public virtual Task SignInAsync(TUser user, AuthenticationProperties authenticationProperties, string authenticationMethod = null);
+        public virtual Task SignInAsync(TUser user, AuthenticationProperties authenticationProperties, string? authenticationMethod = null);
-        public virtual Task SignInAsync(TUser user, bool isPersistent, string authenticationMethod = null);
+        public virtual Task SignInAsync(TUser user, bool isPersistent, string? authenticationMethod = null);
-        protected virtual Task<SignInResult> SignInOrTwoFactorAsync(TUser user, bool isPersistent, string loginProvider = null, bool bypassTwoFactor = false);
+        protected virtual Task<SignInResult> SignInOrTwoFactorAsync(TUser user, bool isPersistent, string? loginProvider = null, bool bypassTwoFactor = false);
-        public virtual Task SignInWithClaimsAsync(TUser user, AuthenticationProperties authenticationProperties, IEnumerable<Claim> additionalClaims);
+        public virtual Task SignInWithClaimsAsync(TUser user, AuthenticationProperties? authenticationProperties, IEnumerable<Claim> additionalClaims);
-        public virtual Task<TUser> ValidateSecurityStampAsync(ClaimsPrincipal principal);
+        public virtual Task<TUser?> ValidateSecurityStampAsync(ClaimsPrincipal? principal);
-        public virtual Task<bool> ValidateSecurityStampAsync(TUser user, string securityStamp);
+        public virtual Task<bool> ValidateSecurityStampAsync(TUser? user, string? securityStamp);
-        public virtual Task<TUser> ValidateTwoFactorSecurityStampAsync(ClaimsPrincipal principal);
+        public virtual Task<TUser?> ValidateTwoFactorSecurityStampAsync(ClaimsPrincipal? principal);
     }
     public class TokenProviderDescriptor {
-        public object ProviderInstance { get; set; }
+        public object? ProviderInstance { get; set; }
     }
     public class TwoFactorSecurityStampValidator<TUser> : SecurityStampValidator<TUser>, ISecurityStampValidator, ITwoFactorSecurityStampValidator where TUser : class {
-        protected override Task<TUser> VerifySecurityStamp(ClaimsPrincipal principal);
+        protected override Task<TUser?> VerifySecurityStamp(ClaimsPrincipal? principal);
     }
     public sealed class UpperInvariantLookupNormalizer : ILookupNormalizer {
-        public string NormalizeEmail(string email);
+        public string? NormalizeEmail(string? email);
-        public string NormalizeName(string name);
+        public string? NormalizeName(string? name);
     }
     public class UserLoginInfo {
-        public UserLoginInfo(string loginProvider, string providerKey, string displayName);
+        public UserLoginInfo(string loginProvider, string providerKey, string? displayName);
-        public string ProviderDisplayName { get; set; }
+        public string? ProviderDisplayName { get; set; }
     }
     public class UserManager<TUser> : IDisposable where TUser : class {
-        public virtual Task<TUser> FindByEmailAsync(string email);
+        public virtual Task<TUser?> FindByEmailAsync(string email);
-        public virtual Task<TUser> FindByIdAsync(string userId);
+        public virtual Task<TUser?> FindByIdAsync(string userId);
-        public virtual Task<TUser> FindByLoginAsync(string loginProvider, string providerKey);
+        public virtual Task<TUser?> FindByLoginAsync(string loginProvider, string providerKey);
-        public virtual Task<TUser> FindByNameAsync(string userName);
+        public virtual Task<TUser?> FindByNameAsync(string userName);
-        public virtual Task<IEnumerable<string>> GenerateNewTwoFactorRecoveryCodesAsync(TUser user, int number);
+        public virtual Task<IEnumerable<string>?> GenerateNewTwoFactorRecoveryCodesAsync(TUser user, int number);
-        public virtual Task<string> GetAuthenticationTokenAsync(TUser user, string loginProvider, string tokenName);
+        public virtual Task<string?> GetAuthenticationTokenAsync(TUser user, string loginProvider, string tokenName);
-        public virtual Task<string> GetAuthenticatorKeyAsync(TUser user);
+        public virtual Task<string?> GetAuthenticatorKeyAsync(TUser user);
-        public virtual Task<string> GetEmailAsync(TUser user);
+        public virtual Task<string?> GetEmailAsync(TUser user);
-        public virtual Task<string> GetPhoneNumberAsync(TUser user);
+        public virtual Task<string?> GetPhoneNumberAsync(TUser user);
-        public virtual Task<TUser> GetUserAsync(ClaimsPrincipal principal);
+        public virtual Task<TUser?> GetUserAsync(ClaimsPrincipal principal);
-        public virtual string GetUserId(ClaimsPrincipal principal);
+        public virtual string? GetUserId(ClaimsPrincipal principal);
-        public virtual string GetUserName(ClaimsPrincipal principal);
+        public virtual string? GetUserName(ClaimsPrincipal principal);
-        public virtual Task<string> GetUserNameAsync(TUser user);
+        public virtual Task<string?> GetUserNameAsync(TUser user);
-        public virtual string NormalizeEmail(string email);
+        public virtual string? NormalizeEmail(string? email);
-        public virtual string NormalizeName(string name);
+        public virtual string? NormalizeName(string? name);
-        public virtual Task<IdentityResult> SetAuthenticationTokenAsync(TUser user, string loginProvider, string tokenName, string tokenValue);
+        public virtual Task<IdentityResult> SetAuthenticationTokenAsync(TUser user, string loginProvider, string tokenName, string? tokenValue);
-        public virtual Task<IdentityResult> SetEmailAsync(TUser user, string email);
+        public virtual Task<IdentityResult> SetEmailAsync(TUser user, string? email);
-        public virtual Task<IdentityResult> SetPhoneNumberAsync(TUser user, string phoneNumber);
+        public virtual Task<IdentityResult> SetPhoneNumberAsync(TUser user, string? phoneNumber);
-        public virtual Task<IdentityResult> SetUserNameAsync(TUser user, string userName);
+        public virtual Task<IdentityResult> SetUserNameAsync(TUser user, string? userName);
-        protected Task<IdentityResult> ValidatePasswordAsync(TUser user, string password);
+        protected Task<IdentityResult> ValidatePasswordAsync(TUser user, string? password);
     }
     public abstract class UserStoreBase<TUser, TKey, TUserClaim, TUserLogin, TUserToken> : IDisposable, IQueryableUserStore<TUser>, IUserAuthenticationTokenStore<TUser>, IUserAuthenticatorKeyStore<TUser>, IUserClaimStore<TUser>, IUserEmailStore<TUser>, IUserLockoutStore<TUser>, IUserLoginStore<TUser>, IUserPasswordStore<TUser>, IUserPhoneNumberStore<TUser>, IUserSecurityStampStore<TUser>, IUserStore<TUser>, IUserTwoFactorRecoveryCodeStore<TUser>, IUserTwoFactorStore<TUser> where TUser : IdentityUser<TKey> where TKey : IEquatable<TKey> where TUserClaim : IdentityUserClaim<TKey>, new() where TUserLogin : IdentityUserLogin<TKey>, new() where TUserToken : IdentityUserToken<TKey>, new() {
-        public virtual TKey ConvertIdFromString(string id);
+        public virtual TKey? ConvertIdFromString(string? id);
-        public virtual string ConvertIdToString(TKey id);
+        public virtual string? ConvertIdToString(TKey id);
-        protected virtual TUserToken CreateUserToken(TUser user, string loginProvider, string name, string value);
+        protected virtual TUserToken CreateUserToken(TUser user, string loginProvider, string name, string? value);
-        public abstract Task<TUser> FindByEmailAsync(string normalizedEmail, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract Task<TUser?> FindByEmailAsync(string normalizedEmail, CancellationToken cancellationToken = default(CancellationToken));
-        public abstract Task<TUser> FindByIdAsync(string userId, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract Task<TUser?> FindByIdAsync(string userId, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<TUser> FindByLoginAsync(string loginProvider, string providerKey, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<TUser?> FindByLoginAsync(string loginProvider, string providerKey, CancellationToken cancellationToken = default(CancellationToken));
-        public abstract Task<TUser> FindByNameAsync(string normalizedUserName, CancellationToken cancellationToken = default(CancellationToken));
+        public abstract Task<TUser?> FindByNameAsync(string normalizedUserName, CancellationToken cancellationToken = default(CancellationToken));
-        protected abstract Task<TUserToken> FindTokenAsync(TUser user, string loginProvider, string name, CancellationToken cancellationToken);
+        protected abstract Task<TUserToken?> FindTokenAsync(TUser user, string loginProvider, string name, CancellationToken cancellationToken);
-        protected abstract Task<TUser> FindUserAsync(TKey userId, CancellationToken cancellationToken);
+        protected abstract Task<TUser?> FindUserAsync(TKey userId, CancellationToken cancellationToken);
-        protected abstract Task<TUserLogin> FindUserLoginAsync(string loginProvider, string providerKey, CancellationToken cancellationToken);
+        protected abstract Task<TUserLogin?> FindUserLoginAsync(string loginProvider, string providerKey, CancellationToken cancellationToken);
-        protected abstract Task<TUserLogin> FindUserLoginAsync(TKey userId, string loginProvider, string providerKey, CancellationToken cancellationToken);
+        protected abstract Task<TUserLogin?> FindUserLoginAsync(TKey userId, string loginProvider, string providerKey, CancellationToken cancellationToken);
-        public virtual Task<string> GetAuthenticatorKeyAsync(TUser user, CancellationToken cancellationToken);
+        public virtual Task<string?> GetAuthenticatorKeyAsync(TUser user, CancellationToken cancellationToken);
-        public virtual Task<string> GetEmailAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetEmailAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<string> GetNormalizedEmailAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetNormalizedEmailAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<string> GetNormalizedUserNameAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetNormalizedUserNameAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<string> GetPasswordHashAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetPasswordHashAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<string> GetPhoneNumberAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetPhoneNumberAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<string> GetSecurityStampAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetSecurityStampAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task<string> GetTokenAsync(TUser user, string loginProvider, string name, CancellationToken cancellationToken);
+        public virtual Task<string?> GetTokenAsync(TUser user, string loginProvider, string name, CancellationToken cancellationToken);
-        public virtual Task<string> GetUserNameAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task<string?> GetUserNameAsync(TUser user, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task SetEmailAsync(TUser user, string email, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task SetEmailAsync(TUser user, string? email, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task SetNormalizedEmailAsync(TUser user, string normalizedEmail, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task SetNormalizedEmailAsync(TUser user, string? normalizedEmail, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task SetNormalizedUserNameAsync(TUser user, string normalizedName, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task SetNormalizedUserNameAsync(TUser user, string? normalizedName, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task SetPasswordHashAsync(TUser user, string passwordHash, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task SetPasswordHashAsync(TUser user, string? passwordHash, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task SetPhoneNumberAsync(TUser user, string phoneNumber, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task SetPhoneNumberAsync(TUser user, string? phoneNumber, CancellationToken cancellationToken = default(CancellationToken));
-        public virtual Task SetTokenAsync(TUser user, string loginProvider, string name, string value, CancellationToken cancellationToken);
+        public virtual Task SetTokenAsync(TUser user, string loginProvider, string name, string? value, CancellationToken cancellationToken);
-        public virtual Task SetUserNameAsync(TUser user, string userName, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task SetUserNameAsync(TUser user, string? userName, CancellationToken cancellationToken = default(CancellationToken));
     }
     public abstract class UserStoreBase<TUser, TRole, TKey, TUserClaim, TUserRole, TUserLogin, TUserToken, TRoleClaim> : UserStoreBase<TUser, TKey, TUserClaim, TUserLogin, TUserToken>, IDisposable, IUserRoleStore<TUser>, IUserStore<TUser> where TUser : IdentityUser<TKey> where TRole : IdentityRole<TKey> where TKey : IEquatable<TKey> where TUserClaim : IdentityUserClaim<TKey>, new() where TUserRole : IdentityUserRole<TKey>, new() where TUserLogin : IdentityUserLogin<TKey>, new() where TUserToken : IdentityUserToken<TKey>, new() where TRoleClaim : IdentityRoleClaim<TKey>, new() {
-        protected abstract Task<TRole> FindRoleAsync(string normalizedRoleName, CancellationToken cancellationToken);
+        protected abstract Task<TRole?> FindRoleAsync(string normalizedRoleName, CancellationToken cancellationToken);
-        protected abstract Task<TUserRole> FindUserRoleAsync(TKey userId, TKey roleId, CancellationToken cancellationToken);
+        protected abstract Task<TUserRole?> FindUserRoleAsync(TKey userId, TKey roleId, CancellationToken cancellationToken);
     }
     public class UserValidator<TUser> : IUserValidator<TUser> where TUser : class {
-        public UserValidator(IdentityErrorDescriber errors = null);
+        public UserValidator(IdentityErrorDescriber? errors = null);
     }
 }
```

