# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
     public class OAuthPostConfigureOptions<TOptions, THandler> : IPostConfigureOptions<TOptions> where TOptions : OAuthOptions, new() where THandler : OAuthHandler<TOptions> {
-        public void PostConfigure(string name, TOptions options);
+        public void PostConfigure(string? name, TOptions options);
     }
     public static class OptionsBuilderConfigurationExtensions {
-        public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config, Action<BinderOptions> configureBinder) where TOptions : class;
+        public static OptionsBuilder<TOptions> Bind<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
-        public static OptionsBuilder<TOptions> BindConfiguration<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, string configSectionPath, Action<BinderOptions> configureBinder = null) where TOptions : class;
+        public static OptionsBuilder<TOptions> BindConfiguration<TOptions>(this OptionsBuilder<TOptions> optionsBuilder, string configSectionPath, Action<BinderOptions>? configureBinder = null) where TOptions : class;
     }
     public static class OptionsConfigurationServiceCollectionExtensions {
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config, Action<BinderOptions> configureBinder) where TOptions : class;
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string name, IConfiguration config) where TOptions : class;
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, IConfiguration config) where TOptions : class;
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string name, IConfiguration config, Action<BinderOptions> configureBinder) where TOptions : class;
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, IConfiguration config, Action<BinderOptions>? configureBinder) where TOptions : class;
     }
     public static class OptionsServiceCollectionExtensions {
-        public static OptionsBuilder<TOptions> AddOptions<TOptions>(this IServiceCollection services, string name) where TOptions : class;
+        public static OptionsBuilder<TOptions> AddOptions<TOptions>(this IServiceCollection services, string? name) where TOptions : class;
-        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string name, Action<TOptions> configureOptions) where TOptions : class;
+        public static IServiceCollection Configure<TOptions>(this IServiceCollection services, string? name, Action<TOptions> configureOptions) where TOptions : class;
-        public static IServiceCollection PostConfigure<TOptions>(this IServiceCollection services, string name, Action<TOptions> configureOptions) where TOptions : class;
+        public static IServiceCollection PostConfigure<TOptions>(this IServiceCollection services, string? name, Action<TOptions> configureOptions) where TOptions : class;
     }
     public sealed class ServiceProvider : IAsyncDisposable, IDisposable, IServiceProvider {
-        public object GetService(Type serviceType);
+        public object? GetService(Type serviceType);
     }
 }
```

