# Microsoft.AspNetCore.DataProtection

``` diff
 namespace Microsoft.AspNetCore.DataProtection {
     public static class DataProtectionAdvancedExtensions {
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         public static byte[] Protect(this ITimeLimitedDataProtector protector, byte[] plaintext, TimeSpan lifetime);
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         public static string Protect(this ITimeLimitedDataProtector protector, string plaintext, DateTimeOffset expiration);
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         public static string Protect(this ITimeLimitedDataProtector protector, string plaintext, TimeSpan lifetime);
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         public static string Unprotect(this ITimeLimitedDataProtector protector, string protectedData, out DateTimeOffset expiration);
     }
     public static class DataProtectionCommonExtensions {
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         public static string Protect(this IDataProtector protector, string plaintext);
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         public static string Unprotect(this IDataProtector protector, string protectedData);
     }
     public interface IDataProtector : IDataProtectionProvider {
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         byte[] Protect(byte[] plaintext);
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         byte[] Unprotect(byte[] protectedData);
     }
     public interface IPersistedDataProtector : IDataProtectionProvider, IDataProtector {
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         byte[] DangerousUnprotect(byte[] protectedData, bool ignoreRevocationErrors, out bool requiresMigration, out bool wasRevoked);
     }
     public interface ITimeLimitedDataProtector : IDataProtectionProvider, IDataProtector {
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         byte[] Protect(byte[] plaintext, DateTimeOffset expiration);
-        [RequiresUnreferencedCode(TrimmerWarning.Message)]
         byte[] Unprotect(byte[] protectedData, out DateTimeOffset expiration);
     }
 }
```

