# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     public abstract class AxHost : Control, ICustomTypeDescriptor, ISupportInitialize {
         public class State : ISerializable {
-            public State(Stream ms, int storageType, bool manualUpdate, string licKey);
+            public State(Stream ms, int storageType, bool manualUpdate, string? licKey);
         }
     }
-    public struct BindingMemberInfo {
+    public struct BindingMemberInfo : IEquatable<BindingMemberInfo> {
+        public bool Equals(BindingMemberInfo other);
     }
     public class ContextMenuStrip : ToolStripDropDownMenu {
-        public Control SourceControl { get; }
+        public Control? SourceControl { get; }
     }
     public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle, IKeyboardToolTip, Interop.Ole32.IOleControl, Interop.Ole32.IOleInPlaceActiveObject, Interop.Ole32.IOleInPlaceObject, Interop.Ole32.IOleObject, Interop.Ole32.IOleWindow, Interop.Ole32.IPersist, Interop.Ole32.IPersistStorage, Interop.Ole32.IPersistStreamInit, Interop.Ole32.IQuickActivate, Interop.Ole32.IViewObject, Interop.Ole32.IViewObject2, Interop.Oleaut32.IPersistPropertyBag, ISupportOleDropSource, ISynchronizeInvoke, IWin32Window {
-        public Control(string text);
+        public Control(string? text);
-        public Control(string text, int left, int top, int width, int height);
+        public Control(string? text, int left, int top, int width, int height);
-        public Control(Control parent, string text);
+        public Control(Control? parent, string? text);
-        public Control(Control parent, string text, int left, int top, int width, int height);
+        public Control(Control? parent, string? text, int left, int top, int width, int height);
-        public string AccessibleDefaultActionDescription { get; set; }
+        public string? AccessibleDefaultActionDescription { get; set; }
-        public string AccessibleDescription { get; set; }
+        public string? AccessibleDescription { get; set; }
-        public string AccessibleName { get; set; }
+        public string? AccessibleName { get; set; }
-        public virtual Image BackgroundImage { get; set; }
+        public virtual Image? BackgroundImage { get; set; }
-        public virtual BindingContext BindingContext { get; set; }
+        public virtual BindingContext? BindingContext { get; set; }
-        public virtual ContextMenuStrip ContextMenuStrip { get; set; }
+        public virtual ContextMenuStrip? ContextMenuStrip { get; set; }
         public virtual Cursor Cursor { get; set; }
         public virtual Font Font { get; set; }
-        public event EventHandler AutoSizeChanged;
+        public event EventHandler? AutoSizeChanged;
-        public event EventHandler BackColorChanged;
+        public event EventHandler? BackColorChanged;
-        public event EventHandler BackgroundImageChanged;
+        public event EventHandler? BackgroundImageChanged;
-        public event EventHandler BackgroundImageLayoutChanged;
+        public event EventHandler? BackgroundImageLayoutChanged;
-        public event EventHandler BindingContextChanged;
+        public event EventHandler? BindingContextChanged;
-        public event EventHandler CausesValidationChanged;
+        public event EventHandler? CausesValidationChanged;
-        public event EventHandler ClientSizeChanged;
+        public event EventHandler? ClientSizeChanged;
-        public event EventHandler ContextMenuStripChanged;
+        public event EventHandler? ContextMenuStripChanged;
-        public event EventHandler CursorChanged;
+        public event EventHandler? CursorChanged;
-        public event EventHandler DockChanged;
+        public event EventHandler? DockChanged;
-        public event EventHandler EnabledChanged;
+        public event EventHandler? EnabledChanged;
-        public event EventHandler FontChanged;
+        public event EventHandler? FontChanged;
-        public event EventHandler ForeColorChanged;
+        public event EventHandler? ForeColorChanged;
-        protected virtual AccessibleObject GetAccessibilityObjectById(int objectId);
+        protected virtual AccessibleObject? GetAccessibilityObjectById(int objectId);
-        public bool SelectNextControl(Control ctl, bool forward, bool tabStopOnly, bool nested, bool wrap);
+        public bool SelectNextControl(Control? ctl, bool forward, bool tabStopOnly, bool nested, bool wrap);
     }
     public sealed class DataGridViewAdvancedBorderStyle : ICloneable {
-        public override bool Equals(object other);
+        public override bool Equals(object? other);
     }
     public class Form : ContainerControl {
+        protected override void OnGotFocus(EventArgs e);
     }
     public class Label : Control, IAutomationLiveRegion {
         public override string Text { get; set; }
     }
-    public struct LinkArea {
+    public struct LinkArea : IEquatable<LinkArea> {
-        public override bool Equals(object o);
+        public override bool Equals(object? o);
+        public bool Equals(LinkArea other);
         public class LinkAreaConverter : TypeConverter {
-            public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+            public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
-            public override object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
+            public override object CreateInstance(ITypeDescriptorContext? context, IDictionary propertyValues);
-            public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+            public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext? context, object value, Attribute[]? attributes);
         }
     }
     public class ListBox : ListControl {
         public override Font Font { get; set; }
     }
     public class ListView : Control {
         public class CheckedListViewItemCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object IList.this[int index] { get; set; }
         }
         public class SelectedListViewItemCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object IList.this[int index] { get; set; }
         }
     }
     public class ListViewHitTestInfo {
         public ListViewItem Item { get; }
         public ListViewHitTestLocations Location { get; }
         public ListViewItem.ListViewSubItem SubItem { get; }
     }
-    public struct Message {
+    public struct Message : IEquatable<Message> {
+        public bool Equals(Message other);
     }
     public sealed class NotifyIcon : Component {
         public string Text { get; set; }
     }
-    public struct Padding {
+    public struct Padding : IEquatable<Padding> {
+        public bool Equals(Padding other);
     }
     public class PrintPreviewDialog : Form {
         public override Cursor Cursor { get; set; }
         public override Font Font { get; set; }
     }
     public class ProgressBar : Control {
         public override Font Font { get; set; }
     }
     public abstract class ScrollBar : Control {
         public override Font Font { get; set; }
     }
     public class Splitter : Control {
         public override Font Font { get; set; }
     }
     public class TabControl : Control {
         public class TabPageCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object IList.this[int index] { get; set; }
         }
     }
-    public struct TableLayoutPanelCellPosition {
+    public struct TableLayoutPanelCellPosition : IEquatable<TableLayoutPanelCellPosition> {
+        public bool Equals(TableLayoutPanelCellPosition other);
     }
     public class TabPage : Panel {
         public string ImageKey { get; set; }
         public override string Text { get; set; }
         public string ToolTipText { get; set; }
     }
     public class ToolStripContentPanel : Panel {
         public new string Name { get; set; }
     }
     public class ToolStripDropDownMenu : ToolStripDropDown {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     public class TrackBar : Control, ISupportInitialize {
         public override Font Font { get; set; }
     }
     public class TreeViewImageIndexConverter : ImageIndexConverter {
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
     }
     public class TreeViewImageKeyConverter : ImageKeyConverter {
-        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object? ConvertTo(ITypeDescriptorContext? context, CultureInfo? culture, object? value, Type destinationType);
     }
     public abstract class UpDownBase : ContainerControl {
-        public override Image BackgroundImage { get; set; }
+        public override Image? BackgroundImage { get; set; }
-        public override ContextMenuStrip ContextMenuStrip { get; set; }
+        public override ContextMenuStrip? ContextMenuStrip { get; set; }
         public override string Text { get; set; }
-        public new event EventHandler AutoSizeChanged;
+        public new event EventHandler? AutoSizeChanged;
-        public new event EventHandler BackgroundImageChanged;
+        public new event EventHandler? BackgroundImageChanged;
-        public new event EventHandler BackgroundImageLayoutChanged;
+        public new event EventHandler? BackgroundImageLayoutChanged;
-        public new event EventHandler MouseEnter;
+        public new event EventHandler? MouseEnter;
-        public new event EventHandler MouseHover;
+        public new event EventHandler? MouseHover;
-        public new event EventHandler MouseLeave;
+        public new event EventHandler? MouseLeave;
-        public new event MouseEventHandler MouseMove;
+        public new event MouseEventHandler? MouseMove;
-        protected virtual void OnChanged(object source, EventArgs e);
+        protected virtual void OnChanged(object? source, EventArgs e);
-        protected virtual void OnTextBoxKeyDown(object source, KeyEventArgs e);
+        protected virtual void OnTextBoxKeyDown(object? source, KeyEventArgs e);
-        protected virtual void OnTextBoxKeyPress(object source, KeyPressEventArgs e);
+        protected virtual void OnTextBoxKeyPress(object? source, KeyPressEventArgs e);
-        protected virtual void OnTextBoxLostFocus(object source, EventArgs e);
+        protected virtual void OnTextBoxLostFocus(object? source, EventArgs e);
-        protected virtual void OnTextBoxResize(object source, EventArgs e);
+        protected virtual void OnTextBoxResize(object? source, EventArgs e);
-        protected virtual void OnTextBoxTextChanged(object source, EventArgs e);
+        protected virtual void OnTextBoxTextChanged(object? source, EventArgs e);
     }
     public class UserControl : ContainerControl {
         public override string Text { get; set; }
     }
 }
```

