# Microsoft.AspNetCore.Mvc

``` diff
 namespace Microsoft.AspNetCore.Mvc {
     [AttributeUsageAttribute(64, AllowMultiple=true, Inherited=true)]
     public sealed class AcceptVerbsAttribute : Attribute, IActionHttpMethodProvider, IRouteTemplateProvider {
-        public string Route { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
+        [StringSyntaxAttribute("Route")]
+        public string Route { [CompilerGeneratedAttribute] get; [CompilerGeneratedAttribute] set; }
     }
     [ControllerAttribute]
     public abstract class ControllerBase {
-        [NonActionAttribute]
-        public Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, IValueProvider valueProvider, params Expression<Func<TModel, object>>[] includeExpressions) where TModel : class;
+        [NonActionAttribute]
+        public Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, IValueProvider valueProvider, params Expression<Func<TModel, object?>>[] includeExpressions) where TModel : class;
-        [AsyncStateMachineAttribute(typeof(ControllerBase.<TryUpdateModelAsync>d__190<>))]
-        [NonActionAttribute]
-        public Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, params Expression<Func<TModel, object>>[] includeExpressions) where TModel : class;
+        [AsyncStateMachineAttribute(typeof(ControllerBase.<TryUpdateModelAsync>d__190<>))]
+        [NonActionAttribute]
+        public Task<bool> TryUpdateModelAsync<TModel>(TModel model, string prefix, params Expression<Func<TModel, object?>>[] includeExpressions) where TModel : class;
     }
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
-    public class DisableRequestSizeLimitAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public class DisableRequestSizeLimitAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter, IRequestSizeLimitMetadata {
+        long? Microsoft.AspNetCore.Http.Metadata.IRequestSizeLimitMetadata.MaxRequestBodySize { get; }
     }
     public class HttpDeleteAttribute : HttpMethodAttribute {
-        public HttpDeleteAttribute(string template);
+        public HttpDeleteAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpGetAttribute : HttpMethodAttribute {
-        public HttpGetAttribute(string template);
+        public HttpGetAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpHeadAttribute : HttpMethodAttribute {
-        public HttpHeadAttribute(string template);
+        public HttpHeadAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpOptionsAttribute : HttpMethodAttribute {
-        public HttpOptionsAttribute(string template);
+        public HttpOptionsAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpPatchAttribute : HttpMethodAttribute {
-        public HttpPatchAttribute(string template);
+        public HttpPatchAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpPostAttribute : HttpMethodAttribute {
-        public HttpPostAttribute(string template);
+        public HttpPostAttribute([StringSyntaxAttribute("Route")] string template);
     }
     public class HttpPutAttribute : HttpMethodAttribute {
-        public HttpPutAttribute(string template);
+        public HttpPutAttribute([StringSyntaxAttribute("Route")] string template);
     }
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
-    public class RequestSizeLimitAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public class RequestSizeLimitAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter, IRequestSizeLimitMetadata {
+        long? Microsoft.AspNetCore.Http.Metadata.IRequestSizeLimitMetadata.MaxRequestBodySize { get; }
     }
     [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
     public class RouteAttribute : Attribute, IRouteTemplateProvider {
-        public RouteAttribute(string template);
+        public RouteAttribute([StringSyntaxAttribute("Route")] string template);
-        public string Template { [CompilerGeneratedAttribute] get; }
+        [StringSyntaxAttribute("Route")]
+        public string Template { [CompilerGeneratedAttribute] get; }
     }
 }
```

