# Microsoft.AspNetCore.Routing

``` diff
 namespace Microsoft.AspNetCore.Routing {
-    [DebuggerDisplayAttribute("{DebuggerDisplayString,nq}")]
-    public sealed class CompositeEndpointDataSource : EndpointDataSource {
+    [DebuggerDisplayAttribute("{DebuggerDisplayString,nq}")]
+    public sealed class CompositeEndpointDataSource : EndpointDataSource, IDisposable {
+        public void Dispose();
+        public override IReadOnlyList<Endpoint> GetEndpointGroup(RouteGroupContext context);
     }
-    public sealed class DefaultEndpointDataSource : EndpointDataSource
+    [DebuggerDisplayAttribute("{DebuggerDisplayString,nq}")]
+    public sealed class DefaultEndpointDataSource : EndpointDataSource
     public abstract class EndpointDataSource {
+        public virtual IReadOnlyList<Endpoint> GetEndpointGroup(RouteGroupContext context);
     }
-    public sealed class GroupRouteBuilder : IEndpointConventionBuilder, IEndpointRouteBuilder {
-        public RoutePattern GroupPrefix { [CompilerGeneratedAttribute] get; }
-        ICollection<EndpointDataSource> IEndpointRouteBuilder.DataSources { get; }
-        IServiceProvider IEndpointRouteBuilder.ServiceProvider { get; }
-        void IEndpointConventionBuilder.Add(Action<EndpointBuilder> convention);
-        IApplicationBuilder IEndpointRouteBuilder.CreateApplicationBuilder();
-    }
     public static class RequestDelegateRouteBuilderExtensions {
-        public static IRouteBuilder MapDelete(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapDelete(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapDelete(this IRouteBuilder builder, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapDelete(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
-        public static IRouteBuilder MapGet(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapGet(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapGet(this IRouteBuilder builder, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapGet(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
-        public static IRouteBuilder MapMiddlewareDelete(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewareDelete(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewareGet(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewareGet(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewarePost(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewarePost(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewarePut(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewarePut(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewareRoute(this IRouteBuilder builder, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewareRoute(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapMiddlewareVerb(this IRouteBuilder builder, string verb, string template, Action<IApplicationBuilder> action);
+        public static IRouteBuilder MapMiddlewareVerb(this IRouteBuilder builder, string verb, [StringSyntaxAttribute("Route")] string template, Action<IApplicationBuilder> action);
-        public static IRouteBuilder MapPost(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapPost(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapPost(this IRouteBuilder builder, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapPost(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
-        public static IRouteBuilder MapPut(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapPut(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapPut(this IRouteBuilder builder, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapPut(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
-        public static IRouteBuilder MapRoute(this IRouteBuilder builder, string template, RequestDelegate handler);
+        public static IRouteBuilder MapRoute(this IRouteBuilder builder, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapVerb(this IRouteBuilder builder, string verb, string template, RequestDelegate handler);
+        public static IRouteBuilder MapVerb(this IRouteBuilder builder, string verb, [StringSyntaxAttribute("Route")] string template, RequestDelegate handler);
-        public static IRouteBuilder MapVerb(this IRouteBuilder builder, string verb, string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
+        public static IRouteBuilder MapVerb(this IRouteBuilder builder, string verb, [StringSyntaxAttribute("Route")] string template, Func<HttpRequest, HttpResponse, RouteData, Task> handler);
     }
     public class Route : RouteBase {
-        public Route(IRouter target, string routeTemplate, IInlineConstraintResolver inlineConstraintResolver);
+        public Route(IRouter target, [StringSyntaxAttribute("Route")] string routeTemplate, IInlineConstraintResolver inlineConstraintResolver);
-        public Route(IRouter target, string routeTemplate, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens, IInlineConstraintResolver inlineConstraintResolver);
+        public Route(IRouter target, [StringSyntaxAttribute("Route")] string routeTemplate, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens, IInlineConstraintResolver inlineConstraintResolver);
-        public Route(IRouter target, string? routeName, string? routeTemplate, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens, IInlineConstraintResolver inlineConstraintResolver);
+        public Route(IRouter target, string? routeName, [StringSyntaxAttribute("Route")] string? routeTemplate, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens, IInlineConstraintResolver inlineConstraintResolver);
     }
     public abstract class RouteBase : INamedRouter, IRouter {
-        public RouteBase(string? template, string? name, IInlineConstraintResolver constraintResolver, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens);
+        public RouteBase([StringSyntaxAttribute("Route")] string? template, string? name, IInlineConstraintResolver constraintResolver, RouteValueDictionary? defaults, IDictionary<string, object>? constraints, RouteValueDictionary? dataTokens);
     }
     public sealed class RouteEndpointBuilder : EndpointBuilder {
-        public override Endpoint Build();
+        [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="We surface a RequireUnreferencedCode in AddRouteHandlerFilter which is required to call unreferenced code here. The trimmer is unable to infer this.")]
+        public override Endpoint Build();
     }
+    public sealed class RouteGroupBuilder : IEndpointConventionBuilder, IEndpointRouteBuilder {
+        ICollection<EndpointDataSource> Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.DataSources { get; }
+        IServiceProvider Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.ServiceProvider { get; }
+        void IEndpointConventionBuilder.Add(Action<EndpointBuilder> convention);
+        IApplicationBuilder IEndpointRouteBuilder.CreateApplicationBuilder();
+    }
+    public sealed class RouteGroupContext {
+        public RouteGroupContext(RoutePattern prefix, IReadOnlyList<Action<EndpointBuilder>> conventions, IServiceProvider applicationServices);
+        public IServiceProvider ApplicationServices { [CompilerGeneratedAttribute] get; }
+        public IReadOnlyList<Action<EndpointBuilder>> Conventions { [CompilerGeneratedAttribute] get; }
+        public RoutePattern Prefix { [CompilerGeneratedAttribute] get; }
+    }
 }
```

