# System

``` diff
 namespace System {
     public readonly struct Byte : IAdditionOperators<byte, byte, byte>, IAdditiveIdentity<byte, byte>, IBinaryInteger<byte>, IBinaryNumber<byte>, IBitwiseOperators<byte, byte, byte>, IComparable, IComparable<byte>, IComparisonOperators<byte, byte>, IConvertible, IDecrementOperators<byte>, IDivisionOperators<byte, byte, byte>, IEqualityOperators<byte, byte>, IEquatable<byte>, IFormattable, IIncrementOperators<byte>, IMinMaxValue<byte>, IModulusOperators<byte, byte, byte>, IMultiplicativeIdentity<byte, byte>, IMultiplyOperators<byte, byte, byte>, INumber<byte>, INumberBase<byte>, IParsable<byte>, IShiftOperators<byte, byte>, ISpanFormattable, ISpanParsable<byte>, ISubtractionOperators<byte, byte, byte>, IUnaryNegationOperators<byte, byte>, IUnaryPlusOperators<byte, byte>, IUnsignedNumber<byte> {
-        static byte IDivisionOperators<byte, byte, byte>.operator checked /(byte left, byte right);
     }
     public readonly struct Char : IAdditionOperators<char, char, char>, IAdditiveIdentity<char, char>, IBinaryInteger<char>, IBinaryNumber<char>, IBitwiseOperators<char, char, char>, IComparable, IComparable<char>, IComparisonOperators<char, char>, IConvertible, IDecrementOperators<char>, IDivisionOperators<char, char, char>, IEqualityOperators<char, char>, IEquatable<char>, IFormattable, IIncrementOperators<char>, IMinMaxValue<char>, IModulusOperators<char, char, char>, IMultiplicativeIdentity<char, char>, IMultiplyOperators<char, char, char>, INumber<char>, INumberBase<char>, IParsable<char>, IShiftOperators<char, char>, ISpanFormattable, ISpanParsable<char>, ISubtractionOperators<char, char, char>, IUnaryNegationOperators<char, char>, IUnaryPlusOperators<char, char>, IUnsignedNumber<char> {
-        static (char Quotient, char Remainder) IBinaryInteger<char>.DivRem(char left, char right);
-        static char IDivisionOperators<char, char, char>.operator checked /(char left, char right);
-        static char INumber<char>.Clamp(char value, char min, char max);
-        static char INumber<char>.CopySign(char value, char sign);
-        static char INumber<char>.Max(char x, char y);
-        static char INumber<char>.MaxNumber(char x, char y);
-        static char INumber<char>.Min(char x, char y);
-        static char INumber<char>.MinNumber(char x, char y);
-        static int INumber<char>.Sign(char value);
     }
     public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal>, IEquatable<decimal>, IFloatingPoint<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, INumberBase<decimal>, IParsable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParsable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal> {
-        public static decimal operator checked *(decimal left, decimal right);
-        static decimal IAdditionOperators<decimal, decimal, decimal>.operator checked +(decimal left, decimal right);
-        static decimal IDecrementOperators<decimal>.operator checked --(decimal value);
-        static decimal IDivisionOperators<decimal, decimal, decimal>.operator checked /(decimal left, decimal right);
-        static decimal IIncrementOperators<decimal>.operator checked ++(decimal value);
-        static decimal ISubtractionOperators<decimal, decimal, decimal>.operator checked -(decimal left, decimal right);
-        static decimal IUnaryNegationOperators<decimal, decimal>.operator checked -(decimal value);
     }
     public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPointIeee754<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double>, IEquatable<double>, IExponentialFunctions<double>, IFloatingPoint<double>, IFloatingPointIeee754<double>, IFormattable, IHyperbolicFunctions<double>, IIncrementOperators<double>, ILogarithmicFunctions<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, INumberBase<double>, IParsable<double>, IPowerFunctions<double>, IRootFunctions<double>, ISignedNumber<double>, ISpanFormattable, ISpanParsable<double>, ISubtractionOperators<double, double, double>, ITrigonometricFunctions<double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
+        public static double AcosPi(double x);
+        public static double AsinPi(double x);
+        public static double Atan2Pi(double y, double x);
+        public static double AtanPi(double x);
-        public static double CopySign(double x, double y);
+        public static double CopySign(double value, double sign);
+        public static double CosPi(double x);
+        public static double Hypot(double x, double y);
+        public static double Root(double x, int n);
+        public static double SinPi(double x);
-        static double IAdditionOperators<double, double, double>.operator checked +(double left, double right);
-        static double IDecrementOperators<double>.operator checked --(double value);
-        static double IDivisionOperators<double, double, double>.operator checked /(double left, double right);
-        static double IIncrementOperators<double>.operator checked ++(double value);
-        static double IMultiplyOperators<double, double, double>.operator checked *(double left, double right);
-        static double ISubtractionOperators<double, double, double>.operator checked -(double left, double right);
-        static double IUnaryNegationOperators<double, double>.operator checked -(double value);
+        public static double TanPi(double x);
     }
     public enum GCCollectionMode {
+        Aggressive = 3,
     }
     public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPointIeee754<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half>, IEquatable<Half>, IExponentialFunctions<Half>, IFloatingPoint<Half>, IFloatingPointIeee754<Half>, IFormattable, IHyperbolicFunctions<Half>, IIncrementOperators<Half>, ILogarithmicFunctions<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, INumberBase<Half>, IParsable<Half>, IPowerFunctions<Half>, IRootFunctions<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParsable<Half>, ISubtractionOperators<Half, Half, Half>, ITrigonometricFunctions<Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
+        public static Half AcosPi(Half x);
+        public static Half AsinPi(Half x);
+        public static Half Atan2Pi(Half y, Half x);
+        public static Half AtanPi(Half x);
-        public static Half CopySign(Half x, Half y);
+        public static Half CopySign(Half value, Half sign);
+        public static Half CosPi(Half x);
+        public static Half Hypot(Half x, Half y);
+        public static Half Root(Half x, int n);
+        public static Half SinPi(Half x);
-        static Half IAdditionOperators<Half, Half, Half>.operator checked +(Half left, Half right);
-        static Half IDecrementOperators<Half>.operator checked --(Half value);
-        static Half IDivisionOperators<Half, Half, Half>.operator checked /(Half left, Half right);
-        static Half IIncrementOperators<Half>.operator checked ++(Half value);
-        static Half IMultiplyOperators<Half, Half, Half>.operator checked *(Half left, Half right);
-        static Half ISubtractionOperators<Half, Half, Half>.operator checked -(Half left, Half right);
-        static Half IUnaryNegationOperators<Half, Half>.operator checked -(Half value);
+        public static Half TanPi(Half x);
     }
     public readonly struct Int16 : IAdditionOperators<short, short, short>, IAdditiveIdentity<short, short>, IBinaryInteger<short>, IBinaryNumber<short>, IBitwiseOperators<short, short, short>, IComparable, IComparable<short>, IComparisonOperators<short, short>, IConvertible, IDecrementOperators<short>, IDivisionOperators<short, short, short>, IEqualityOperators<short, short>, IEquatable<short>, IFormattable, IIncrementOperators<short>, IMinMaxValue<short>, IModulusOperators<short, short, short>, IMultiplicativeIdentity<short, short>, IMultiplyOperators<short, short, short>, INumber<short>, INumberBase<short>, IParsable<short>, IShiftOperators<short, short>, ISignedNumber<short>, ISpanFormattable, ISpanParsable<short>, ISubtractionOperators<short, short, short>, IUnaryNegationOperators<short, short>, IUnaryPlusOperators<short, short> {
-        static short IDivisionOperators<short, short, short>.operator checked /(short left, short right);
     }
     public readonly struct Int32 : IAdditionOperators<int, int, int>, IAdditiveIdentity<int, int>, IBinaryInteger<int>, IBinaryNumber<int>, IBitwiseOperators<int, int, int>, IComparable, IComparable<int>, IComparisonOperators<int, int>, IConvertible, IDecrementOperators<int>, IDivisionOperators<int, int, int>, IEqualityOperators<int, int>, IEquatable<int>, IFormattable, IIncrementOperators<int>, IMinMaxValue<int>, IModulusOperators<int, int, int>, IMultiplicativeIdentity<int, int>, IMultiplyOperators<int, int, int>, INumber<int>, INumberBase<int>, IParsable<int>, IShiftOperators<int, int>, ISignedNumber<int>, ISpanFormattable, ISpanParsable<int>, ISubtractionOperators<int, int, int>, IUnaryNegationOperators<int, int>, IUnaryPlusOperators<int, int> {
-        static int IDivisionOperators<int, int, int>.operator checked /(int left, int right);
     }
     public readonly struct Int64 : IAdditionOperators<long, long, long>, IAdditiveIdentity<long, long>, IBinaryInteger<long>, IBinaryNumber<long>, IBitwiseOperators<long, long, long>, IComparable, IComparable<long>, IComparisonOperators<long, long>, IConvertible, IDecrementOperators<long>, IDivisionOperators<long, long, long>, IEqualityOperators<long, long>, IEquatable<long>, IFormattable, IIncrementOperators<long>, IMinMaxValue<long>, IModulusOperators<long, long, long>, IMultiplicativeIdentity<long, long>, IMultiplyOperators<long, long, long>, INumber<long>, INumberBase<long>, IParsable<long>, IShiftOperators<long, long>, ISignedNumber<long>, ISpanFormattable, ISpanParsable<long>, ISubtractionOperators<long, long, long>, IUnaryNegationOperators<long, long>, IUnaryPlusOperators<long, long> {
-        static long IDivisionOperators<long, long, long>.operator checked /(long left, long right);
     }
     public readonly struct IntPtr : IAdditionOperators<IntPtr, IntPtr, IntPtr>, IAdditiveIdentity<IntPtr, IntPtr>, IBinaryInteger<IntPtr>, IBinaryNumber<IntPtr>, IBitwiseOperators<IntPtr, IntPtr, IntPtr>, IComparable, IComparable<IntPtr>, IComparisonOperators<IntPtr, IntPtr>, IDecrementOperators<IntPtr>, IDivisionOperators<IntPtr, IntPtr, IntPtr>, IEqualityOperators<IntPtr, IntPtr>, IEquatable<IntPtr>, IFormattable, IIncrementOperators<IntPtr>, IMinMaxValue<IntPtr>, IModulusOperators<IntPtr, IntPtr, IntPtr>, IMultiplicativeIdentity<IntPtr, IntPtr>, IMultiplyOperators<IntPtr, IntPtr, IntPtr>, INumber<IntPtr>, INumberBase<IntPtr>, IParsable<IntPtr>, ISerializable, IShiftOperators<IntPtr, IntPtr>, ISignedNumber<IntPtr>, ISpanFormattable, ISpanParsable<IntPtr>, ISubtractionOperators<IntPtr, IntPtr, IntPtr>, IUnaryNegationOperators<IntPtr, IntPtr>, IUnaryPlusOperators<IntPtr, IntPtr> {
-        static IntPtr IDivisionOperators<IntPtr, IntPtr, IntPtr>.operator checked /(IntPtr left, IntPtr right);
     }
     [CLSCompliantAttribute(false)]
     public readonly struct SByte : IAdditionOperators<sbyte, sbyte, sbyte>, IAdditiveIdentity<sbyte, sbyte>, IBinaryInteger<sbyte>, IBinaryNumber<sbyte>, IBitwiseOperators<sbyte, sbyte, sbyte>, IComparable, IComparable<sbyte>, IComparisonOperators<sbyte, sbyte>, IConvertible, IDecrementOperators<sbyte>, IDivisionOperators<sbyte, sbyte, sbyte>, IEqualityOperators<sbyte, sbyte>, IEquatable<sbyte>, IFormattable, IIncrementOperators<sbyte>, IMinMaxValue<sbyte>, IModulusOperators<sbyte, sbyte, sbyte>, IMultiplicativeIdentity<sbyte, sbyte>, IMultiplyOperators<sbyte, sbyte, sbyte>, INumber<sbyte>, INumberBase<sbyte>, IParsable<sbyte>, IShiftOperators<sbyte, sbyte>, ISignedNumber<sbyte>, ISpanFormattable, ISpanParsable<sbyte>, ISubtractionOperators<sbyte, sbyte, sbyte>, IUnaryNegationOperators<sbyte, sbyte>, IUnaryPlusOperators<sbyte, sbyte> {
-        static sbyte IDivisionOperators<sbyte, sbyte, sbyte>.operator checked /(sbyte left, sbyte right);
     }
     public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPointIeee754<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float>, IEquatable<float>, IExponentialFunctions<float>, IFloatingPoint<float>, IFloatingPointIeee754<float>, IFormattable, IHyperbolicFunctions<float>, IIncrementOperators<float>, ILogarithmicFunctions<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, INumberBase<float>, IParsable<float>, IPowerFunctions<float>, IRootFunctions<float>, ISignedNumber<float>, ISpanFormattable, ISpanParsable<float>, ISubtractionOperators<float, float, float>, ITrigonometricFunctions<float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
+        public static float AcosPi(float x);
+        public static float AsinPi(float x);
+        public static float Atan2Pi(float y, float x);
+        public static float AtanPi(float x);
-        public static float CopySign(float x, float y);
+        public static float CopySign(float value, float sign);
+        public static float CosPi(float x);
+        public static float Hypot(float x, float y);
+        public static float Root(float x, int n);
+        public static float SinPi(float x);
-        static float IAdditionOperators<float, float, float>.operator checked +(float left, float right);
-        static float IDecrementOperators<float>.operator checked --(float value);
-        static float IDivisionOperators<float, float, float>.operator checked /(float left, float right);
-        static float IIncrementOperators<float>.operator checked ++(float value);
-        static float IMultiplyOperators<float, float, float>.operator checked *(float left, float right);
-        static float ISubtractionOperators<float, float, float>.operator checked -(float left, float right);
-        static float IUnaryNegationOperators<float, float>.operator checked -(float value);
+        public static float TanPi(float x);
     }
     [CLSCompliantAttribute(false)]
     public readonly struct UInt16 : IAdditionOperators<ushort, ushort, ushort>, IAdditiveIdentity<ushort, ushort>, IBinaryInteger<ushort>, IBinaryNumber<ushort>, IBitwiseOperators<ushort, ushort, ushort>, IComparable, IComparable<ushort>, IComparisonOperators<ushort, ushort>, IConvertible, IDecrementOperators<ushort>, IDivisionOperators<ushort, ushort, ushort>, IEqualityOperators<ushort, ushort>, IEquatable<ushort>, IFormattable, IIncrementOperators<ushort>, IMinMaxValue<ushort>, IModulusOperators<ushort, ushort, ushort>, IMultiplicativeIdentity<ushort, ushort>, IMultiplyOperators<ushort, ushort, ushort>, INumber<ushort>, INumberBase<ushort>, IParsable<ushort>, IShiftOperators<ushort, ushort>, ISpanFormattable, ISpanParsable<ushort>, ISubtractionOperators<ushort, ushort, ushort>, IUnaryNegationOperators<ushort, ushort>, IUnaryPlusOperators<ushort, ushort>, IUnsignedNumber<ushort> {
-        static ushort IDivisionOperators<ushort, ushort, ushort>.operator checked /(ushort left, ushort right);
     }
     [CLSCompliantAttribute(false)]
     public readonly struct UInt32 : IAdditionOperators<uint, uint, uint>, IAdditiveIdentity<uint, uint>, IBinaryInteger<uint>, IBinaryNumber<uint>, IBitwiseOperators<uint, uint, uint>, IComparable, IComparable<uint>, IComparisonOperators<uint, uint>, IConvertible, IDecrementOperators<uint>, IDivisionOperators<uint, uint, uint>, IEqualityOperators<uint, uint>, IEquatable<uint>, IFormattable, IIncrementOperators<uint>, IMinMaxValue<uint>, IModulusOperators<uint, uint, uint>, IMultiplicativeIdentity<uint, uint>, IMultiplyOperators<uint, uint, uint>, INumber<uint>, INumberBase<uint>, IParsable<uint>, IShiftOperators<uint, uint>, ISpanFormattable, ISpanParsable<uint>, ISubtractionOperators<uint, uint, uint>, IUnaryNegationOperators<uint, uint>, IUnaryPlusOperators<uint, uint>, IUnsignedNumber<uint> {
-        static uint IDivisionOperators<uint, uint, uint>.operator checked /(uint left, uint right);
     }
     [CLSCompliantAttribute(false)]
     public readonly struct UInt64 : IAdditionOperators<ulong, ulong, ulong>, IAdditiveIdentity<ulong, ulong>, IBinaryInteger<ulong>, IBinaryNumber<ulong>, IBitwiseOperators<ulong, ulong, ulong>, IComparable, IComparable<ulong>, IComparisonOperators<ulong, ulong>, IConvertible, IDecrementOperators<ulong>, IDivisionOperators<ulong, ulong, ulong>, IEqualityOperators<ulong, ulong>, IEquatable<ulong>, IFormattable, IIncrementOperators<ulong>, IMinMaxValue<ulong>, IModulusOperators<ulong, ulong, ulong>, IMultiplicativeIdentity<ulong, ulong>, IMultiplyOperators<ulong, ulong, ulong>, INumber<ulong>, INumberBase<ulong>, IParsable<ulong>, IShiftOperators<ulong, ulong>, ISpanFormattable, ISpanParsable<ulong>, ISubtractionOperators<ulong, ulong, ulong>, IUnaryNegationOperators<ulong, ulong>, IUnaryPlusOperators<ulong, ulong>, IUnsignedNumber<ulong> {
-        static ulong IDivisionOperators<ulong, ulong, ulong>.operator checked /(ulong left, ulong right);
     }
     [CLSCompliantAttribute(false)]
     public readonly struct UIntPtr : IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>, IAdditiveIdentity<UIntPtr, UIntPtr>, IBinaryInteger<UIntPtr>, IBinaryNumber<UIntPtr>, IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>, IComparable, IComparable<UIntPtr>, IComparisonOperators<UIntPtr, UIntPtr>, IDecrementOperators<UIntPtr>, IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>, IEqualityOperators<UIntPtr, UIntPtr>, IEquatable<UIntPtr>, IFormattable, IIncrementOperators<UIntPtr>, IMinMaxValue<UIntPtr>, IModulusOperators<UIntPtr, UIntPtr, UIntPtr>, IMultiplicativeIdentity<UIntPtr, UIntPtr>, IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>, INumber<UIntPtr>, INumberBase<UIntPtr>, IParsable<UIntPtr>, ISerializable, IShiftOperators<UIntPtr, UIntPtr>, ISpanFormattable, ISpanParsable<UIntPtr>, ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>, IUnaryNegationOperators<UIntPtr, UIntPtr>, IUnaryPlusOperators<UIntPtr, UIntPtr>, IUnsignedNumber<UIntPtr> {
-        static UIntPtr IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>.operator checked /(UIntPtr left, UIntPtr right);
     }
 }
```

