# System.Text.Json.Serialization.Metadata

``` diff
 namespace System.Text.Json.Serialization.Metadata {
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public class DefaultJsonTypeInfoResolver : IJsonTypeInfoResolver {
-        public IList<Action<JsonTypeInfo>> Modifiers { [CompilerGeneratedAttribute] get; }
+        public IList<Action<JsonTypeInfo>> Modifiers { get; }
     }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct JsonDerivedType {
+        public JsonDerivedType(Type derivedType);
+        public JsonDerivedType(Type derivedType, int typeDiscriminator);
+        public JsonDerivedType(Type derivedType, string typeDiscriminator);
+        public Type DerivedType { get; }
+        [NullableAttribute((byte)2)]
+        public object? TypeDiscriminator { [NullableContextAttribute((byte)2)] get; }
+    }
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public static class JsonMetadataServices {
-        public static JsonConverter<object> ObjectConverter { get; }
+        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
+        [NullableAttribute(new byte[]{ (byte)1, (byte)2})]
+        public static JsonConverter<object?> ObjectConverter { get; }
     }
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    public class JsonPolymorphismOptions {
+        public JsonPolymorphismOptions();
+        public IList<JsonDerivedType> DerivedTypes { get; }
+        public bool IgnoreUnrecognizedTypeDiscriminators { get; set; }
+        [AllowNullAttribute]
+        public string TypeDiscriminatorPropertyName { get; set; }
+        public JsonUnknownDerivedTypeHandling UnknownDerivedTypeHandling { get; set; }
+    }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class JsonPropertyInfo {
+        [NullableAttribute((byte)2)]
+        public ICustomAttributeProvider? AttributeProvider { [NullableContextAttribute((byte)2)] get; [NullableContextAttribute((byte)2)] set; }
+        public bool IsExtensionData { get; set; }
+        public int Order { get; set; }
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public abstract class JsonTypeInfo {
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        public Action<object>? OnDeserialized { get; set; }
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        public Action<object>? OnDeserializing { get; set; }
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        public Action<object>? OnSerialized { get; set; }
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        [NullableAttribute(new byte[]{ (byte)2, (byte)1})]
+        public Action<object>? OnSerializing { get; set; }
+        [NullableAttribute((byte)2)]
+        public JsonPolymorphismOptions? PolymorphismOptions { [NullableContextAttribute((byte)2)] get; [NullableContextAttribute((byte)2)] set; }
-        public JsonPropertyInfo CreateJsonPropertyInfo(Type propertyType, string name);
+        [RequiresDynamicCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        public JsonPropertyInfo CreateJsonPropertyInfo(Type propertyType, string name);
-        [RequiresDynamicCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use generic overload or System.Text.Json source generation for native AOT applications.")]
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use generic overload or System.Text.Json source generation for native AOT applications.")]
-        public static JsonTypeInfo CreateJsonTypeInfo(Type type, JsonSerializerOptions options);
+        [RequiresDynamicCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        public static JsonTypeInfo CreateJsonTypeInfo(Type type, JsonSerializerOptions options);
-        [RequiresDynamicCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use generic overload or System.Text.Json source generation for native AOT applications.")]
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use generic overload or System.Text.Json source generation for native AOT applications.")]
-        public static JsonTypeInfo<T> CreateJsonTypeInfo<T>(JsonSerializerOptions options);
+        [RequiresDynamicCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed and might need runtime code generation. Use System.Text.Json source generation for native AOT applications.")]
+        public static JsonTypeInfo<T> CreateJsonTypeInfo<T>(JsonSerializerOptions options);
     }
 }
```

