# System

``` diff
 namespace System {
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Byte : IAdditionOperators<byte, byte, byte>, IAdditiveIdentity<byte, byte>, IBinaryInteger<byte>, IBinaryNumber<byte>, IBitwiseOperators<byte, byte, byte>, IComparable, IComparable<byte>, IComparisonOperators<byte, byte>, IConvertible, IDecrementOperators<byte>, IDivisionOperators<byte, byte, byte>, IEqualityOperators<byte, byte>, IEquatable<byte>, IFormattable, IIncrementOperators<byte>, IMinMaxValue<byte>, IModulusOperators<byte, byte, byte>, IMultiplicativeIdentity<byte, byte>, IMultiplyOperators<byte, byte, byte>, INumber<byte>, INumberBase<byte>, IParsable<byte>, IShiftOperators<byte, byte>, ISpanFormattable, ISpanParsable<byte>, ISubtractionOperators<byte, byte, byte>, IUnaryNegationOperators<byte, byte>, IUnaryPlusOperators<byte, byte>, IUnsignedNumber<byte> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Byte : IAdditionOperators<byte, byte, byte>, IAdditiveIdentity<byte, byte>, IBinaryInteger<byte>, IBinaryNumber<byte>, IBitwiseOperators<byte, byte, byte>, IComparable, IComparable<byte>, IComparisonOperators<byte, byte, bool>, IConvertible, IDecrementOperators<byte>, IDivisionOperators<byte, byte, byte>, IEqualityOperators<byte, byte, bool>, IEquatable<byte>, IFormattable, IIncrementOperators<byte>, IMinMaxValue<byte>, IModulusOperators<byte, byte, byte>, IMultiplicativeIdentity<byte, byte>, IMultiplyOperators<byte, byte, byte>, INumber<byte>, INumberBase<byte>, IParsable<byte>, IShiftOperators<byte, int, byte>, ISpanFormattable, ISpanParsable<byte>, ISubtractionOperators<byte, byte, byte>, IUnaryNegationOperators<byte, byte>, IUnaryPlusOperators<byte, byte>, IUnsignedNumber<byte> {
+        static byte System.Numerics.IBinaryNumber<System.Byte>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static byte CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static byte CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static byte CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<byte, byte, bool>.operator >(byte left, byte right);
+        static bool IComparisonOperators<byte, byte, bool>.operator >=(byte left, byte right);
+        static bool IComparisonOperators<byte, byte, bool>.operator <(byte left, byte right);
+        static bool IComparisonOperators<byte, byte, bool>.operator <=(byte left, byte right);
-        static bool IComparisonOperators<byte, byte>.operator >(byte left, byte right);
-        static bool IComparisonOperators<byte, byte>.operator >=(byte left, byte right);
-        static bool IComparisonOperators<byte, byte>.operator <(byte left, byte right);
-        static bool IComparisonOperators<byte, byte>.operator <=(byte left, byte right);
+        static bool IEqualityOperators<byte, byte, bool>.operator ==(byte left, byte right);
+        static bool IEqualityOperators<byte, byte, bool>.operator !=(byte left, byte right);
-        static bool IEqualityOperators<byte, byte>.operator ==(byte left, byte right);
-        static bool IEqualityOperators<byte, byte>.operator !=(byte left, byte right);
-        static byte IShiftOperators<byte, byte>.operator <<(byte value, int shiftAmount);
-        static byte IShiftOperators<byte, byte>.operator >>(byte value, int shiftAmount);
-        static byte IShiftOperators<byte, byte>.operator >>>(byte value, int shiftAmount);
+        static byte IShiftOperators<byte, int, byte>.operator <<(byte value, int shiftAmount);
+        static byte IShiftOperators<byte, int, byte>.operator >>(byte value, int shiftAmount);
+        static byte IShiftOperators<byte, int, byte>.operator >>>(byte value, int shiftAmount);
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Char : IAdditionOperators<char, char, char>, IAdditiveIdentity<char, char>, IBinaryInteger<char>, IBinaryNumber<char>, IBitwiseOperators<char, char, char>, IComparable, IComparable<char>, IComparisonOperators<char, char>, IConvertible, IDecrementOperators<char>, IDivisionOperators<char, char, char>, IEqualityOperators<char, char>, IEquatable<char>, IFormattable, IIncrementOperators<char>, IMinMaxValue<char>, IModulusOperators<char, char, char>, IMultiplicativeIdentity<char, char>, IMultiplyOperators<char, char, char>, INumber<char>, INumberBase<char>, IParsable<char>, IShiftOperators<char, char>, ISpanFormattable, ISpanParsable<char>, ISubtractionOperators<char, char, char>, IUnaryNegationOperators<char, char>, IUnaryPlusOperators<char, char>, IUnsignedNumber<char> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Char : IAdditionOperators<char, char, char>, IAdditiveIdentity<char, char>, IBinaryInteger<char>, IBinaryNumber<char>, IBitwiseOperators<char, char, char>, IComparable, IComparable<char>, IComparisonOperators<char, char, bool>, IConvertible, IDecrementOperators<char>, IDivisionOperators<char, char, char>, IEqualityOperators<char, char, bool>, IEquatable<char>, IFormattable, IIncrementOperators<char>, IMinMaxValue<char>, IModulusOperators<char, char, char>, IMultiplicativeIdentity<char, char>, IMultiplyOperators<char, char, char>, INumber<char>, INumberBase<char>, IParsable<char>, IShiftOperators<char, int, char>, ISpanFormattable, ISpanParsable<char>, ISubtractionOperators<char, char, char>, IUnaryNegationOperators<char, char>, IUnaryPlusOperators<char, char>, IUnsignedNumber<char> {
+        static char System.Numerics.IBinaryNumber<System.Char>.AllBitsSet { get; }
+        static bool IComparisonOperators<char, char, bool>.operator >(char left, char right);
+        static bool IComparisonOperators<char, char, bool>.operator >=(char left, char right);
+        static bool IComparisonOperators<char, char, bool>.operator <(char left, char right);
+        static bool IComparisonOperators<char, char, bool>.operator <=(char left, char right);
-        static bool IComparisonOperators<char, char>.operator >(char left, char right);
-        static bool IComparisonOperators<char, char>.operator >=(char left, char right);
-        static bool IComparisonOperators<char, char>.operator <(char left, char right);
-        static bool IComparisonOperators<char, char>.operator <=(char left, char right);
+        static bool IEqualityOperators<char, char, bool>.operator ==(char left, char right);
+        static bool IEqualityOperators<char, char, bool>.operator !=(char left, char right);
-        static bool IEqualityOperators<char, char>.operator ==(char left, char right);
-        static bool IEqualityOperators<char, char>.operator !=(char left, char right);
-        static char IShiftOperators<char, char>.operator <<(char value, int shiftAmount);
-        static char IShiftOperators<char, char>.operator >>(char value, int shiftAmount);
-        static char IShiftOperators<char, char>.operator >>>(char value, int shiftAmount);
+        static char IShiftOperators<char, int, char>.operator <<(char value, int shiftAmount);
+        static char IShiftOperators<char, int, char>.operator >>(char value, int shiftAmount);
+        static char IShiftOperators<char, int, char>.operator >>>(char value, int shiftAmount);
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal>, IEquatable<decimal>, IFloatingPoint<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, INumberBase<decimal>, IParsable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParsable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal, bool>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal, bool>, IEquatable<decimal>, IFloatingPoint<decimal>, IFloatingPointConstants<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, INumberBase<decimal>, IParsable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParsable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal> {
+        static decimal System.Numerics.IFloatingPointConstants<System.Decimal>.E { get; }
+        static decimal System.Numerics.IFloatingPointConstants<System.Decimal>.Pi { get; }
+        static decimal System.Numerics.IFloatingPointConstants<System.Decimal>.Tau { get; }
+        [NullableContextAttribute((byte)1)]
+        public static decimal CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static decimal CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static decimal CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPointIeee754<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double>, IEquatable<double>, IExponentialFunctions<double>, IFloatingPoint<double>, IFloatingPointIeee754<double>, IFormattable, IHyperbolicFunctions<double>, IIncrementOperators<double>, ILogarithmicFunctions<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, INumberBase<double>, IParsable<double>, IPowerFunctions<double>, IRootFunctions<double>, ISignedNumber<double>, ISpanFormattable, ISpanParsable<double>, ISubtractionOperators<double, double, double>, ITrigonometricFunctions<double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPointIeee754<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double, bool>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double, bool>, IEquatable<double>, IExponentialFunctions<double>, IFloatingPoint<double>, IFloatingPointConstants<double>, IFloatingPointIeee754<double>, IFormattable, IHyperbolicFunctions<double>, IIncrementOperators<double>, ILogarithmicFunctions<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, INumberBase<double>, IParsable<double>, IPowerFunctions<double>, IRootFunctions<double>, ISignedNumber<double>, ISpanFormattable, ISpanParsable<double>, ISubtractionOperators<double, double, double>, ITrigonometricFunctions<double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
+        static double System.Numerics.IBinaryNumber<System.Double>.AllBitsSet { get; }
+        static double System.Numerics.IFloatingPointConstants<System.Double>.E { get; }
+        static double System.Numerics.IFloatingPointConstants<System.Double>.Pi { get; }
+        static double System.Numerics.IFloatingPointConstants<System.Double>.Tau { get; }
-        static double System.Numerics.IFloatingPointIeee754<System.Double>.E { get; }
-        static double System.Numerics.IFloatingPointIeee754<System.Double>.Pi { get; }
-        static double System.Numerics.IFloatingPointIeee754<System.Double>.Tau { get; }
+        [NullableContextAttribute((byte)1)]
+        public static double CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static double CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static double CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
-        public static double Root(double x, int n);
+        public static double RootN(double x, int n);
+        public static (double SinPi, double CosPi) SinCosPi(double x);
     }
     [NullableAttribute((byte)0)]
     [NullableContextAttribute((byte)1)]
     public static class GC {
+        public static IReadOnlyDictionary<string, object> GetConfigurationVariables();
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPointIeee754<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half>, IEquatable<Half>, IExponentialFunctions<Half>, IFloatingPoint<Half>, IFloatingPointIeee754<Half>, IFormattable, IHyperbolicFunctions<Half>, IIncrementOperators<Half>, ILogarithmicFunctions<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, INumberBase<Half>, IParsable<Half>, IPowerFunctions<Half>, IRootFunctions<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParsable<Half>, ISubtractionOperators<Half, Half, Half>, ITrigonometricFunctions<Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPointIeee754<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half, bool>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half, bool>, IEquatable<Half>, IExponentialFunctions<Half>, IFloatingPoint<Half>, IFloatingPointConstants<Half>, IFloatingPointIeee754<Half>, IFormattable, IHyperbolicFunctions<Half>, IIncrementOperators<Half>, ILogarithmicFunctions<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, INumberBase<Half>, IParsable<Half>, IPowerFunctions<Half>, IRootFunctions<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParsable<Half>, ISubtractionOperators<Half, Half, Half>, ITrigonometricFunctions<Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
+        static Half System.Numerics.IBinaryNumber<System.Half>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static Half CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static Half CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static Half CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
-        public static Half Root(Half x, int n);
+        public static Half RootN(Half x, int n);
+        public static (Half SinPi, Half CosPi) SinCosPi(Half x);
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Int128 : IAdditionOperators<Int128, Int128, Int128>, IAdditiveIdentity<Int128, Int128>, IBinaryInteger<Int128>, IBinaryNumber<Int128>, IBitwiseOperators<Int128, Int128, Int128>, IComparable, IComparable<Int128>, IComparisonOperators<Int128, Int128>, IDecrementOperators<Int128>, IDivisionOperators<Int128, Int128, Int128>, IEqualityOperators<Int128, Int128>, IEquatable<Int128>, IFormattable, IIncrementOperators<Int128>, IMinMaxValue<Int128>, IModulusOperators<Int128, Int128, Int128>, IMultiplicativeIdentity<Int128, Int128>, IMultiplyOperators<Int128, Int128, Int128>, INumber<Int128>, INumberBase<Int128>, IParsable<Int128>, IShiftOperators<Int128, Int128>, ISignedNumber<Int128>, ISpanFormattable, ISpanParsable<Int128>, ISubtractionOperators<Int128, Int128, Int128>, IUnaryNegationOperators<Int128, Int128>, IUnaryPlusOperators<Int128, Int128> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Int128 : IAdditionOperators<Int128, Int128, Int128>, IAdditiveIdentity<Int128, Int128>, IBinaryInteger<Int128>, IBinaryNumber<Int128>, IBitwiseOperators<Int128, Int128, Int128>, IComparable, IComparable<Int128>, IComparisonOperators<Int128, Int128, bool>, IDecrementOperators<Int128>, IDivisionOperators<Int128, Int128, Int128>, IEqualityOperators<Int128, Int128, bool>, IEquatable<Int128>, IFormattable, IIncrementOperators<Int128>, IMinMaxValue<Int128>, IModulusOperators<Int128, Int128, Int128>, IMultiplicativeIdentity<Int128, Int128>, IMultiplyOperators<Int128, Int128, Int128>, INumber<Int128>, INumberBase<Int128>, IParsable<Int128>, IShiftOperators<Int128, int, Int128>, ISignedNumber<Int128>, ISpanFormattable, ISpanParsable<Int128>, ISubtractionOperators<Int128, Int128, Int128>, IUnaryNegationOperators<Int128, Int128>, IUnaryPlusOperators<Int128, Int128> {
+        static Int128 System.Numerics.IBinaryNumber<System.Int128>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static Int128 CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static Int128 CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static Int128 CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Int16 : IAdditionOperators<short, short, short>, IAdditiveIdentity<short, short>, IBinaryInteger<short>, IBinaryNumber<short>, IBitwiseOperators<short, short, short>, IComparable, IComparable<short>, IComparisonOperators<short, short>, IConvertible, IDecrementOperators<short>, IDivisionOperators<short, short, short>, IEqualityOperators<short, short>, IEquatable<short>, IFormattable, IIncrementOperators<short>, IMinMaxValue<short>, IModulusOperators<short, short, short>, IMultiplicativeIdentity<short, short>, IMultiplyOperators<short, short, short>, INumber<short>, INumberBase<short>, IParsable<short>, IShiftOperators<short, short>, ISignedNumber<short>, ISpanFormattable, ISpanParsable<short>, ISubtractionOperators<short, short, short>, IUnaryNegationOperators<short, short>, IUnaryPlusOperators<short, short> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Int16 : IAdditionOperators<short, short, short>, IAdditiveIdentity<short, short>, IBinaryInteger<short>, IBinaryNumber<short>, IBitwiseOperators<short, short, short>, IComparable, IComparable<short>, IComparisonOperators<short, short, bool>, IConvertible, IDecrementOperators<short>, IDivisionOperators<short, short, short>, IEqualityOperators<short, short, bool>, IEquatable<short>, IFormattable, IIncrementOperators<short>, IMinMaxValue<short>, IModulusOperators<short, short, short>, IMultiplicativeIdentity<short, short>, IMultiplyOperators<short, short, short>, INumber<short>, INumberBase<short>, IParsable<short>, IShiftOperators<short, int, short>, ISignedNumber<short>, ISpanFormattable, ISpanParsable<short>, ISubtractionOperators<short, short, short>, IUnaryNegationOperators<short, short>, IUnaryPlusOperators<short, short> {
+        static short System.Numerics.IBinaryNumber<System.Int16>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static short CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static short CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static short CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<short, short, bool>.operator >(short left, short right);
+        static bool IComparisonOperators<short, short, bool>.operator >=(short left, short right);
+        static bool IComparisonOperators<short, short, bool>.operator <(short left, short right);
+        static bool IComparisonOperators<short, short, bool>.operator <=(short left, short right);
-        static bool IComparisonOperators<short, short>.operator >(short left, short right);
-        static bool IComparisonOperators<short, short>.operator >=(short left, short right);
-        static bool IComparisonOperators<short, short>.operator <(short left, short right);
-        static bool IComparisonOperators<short, short>.operator <=(short left, short right);
+        static bool IEqualityOperators<short, short, bool>.operator ==(short left, short right);
+        static bool IEqualityOperators<short, short, bool>.operator !=(short left, short right);
-        static bool IEqualityOperators<short, short>.operator ==(short left, short right);
-        static bool IEqualityOperators<short, short>.operator !=(short left, short right);
-        static short IShiftOperators<short, short>.operator <<(short value, int shiftAmount);
-        static short IShiftOperators<short, short>.operator >>(short value, int shiftAmount);
-        static short IShiftOperators<short, short>.operator >>>(short value, int shiftAmount);
+        static short IShiftOperators<short, int, short>.operator <<(short value, int shiftAmount);
+        static short IShiftOperators<short, int, short>.operator >>(short value, int shiftAmount);
+        static short IShiftOperators<short, int, short>.operator >>>(short value, int shiftAmount);
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Int32 : IAdditionOperators<int, int, int>, IAdditiveIdentity<int, int>, IBinaryInteger<int>, IBinaryNumber<int>, IBitwiseOperators<int, int, int>, IComparable, IComparable<int>, IComparisonOperators<int, int>, IConvertible, IDecrementOperators<int>, IDivisionOperators<int, int, int>, IEqualityOperators<int, int>, IEquatable<int>, IFormattable, IIncrementOperators<int>, IMinMaxValue<int>, IModulusOperators<int, int, int>, IMultiplicativeIdentity<int, int>, IMultiplyOperators<int, int, int>, INumber<int>, INumberBase<int>, IParsable<int>, IShiftOperators<int, int>, ISignedNumber<int>, ISpanFormattable, ISpanParsable<int>, ISubtractionOperators<int, int, int>, IUnaryNegationOperators<int, int>, IUnaryPlusOperators<int, int> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Int32 : IAdditionOperators<int, int, int>, IAdditiveIdentity<int, int>, IBinaryInteger<int>, IBinaryNumber<int>, IBitwiseOperators<int, int, int>, IComparable, IComparable<int>, IComparisonOperators<int, int, bool>, IConvertible, IDecrementOperators<int>, IDivisionOperators<int, int, int>, IEqualityOperators<int, int, bool>, IEquatable<int>, IFormattable, IIncrementOperators<int>, IMinMaxValue<int>, IModulusOperators<int, int, int>, IMultiplicativeIdentity<int, int>, IMultiplyOperators<int, int, int>, INumber<int>, INumberBase<int>, IParsable<int>, IShiftOperators<int, int, int>, ISignedNumber<int>, ISpanFormattable, ISpanParsable<int>, ISubtractionOperators<int, int, int>, IUnaryNegationOperators<int, int>, IUnaryPlusOperators<int, int> {
+        static int System.Numerics.IBinaryNumber<System.Int32>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static int CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static int CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static int CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<int, int, bool>.operator >(int left, int right);
+        static bool IComparisonOperators<int, int, bool>.operator >=(int left, int right);
+        static bool IComparisonOperators<int, int, bool>.operator <(int left, int right);
+        static bool IComparisonOperators<int, int, bool>.operator <=(int left, int right);
-        static bool IComparisonOperators<int, int>.operator >(int left, int right);
-        static bool IComparisonOperators<int, int>.operator >=(int left, int right);
-        static bool IComparisonOperators<int, int>.operator <(int left, int right);
-        static bool IComparisonOperators<int, int>.operator <=(int left, int right);
+        static bool IEqualityOperators<int, int, bool>.operator ==(int left, int right);
+        static bool IEqualityOperators<int, int, bool>.operator !=(int left, int right);
-        static bool IEqualityOperators<int, int>.operator ==(int left, int right);
-        static bool IEqualityOperators<int, int>.operator !=(int left, int right);
+        static int IShiftOperators<int, int, int>.operator <<(int value, int shiftAmount);
+        static int IShiftOperators<int, int, int>.operator >>(int value, int shiftAmount);
+        static int IShiftOperators<int, int, int>.operator >>>(int value, int shiftAmount);
-        static int IShiftOperators<int, int>.operator <<(int value, int shiftAmount);
-        static int IShiftOperators<int, int>.operator >>(int value, int shiftAmount);
-        static int IShiftOperators<int, int>.operator >>>(int value, int shiftAmount);
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Int64 : IAdditionOperators<long, long, long>, IAdditiveIdentity<long, long>, IBinaryInteger<long>, IBinaryNumber<long>, IBitwiseOperators<long, long, long>, IComparable, IComparable<long>, IComparisonOperators<long, long>, IConvertible, IDecrementOperators<long>, IDivisionOperators<long, long, long>, IEqualityOperators<long, long>, IEquatable<long>, IFormattable, IIncrementOperators<long>, IMinMaxValue<long>, IModulusOperators<long, long, long>, IMultiplicativeIdentity<long, long>, IMultiplyOperators<long, long, long>, INumber<long>, INumberBase<long>, IParsable<long>, IShiftOperators<long, long>, ISignedNumber<long>, ISpanFormattable, ISpanParsable<long>, ISubtractionOperators<long, long, long>, IUnaryNegationOperators<long, long>, IUnaryPlusOperators<long, long> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Int64 : IAdditionOperators<long, long, long>, IAdditiveIdentity<long, long>, IBinaryInteger<long>, IBinaryNumber<long>, IBitwiseOperators<long, long, long>, IComparable, IComparable<long>, IComparisonOperators<long, long, bool>, IConvertible, IDecrementOperators<long>, IDivisionOperators<long, long, long>, IEqualityOperators<long, long, bool>, IEquatable<long>, IFormattable, IIncrementOperators<long>, IMinMaxValue<long>, IModulusOperators<long, long, long>, IMultiplicativeIdentity<long, long>, IMultiplyOperators<long, long, long>, INumber<long>, INumberBase<long>, IParsable<long>, IShiftOperators<long, int, long>, ISignedNumber<long>, ISpanFormattable, ISpanParsable<long>, ISubtractionOperators<long, long, long>, IUnaryNegationOperators<long, long>, IUnaryPlusOperators<long, long> {
+        static long System.Numerics.IBinaryNumber<System.Int64>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static long CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static long CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static long CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<long, long, bool>.operator >(long left, long right);
+        static bool IComparisonOperators<long, long, bool>.operator >=(long left, long right);
+        static bool IComparisonOperators<long, long, bool>.operator <(long left, long right);
+        static bool IComparisonOperators<long, long, bool>.operator <=(long left, long right);
-        static bool IComparisonOperators<long, long>.operator >(long left, long right);
-        static bool IComparisonOperators<long, long>.operator >=(long left, long right);
-        static bool IComparisonOperators<long, long>.operator <(long left, long right);
-        static bool IComparisonOperators<long, long>.operator <=(long left, long right);
+        static bool IEqualityOperators<long, long, bool>.operator ==(long left, long right);
+        static bool IEqualityOperators<long, long, bool>.operator !=(long left, long right);
-        static bool IEqualityOperators<long, long>.operator ==(long left, long right);
-        static bool IEqualityOperators<long, long>.operator !=(long left, long right);
+        static long IShiftOperators<long, int, long>.operator <<(long value, int shiftAmount);
+        static long IShiftOperators<long, int, long>.operator >>(long value, int shiftAmount);
+        static long IShiftOperators<long, int, long>.operator >>>(long value, int shiftAmount);
-        static long IShiftOperators<long, long>.operator <<(long value, int shiftAmount);
-        static long IShiftOperators<long, long>.operator >>(long value, int shiftAmount);
-        static long IShiftOperators<long, long>.operator >>>(long value, int shiftAmount);
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct IntPtr : IAdditionOperators<IntPtr, IntPtr, IntPtr>, IAdditiveIdentity<IntPtr, IntPtr>, IBinaryInteger<IntPtr>, IBinaryNumber<IntPtr>, IBitwiseOperators<IntPtr, IntPtr, IntPtr>, IComparable, IComparable<IntPtr>, IComparisonOperators<IntPtr, IntPtr>, IDecrementOperators<IntPtr>, IDivisionOperators<IntPtr, IntPtr, IntPtr>, IEqualityOperators<IntPtr, IntPtr>, IEquatable<IntPtr>, IFormattable, IIncrementOperators<IntPtr>, IMinMaxValue<IntPtr>, IModulusOperators<IntPtr, IntPtr, IntPtr>, IMultiplicativeIdentity<IntPtr, IntPtr>, IMultiplyOperators<IntPtr, IntPtr, IntPtr>, INumber<IntPtr>, INumberBase<IntPtr>, IParsable<IntPtr>, ISerializable, IShiftOperators<IntPtr, IntPtr>, ISignedNumber<IntPtr>, ISpanFormattable, ISpanParsable<IntPtr>, ISubtractionOperators<IntPtr, IntPtr, IntPtr>, IUnaryNegationOperators<IntPtr, IntPtr>, IUnaryPlusOperators<IntPtr, IntPtr> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct IntPtr : IAdditionOperators<IntPtr, IntPtr, IntPtr>, IAdditiveIdentity<IntPtr, IntPtr>, IBinaryInteger<IntPtr>, IBinaryNumber<IntPtr>, IBitwiseOperators<IntPtr, IntPtr, IntPtr>, IComparable, IComparable<IntPtr>, IComparisonOperators<IntPtr, IntPtr, bool>, IDecrementOperators<IntPtr>, IDivisionOperators<IntPtr, IntPtr, IntPtr>, IEqualityOperators<IntPtr, IntPtr, bool>, IEquatable<IntPtr>, IFormattable, IIncrementOperators<IntPtr>, IMinMaxValue<IntPtr>, IModulusOperators<IntPtr, IntPtr, IntPtr>, IMultiplicativeIdentity<IntPtr, IntPtr>, IMultiplyOperators<IntPtr, IntPtr, IntPtr>, INumber<IntPtr>, INumberBase<IntPtr>, IParsable<IntPtr>, ISerializable, IShiftOperators<IntPtr, int, IntPtr>, ISignedNumber<IntPtr>, ISpanFormattable, ISpanParsable<IntPtr>, ISubtractionOperators<IntPtr, IntPtr, IntPtr>, IUnaryNegationOperators<IntPtr, IntPtr>, IUnaryPlusOperators<IntPtr, IntPtr> {
+        static IntPtr System.Numerics.IBinaryNumber<nint>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static IntPtr CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static IntPtr CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static IntPtr CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<IntPtr, IntPtr, bool>.operator >(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr, bool>.operator >=(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr, bool>.operator <(IntPtr left, IntPtr right);
+        static bool IComparisonOperators<IntPtr, IntPtr, bool>.operator <=(IntPtr left, IntPtr right);
-        static bool IComparisonOperators<IntPtr, IntPtr>.operator >(IntPtr left, IntPtr right);
-        static bool IComparisonOperators<IntPtr, IntPtr>.operator >=(IntPtr left, IntPtr right);
-        static bool IComparisonOperators<IntPtr, IntPtr>.operator <(IntPtr left, IntPtr right);
-        static bool IComparisonOperators<IntPtr, IntPtr>.operator <=(IntPtr left, IntPtr right);
-        static IntPtr IShiftOperators<IntPtr, IntPtr>.operator <<(IntPtr value, int shiftAmount);
-        static IntPtr IShiftOperators<IntPtr, IntPtr>.operator >>(IntPtr value, int shiftAmount);
-        static IntPtr IShiftOperators<IntPtr, IntPtr>.operator >>>(IntPtr value, int shiftAmount);
+        static IntPtr IShiftOperators<IntPtr, int, IntPtr>.operator <<(IntPtr value, int shiftAmount);
+        static IntPtr IShiftOperators<IntPtr, int, IntPtr>.operator >>(IntPtr value, int shiftAmount);
+        static IntPtr IShiftOperators<IntPtr, int, IntPtr>.operator >>>(IntPtr value, int shiftAmount);
     }
     [NullableContextAttribute((byte)1)]
     public interface IParsable<TSelf> where TSelf : IParsable<TSelf> {
-        [NullableContextAttribute((byte)2)]
-        static abstract bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, [NullableAttribute((byte)1)] out TSelf result);
+        [NullableContextAttribute((byte)2)]
+        static abstract bool TryParse([NotNullWhenAttribute(true)] string? s, IFormatProvider? provider, [MaybeNullWhenAttribute(false), NullableAttribute((byte)1)] out TSelf result);
     }
     public interface ISpanParsable<TSelf> : IParsable<TSelf> where TSelf : ISpanParsable<TSelf> {
-        static abstract bool TryParse(ReadOnlySpan<char> s, [NullableAttribute((byte)2)] IFormatProvider? provider, [NullableAttribute((byte)1)] out TSelf result);
+        static abstract bool TryParse(ReadOnlySpan<char> s, [NullableAttribute((byte)2)] IFormatProvider? provider, [MaybeNullWhenAttribute(false), NullableAttribute((byte)1)] out TSelf result);
     }
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly ref struct ReadOnlySpan<T> {
+    [NativeMarshallingAttribute(typeof(ReadOnlySpanMarshaller<,>))]
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly ref struct ReadOnlySpan<T> {
+        public ReadOnlySpan(in T reference);
     }
-    [CLSCompliantAttribute(false)]
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct SByte : IAdditionOperators<sbyte, sbyte, sbyte>, IAdditiveIdentity<sbyte, sbyte>, IBinaryInteger<sbyte>, IBinaryNumber<sbyte>, IBitwiseOperators<sbyte, sbyte, sbyte>, IComparable, IComparable<sbyte>, IComparisonOperators<sbyte, sbyte>, IConvertible, IDecrementOperators<sbyte>, IDivisionOperators<sbyte, sbyte, sbyte>, IEqualityOperators<sbyte, sbyte>, IEquatable<sbyte>, IFormattable, IIncrementOperators<sbyte>, IMinMaxValue<sbyte>, IModulusOperators<sbyte, sbyte, sbyte>, IMultiplicativeIdentity<sbyte, sbyte>, IMultiplyOperators<sbyte, sbyte, sbyte>, INumber<sbyte>, INumberBase<sbyte>, IParsable<sbyte>, IShiftOperators<sbyte, sbyte>, ISignedNumber<sbyte>, ISpanFormattable, ISpanParsable<sbyte>, ISubtractionOperators<sbyte, sbyte, sbyte>, IUnaryNegationOperators<sbyte, sbyte>, IUnaryPlusOperators<sbyte, sbyte> {
+    [CLSCompliantAttribute(false)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct SByte : IAdditionOperators<sbyte, sbyte, sbyte>, IAdditiveIdentity<sbyte, sbyte>, IBinaryInteger<sbyte>, IBinaryNumber<sbyte>, IBitwiseOperators<sbyte, sbyte, sbyte>, IComparable, IComparable<sbyte>, IComparisonOperators<sbyte, sbyte, bool>, IConvertible, IDecrementOperators<sbyte>, IDivisionOperators<sbyte, sbyte, sbyte>, IEqualityOperators<sbyte, sbyte, bool>, IEquatable<sbyte>, IFormattable, IIncrementOperators<sbyte>, IMinMaxValue<sbyte>, IModulusOperators<sbyte, sbyte, sbyte>, IMultiplicativeIdentity<sbyte, sbyte>, IMultiplyOperators<sbyte, sbyte, sbyte>, INumber<sbyte>, INumberBase<sbyte>, IParsable<sbyte>, IShiftOperators<sbyte, int, sbyte>, ISignedNumber<sbyte>, ISpanFormattable, ISpanParsable<sbyte>, ISubtractionOperators<sbyte, sbyte, sbyte>, IUnaryNegationOperators<sbyte, sbyte>, IUnaryPlusOperators<sbyte, sbyte> {
+        static sbyte System.Numerics.IBinaryNumber<System.SByte>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static sbyte CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static sbyte CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static sbyte CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<sbyte, sbyte, bool>.operator >(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte, bool>.operator >=(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte, bool>.operator <(sbyte left, sbyte right);
+        static bool IComparisonOperators<sbyte, sbyte, bool>.operator <=(sbyte left, sbyte right);
-        static bool IComparisonOperators<sbyte, sbyte>.operator >(sbyte left, sbyte right);
-        static bool IComparisonOperators<sbyte, sbyte>.operator >=(sbyte left, sbyte right);
-        static bool IComparisonOperators<sbyte, sbyte>.operator <(sbyte left, sbyte right);
-        static bool IComparisonOperators<sbyte, sbyte>.operator <=(sbyte left, sbyte right);
+        static bool IEqualityOperators<sbyte, sbyte, bool>.operator ==(sbyte left, sbyte right);
+        static bool IEqualityOperators<sbyte, sbyte, bool>.operator !=(sbyte left, sbyte right);
-        static bool IEqualityOperators<sbyte, sbyte>.operator ==(sbyte left, sbyte right);
-        static bool IEqualityOperators<sbyte, sbyte>.operator !=(sbyte left, sbyte right);
+        static sbyte IShiftOperators<sbyte, int, sbyte>.operator <<(sbyte value, int shiftAmount);
+        static sbyte IShiftOperators<sbyte, int, sbyte>.operator >>(sbyte value, int shiftAmount);
+        static sbyte IShiftOperators<sbyte, int, sbyte>.operator >>>(sbyte value, int shiftAmount);
-        static sbyte IShiftOperators<sbyte, sbyte>.operator <<(sbyte value, int shiftAmount);
-        static sbyte IShiftOperators<sbyte, sbyte>.operator >>(sbyte value, int shiftAmount);
-        static sbyte IShiftOperators<sbyte, sbyte>.operator >>>(sbyte value, int shiftAmount);
     }
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPointIeee754<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float>, IEquatable<float>, IExponentialFunctions<float>, IFloatingPoint<float>, IFloatingPointIeee754<float>, IFormattable, IHyperbolicFunctions<float>, IIncrementOperators<float>, ILogarithmicFunctions<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, INumberBase<float>, IParsable<float>, IPowerFunctions<float>, IRootFunctions<float>, ISignedNumber<float>, ISpanFormattable, ISpanParsable<float>, ISubtractionOperators<float, float, float>, ITrigonometricFunctions<float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPointIeee754<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float, bool>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float, bool>, IEquatable<float>, IExponentialFunctions<float>, IFloatingPoint<float>, IFloatingPointConstants<float>, IFloatingPointIeee754<float>, IFormattable, IHyperbolicFunctions<float>, IIncrementOperators<float>, ILogarithmicFunctions<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, INumberBase<float>, IParsable<float>, IPowerFunctions<float>, IRootFunctions<float>, ISignedNumber<float>, ISpanFormattable, ISpanParsable<float>, ISubtractionOperators<float, float, float>, ITrigonometricFunctions<float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
+        static float System.Numerics.IBinaryNumber<System.Single>.AllBitsSet { get; }
+        static float System.Numerics.IFloatingPointConstants<System.Single>.E { get; }
+        static float System.Numerics.IFloatingPointConstants<System.Single>.Pi { get; }
+        static float System.Numerics.IFloatingPointConstants<System.Single>.Tau { get; }
-        static float System.Numerics.IFloatingPointIeee754<System.Single>.E { get; }
-        static float System.Numerics.IFloatingPointIeee754<System.Single>.Pi { get; }
-        static float System.Numerics.IFloatingPointIeee754<System.Single>.Tau { get; }
+        [NullableContextAttribute((byte)1)]
+        public static float CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static float CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static float CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
-        public static float Root(float x, int n);
+        public static float RootN(float x, int n);
+        public static (float SinPi, float CosPi) SinCosPi(float x);
     }
-    [NullableAttribute((byte)0)]
-    [NullableContextAttribute((byte)1)]
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly ref struct Span<T> {
+    [NativeMarshallingAttribute(typeof(SpanMarshaller<,>))]
+    [NullableAttribute((byte)0)]
+    [NullableContextAttribute((byte)1)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly ref struct Span<T> {
+        public Span(ref T reference);
     }
-    [CLSCompliantAttribute(false)]
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct UInt128 : IAdditionOperators<UInt128, UInt128, UInt128>, IAdditiveIdentity<UInt128, UInt128>, IBinaryInteger<UInt128>, IBinaryNumber<UInt128>, IBitwiseOperators<UInt128, UInt128, UInt128>, IComparable, IComparable<UInt128>, IComparisonOperators<UInt128, UInt128>, IDecrementOperators<UInt128>, IDivisionOperators<UInt128, UInt128, UInt128>, IEqualityOperators<UInt128, UInt128>, IEquatable<UInt128>, IFormattable, IIncrementOperators<UInt128>, IMinMaxValue<UInt128>, IModulusOperators<UInt128, UInt128, UInt128>, IMultiplicativeIdentity<UInt128, UInt128>, IMultiplyOperators<UInt128, UInt128, UInt128>, INumber<UInt128>, INumberBase<UInt128>, IParsable<UInt128>, IShiftOperators<UInt128, UInt128>, ISpanFormattable, ISpanParsable<UInt128>, ISubtractionOperators<UInt128, UInt128, UInt128>, IUnaryNegationOperators<UInt128, UInt128>, IUnaryPlusOperators<UInt128, UInt128>, IUnsignedNumber<UInt128> {
+    [CLSCompliantAttribute(false)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct UInt128 : IAdditionOperators<UInt128, UInt128, UInt128>, IAdditiveIdentity<UInt128, UInt128>, IBinaryInteger<UInt128>, IBinaryNumber<UInt128>, IBitwiseOperators<UInt128, UInt128, UInt128>, IComparable, IComparable<UInt128>, IComparisonOperators<UInt128, UInt128, bool>, IDecrementOperators<UInt128>, IDivisionOperators<UInt128, UInt128, UInt128>, IEqualityOperators<UInt128, UInt128, bool>, IEquatable<UInt128>, IFormattable, IIncrementOperators<UInt128>, IMinMaxValue<UInt128>, IModulusOperators<UInt128, UInt128, UInt128>, IMultiplicativeIdentity<UInt128, UInt128>, IMultiplyOperators<UInt128, UInt128, UInt128>, INumber<UInt128>, INumberBase<UInt128>, IParsable<UInt128>, IShiftOperators<UInt128, int, UInt128>, ISpanFormattable, ISpanParsable<UInt128>, ISubtractionOperators<UInt128, UInt128, UInt128>, IUnaryNegationOperators<UInt128, UInt128>, IUnaryPlusOperators<UInt128, UInt128>, IUnsignedNumber<UInt128> {
+        static UInt128 System.Numerics.IBinaryNumber<System.UInt128>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static UInt128 CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static UInt128 CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static UInt128 CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
     }
-    [CLSCompliantAttribute(false)]
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct UInt16 : IAdditionOperators<ushort, ushort, ushort>, IAdditiveIdentity<ushort, ushort>, IBinaryInteger<ushort>, IBinaryNumber<ushort>, IBitwiseOperators<ushort, ushort, ushort>, IComparable, IComparable<ushort>, IComparisonOperators<ushort, ushort>, IConvertible, IDecrementOperators<ushort>, IDivisionOperators<ushort, ushort, ushort>, IEqualityOperators<ushort, ushort>, IEquatable<ushort>, IFormattable, IIncrementOperators<ushort>, IMinMaxValue<ushort>, IModulusOperators<ushort, ushort, ushort>, IMultiplicativeIdentity<ushort, ushort>, IMultiplyOperators<ushort, ushort, ushort>, INumber<ushort>, INumberBase<ushort>, IParsable<ushort>, IShiftOperators<ushort, ushort>, ISpanFormattable, ISpanParsable<ushort>, ISubtractionOperators<ushort, ushort, ushort>, IUnaryNegationOperators<ushort, ushort>, IUnaryPlusOperators<ushort, ushort>, IUnsignedNumber<ushort> {
+    [CLSCompliantAttribute(false)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct UInt16 : IAdditionOperators<ushort, ushort, ushort>, IAdditiveIdentity<ushort, ushort>, IBinaryInteger<ushort>, IBinaryNumber<ushort>, IBitwiseOperators<ushort, ushort, ushort>, IComparable, IComparable<ushort>, IComparisonOperators<ushort, ushort, bool>, IConvertible, IDecrementOperators<ushort>, IDivisionOperators<ushort, ushort, ushort>, IEqualityOperators<ushort, ushort, bool>, IEquatable<ushort>, IFormattable, IIncrementOperators<ushort>, IMinMaxValue<ushort>, IModulusOperators<ushort, ushort, ushort>, IMultiplicativeIdentity<ushort, ushort>, IMultiplyOperators<ushort, ushort, ushort>, INumber<ushort>, INumberBase<ushort>, IParsable<ushort>, IShiftOperators<ushort, int, ushort>, ISpanFormattable, ISpanParsable<ushort>, ISubtractionOperators<ushort, ushort, ushort>, IUnaryNegationOperators<ushort, ushort>, IUnaryPlusOperators<ushort, ushort>, IUnsignedNumber<ushort> {
+        static ushort System.Numerics.IBinaryNumber<System.UInt16>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static ushort CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static ushort CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static ushort CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<ushort, ushort, bool>.operator >(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort, bool>.operator >=(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort, bool>.operator <(ushort left, ushort right);
+        static bool IComparisonOperators<ushort, ushort, bool>.operator <=(ushort left, ushort right);
-        static bool IComparisonOperators<ushort, ushort>.operator >(ushort left, ushort right);
-        static bool IComparisonOperators<ushort, ushort>.operator >=(ushort left, ushort right);
-        static bool IComparisonOperators<ushort, ushort>.operator <(ushort left, ushort right);
-        static bool IComparisonOperators<ushort, ushort>.operator <=(ushort left, ushort right);
+        static bool IEqualityOperators<ushort, ushort, bool>.operator ==(ushort left, ushort right);
+        static bool IEqualityOperators<ushort, ushort, bool>.operator !=(ushort left, ushort right);
-        static bool IEqualityOperators<ushort, ushort>.operator ==(ushort left, ushort right);
-        static bool IEqualityOperators<ushort, ushort>.operator !=(ushort left, ushort right);
+        static ushort IShiftOperators<ushort, int, ushort>.operator <<(ushort value, int shiftAmount);
+        static ushort IShiftOperators<ushort, int, ushort>.operator >>(ushort value, int shiftAmount);
+        static ushort IShiftOperators<ushort, int, ushort>.operator >>>(ushort value, int shiftAmount);
-        static ushort IShiftOperators<ushort, ushort>.operator <<(ushort value, int shiftAmount);
-        static ushort IShiftOperators<ushort, ushort>.operator >>(ushort value, int shiftAmount);
-        static ushort IShiftOperators<ushort, ushort>.operator >>>(ushort value, int shiftAmount);
     }
-    [CLSCompliantAttribute(false)]
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct UInt32 : IAdditionOperators<uint, uint, uint>, IAdditiveIdentity<uint, uint>, IBinaryInteger<uint>, IBinaryNumber<uint>, IBitwiseOperators<uint, uint, uint>, IComparable, IComparable<uint>, IComparisonOperators<uint, uint>, IConvertible, IDecrementOperators<uint>, IDivisionOperators<uint, uint, uint>, IEqualityOperators<uint, uint>, IEquatable<uint>, IFormattable, IIncrementOperators<uint>, IMinMaxValue<uint>, IModulusOperators<uint, uint, uint>, IMultiplicativeIdentity<uint, uint>, IMultiplyOperators<uint, uint, uint>, INumber<uint>, INumberBase<uint>, IParsable<uint>, IShiftOperators<uint, uint>, ISpanFormattable, ISpanParsable<uint>, ISubtractionOperators<uint, uint, uint>, IUnaryNegationOperators<uint, uint>, IUnaryPlusOperators<uint, uint>, IUnsignedNumber<uint> {
+    [CLSCompliantAttribute(false)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct UInt32 : IAdditionOperators<uint, uint, uint>, IAdditiveIdentity<uint, uint>, IBinaryInteger<uint>, IBinaryNumber<uint>, IBitwiseOperators<uint, uint, uint>, IComparable, IComparable<uint>, IComparisonOperators<uint, uint, bool>, IConvertible, IDecrementOperators<uint>, IDivisionOperators<uint, uint, uint>, IEqualityOperators<uint, uint, bool>, IEquatable<uint>, IFormattable, IIncrementOperators<uint>, IMinMaxValue<uint>, IModulusOperators<uint, uint, uint>, IMultiplicativeIdentity<uint, uint>, IMultiplyOperators<uint, uint, uint>, INumber<uint>, INumberBase<uint>, IParsable<uint>, IShiftOperators<uint, int, uint>, ISpanFormattable, ISpanParsable<uint>, ISubtractionOperators<uint, uint, uint>, IUnaryNegationOperators<uint, uint>, IUnaryPlusOperators<uint, uint>, IUnsignedNumber<uint> {
+        static uint System.Numerics.IBinaryNumber<System.UInt32>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static uint CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static uint CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static uint CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<uint, uint, bool>.operator >(uint left, uint right);
+        static bool IComparisonOperators<uint, uint, bool>.operator >=(uint left, uint right);
+        static bool IComparisonOperators<uint, uint, bool>.operator <(uint left, uint right);
+        static bool IComparisonOperators<uint, uint, bool>.operator <=(uint left, uint right);
-        static bool IComparisonOperators<uint, uint>.operator >(uint left, uint right);
-        static bool IComparisonOperators<uint, uint>.operator >=(uint left, uint right);
-        static bool IComparisonOperators<uint, uint>.operator <(uint left, uint right);
-        static bool IComparisonOperators<uint, uint>.operator <=(uint left, uint right);
+        static bool IEqualityOperators<uint, uint, bool>.operator ==(uint left, uint right);
+        static bool IEqualityOperators<uint, uint, bool>.operator !=(uint left, uint right);
-        static bool IEqualityOperators<uint, uint>.operator ==(uint left, uint right);
-        static bool IEqualityOperators<uint, uint>.operator !=(uint left, uint right);
+        static uint IShiftOperators<uint, int, uint>.operator <<(uint value, int shiftAmount);
+        static uint IShiftOperators<uint, int, uint>.operator >>(uint value, int shiftAmount);
+        static uint IShiftOperators<uint, int, uint>.operator >>>(uint value, int shiftAmount);
-        static uint IShiftOperators<uint, uint>.operator <<(uint value, int shiftAmount);
-        static uint IShiftOperators<uint, uint>.operator >>(uint value, int shiftAmount);
-        static uint IShiftOperators<uint, uint>.operator >>>(uint value, int shiftAmount);
     }
-    [CLSCompliantAttribute(false)]
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct UInt64 : IAdditionOperators<ulong, ulong, ulong>, IAdditiveIdentity<ulong, ulong>, IBinaryInteger<ulong>, IBinaryNumber<ulong>, IBitwiseOperators<ulong, ulong, ulong>, IComparable, IComparable<ulong>, IComparisonOperators<ulong, ulong>, IConvertible, IDecrementOperators<ulong>, IDivisionOperators<ulong, ulong, ulong>, IEqualityOperators<ulong, ulong>, IEquatable<ulong>, IFormattable, IIncrementOperators<ulong>, IMinMaxValue<ulong>, IModulusOperators<ulong, ulong, ulong>, IMultiplicativeIdentity<ulong, ulong>, IMultiplyOperators<ulong, ulong, ulong>, INumber<ulong>, INumberBase<ulong>, IParsable<ulong>, IShiftOperators<ulong, ulong>, ISpanFormattable, ISpanParsable<ulong>, ISubtractionOperators<ulong, ulong, ulong>, IUnaryNegationOperators<ulong, ulong>, IUnaryPlusOperators<ulong, ulong>, IUnsignedNumber<ulong> {
+    [CLSCompliantAttribute(false)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct UInt64 : IAdditionOperators<ulong, ulong, ulong>, IAdditiveIdentity<ulong, ulong>, IBinaryInteger<ulong>, IBinaryNumber<ulong>, IBitwiseOperators<ulong, ulong, ulong>, IComparable, IComparable<ulong>, IComparisonOperators<ulong, ulong, bool>, IConvertible, IDecrementOperators<ulong>, IDivisionOperators<ulong, ulong, ulong>, IEqualityOperators<ulong, ulong, bool>, IEquatable<ulong>, IFormattable, IIncrementOperators<ulong>, IMinMaxValue<ulong>, IModulusOperators<ulong, ulong, ulong>, IMultiplicativeIdentity<ulong, ulong>, IMultiplyOperators<ulong, ulong, ulong>, INumber<ulong>, INumberBase<ulong>, IParsable<ulong>, IShiftOperators<ulong, int, ulong>, ISpanFormattable, ISpanParsable<ulong>, ISubtractionOperators<ulong, ulong, ulong>, IUnaryNegationOperators<ulong, ulong>, IUnaryPlusOperators<ulong, ulong>, IUnsignedNumber<ulong> {
+        static ulong System.Numerics.IBinaryNumber<System.UInt64>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static ulong CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static ulong CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static ulong CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<ulong, ulong, bool>.operator >(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong, bool>.operator >=(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong, bool>.operator <(ulong left, ulong right);
+        static bool IComparisonOperators<ulong, ulong, bool>.operator <=(ulong left, ulong right);
-        static bool IComparisonOperators<ulong, ulong>.operator >(ulong left, ulong right);
-        static bool IComparisonOperators<ulong, ulong>.operator >=(ulong left, ulong right);
-        static bool IComparisonOperators<ulong, ulong>.operator <(ulong left, ulong right);
-        static bool IComparisonOperators<ulong, ulong>.operator <=(ulong left, ulong right);
+        static bool IEqualityOperators<ulong, ulong, bool>.operator ==(ulong left, ulong right);
+        static bool IEqualityOperators<ulong, ulong, bool>.operator !=(ulong left, ulong right);
-        static bool IEqualityOperators<ulong, ulong>.operator ==(ulong left, ulong right);
-        static bool IEqualityOperators<ulong, ulong>.operator !=(ulong left, ulong right);
+        static ulong IShiftOperators<ulong, int, ulong>.operator <<(ulong value, int shiftAmount);
+        static ulong IShiftOperators<ulong, int, ulong>.operator >>(ulong value, int shiftAmount);
+        static ulong IShiftOperators<ulong, int, ulong>.operator >>>(ulong value, int shiftAmount);
-        static ulong IShiftOperators<ulong, ulong>.operator <<(ulong value, int shiftAmount);
-        static ulong IShiftOperators<ulong, ulong>.operator >>(ulong value, int shiftAmount);
-        static ulong IShiftOperators<ulong, ulong>.operator >>>(ulong value, int shiftAmount);
     }
-    [CLSCompliantAttribute(false)]
-    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
-    public readonly struct UIntPtr : IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>, IAdditiveIdentity<UIntPtr, UIntPtr>, IBinaryInteger<UIntPtr>, IBinaryNumber<UIntPtr>, IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>, IComparable, IComparable<UIntPtr>, IComparisonOperators<UIntPtr, UIntPtr>, IDecrementOperators<UIntPtr>, IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>, IEqualityOperators<UIntPtr, UIntPtr>, IEquatable<UIntPtr>, IFormattable, IIncrementOperators<UIntPtr>, IMinMaxValue<UIntPtr>, IModulusOperators<UIntPtr, UIntPtr, UIntPtr>, IMultiplicativeIdentity<UIntPtr, UIntPtr>, IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>, INumber<UIntPtr>, INumberBase<UIntPtr>, IParsable<UIntPtr>, ISerializable, IShiftOperators<UIntPtr, UIntPtr>, ISpanFormattable, ISpanParsable<UIntPtr>, ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>, IUnaryNegationOperators<UIntPtr, UIntPtr>, IUnaryPlusOperators<UIntPtr, UIntPtr>, IUnsignedNumber<UIntPtr> {
+    [CLSCompliantAttribute(false)]
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public readonly struct UIntPtr : IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>, IAdditiveIdentity<UIntPtr, UIntPtr>, IBinaryInteger<UIntPtr>, IBinaryNumber<UIntPtr>, IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>, IComparable, IComparable<UIntPtr>, IComparisonOperators<UIntPtr, UIntPtr, bool>, IDecrementOperators<UIntPtr>, IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>, IEqualityOperators<UIntPtr, UIntPtr, bool>, IEquatable<UIntPtr>, IFormattable, IIncrementOperators<UIntPtr>, IMinMaxValue<UIntPtr>, IModulusOperators<UIntPtr, UIntPtr, UIntPtr>, IMultiplicativeIdentity<UIntPtr, UIntPtr>, IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>, INumber<UIntPtr>, INumberBase<UIntPtr>, IParsable<UIntPtr>, ISerializable, IShiftOperators<UIntPtr, int, UIntPtr>, ISpanFormattable, ISpanParsable<UIntPtr>, ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>, IUnaryNegationOperators<UIntPtr, UIntPtr>, IUnaryPlusOperators<UIntPtr, UIntPtr>, IUnsignedNumber<UIntPtr> {
+        static UIntPtr System.Numerics.IBinaryNumber<nuint>.AllBitsSet { get; }
+        [NullableContextAttribute((byte)1)]
+        public static UIntPtr CreateChecked<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static UIntPtr CreateSaturating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        [NullableContextAttribute((byte)1)]
+        public static UIntPtr CreateTruncating<TOther>(TOther value) where TOther : INumberBase<TOther>;
+        static bool IComparisonOperators<UIntPtr, UIntPtr, bool>.operator >(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr, bool>.operator >=(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr, bool>.operator <(UIntPtr left, UIntPtr right);
+        static bool IComparisonOperators<UIntPtr, UIntPtr, bool>.operator <=(UIntPtr left, UIntPtr right);
-        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator >(UIntPtr left, UIntPtr right);
-        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator >=(UIntPtr left, UIntPtr right);
-        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator <(UIntPtr left, UIntPtr right);
-        static bool IComparisonOperators<UIntPtr, UIntPtr>.operator <=(UIntPtr left, UIntPtr right);
-        static UIntPtr IShiftOperators<UIntPtr, UIntPtr>.operator <<(UIntPtr value, int shiftAmount);
-        static UIntPtr IShiftOperators<UIntPtr, UIntPtr>.operator >>(UIntPtr value, int shiftAmount);
-        static UIntPtr IShiftOperators<UIntPtr, UIntPtr>.operator >>>(UIntPtr value, int shiftAmount);
+        static UIntPtr IShiftOperators<UIntPtr, int, UIntPtr>.operator <<(UIntPtr value, int shiftAmount);
+        static UIntPtr IShiftOperators<UIntPtr, int, UIntPtr>.operator >>(UIntPtr value, int shiftAmount);
+        static UIntPtr IShiftOperators<UIntPtr, int, UIntPtr>.operator >>>(UIntPtr value, int shiftAmount);
     }
 }
```

