# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
     public sealed class ComponentEndpointConventionBuilder : IEndpointConventionBuilder, IHubEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public sealed class ConnectionEndpointRouteBuilder : IEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public sealed class ControllerActionEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public abstract class EndpointBuilder {
+        public IList<Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate>> FilterFactories { [CompilerGeneratedAttribute] get; }
     }
     public sealed class HubEndpointConventionBuilder : IEndpointConventionBuilder, IHubEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
     public interface IEndpointConventionBuilder {
+        void Finally(Action<EndpointBuilder> finallyConvention);
     }
     public sealed class PageActionEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
+    public static class RateLimiterApplicationBuilderExtensions {
+        public static IApplicationBuilder UseRateLimiter(this IApplicationBuilder app);
+        public static IApplicationBuilder UseRateLimiter(this IApplicationBuilder app, RateLimiterOptions options);
+    }
+    public static class RateLimiterEndpointConventionBuilderExtensions {
+        public static TBuilder DisableRateLimiting<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder RequireRateLimiting<TBuilder, TPartitionKey>(this TBuilder builder, IRateLimiterPolicy<TPartitionKey> policy) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder RequireRateLimiting<TBuilder>(this TBuilder builder, string policyName) where TBuilder : IEndpointConventionBuilder;
+    }
+    public static class RateLimiterServiceCollectionExtensions {
+        public static IServiceCollection AddRateLimiter(this IServiceCollection services, Action<RateLimiterOptions> configureOptions);
+    }
     public sealed class RouteHandlerBuilder : IEndpointConventionBuilder {
+        public void Finally(Action<EndpointBuilder> finalConvention);
     }
 }
```

