# Microsoft.AspNetCore.Identity

``` diff
 namespace Microsoft.AspNetCore.Identity {
     public class IdentityBuilder {
-        public IdentityBuilder(Type user, Type role, IServiceCollection services);
+        public IdentityBuilder(Type user, [DynamicallyAccessedMembersAttribute(3)] Type role, IServiceCollection services);
-        public Type? RoleType { [CompilerGeneratedAttribute] get; }
+        [DynamicallyAccessedMembersAttribute(3)]
+        public Type? RoleType { [CompilerGeneratedAttribute] get; }
-        public virtual IdentityBuilder AddTokenProvider(string providerName, Type provider);
+        public virtual IdentityBuilder AddTokenProvider(string providerName, [DynamicallyAccessedMembersAttribute(3)] Type provider);
     }
     public abstract class RoleStoreBase<TRole, TKey, TUserRole, TRoleClaim> : IDisposable, IQueryableRoleStore<TRole>, IRoleClaimStore<TRole>, IRoleStore<TRole> where TRole : IdentityRole<TKey> where TKey : IEquatable<TKey> where TUserRole : IdentityUserRole<TKey>, new() where TRoleClaim : IdentityRoleClaim<TKey>, new() {
-        public virtual TKey? ConvertIdFromString(string? id);
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2026:Members annotated with 'RequiresUnreferencedCodeAttribute' require dynamic access otherwise can break functionality when trimming application code", Justification="TKey is annoated with RequiresUnreferencedCodeAttribute.All.")]
+        public virtual TKey? ConvertIdFromString(string? id);
     }
     public abstract class UserStoreBase<TUser, TKey, TUserClaim, TUserLogin, TUserToken> : IDisposable, IQueryableUserStore<TUser>, IUserAuthenticationTokenStore<TUser>, IUserAuthenticatorKeyStore<TUser>, IUserClaimStore<TUser>, IUserEmailStore<TUser>, IUserLockoutStore<TUser>, IUserLoginStore<TUser>, IUserPasswordStore<TUser>, IUserPhoneNumberStore<TUser>, IUserSecurityStampStore<TUser>, IUserStore<TUser>, IUserTwoFactorRecoveryCodeStore<TUser>, IUserTwoFactorStore<TUser> where TUser : IdentityUser<TKey> where TKey : IEquatable<TKey> where TUserClaim : IdentityUserClaim<TKey>, new() where TUserLogin : IdentityUserLogin<TKey>, new() where TUserToken : IdentityUserToken<TKey>, new() {
-        public virtual TKey? ConvertIdFromString(string? id);
+        [UnconditionalSuppressMessageAttribute("Trimming", "IL2026:Members annotated with 'RequiresUnreferencedCodeAttribute' require dynamic access otherwise can break functionality when trimming application code", Justification="TKey is annoated with RequiresUnreferencedCodeAttribute.All.")]
+        public virtual TKey? ConvertIdFromString(string? id);
     }
 }
```

