# Microsoft.Extensions.Options

``` diff
 namespace Microsoft.Extensions.Options {
     public class ConfigureFromConfigurationOptions<TOptions> : ConfigureOptions<TOptions> where TOptions : class {
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public ConfigureFromConfigurationOptions(IConfiguration config);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public ConfigureFromConfigurationOptions(IConfiguration config);
     }
     public class NamedConfigureFromConfigurationOptions<TOptions> : ConfigureNamedOptions<TOptions> where TOptions : class {
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public NamedConfigureFromConfigurationOptions(string? name, IConfiguration config);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public NamedConfigureFromConfigurationOptions(string? name, IConfiguration config);
-        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
-        public NamedConfigureFromConfigurationOptions(string? name, IConfiguration config, Action<BinderOptions>? configureBinder);
+        [RequiresDynamicCodeAttribute("Binding strongly typed objects to configuration values may require generating dynamic code at runtime.")]
+        [RequiresUnreferencedCodeAttribute("TOptions's dependent types may have their members trimmed. Ensure all required members are preserved.")]
+        public NamedConfigureFromConfigurationOptions(string? name, IConfiguration config, Action<BinderOptions>? configureBinder);
     }
 }
```

