# .NET Core 2.0.0 Preview 1

.NET Core 2.0.0 Preview 1 comprises:

* .NET Core Runtime 2.0.0 Preview 1 build 002111
* .NET Core SDK 2.0.0 Preview 1 build 005977

|                         | SDK Installer                                        | SDK Binaries                                        | Runtime Installer | Runtime Binaries |
| ----------------------- | :----------------------------------------------: | :----------------------------------------------:| :--: | :--: |
| Windows                 | [32-bit](https://download.microsoft.com/download/3/7/F/37F1CA21-E5EE-4309-9714-E914703ED05A/dotnet-dev-win-x86.2.0.0-preview1-005977.exe) / [64-bit](https://download.microsoft.com/download/3/7/F/37F1CA21-E5EE-4309-9714-E914703ED05A/dotnet-dev-win-x64.2.0.0-preview1-005977.exe)  | [32-bit](https://download.microsoft.com/download/0/6/5/0656B047-5F2F-4281-A851-F30776F8616D/dotnet-dev-win-x86.2.0.0-preview1-005977.zip) / [64-bit](https://download.microsoft.com/download/0/6/5/0656B047-5F2F-4281-A851-F30776F8616D/dotnet-dev-win-x64.2.0.0-preview1-005977.zip) | [32-bit](https://download.microsoft.com/download/0/4/8/048C286D-59CB-4B7C-95A1-D0F7FD4D37D2/dotnet-win-x86.2.0.0-preview1-002111-00.exe) / [64-bit](https://download.microsoft.com/download/0/4/8/048C286D-59CB-4B7C-95A1-D0F7FD4D37D2/dotnet-win-x64.2.0.0-preview1-002111-00.exe) | [32-bit](https://download.microsoft.com/download/0/9/0/09060200-E749-4025-A51A-83391C611C86/dotnet-win-x86.2.0.0-preview1-002111-00.zip) / [64-bit](https://download.microsoft.com/download/0/9/0/09060200-E749-4025-A51A-83391C611C86/dotnet-win-x64.2.0.0-preview1-002111-00.zip) |
| macOS                   | [64-bit](https://download.microsoft.com/download/3/7/F/37F1CA21-E5EE-4309-9714-E914703ED05A/dotnet-dev-osx-x64.2.0.0-preview1-005977.pkg)  | [64-bit](https://download.microsoft.com/download/0/6/5/0656B047-5F2F-4281-A851-F30776F8616D/dotnet-dev-osx-x64.2.0.0-preview1-005977.tar.gz)                          | [64-bit](https://download.microsoft.com/download/0/4/8/048C286D-59CB-4B7C-95A1-D0F7FD4D37D2/dotnet-osx-x64.2.0.0-preview1-002111-00.pkg) | [64-bit](https://download.microsoft.com/download/0/9/0/09060200-E749-4025-A51A-83391C611C86/dotnet-osx-x64.2.0.0-preview1-002111-00.tar.gz) |
| Linux *                 | -                                                         | [64-bit](https://download.microsoft.com/download/0/6/5/0656B047-5F2F-4281-A851-F30776F8616D/dotnet-dev-linux-x64.2.0.0-preview1-005977.tar.gz)                          | - | [64-bit](https://download.microsoft.com/download/0/9/0/09060200-E749-4025-A51A-83391C611C86/dotnet-linux-x64.2.0.0-preview1-002111-00.tar.gz) |
| Ubuntu 14.04            |[64-bit](https://download.microsoft.com/download/3/7/F/37F1CA21-E5EE-4309-9714-E914703ED05A/dotnet-sdk-ubuntu-x64.2.0.0-preview1-005977.deb)   | [64-bit](https://download.microsoft.com/download/0/6/5/0656B047-5F2F-4281-A851-F30776F8616D/dotnet-dev-linux-x64.2.0.0-preview1-005977.tar.gz)                          |[64-bit](https://download.microsoft.com/download/0/4/8/048C286D-59CB-4B7C-95A1-D0F7FD4D37D2/dotnet-sharedframework-ubuntu-x64.2.0.0-preview1-002111-00.deb) | [64-bit](https://download.microsoft.com/download/0/9/0/09060200-E749-4025-A51A-83391C611C86/dotnet-linux-x64.2.0.0-preview1-002111-00.tar.gz) |
| Ubuntu 16.04            |[64-bit](https://download.microsoft.com/download/3/7/F/37F1CA21-E5EE-4309-9714-E914703ED05A/dotnet-sdk-ubuntu.16.04-x64.2.0.0-preview1-005977.deb)   | [64-bit](https://download.microsoft.com/download/0/6/5/0656B047-5F2F-4281-A851-F30776F8616D/dotnet-dev-linux-x64.2.0.0-preview1-005977.tar.gz)                          |[64-bit](https://download.microsoft.com/download/0/4/8/048C286D-59CB-4B7C-95A1-D0F7FD4D37D2/dotnet-sharedframework-ubuntu.16.04-x64.2.0.0-preview1-002111-00.deb) | [64-bit](https://download.microsoft.com/download/0/9/0/09060200-E749-4025-A51A-83391C611C86/dotnet-linux-x64.2.0.0-preview1-002111-00.tar.gz) |
| Ubuntu 16.10            |[64-bit](https://download.microsoft.com/download/3/7/F/37F1CA21-E5EE-4309-9714-E914703ED05A/dotnet-sdk-ubuntu.16.10-x64.2.0.0-preview1-005977.deb)   | [64-bit](https://download.microsoft.com/download/0/6/5/0656B047-5F2F-4281-A851-F30776F8616D/dotnet-dev-linux-x64.2.0.0-preview1-005977.tar.gz)                          |[64-bit](https://download.microsoft.com/download/0/4/8/048C286D-59CB-4B7C-95A1-D0F7FD4D37D2/dotnet-sharedframework-ubuntu.16.10-x64.2.0.0-preview1-002111-00.deb) | [64-bit](https://download.microsoft.com/download/0/9/0/09060200-E749-4025-A51A-83391C611C86/dotnet-linux-x64.2.0.0-preview1-002111-00.tar.gz) |

**Note:** The 'Linux' binary archives are new for the 2.0 release. This package contains binaries which are compatible with [Linux distros and versions supported by .NET Core](https://github.com/dotnet/core/blob/main/roadmap.md).

**Checksum** files to verify downloads are available as follows:
* [Checksums_Shared_Framework](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.0-preview1-sharedfx-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.0-preview1-sdk-sha.txt)

**Debug Symbols**
* [Shared Framework](https://go.microsoft.com/fwlink/?linkid=848983)
* [Runtime](https://go.microsoft.com/fwlink/?linkid=848978)

## Docker

Images for .NET Core 2.0.0 Preview 1 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).

## Installation from a binary archive

When using binary archives to install, we recommend the contents be extracted to `/opt/dotnet` and a symbolic link created for `dotnet`. If an earlier release of .NET Core is already installed, the directory and symbolic link may already exist. Ubuntu and Mint users should follow the instructions in the Ubuntu Installation section below.

```bash
sudo mkdir -p /opt/dotnet
sudo tar zxf [tar.gz filename] -C /opt/dotnet
sudo ln -s /opt/dotnet/dotnet /usr/local/bin
```

## Ubuntu installation

> **Note:** The Ubuntu packages are not yet available through the package feed. We are investigating and hope to have them available soon.
> In the meantime, you can use the Linux binary archives listed in the table above.

### Add the dotnet apt-get feed

The first step is to establish the source feed for the package manager. This is only needed if you have not previously set up the source or if you are installing for the first time.

#### Ubuntu 14.04 and Linux Mint 17

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
```

#### Ubuntu 16.04 and Linux Mint 18

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
```

#### Ubuntu 16.10

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ yakkety main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
```

### Install .NET Core 2.0 Preview 1

To install .NET Core 2.0 Preview on Ubuntu or Linux Mint, simply use apt-get.

```bash
sudo apt-get update
sudo apt-get install dotnet-dev-2.0.0-preview1-005977
```

## Windows Server Hosting
If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the Windows (Server Hosting) installer and run the following command from an Administrator command prompt:

[```DotNetCore.2.0.0-Preview1-WindowsHosting.exe```](https://download.microsoft.com/download/4/6/6/4668DB58-0643-48EA-A194-CAD059143696/DotNetCore.2.0.0-Preview1-WindowsHosting.exe)

### ASP.NET Core Package Store

The Runtime Package Store is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the Runtime Package Store separately, the following can be used.

* [AspNetCore.2.0.0-Preview1.RuntimePackageStore_x64.exe](https://download.microsoft.com/download/4/6/6/4668DB58-0643-48EA-A194-CAD059143696/AspNetCore.2.0.0-Preview1.RuntimePackageStore_x64.exe)
* [AspNetCore.2.0.0-Preview1.RuntimePackageStore_x86.exe](https://download.microsoft.com/download/4/6/6/4668DB58-0643-48EA-A194-CAD059143696/AspNetCore.2.0.0-Preview1.RuntimePackageStore_x86.exe)