# Dependadotnet -- Generator for dependabot.yml for .NET

Dependadotnet generates [Dependabot](https://docs.github.com/en/free-pro-team@latest/github/administering-a-repository/keeping-your-dependencies-updated-automatically) yaml files for GitHub repositories that contain .NET projects. Dependabot is a GitHub service for automatically updating dependencies listed in project files for various package managers, including NuGet.

Dependabot works out of the box if you have a solution (`.sln`) or project file (like `.csproj`) at the root of the repo. It also supports `packages.config`.

This tool is for repos that contain projects that are [not discoverable from any one location](https://github.com/dependabot/feedback/issues/632). [dotnet/samples](https://github.com/dotnet/samples) is a good example of this case, and has a [dependabot.yml](https://github.com/dotnet/samples/blob/main/.github/dependabot.yml) (generated by this tool) that describes all projects within the repo.

Dependabot also supports specifying ranges of package versions that should be ignored as candidates for updates. The dependadotnet tool uses a [database](package-ignore.json) ([source](https://github.com/richlander/dependabot-data-processing)) that maps target frameworks to incompatible package versions, and generates dependabot manifests to match ([example](https://github.com/richlander/dependabot-dotnet-test-projects/blob/main/.github/dependabot.yml)).

## Install the tool

Use the following instructions to install [dependadotnet](https://www.nuget.org/packages/dependadotnet/)

```console
dotnet tool install -g dependadotnet
dependadotnet [repo-root]
```

You can uninstall the tool using the following command.

```console
dotnet tool uninstall -g dependadotnet
```

## Usage

`dependadotnet [path-to-repo-root]`

Alternatively, if you are in the repo root, you can use the following pattern to avoid needing to write the path:

`dependadotnet .`

The tool writes to stdout. The following pattern is recommended to generate the dependabot config file (assuming the `.github` directory exists):

`dependadotnet . > .github\dependabot.yml`
