// Copyright 2015 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Flags: --strong-mode --allow-natives-syntax

"use strict";

function getTestFuncs() {
  "use strong";
  return [
    function(x){return 1 + true;},
    function(x){return 1 - true;},
    function(x){return 1 * true;},
    function(x){return 1 / true;},
    function(x){return 1 % true;},
    function(x){return 1 | true;},
    function(x){return 1 & true;},
    function(x){return 1 ^ true;},
    function(x){return 1 << true;},
    function(x){return 1 >> true;},
    function(x){return 1 >>> true;},
    function(x){return 1 < true;},
    function(x){return 1 > true;},
    function(x){return 1 <= true;},
    function(x){return 1 >= true;},
    function(x){return 1 + undefined;},
    function(x){return 1 - undefined;},
    function(x){return 1 * undefined;},
    function(x){return 1 / undefined;},
    function(x){return 1 % undefined;},
    function(x){return 1 | undefined;},
    function(x){return 1 & undefined;},
    function(x){return 1 ^ undefined;},
    function(x){return 1 << undefined;},
    function(x){return 1 >> undefined;},
    function(x){return 1 >>> undefined;},
    function(x){return 1 < undefined;},
    function(x){return 1 > undefined;},
    function(x){return 1 <= undefined;},
    function(x){return 1 >= undefined;},
    function(x){return 1 + null;},
    function(x){return 1 - null;},
    function(x){return 1 * null;},
    function(x){return 1 / null;},
    function(x){return 1 % null;},
    function(x){return 1 | null;},
    function(x){return 1 & null;},
    function(x){return 1 ^ null;},
    function(x){return 1 << null;},
    function(x){return 1 >> null;},
    function(x){return 1 >>> null;},
    function(x){return 1 < null;},
    function(x){return 1 > null;},
    function(x){return 1 <= null;},
    function(x){return 1 >= null;},
    function(x){return NaN + true;},
    function(x){return NaN - true;},
    function(x){return NaN * true;},
    function(x){return NaN / true;},
    function(x){return NaN % true;},
    function(x){return NaN | true;},
    function(x){return NaN & true;},
    function(x){return NaN ^ true;},
    function(x){return NaN << true;},
    function(x){return NaN >> true;},
    function(x){return NaN >>> true;},
    function(x){return NaN < true;},
    function(x){return NaN > true;},
    function(x){return NaN <= true;},
    function(x){return NaN >= true;},
    function(x){return NaN + undefined;},
    function(x){return NaN - undefined;},
    function(x){return NaN * undefined;},
    function(x){return NaN / undefined;},
    function(x){return NaN % undefined;},
    function(x){return NaN | undefined;},
    function(x){return NaN & undefined;},
    function(x){return NaN ^ undefined;},
    function(x){return NaN << undefined;},
    function(x){return NaN >> undefined;},
    function(x){return NaN >>> undefined;},
    function(x){return NaN < undefined;},
    function(x){return NaN > undefined;},
    function(x){return NaN <= undefined;},
    function(x){return NaN >= undefined;},
    function(x){return NaN + null;},
    function(x){return NaN - null;},
    function(x){return NaN * null;},
    function(x){return NaN / null;},
    function(x){return NaN % null;},
    function(x){return NaN | null;},
    function(x){return NaN & null;},
    function(x){return NaN ^ null;},
    function(x){return NaN << null;},
    function(x){return NaN >> null;},
    function(x){return NaN >>> null;},
    function(x){return NaN < null;},
    function(x){return NaN > null;},
    function(x){return NaN <= null;},
    function(x){return NaN >= null;},
    function(x){return true + 1;},
    function(x){return true - 1;},
    function(x){return true * 1;},
    function(x){return true / 1;},
    function(x){return true % 1;},
    function(x){return true | 1;},
    function(x){return true & 1;},
    function(x){return true ^ 1;},
    function(x){return true << 1;},
    function(x){return true >> 1;},
    function(x){return true >>> 1;},
    function(x){return true < 1;},
    function(x){return true > 1;},
    function(x){return true <= 1;},
    function(x){return true >= 1;},
    function(x){return undefined + 1;},
    function(x){return undefined - 1;},
    function(x){return undefined * 1;},
    function(x){return undefined / 1;},
    function(x){return undefined % 1;},
    function(x){return undefined | 1;},
    function(x){return undefined & 1;},
    function(x){return undefined ^ 1;},
    function(x){return undefined << 1;},
    function(x){return undefined >> 1;},
    function(x){return undefined >>> 1;},
    function(x){return undefined < 1;},
    function(x){return undefined > 1;},
    function(x){return undefined <= 1;},
    function(x){return undefined >= 1;},
    function(x){return null + 1;},
    function(x){return null - 1;},
    function(x){return null * 1;},
    function(x){return null / 1;},
    function(x){return null % 1;},
    function(x){return null | 1;},
    function(x){return null & 1;},
    function(x){return null ^ 1;},
    function(x){return null << 1;},
    function(x){return null >> 1;},
    function(x){return null >>> 1;},
    function(x){return null < 1;},
    function(x){return null > 1;},
    function(x){return null <= 1;},
    function(x){return null >= 1;},
    function(x){return true + NaN;},
    function(x){return true - NaN;},
    function(x){return true * NaN;},
    function(x){return true / NaN;},
    function(x){return true % NaN;},
    function(x){return true | NaN;},
    function(x){return true & NaN;},
    function(x){return true ^ NaN;},
    function(x){return true << NaN;},
    function(x){return true >> NaN;},
    function(x){return true >>> NaN;},
    function(x){return true < NaN;},
    function(x){return true > NaN;},
    function(x){return true <= NaN;},
    function(x){return true >= NaN;},
    function(x){return undefined + NaN;},
    function(x){return undefined - NaN;},
    function(x){return undefined * NaN;},
    function(x){return undefined / NaN;},
    function(x){return undefined % NaN;},
    function(x){return undefined | NaN;},
    function(x){return undefined & NaN;},
    function(x){return undefined ^ NaN;},
    function(x){return undefined << NaN;},
    function(x){return undefined >> NaN;},
    function(x){return undefined >>> NaN;},
    function(x){return undefined < NaN;},
    function(x){return undefined > NaN;},
    function(x){return undefined <= NaN;},
    function(x){return undefined >= NaN;},
    function(x){return null + NaN;},
    function(x){return null - NaN;},
    function(x){return null * NaN;},
    function(x){return null / NaN;},
    function(x){return null % NaN;},
    function(x){return null | NaN;},
    function(x){return null & NaN;},
    function(x){return null ^ NaN;},
    function(x){return null << NaN;},
    function(x){return null >> NaN;},
    function(x){return null >>> NaN;},
    function(x){return null < NaN;},
    function(x){return null > NaN;},
    function(x){return null <= NaN;},
    function(x){return null >= NaN;}
  ];
}

for (let func of getTestFuncs()) {
  assertThrows(func, TypeError);
  assertThrows(func, TypeError);
  assertThrows(func, TypeError);
  %OptimizeFunctionOnNextCall(func);
  assertThrows(func, TypeError);
  %DeoptimizeFunction(func);
  assertThrows(func, TypeError);
}
