# System.ServiceModel

``` diff
+namespace System.ServiceModel {
+    public class ActionNotSupportedException : CommunicationException {
+        public ActionNotSupportedException();
+        public ActionNotSupportedException(string message);
+        public ActionNotSupportedException(string message, Exception innerException);
+    }
+    public enum AuditLevel {
+        Failure = 2,
+        None = 0,
+        Success = 1,
+        SuccessOrFailure = 3,
+    }
+    public enum AuditLogLocation {
+        Application = 1,
+        Default = 0,
+        Security = 2,
+    }
+    public class BasicHttpBinding : HttpBindingBase {
+        public BasicHttpBinding();
+        public BasicHttpBinding(BasicHttpSecurityMode securityMode);
+        public BasicHttpSecurity Security { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingParameterCollection parameters);
+        public override BindingElementCollection CreateBindingElements();
+    }
+    public enum BasicHttpMessageCredentialType {
+        Certificate = 1,
+        UserName = 0,
+    }
+    public class BasicHttpsBinding : HttpBindingBase {
+        public BasicHttpsBinding();
+        public BasicHttpsBinding(BasicHttpsSecurityMode securityMode);
+        public BasicHttpsSecurity Security { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingParameterCollection parameters);
+        public override BindingElementCollection CreateBindingElements();
+    }
+    public sealed class BasicHttpSecurity {
+        public BasicHttpSecurity();
+        public BasicHttpSecurityMode Mode { get; set; }
+        public HttpTransportSecurity Transport { get; set; }
+    }
+    public enum BasicHttpSecurityMode {
+        Message = 2,
+        None = 0,
+        Transport = 1,
+        TransportCredentialOnly = 4,
+        TransportWithMessageCredential = 3,
+    }
+    public sealed class BasicHttpsSecurity {
+        public BasicHttpsSecurity();
+        public BasicHttpsSecurityMode Mode { get; set; }
+        public HttpTransportSecurity Transport { get; set; }
+    }
+    public enum BasicHttpsSecurityMode {
+        Transport = 0,
+        TransportWithMessageCredential = 1,
+    }
+    public sealed class CallbackBehaviorAttribute : Attribute, IEndpointBehavior {
+        public CallbackBehaviorAttribute();
+        public bool AutomaticSessionShutdown { get; set; }
+        public bool UseSynchronizationContext { get; set; }
+        void System.ServiceModel.Description.IEndpointBehavior.AddBindingParameters(ServiceEndpoint serviceEndpoint, BindingParameterCollection parameters);
+        void System.ServiceModel.Description.IEndpointBehavior.ApplyClientBehavior(ServiceEndpoint serviceEndpoint, ClientRuntime clientRuntime);
+        void System.ServiceModel.Description.IEndpointBehavior.ApplyDispatchBehavior(ServiceEndpoint serviceEndpoint, EndpointDispatcher endpointDispatcher);
+        void System.ServiceModel.Description.IEndpointBehavior.Validate(ServiceEndpoint serviceEndpoint);
+    }
+    public abstract class ChannelFactory : CommunicationObject, IChannelFactory, ICommunicationObject, IDisposable {
+        protected ChannelFactory();
+        public ClientCredentials Credentials { get; }
+        protected override TimeSpan DefaultCloseTimeout { get; }
+        protected override TimeSpan DefaultOpenTimeout { get; }
+        public ServiceEndpoint Endpoint { get; }
+        protected virtual void ApplyConfiguration(string configurationName);
+        protected abstract ServiceEndpoint CreateDescription();
+        protected virtual IChannelFactory CreateFactory();
+        protected internal void EnsureOpened();
+        public T GetProperty<T>() where T : class;
+        protected void InitializeEndpoint(Binding binding, EndpointAddress address);
+        protected void InitializeEndpoint(ServiceEndpoint endpoint);
+        protected void InitializeEndpoint(string configurationName, EndpointAddress address);
+        protected override void OnAbort();
+        protected override IAsyncResult OnBeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override IAsyncResult OnBeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override void OnClose(TimeSpan timeout);
+        protected internal override Task OnCloseAsync(TimeSpan timeout);
+        protected override void OnEndClose(IAsyncResult result);
+        protected override void OnEndOpen(IAsyncResult result);
+        protected override void OnOpen(TimeSpan timeout);
+        protected internal override Task OnOpenAsync(TimeSpan timeout);
+        protected override void OnOpened();
+        protected override void OnOpening();
+        void System.IDisposable.Dispose();
+    }
+    public class ChannelFactory<TChannel> : ChannelFactory, IChannelFactory, IChannelFactory<TChannel>, ICommunicationObject {
+        public ChannelFactory();
+        public ChannelFactory(Binding binding);
+        public ChannelFactory(Binding binding, EndpointAddress remoteAddress);
+        public ChannelFactory(Binding binding, string remoteAddress);
+        public ChannelFactory(ServiceEndpoint endpoint);
+        public ChannelFactory(string endpointConfigurationName);
+        public ChannelFactory(string endpointConfigurationName, EndpointAddress remoteAddress);
+        protected ChannelFactory(Type channelType);
+        public TChannel CreateChannel();
+        public static TChannel CreateChannel(Binding binding, EndpointAddress endpointAddress);
+        public static TChannel CreateChannel(Binding binding, EndpointAddress endpointAddress, Uri via);
+        public TChannel CreateChannel(EndpointAddress address);
+        public virtual TChannel CreateChannel(EndpointAddress address, Uri via);
+        protected static TChannel CreateChannel(string endpointConfigurationName);
+        protected override ServiceEndpoint CreateDescription();
+    }
+    public class ChannelTerminatedException : CommunicationException {
+        public ChannelTerminatedException();
+        public ChannelTerminatedException(string message);
+        public ChannelTerminatedException(string message, Exception innerException);
+    }
+    public abstract class ClientBase<TChannel> : ICommunicationObject where TChannel : class {
+        protected ClientBase();
+        protected ClientBase(Binding binding, EndpointAddress remoteAddress);
+        protected ClientBase(InstanceContext callbackInstance, Binding binding, EndpointAddress remoteAddress);
+        protected ClientBase(string endpointConfigurationName);
+        protected ClientBase(string endpointConfigurationName, EndpointAddress remoteAddress);
+        protected ClientBase(string endpointConfigurationName, string remoteAddress);
+        protected TChannel Channel { get; }
+        public ChannelFactory<TChannel> ChannelFactory { get; }
+        public ClientCredentials ClientCredentials { get; }
+        public ServiceEndpoint Endpoint { get; }
+        public IClientChannel InnerChannel { get; }
+        public CommunicationState State { get; }
+        event EventHandler System.ServiceModel.ICommunicationObject.Closed;
+        event EventHandler System.ServiceModel.ICommunicationObject.Closing;
+        event EventHandler System.ServiceModel.ICommunicationObject.Faulted;
+        event EventHandler System.ServiceModel.ICommunicationObject.Opened;
+        event EventHandler System.ServiceModel.ICommunicationObject.Opening;
+        public void Abort();
+        public void Close();
+        protected virtual TChannel CreateChannel();
+        protected T GetDefaultValueForInitialization<T>();
+        protected void InvokeAsync(ClientBase<TChannel>.BeginOperationDelegate beginOperationDelegate, object[] inValues, ClientBase<TChannel>.EndOperationDelegate endOperationDelegate, SendOrPostCallback operationCompletedCallback, object userState);
+        public void Open();
+        void System.IDisposable.Dispose();
+        IAsyncResult System.ServiceModel.ICommunicationObject.BeginClose(AsyncCallback callback, object state);
+        IAsyncResult System.ServiceModel.ICommunicationObject.BeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        IAsyncResult System.ServiceModel.ICommunicationObject.BeginOpen(AsyncCallback callback, object state);
+        IAsyncResult System.ServiceModel.ICommunicationObject.BeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+        void System.ServiceModel.ICommunicationObject.Close();
+        void System.ServiceModel.ICommunicationObject.Close(TimeSpan timeout);
+        void System.ServiceModel.ICommunicationObject.EndClose(IAsyncResult result);
+        void System.ServiceModel.ICommunicationObject.EndOpen(IAsyncResult result);
+        void System.ServiceModel.ICommunicationObject.Open();
+        void System.ServiceModel.ICommunicationObject.Open(TimeSpan timeout);
+        protected class AsyncOperationContext
+        protected delegate IAsyncResult BeginOperationDelegate(object[] inValues, AsyncCallback asyncCallback, object state);
+        protected class ChannelBase<T> : IChannel, IClientChannel, ICommunicationObject, IContextChannel, IDisposable, IExtensibleObject<IContextChannel>, IOutputChannel, IRequestChannel where T : class {
+            protected ChannelBase(ClientBase<T> client);
+            EndpointAddress System.ServiceModel.Channels.IOutputChannel.RemoteAddress { get; }
+            Uri System.ServiceModel.Channels.IOutputChannel.Via { get; }
+            EndpointAddress System.ServiceModel.Channels.IRequestChannel.RemoteAddress { get; }
+            Uri System.ServiceModel.Channels.IRequestChannel.Via { get; }
+            bool System.ServiceModel.IClientChannel.AllowInitializationUI { get; set; }
+            bool System.ServiceModel.IClientChannel.DidInteractiveInitialization { get; }
+            Uri System.ServiceModel.IClientChannel.Via { get; }
+            CommunicationState System.ServiceModel.ICommunicationObject.State { get; }
+            bool System.ServiceModel.IContextChannel.AllowOutputBatching { get; set; }
+            IInputSession System.ServiceModel.IContextChannel.InputSession { get; }
+            EndpointAddress System.ServiceModel.IContextChannel.LocalAddress { get; }
+            TimeSpan System.ServiceModel.IContextChannel.OperationTimeout { get; set; }
+            IOutputSession System.ServiceModel.IContextChannel.OutputSession { get; }
+            EndpointAddress System.ServiceModel.IContextChannel.RemoteAddress { get; }
+            string System.ServiceModel.IContextChannel.SessionId { get; }
+            IExtensionCollection<IContextChannel> System.ServiceModel.IExtensibleObject<System.ServiceModel.IContextChannel>.Extensions { get; }
+            event EventHandler<UnknownMessageReceivedEventArgs> System.ServiceModel.IClientChannel.UnknownMessageReceived;
+            event EventHandler System.ServiceModel.ICommunicationObject.Closed;
+            event EventHandler System.ServiceModel.ICommunicationObject.Closing;
+            event EventHandler System.ServiceModel.ICommunicationObject.Faulted;
+            event EventHandler System.ServiceModel.ICommunicationObject.Opened;
+            event EventHandler System.ServiceModel.ICommunicationObject.Opening;
+            protected IAsyncResult BeginInvoke(string methodName, object[] args, AsyncCallback callback, object state);
+            protected object EndInvoke(string methodName, object[] args, IAsyncResult result);
+            void System.IDisposable.Dispose();
+            TProperty System.ServiceModel.Channels.IChannel.GetProperty<TProperty>();
+            IAsyncResult System.ServiceModel.Channels.IOutputChannel.BeginSend(Message message, AsyncCallback callback, object state);
+            IAsyncResult System.ServiceModel.Channels.IOutputChannel.BeginSend(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+            void System.ServiceModel.Channels.IOutputChannel.EndSend(IAsyncResult result);
+            void System.ServiceModel.Channels.IOutputChannel.Send(Message message);
+            void System.ServiceModel.Channels.IOutputChannel.Send(Message message, TimeSpan timeout);
+            IAsyncResult System.ServiceModel.Channels.IRequestChannel.BeginRequest(Message message, AsyncCallback callback, object state);
+            IAsyncResult System.ServiceModel.Channels.IRequestChannel.BeginRequest(Message message, TimeSpan timeout, AsyncCallback callback, object state);
+            Message System.ServiceModel.Channels.IRequestChannel.EndRequest(IAsyncResult result);
+            Message System.ServiceModel.Channels.IRequestChannel.Request(Message message);
+            Message System.ServiceModel.Channels.IRequestChannel.Request(Message message, TimeSpan timeout);
+            IAsyncResult System.ServiceModel.IClientChannel.BeginDisplayInitializationUI(AsyncCallback callback, object state);
+            void System.ServiceModel.IClientChannel.DisplayInitializationUI();
+            void System.ServiceModel.IClientChannel.EndDisplayInitializationUI(IAsyncResult result);
+            void System.ServiceModel.ICommunicationObject.Abort();
+            IAsyncResult System.ServiceModel.ICommunicationObject.BeginClose(AsyncCallback callback, object state);
+            IAsyncResult System.ServiceModel.ICommunicationObject.BeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+            IAsyncResult System.ServiceModel.ICommunicationObject.BeginOpen(AsyncCallback callback, object state);
+            IAsyncResult System.ServiceModel.ICommunicationObject.BeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+            void System.ServiceModel.ICommunicationObject.Close();
+            void System.ServiceModel.ICommunicationObject.Close(TimeSpan timeout);
+            void System.ServiceModel.ICommunicationObject.EndClose(IAsyncResult result);
+            void System.ServiceModel.ICommunicationObject.EndOpen(IAsyncResult result);
+            void System.ServiceModel.ICommunicationObject.Open();
+            void System.ServiceModel.ICommunicationObject.Open(TimeSpan timeout);
+        }
+        protected delegate object[] EndOperationDelegate(IAsyncResult result);
+        protected class InvokeAsyncCompletedEventArgs : AsyncCompletedEventArgs {
+            public object[] Results { get; }
+        }
+    }
+    public class ClientCredentialsSecurityTokenManager : SecurityTokenManager {
+        public ClientCredentialsSecurityTokenManager(ClientCredentials clientCredentials);
+        public ClientCredentials ClientCredentials { get; }
+        public override SecurityTokenAuthenticator CreateSecurityTokenAuthenticator(SecurityTokenRequirement tokenRequirement, out SecurityTokenResolver outOfBandTokenResolver);
+        public override SecurityTokenProvider CreateSecurityTokenProvider(SecurityTokenRequirement tokenRequirement);
+        public override SecurityTokenSerializer CreateSecurityTokenSerializer(SecurityTokenVersion version);
+        protected internal bool IsIssuedSecurityTokenRequirement(SecurityTokenRequirement requirement);
+    }
+    public class CommunicationException : Exception {
+        public CommunicationException();
+        public CommunicationException(string message);
+        public CommunicationException(string message, Exception innerException);
+    }
+    public class CommunicationObjectAbortedException : CommunicationException {
+        public CommunicationObjectAbortedException();
+        public CommunicationObjectAbortedException(string message);
+        public CommunicationObjectAbortedException(string message, Exception innerException);
+    }
+    public class CommunicationObjectFaultedException : CommunicationException {
+        public CommunicationObjectFaultedException();
+        public CommunicationObjectFaultedException(string message);
+        public CommunicationObjectFaultedException(string message, Exception innerException);
+    }
+    public enum CommunicationState {
+        Closed = 4,
+        Closing = 3,
+        Created = 0,
+        Faulted = 5,
+        Opened = 2,
+        Opening = 1,
+    }
+    public enum ConcurrencyMode {
+        Multiple = 2,
+        Reentrant = 1,
+        Single = 0,
+    }
+    public static class ConcurrencyModeHelper {
+        public static bool IsDefined(ConcurrencyMode x);
+    }
+    public sealed class DataContractFormatAttribute : Attribute {
+        public DataContractFormatAttribute();
+        public OperationFormatStyle Style { get; set; }
+    }
+    public static class DiagnosticUtility {
+        public static ExceptionUtility ExceptionUtility { get; }
+    }
+    public class DnsEndpointIdentity : EndpointIdentity {
+        public DnsEndpointIdentity(Claim identity);
+        public DnsEndpointIdentity(string dnsName);
+    }
+    public class DuplexChannelFactory<TChannel> : ChannelFactory<TChannel> {
+        public DuplexChannelFactory(object callbackObject);
+        public DuplexChannelFactory(object callbackObject, Binding binding);
+        public DuplexChannelFactory(object callbackObject, Binding binding, EndpointAddress remoteAddress);
+        public DuplexChannelFactory(object callbackObject, Binding binding, string remoteAddress);
+        public DuplexChannelFactory(object callbackObject, ServiceEndpoint endpoint);
+        public DuplexChannelFactory(object callbackObject, string endpointConfigurationName);
+        public DuplexChannelFactory(object callbackObject, string endpointConfigurationName, EndpointAddress remoteAddress);
+        public DuplexChannelFactory(InstanceContext callbackInstance);
+        public DuplexChannelFactory(InstanceContext callbackInstance, Binding binding);
+        public DuplexChannelFactory(InstanceContext callbackInstance, Binding binding, EndpointAddress remoteAddress);
+        public DuplexChannelFactory(InstanceContext callbackInstance, Binding binding, string remoteAddress);
+        public DuplexChannelFactory(InstanceContext callbackInstance, ServiceEndpoint endpoint);
+        public DuplexChannelFactory(InstanceContext callbackInstance, string endpointConfigurationName);
+        public DuplexChannelFactory(InstanceContext callbackInstance, string endpointConfigurationName, EndpointAddress remoteAddress);
+        public DuplexChannelFactory(Type callbackInstanceType);
+        public DuplexChannelFactory(Type callbackInstanceType, Binding binding);
+        public DuplexChannelFactory(Type callbackInstanceType, Binding binding, EndpointAddress remoteAddress);
+        public DuplexChannelFactory(Type callbackInstanceType, Binding binding, string remoteAddress);
+        public DuplexChannelFactory(Type callbackInstanceType, ServiceEndpoint endpoint);
+        public DuplexChannelFactory(Type callbackInstanceType, string endpointConfigurationName);
+        public DuplexChannelFactory(Type callbackInstanceType, string endpointConfigurationName, EndpointAddress remoteAddress);
+        public static TChannel CreateChannel(object callbackObject, Binding binding, EndpointAddress endpointAddress);
+        public static TChannel CreateChannel(object callbackObject, Binding binding, EndpointAddress endpointAddress, Uri via);
+        public static TChannel CreateChannel(object callbackObject, string endpointConfigurationName);
+        public override TChannel CreateChannel(EndpointAddress address, Uri via);
+        public TChannel CreateChannel(InstanceContext callbackInstance);
+        public static TChannel CreateChannel(InstanceContext callbackInstance, Binding binding, EndpointAddress endpointAddress);
+        public static TChannel CreateChannel(InstanceContext callbackInstance, Binding binding, EndpointAddress endpointAddress, Uri via);
+        public TChannel CreateChannel(InstanceContext callbackInstance, EndpointAddress address);
+        public virtual TChannel CreateChannel(InstanceContext callbackInstance, EndpointAddress address, Uri via);
+        public static TChannel CreateChannel(InstanceContext callbackInstance, string endpointConfigurationName);
+    }
+    public abstract class DuplexClientBase<TChannel> : ClientBase<TChannel> where TChannel : class {
+        protected DuplexClientBase(InstanceContext callbackInstance);
+        protected DuplexClientBase(InstanceContext callbackInstance, Binding binding, EndpointAddress remoteAddress);
+        protected DuplexClientBase(InstanceContext callbackInstance, string endpointConfigurationName);
+        protected DuplexClientBase(InstanceContext callbackInstance, string endpointConfigurationName, EndpointAddress remoteAddress);
+        protected DuplexClientBase(InstanceContext callbackInstance, string endpointConfigurationName, string remoteAddress);
+        public IDuplexContextChannel InnerDuplexChannel { get; }
+    }
+    public class EndpointAddress {
+        public EndpointAddress(string uri);
+        public EndpointAddress(Uri uri, params AddressHeader[] addressHeaders);
+        public EndpointAddress(Uri uri, EndpointIdentity identity, params AddressHeader[] addressHeaders);
+        public static Uri AnonymousUri { get; }
+        public AddressHeaderCollection Headers { get; }
+        public EndpointIdentity Identity { get; }
+        public bool IsAnonymous { get; }
+        public bool IsNone { get; }
+        public static Uri NoneUri { get; }
+        public Uri Uri { get; }
+        public void ApplyTo(Message message);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public XmlDictionaryReader GetReaderAtExtensions();
+        public XmlDictionaryReader GetReaderAtMetadata();
+        public static bool operator ==(EndpointAddress address1, EndpointAddress address2);
+        public static bool operator !=(EndpointAddress address1, EndpointAddress address2);
+        public static EndpointAddress ReadFrom(AddressingVersion addressingVersion, XmlDictionaryReader reader);
+        public static EndpointAddress ReadFrom(XmlDictionaryReader reader);
+        public override string ToString();
+        public void WriteContentsTo(AddressingVersion addressingVersion, XmlDictionaryWriter writer);
+        public void WriteContentsTo(AddressingVersion addressingVersion, XmlWriter writer);
+        public void WriteTo(AddressingVersion addressingVersion, XmlDictionaryWriter writer);
+        public void WriteTo(AddressingVersion addressingVersion, XmlDictionaryWriter writer, XmlDictionaryString localName, XmlDictionaryString ns);
+        public void WriteTo(AddressingVersion addressingVersion, XmlWriter writer);
+        public void WriteTo(AddressingVersion addressingVersion, XmlWriter writer, string localName, string ns);
+    }
+    public class EndpointAddressBuilder {
+        public EndpointAddressBuilder();
+        public EndpointAddressBuilder(EndpointAddress address);
+        public Collection<AddressHeader> Headers { get; }
+        public EndpointIdentity Identity { get; set; }
+        public Uri Uri { get; set; }
+        public XmlDictionaryReader GetReaderAtExtensions();
+        public XmlDictionaryReader GetReaderAtMetadata();
+        public void SetExtensionReader(XmlDictionaryReader reader);
+        public void SetMetadataReader(XmlDictionaryReader reader);
+        public EndpointAddress ToEndpointAddress();
+    }
+    public abstract class EndpointIdentity {
+        protected EndpointIdentity();
+        public Claim IdentityClaim { get; }
+        public static EndpointIdentity CreateDnsIdentity(string dnsName);
+        public static EndpointIdentity CreateIdentity(Claim identity);
+        public static EndpointIdentity CreateSpnIdentity(string spnName);
+        public static EndpointIdentity CreateUpnIdentity(string upnName);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        protected void Initialize(Claim identityClaim);
+        protected void Initialize(Claim identityClaim, IEqualityComparer<Claim> claimComparer);
+        public override string ToString();
+    }
+    public class EndpointNotFoundException : CommunicationException {
+        public EndpointNotFoundException();
+        public EndpointNotFoundException(string message);
+        public EndpointNotFoundException(string message, Exception innerException);
+    }
+    public sealed class EnvelopeVersion {
+        public string NextDestinationActorValue { get; }
+        public static EnvelopeVersion None { get; }
+        public static EnvelopeVersion Soap11 { get; }
+        public static EnvelopeVersion Soap12 { get; }
+        public string[] GetUltimateDestinationActorValues();
+        public override string ToString();
+    }
+    public class ExceptionDetail {
+        public ExceptionDetail(Exception exception);
+        public string HelpLink { get; set; }
+        public ExceptionDetail InnerException { get; set; }
+        public string Message { get; set; }
+        public string StackTrace { get; set; }
+        public string Type { get; set; }
+        public override string ToString();
+    }
+    public class ExceptionHelper {
+        public const string WinsdowsStreamSecurityNotSupported = "Windows Stream Security is not supported";
+        public ExceptionHelper();
+        public static Exception AsError(Exception exception);
+        public static Exception CreateMaxReceivedMessageSizeExceededException(long maxMessageSize);
+        public static PlatformNotSupportedException PlatformNotSupported();
+        public static PlatformNotSupportedException PlatformNotSupported(string message);
+    }
+    public sealed class ExtensionCollection<T> : SynchronizedCollection<IExtension<T>>, ICollection<IExtension<T>>, IEnumerable, IEnumerable<IExtension<T>>, IExtensionCollection<T> where T : IExtensibleObject<T> {
+        public ExtensionCollection(T owner);
+        public ExtensionCollection(T owner, object syncRoot);
+        bool System.Collections.Generic.ICollection<System.ServiceModel.IExtension<T>>.IsReadOnly { get; }
+        protected override void ClearItems();
+        public E Find<E>();
+        public Collection<E> FindAll<E>();
+        protected override void InsertItem(int index, IExtension<T> item);
+        protected override void RemoveItem(int index);
+        protected override void SetItem(int index, IExtension<T> item);
+    }
+    public class FaultCode {
+        public FaultCode(string name);
+        public FaultCode(string name, FaultCode subCode);
+        public FaultCode(string name, string ns);
+        public FaultCode(string name, string ns, FaultCode subCode);
+        public bool IsPredefinedFault { get; }
+        public bool IsReceiverFault { get; }
+        public bool IsSenderFault { get; }
+        public string Name { get; }
+        public string Namespace { get; }
+        public FaultCode SubCode { get; }
+        public static FaultCode CreateReceiverFaultCode(FaultCode subCode);
+        public static FaultCode CreateReceiverFaultCode(string name, string ns);
+        public static FaultCode CreateSenderFaultCode(FaultCode subCode);
+        public static FaultCode CreateSenderFaultCode(string name, string ns);
+    }
+    public sealed class FaultContractAttribute : Attribute {
+        public FaultContractAttribute(Type detailType);
+        public string Action { get; set; }
+        public Type DetailType { get; }
+        public bool HasProtectionLevel { get; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+    }
+    public class FaultException : CommunicationException {
+        public FaultException();
+        public FaultException(MessageFault fault);
+        public FaultException(MessageFault fault, string action);
+        public FaultException(FaultReason reason);
+        public FaultException(FaultReason reason, FaultCode code);
+        public FaultException(FaultReason reason, FaultCode code, string action);
+        public FaultException(string reason);
+        public FaultException(string reason, FaultCode code);
+        public FaultException(string reason, FaultCode code, string action);
+        public string Action { get; }
+        public FaultCode Code { get; }
+        public override string Message { get; }
+        public FaultReason Reason { get; }
+        public static FaultException CreateFault(MessageFault messageFault, string action, params Type[] faultDetailTypes);
+        public static FaultException CreateFault(MessageFault messageFault, params Type[] faultDetailTypes);
+        public virtual MessageFault CreateMessageFault();
+    }
+    public class FaultException<TDetail> : FaultException {
+        public FaultException(TDetail detail);
+        public FaultException(TDetail detail, FaultReason reason);
+        public FaultException(TDetail detail, FaultReason reason, FaultCode code);
+        public FaultException(TDetail detail, FaultReason reason, FaultCode code, string action);
+        public FaultException(TDetail detail, string reason);
+        public FaultException(TDetail detail, string reason, FaultCode code);
+        public FaultException(TDetail detail, string reason, FaultCode code, string action);
+        public TDetail Detail { get; }
+        public override MessageFault CreateMessageFault();
+        public override string ToString();
+    }
+    public class FaultReason {
+        public FaultReason(IEnumerable<FaultReasonText> translations);
+        public FaultReason(FaultReasonText translation);
+        public FaultReason(string text);
+        public SynchronizedReadOnlyCollection<FaultReasonText> Translations { get; }
+        public FaultReasonText GetMatchingTranslation();
+        public FaultReasonText GetMatchingTranslation(CultureInfo cultureInfo);
+        public override string ToString();
+    }
+    public class FaultReasonText {
+        public FaultReasonText(string text);
+        public FaultReasonText(string text, CultureInfo cultureInfo);
+        public FaultReasonText(string text, string xmlLang);
+        public string Text { get; }
+        public string XmlLang { get; }
+        public bool Matches(CultureInfo cultureInfo);
+    }
+    public enum HostNameComparisonMode {
+        Exact = 1,
+        StrongWildcard = 0,
+        WeakWildcard = 2,
+    }
+    public static class HostNameComparisonModeHelper {
+        public static bool IsDefined(HostNameComparisonMode value);
+        public static void Validate(HostNameComparisonMode value);
+    }
+    public abstract class HttpBindingBase : Binding {
+        public bool AllowCookies { get; set; }
+        public EnvelopeVersion EnvelopeVersion { get; }
+        public HostNameComparisonMode HostNameComparisonMode { get; set; }
+        public long MaxBufferPoolSize { get; set; }
+        public int MaxBufferSize { get; set; }
+        public long MaxReceivedMessageSize { get; set; }
+        public XmlDictionaryReaderQuotas ReaderQuotas { get; set; }
+        public override string Scheme { get; }
+        bool System.ServiceModel.Channels.IBindingRuntimePreferences.ReceiveSynchronously { get; }
+        public Encoding TextEncoding { get; set; }
+        public TransferMode TransferMode { get; set; }
+        public bool UseDefaultWebProxy { get; }
+    }
+    public enum HttpClientCredentialType {
+        Basic = 1,
+        Certificate = 5,
+        Digest = 2,
+        InheritedFromHost = 6,
+        None = 0,
+        Ntlm = 3,
+        Windows = 4,
+    }
+    public sealed class HttpTransportSecurity {
+        public HttpTransportSecurity();
+        public HttpClientCredentialType ClientCredentialType { get; set; }
+        public string Realm { get; set; }
+    }
+    public interface IAsyncCommunicationObject : ICommunicationObject {
+        Task CloseAsync(TimeSpan timeout);
+        Task OpenAsync(TimeSpan timeout);
+    }
+    public interface IClientChannel : IChannel, ICommunicationObject, IContextChannel, IDisposable, IExtensibleObject<IContextChannel> {
+        bool AllowInitializationUI { get; set; }
+        bool DidInteractiveInitialization { get; }
+        Uri Via { get; }
+        event EventHandler<UnknownMessageReceivedEventArgs> UnknownMessageReceived;
+        IAsyncResult BeginDisplayInitializationUI(AsyncCallback callback, object state);
+        void DisplayInitializationUI();
+        void EndDisplayInitializationUI(IAsyncResult result);
+    }
+    public interface ICommunicationObject {
+        CommunicationState State { get; }
+        event EventHandler Closed;
+        event EventHandler Closing;
+        event EventHandler Faulted;
+        event EventHandler Opened;
+        event EventHandler Opening;
+        void Abort();
+        IAsyncResult BeginClose(AsyncCallback callback, object state);
+        IAsyncResult BeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        IAsyncResult BeginOpen(AsyncCallback callback, object state);
+        IAsyncResult BeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+        void Close();
+        void Close(TimeSpan timeout);
+        void EndClose(IAsyncResult result);
+        void EndOpen(IAsyncResult result);
+        void Open();
+        void Open(TimeSpan timeout);
+    }
+    public interface IContextChannel : IChannel, ICommunicationObject, IExtensibleObject<IContextChannel> {
+        bool AllowOutputBatching { get; set; }
+        IInputSession InputSession { get; }
+        EndpointAddress LocalAddress { get; }
+        TimeSpan OperationTimeout { get; set; }
+        IOutputSession OutputSession { get; }
+        EndpointAddress RemoteAddress { get; }
+        string SessionId { get; }
+    }
+    public interface IDefaultCommunicationTimeouts {
+        TimeSpan CloseTimeout { get; }
+        TimeSpan OpenTimeout { get; }
+        TimeSpan ReceiveTimeout { get; }
+        TimeSpan SendTimeout { get; }
+    }
+    public interface IDuplexContextChannel : IChannel, ICommunicationObject, IContextChannel, IExtensibleObject<IContextChannel> {
+        bool AutomaticInputSessionShutdown { get; set; }
+        InstanceContext CallbackInstance { get; set; }
+        IAsyncResult BeginCloseOutputSession(TimeSpan timeout, AsyncCallback callback, object state);
+        void CloseOutputSession(TimeSpan timeout);
+        void EndCloseOutputSession(IAsyncResult result);
+    }
+    public interface IExtensibleObject<T> where T : IExtensibleObject<T> {
+        IExtensionCollection<T> Extensions { get; }
+    }
+    public interface IExtension<T> where T : IExtensibleObject<T> {
+        void Attach(T owner);
+        void Detach(T owner);
+    }
+    public interface IExtensionCollection<T> : ICollection<IExtension<T>>, IEnumerable, IEnumerable<IExtension<T>> where T : IExtensibleObject<T> {
+        E Find<E>();
+        Collection<E> FindAll<E>();
+    }
+    public enum ImpersonationOption {
+        Allowed = 1,
+        NotAllowed = 0,
+        Required = 2,
+    }
+    public sealed class InstanceContext : CommunicationObject, IExtensibleObject<InstanceContext> {
+        public InstanceContext(object implementation);
+        protected override TimeSpan DefaultCloseTimeout { get; }
+        protected override TimeSpan DefaultOpenTimeout { get; }
+        public IExtensionCollection<InstanceContext> Extensions { get; }
+        public ICollection<IChannel> IncomingChannels { get; }
+        public ICollection<IChannel> OutgoingChannels { get; }
+        public SynchronizationContext SynchronizationContext { get; set; }
+        IExtensionCollection<InstanceContext> System.ServiceModel.IExtensibleObject<System.ServiceModel.InstanceContext>.Extensions { get; }
+        public object GetServiceInstance(Message message);
+        protected override void OnAbort();
+        protected override IAsyncResult OnBeginClose(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override IAsyncResult OnBeginOpen(TimeSpan timeout, AsyncCallback callback, object state);
+        protected override void OnClose(TimeSpan timeout);
+        protected internal override Task OnCloseAsync(TimeSpan timeout);
+        protected override void OnClosed();
+        protected override void OnEndClose(IAsyncResult result);
+        protected override void OnEndOpen(IAsyncResult result);
+        protected override void OnFaulted();
+        protected override void OnOpen(TimeSpan timeout);
+        protected internal override Task OnOpenAsync(TimeSpan timeout);
+        protected override void OnOpened();
+        protected override void OnOpening();
+    }
+    public enum InstanceContextMode {
+        PerCall = 1,
+        PerSession = 0,
+        Single = 2,
+    }
+    public class InvalidMessageContractException : Exception {
+        public InvalidMessageContractException();
+        public InvalidMessageContractException(string message);
+        public InvalidMessageContractException(string message, Exception innerException);
+    }
+    public interface IServiceChannel : IChannel, ICommunicationObject, IContextChannel, IExtensibleObject<IContextChannel> {
+        Uri ListenUri { get; }
+    }
+    public class MessageBodyMemberAttribute : MessageContractMemberAttribute {
+        public MessageBodyMemberAttribute();
+        public int Order { get; set; }
+    }
+    public sealed class MessageContractAttribute : Attribute {
+        public MessageContractAttribute();
+        public bool HasProtectionLevel { get; }
+        public bool IsWrapped { get; set; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+        public string WrapperName { get; set; }
+        public string WrapperNamespace { get; set; }
+    }
+    public abstract class MessageContractMemberAttribute : Attribute {
+        protected MessageContractMemberAttribute();
+        public bool HasProtectionLevel { get; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+    }
+    public enum MessageCredentialType {
+        Certificate = 3,
+        IssuedToken = 4,
+        None = 0,
+        UserName = 2,
+        Windows = 1,
+    }
+    public class MessageHeader<T> {
+        public MessageHeader();
+        public MessageHeader(T content);
+        public MessageHeader(T content, bool mustUnderstand, string actor, bool relay);
+        public string Actor { get; set; }
+        public T Content { get; set; }
+        public bool MustUnderstand { get; set; }
+        public bool Relay { get; set; }
+        public MessageHeader GetUntypedHeader(string name, string ns);
+    }
+    public class MessageHeaderAttribute : MessageContractMemberAttribute {
+        public MessageHeaderAttribute();
+        public string Actor { get; set; }
+        public bool MustUnderstand { get; set; }
+        public bool Relay { get; set; }
+    }
+    public class MessageHeaderException : ProtocolException {
+        public MessageHeaderException();
+        public MessageHeaderException(string message);
+        public MessageHeaderException(string message, bool isDuplicate);
+        public MessageHeaderException(string message, Exception innerException);
+        public MessageHeaderException(string message, string headerName, string ns);
+        public MessageHeaderException(string message, string headerName, string ns, bool isDuplicate);
+        public MessageHeaderException(string message, string headerName, string ns, bool isDuplicate, Exception innerException);
+        public MessageHeaderException(string message, string headerName, string ns, Exception innerException);
+        public string HeaderName { get; }
+        public string HeaderNamespace { get; }
+        public bool IsDuplicate { get; }
+    }
+    public sealed class MessageParameterAttribute : Attribute {
+        public MessageParameterAttribute();
+        public string Name { get; set; }
+    }
+    public sealed class MessageSecurityOverTcp {
+        public MessageSecurityOverTcp();
+        public MessageCredentialType ClientCredentialType { get; set; }
+    }
+    public abstract class MessageSecurityVersion {
+        public abstract BasicSecurityProfileVersion BasicSecurityProfileVersion { get; }
+        public static MessageSecurityVersion Default { get; }
+        public SecureConversationVersion SecureConversationVersion { get; }
+        public abstract SecurityPolicyVersion SecurityPolicyVersion { get; }
+        public SecurityTokenVersion SecurityTokenVersion { get; }
+        public SecurityVersion SecurityVersion { get; }
+        public TrustVersion TrustVersion { get; }
+        public static MessageSecurityVersion WSSecurity10WSTrust13WSSecureConversation13WSSecurityPolicy12BasicSecurityProfile10 { get; }
+        public static MessageSecurityVersion WSSecurity10WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11BasicSecurityProfile10 { get; }
+        public static MessageSecurityVersion WSSecurity11WSTrust13WSSecureConversation13WSSecurityPolicy12 { get; }
+        public static MessageSecurityVersion WSSecurity11WSTrust13WSSecureConversation13WSSecurityPolicy12BasicSecurityProfile10 { get; }
+        public static MessageSecurityVersion WSSecurity11WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11 { get; }
+        public static MessageSecurityVersion WSSecurity11WSTrustFebruary2005WSSecureConversationFebruary2005WSSecurityPolicy11BasicSecurityProfile10 { get; }
+    }
+    public class NetHttpBinding : HttpBindingBase {
+        public NetHttpBinding();
+        public NetHttpBinding(BasicHttpSecurityMode securityMode);
+        public NetHttpBinding(string configurationName);
+        public NetHttpMessageEncoding MessageEncoding { get; set; }
+        public BasicHttpSecurity Security { get; set; }
+        public WebSocketTransportSettings WebSocketSettings { get; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingParameterCollection parameters);
+        public override BindingElementCollection CreateBindingElements();
+    }
+    public enum NetHttpMessageEncoding {
+        Binary = 0,
+        Mtom = 2,
+        Text = 1,
+    }
+    public class NetHttpsBinding : HttpBindingBase {
+        public NetHttpsBinding();
+        public NetHttpsBinding(BasicHttpsSecurityMode securityMode);
+        public NetHttpMessageEncoding MessageEncoding { get; set; }
+        public BasicHttpsSecurity Security { get; set; }
+        public WebSocketTransportSettings WebSocketSettings { get; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingParameterCollection parameters);
+        public override BindingElementCollection CreateBindingElements();
+    }
+    public class NetTcpBinding : Binding {
+        public NetTcpBinding();
+        public NetTcpBinding(SecurityMode securityMode);
+        public NetTcpBinding(string configurationName);
+        public EnvelopeVersion EnvelopeVersion { get; }
+        public long MaxBufferPoolSize { get; set; }
+        public int MaxBufferSize { get; set; }
+        public long MaxReceivedMessageSize { get; set; }
+        public XmlDictionaryReaderQuotas ReaderQuotas { get; set; }
+        public override string Scheme { get; }
+        public NetTcpSecurity Security { get; set; }
+        public TransferMode TransferMode { get; set; }
+        public override BindingElementCollection CreateBindingElements();
+    }
+    public sealed class NetTcpSecurity {
+        public NetTcpSecurity();
+        public MessageSecurityOverTcp Message { get; set; }
+        public SecurityMode Mode { get; set; }
+        public TcpTransportSecurity Transport { get; set; }
+    }
+    public sealed class OperationContext : IExtensibleObject<OperationContext> {
+        public OperationContext(IContextChannel channel);
+        public IContextChannel Channel { get; }
+        public ClaimsPrincipal ClaimsPrincipal { get; internal set; }
+        public static OperationContext Current { get; set; }
+        public EndpointDispatcher EndpointDispatcher { get; set; }
+        public IExtensionCollection<OperationContext> Extensions { get; }
+        public MessageHeaders IncomingMessageHeaders { get; }
+        public MessageProperties IncomingMessageProperties { get; }
+        public MessageVersion IncomingMessageVersion { get; }
+        public InstanceContext InstanceContext { get; }
+        public bool IsUserContext { get; }
+        public MessageHeaders OutgoingMessageHeaders { get; }
+        public MessageProperties OutgoingMessageProperties { get; }
+        public RequestContext RequestContext { get; set; }
+        public string SessionId { get; }
+        public event EventHandler OperationCompleted;
+        public T GetCallbackChannel<T>();
+    }
+    public sealed class OperationContextScope : IDisposable {
+        public OperationContextScope(IContextChannel channel);
+        public OperationContextScope(OperationContext context);
+        public void Dispose();
+    }
+    public sealed class OperationContractAttribute : Attribute {
+        public OperationContractAttribute();
+        public string Action { get; set; }
+        public bool AsyncPattern { get; set; }
+        public bool HasProtectionLevel { get; }
+        public bool IsInitiating { get; set; }
+        public bool IsOneWay { get; set; }
+        public string Name { get; set; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+        public string ReplyAction { get; set; }
+    }
+    public enum OperationFormatStyle {
+        Document = 0,
+        Rpc = 1,
+    }
+    public class Pool<T> where T : class {
+        public Pool(int maxCount);
+        public int Count { get; }
+        public void Clear();
+        public bool Return(T item);
+        public T Take();
+    }
+    public class ProtocolException : CommunicationException {
+        public ProtocolException();
+        public ProtocolException(string message);
+        public ProtocolException(string message, Exception innerException);
+    }
+    public class QuotaExceededException : Exception {
+        public QuotaExceededException();
+        public QuotaExceededException(string message);
+        public QuotaExceededException(string message, Exception innerException);
+    }
+    public enum ReceiveErrorHandling {
+        Drop = 1,
+        Fault = 0,
+        Move = 3,
+        Reject = 2,
+    }
+    public enum SecurityMode {
+        Message = 2,
+        None = 0,
+        Transport = 1,
+        TransportWithMessageCredential = 3,
+    }
+    public static class SecurityModeHelper {
+        public static bool IsDefined(SecurityMode value);
+        public static SecurityMode ToSecurityMode(UnifiedSecurityMode value);
+    }
+    public class ServerTooBusyException : CommunicationException {
+        public ServerTooBusyException();
+        public ServerTooBusyException(string message);
+        public ServerTooBusyException(string message, Exception innerException);
+    }
+    public class ServiceActivationException : CommunicationException {
+        public ServiceActivationException();
+        public ServiceActivationException(string message);
+        public ServiceActivationException(string message, Exception innerException);
+    }
+    public sealed class ServiceContractAttribute : Attribute {
+        public ServiceContractAttribute();
+        public Type CallbackContract { get; set; }
+        public string ConfigurationName { get; set; }
+        public bool HasProtectionLevel { get; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public ProtectionLevel ProtectionLevel { get; set; }
+        public SessionMode SessionMode { get; set; }
+    }
+    public static class ServiceDefaults {
+        public static TimeSpan CloseTimeout { get; }
+        public static TimeSpan OpenTimeout { get; }
+        public static TimeSpan ReceiveTimeout { get; }
+        public static TimeSpan SendTimeout { get; }
+    }
+    public sealed class ServiceKnownTypeAttribute : Attribute {
+        public ServiceKnownTypeAttribute(string methodName);
+        public ServiceKnownTypeAttribute(string methodName, Type declaringType);
+        public ServiceKnownTypeAttribute(Type type);
+        public Type DeclaringType { get; }
+        public string MethodName { get; }
+        public Type Type { get; }
+    }
+    public class ServiceSecurityContext {
+        public ServiceSecurityContext(ReadOnlyCollection<IAuthorizationPolicy> authorizationPolicies);
+        public ServiceSecurityContext(AuthorizationContext authorizationContext);
+        public ServiceSecurityContext(AuthorizationContext authorizationContext, ReadOnlyCollection<IAuthorizationPolicy> authorizationPolicies);
+        public static ServiceSecurityContext Anonymous { get; }
+        public AuthorizationContext AuthorizationContext { get; }
+        public ReadOnlyCollection<IAuthorizationPolicy> AuthorizationPolicies { get; set; }
+        public bool IsAnonymous { get; }
+        public IIdentity PrimaryIdentity { get; }
+    }
+    public enum SessionMode {
+        Allowed = 0,
+        NotAllowed = 2,
+        Required = 1,
+    }
+    public class SpnEndpointIdentity : EndpointIdentity {
+        public SpnEndpointIdentity(Claim identity);
+        public SpnEndpointIdentity(string spnName);
+        public static TimeSpan SpnLookupTime { get; set; }
+    }
+    public enum TcpClientCredentialType {
+        Certificate = 2,
+        None = 0,
+        Windows = 1,
+    }
+    public sealed class TcpTransportSecurity {
+        public TcpTransportSecurity();
+        public TcpClientCredentialType ClientCredentialType { get; set; }
+        public SslProtocols SslProtocols { get; set; }
+    }
+    public static class TimeSpanHelper {
+        public static TimeSpan FromMilliseconds(int ms, string text);
+        public static TimeSpan FromMinutes(int minutes, string text);
+        public static TimeSpan FromSeconds(int seconds, string text);
+    }
+    public enum TransferMode {
+        Buffered = 0,
+        Streamed = 1,
+        StreamedRequest = 2,
+        StreamedResponse = 3,
+    }
+    public static class TransferModeHelper {
+        public static bool IsDefined(TransferMode v);
+        public static bool IsRequestStreamed(TransferMode v);
+        public static bool IsResponseStreamed(TransferMode v);
+        public static void Validate(TransferMode value);
+    }
+    public enum UnifiedSecurityMode {
+        Both = 16,
+        Message = 8,
+        None = 1,
+        Transport = 4,
+        TransportCredentialOnly = 64,
+        TransportWithMessageCredential = 32,
+    }
+    public sealed class UnknownMessageReceivedEventArgs : EventArgs {
+        public Message Message { get; }
+    }
+    public class UpnEndpointIdentity : EndpointIdentity {
+        public UpnEndpointIdentity(Claim identity);
+        public UpnEndpointIdentity(string upnName);
+    }
+    public class UriSchemeKeyedCollection : SynchronizedKeyedCollection<string, Uri> {
+        public UriSchemeKeyedCollection(params Uri[] addresses);
+        protected override string GetKeyForItem(Uri item);
+        protected override void InsertItem(int index, Uri item);
+        protected override void SetItem(int index, Uri item);
+    }
+    public enum WSMessageEncoding {
+        Text = 0,
+    }
+    public class X509CertificateEndpointIdentity : EndpointIdentity {
+        public X509CertificateEndpointIdentity(X509Certificate2 certificate);
+        public X509CertificateEndpointIdentity(X509Certificate2 primaryCertificate, X509Certificate2Collection supportingCertificates);
+        public X509Certificate2Collection Certificates { get; }
+    }
+    public sealed class XmlSerializerFormatAttribute : Attribute {
+        public XmlSerializerFormatAttribute();
+        public OperationFormatStyle Style { get; set; }
+        public bool SupportFaults { get; set; }
+    }
+}
```

