# .NET Core 3.0.0 Preview 2

.NET Core 3.0.0 Preview 2 comprises:

* .NET Core Runtime 3.0.0-preview-27324-5
* ASP.NET Core 3.0.0-preview-19075-0444
* .NET Core SDK 3.0.100-preview-010184

See the [Release Notes](https://github.com/dotnet/core/blob/master/release-notes/3.0/preview/3.0.0-preview2.md) for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://blogs.msdn.microsoft.com/dotnet/2018/06/18/staying-up-to-date-with-net-container-images/).

## Installing .NET Core 3.0.0 Preview 2 on Linux

Snap is the preferred way to install and try .NET Core previews on [Linux distributions that support Snap](https://docs.snapcraft.io/installing-snapd/6735).

After configuring Snap on your system, run the following command to install the .NET Core SDK 3.0 Preview.

`sudo snap install dotnet-sdk --beta --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

Some distros require an additional step to enable access to the SSL certificate. See [Linux Setup](https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md) for details.

### Installation from a binary archive

You can also install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/master/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.0` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.0` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installers can be used on Windows and Linx systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.0.0-preview-19075-0444-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/master/release-notes/3.0/preview/3.0.0-preview2.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c91ed181-87b5-455f-ace8-7c288fd27a02/5eca93bead02f2b6d2bd5e3968a8f997/dotnet-runtime-3.0.0-preview-27324-5-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/54f8a5fa-37a6-4bd1-be00-e92d428ba9fc/6d87634846e580d563daee8df761ca50/dotnet-runtime-3.0.0-preview-27324-5-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4ea98538-3144-4c3e-aaba-f9b6d37d85c5/17b867d5fb4dfd753b2ecabe40762a51/dotnet-runtime-3.0.0-preview-27324-5-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f29a6be7-72a1-493c-a047-f01c93e67b15/c40ce83a8f85432d4c8a019ea5a7a34f/dotnet-runtime-3.0.0-preview-27324-5-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5aa8af44-d469-4556-a2ff-41f5c275a7b4/8ffaf6c431aea9a0f1daf02760d1efff/dotnet-runtime-3.0.0-preview-27324-5-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3e75c91-9f50-4509-b525-eaf83da3e037/497a1ddf6739df041de49c01599378f4/dotnet-runtime-3.0.0-preview-27324-5-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4331b9ec-0686-4a2b-900a-cdcf699cd016/9f7ce2a0009d3463ceccc0f6214713af/dotnet-runtime-3.0.0-preview-27324-5-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/6004c6c3-015e-4900-bb45-b6ad79b05238/74fe4419b74a40895fc88eb27fa413b3/dotnet-runtime-3.0.0-preview-27324-5-win-arm.zip
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/a764f239-ea5f-436a-a3b0-cecc955cc0ab/67e8f1848e7469c029a0704eb8cc77b0/dotnet-runtime-3.0.0-preview-27324-5-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/30594a10-9dcf-44c9-88c2-c559da2a0c6e/7cb211623fefc681750632dc6e5b3b36/dotnet-runtime-3.0.0-preview-27324-5-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/1abbe748-2565-422b-aae9-e127a138c2fb/ae4ddb0d6820f9f32374d85b352646dd/dotnet-runtime-3.0.0-preview-27324-5-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a124f110-426e-47e5-bc3a-6e7452a878ff/54c7fbd2df2e976b832eb317f7b49767/dotnet-runtime-3.0.0-preview-27324-5-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3d12d669-d0ec-47e5-abdf-7a836280510b/78f592341859c071ab92ce893f5be66b/dotnet-runtime-3.0.0-preview-27324-5-win-x86.zip

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c83595cd-7f49-484d-89cf-3dfffc1cca15/de670466aeeb953b5487d44039e65ca7/aspnetcore-runtime-3.0.0-preview-19075-0444-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3ccac0c-16f8-4574-8ed4-1bb8c1bd1bbd/a6611d9400eff28e507bd0e213c0aeb1/aspnetcore-runtime-3.0.0-preview-19075-0444-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2f85d75a-5a3f-4f3e-a30b-8ba033b61ee6/16f3a28b8da98d6a8cedf9e333ada502/aspnetcore-runtime-3.0.0-preview-19075-0444-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8123f592-5157-439f-9db6-3e20d34b903d/83e9abdd3a7dbf9d1900d754c5fab7d8/aspnetcore-runtime-3.0.0-preview-19075-0444-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8fa5bf65-5d96-478b-ab47-f05498d19817/fb3c9f3d301734ed9ef86bc3b03c7691/aspnetcore-runtime-3.0.0-preview-19075-0444-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8e32cd17-59fe-4865-a675-80040c9a6434/fff561380a16769312717f1c7caa8ec5/aspnetcore-runtime-3.0.0-preview-19075-0444-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/06089a79-846b-462f-bf50-71046c046741/b6c1eeea8fbe210af11261f3d7b40f25/aspnetcore-runtime-3.0.0-preview-19075-0444-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f6553777-48be-46b2-8588-708e5585e6d7/06bab8faa0bb1e413a0cb0c73eaf7eea/aspnetcore-runtime-3.0.0-preview-19075-0444-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5fe8dd95-5649-4c05-9dd2-a79c692007d1/adca517a835200b3253fa337229cf415/aspnetcore-runtime-3.0.0-preview-19075-0444-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d252ee01-b95d-476e-93db-ac01d81ee0c2/9465056dad090c55a2d19708162eb55b/aspnetcore-runtime-3.0.0-preview-19075-0444-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/1f4548a4-96a4-4905-b222-1115d0f30535/a7eaa7c6565c2273991e0f3ca4c790c9/dotnet-hosting-3.0.0-preview-19075-0444-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/83bca990-9618-46d8-b096-32ecdf3ae492/c2f9d2785e78f20de0c3bb2adb880c5e/dotnet-sdk-3.0.100-preview-010184-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/716a5791-eca8-4b65-b1bd-6a9852327b00/4cb3c2c89e2428bebcdb7193eaa45b91/dotnet-sdk-3.0.100-preview-010184-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3e28fec3-fd16-4fb3-8eaf-bb7351ab210c/50b758004c5c307fa048b7ef41fa47d2/dotnet-sdk-3.0.100-preview-010184-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/efa6dde9-a5ee-4322-b13c-a2a02d3980f0/dad445eba341c1d806bae5c8afb47015/dotnet-sdk-3.0.100-preview-010184-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9748ef38-c39d-421c-85ba-87cb594f39d7/44971a83ac21284c39927cba8d747d99/dotnet-sdk-3.0.100-preview-010184-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1cff8a8-9c60-4818-92c4-ac2ebe8fc47f/cce8dd19438ac62ff52d80fab7a61093/dotnet-sdk-3.0.100-preview-010184-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/96b5fd54-7c90-4b83-ac12-9015093ba1b7/d7684cc81cfab9fc10d2b51b6c11a9d9/dotnet-sdk-3.0.100-preview-010184-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ad976dfc-09d8-429b-9c49-48626898b1bf/680250d6940b02dd7a392321afec9aa6/dotnet-sdk-3.0.100-preview-010184-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a7e73d05-4e75-4543-ac41-fc69d2f617e5/3f65a44f90c9df66664b44e86b0e6d29/dotnet-sdk-3.0.100-preview-010184-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/918c5936-1c58-4a6a-b738-0a9766ec6192/4f17576e7efe45c447a088adda08b2f9/dotnet-sdk-3.0.100-preview-010184-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/49471fc3-4a86-4f2d-bfe9-b26f8681a728/73a0afdc0bc45fc52b9f182efb6310ed/dotnet-sdk-3.0.100-preview-010184-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/760485de-7ad3-4cf7-aa48-1fd5aaf4f4f6/eb1e06460b5b061f6a61068fabeb28f8/dotnet-sdk-3.0.100-preview-010184-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/3bb56825-2b32-4abb-9052-040a276d16d1/a059da55e95a6f516b433c97de17ad56/aspnet-3.0.0-preview2-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/6eacf7dc-e302-487d-956e-86277f630491/30fa1ae51bb033a8f58391612112567f/core-setup-3.0.0-preview2-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/9b361fc7-c3fc-4964-b1e7-9826d2f3778e/036f50690dca77182353bd78474c0ffe/coreclr-3.0.0-preview2-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/1a50a636-b56f-48ed-a5ab-7cdf8c85914e/d89d8d15227621c495b7eebfea54d3b5/corefx-3.0.0-preveiw2-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.0-preview-27324-5-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.100-preview-010184-sdk-sha.txt

[linux-install]: https://www.microsoft.com/net/download/linux
[linux-setup]: https://github.com/dotnet/core/blob/master/Documentation/linux-setup.md

[dotnet-blog]: https://blogs.msdn.microsoft.com/dotnet/
