/*
 * Decompiled with CFR 0.152.
 */
package driftwood.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AngleDial
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final Dimension DIAL_DIM = new Dimension(92, 92);
    static final DecimalFormat df1 = new DecimalFormat("0.0");
    static final double TWO_PI = Math.PI * 2;
    static final Color backColor = new Color(0xFFFFFF);
    static final Color activeBack = new Color(0xFFFFCC);
    static final Color offBack = new Color(0xCCCCCC);
    static final Color ghostColor = new Color(0xBBBBBB);
    static final Color currColor = new Color(204);
    static final Color activeCurr = new Color(0xFF6600);
    static final Color foreColor = new Color(0);
    static final Color offFore = new Color(0x999999);
    int size;
    int top;
    int left;
    int cx;
    int cy;
    Font font;
    FontMetrics metrics = null;
    Line2D.Double line2d = new Line2D.Double();
    Ellipse2D.Double ellipse2d = new Ellipse2D.Double();
    BasicStroke pen1 = new BasicStroke(1.0f, 1, 1);
    BasicStroke pen2 = new BasicStroke(2.0f, 1, 1);
    Rectangle plusBtn = new Rectangle();
    Rectangle minusBtn = new Rectangle();
    Formatter formatter = null;
    boolean paintOrigAngle = true;
    double currAngleValue;
    double origAngleValue;
    int mouseSensitivity = 3600;
    double stepSize = Math.PI / 180;
    boolean isUpdating = false;
    double dragStartAngle = 0.0;
    int dragStartX = 0;
    int dragStartY = 0;
    double dragAngleOffset = 0.0;
    Collection changeListeners = new ArrayList();

    public AngleDial() {
        this(0.0, 0.0);
    }

    public AngleDial(double d, double d2) {
        this.currAngleValue = d;
        this.origAngleValue = d2;
        this.setPreferredSize(DIAL_DIM);
        this.setMinimumSize(DIAL_DIM);
        this.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.font = new Font("SansSerif", 0, 18);
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        graphics.setFont(this.font);
        if (this.metrics == null) {
            this.metrics = graphics.getFontMetrics();
        }
        this.size = Math.min(dimension.width, dimension.height) - 1;
        this.left = (dimension.width - this.size) / 2;
        this.top = (dimension.height - this.size) / 2;
        this.cx = dimension.width / 2;
        this.cy = dimension.height / 2;
        boolean bl = !this.isEnabled();
        graphics2D.setStroke(this.pen1);
        if (bl) {
            graphics.setColor(offBack);
        } else if (this.isUpdating) {
            graphics.setColor(activeBack);
        } else {
            graphics.setColor(backColor);
        }
        this.ellipse2d.setFrame(this.left, this.top, this.size, this.size);
        graphics2D.fill(this.ellipse2d);
        graphics2D.setStroke(this.pen2);
        double d = this.getOrigRadians();
        if (bl) {
            graphics.setColor(offFore);
        } else {
            graphics.setColor(ghostColor);
        }
        this.line2d.setLine(this.cx, this.cy, this.cx + (int)(0.5 * (double)this.size * Math.cos(d)), this.cy - (int)(0.5 * (double)this.size * Math.sin(d)));
        graphics2D.draw(this.line2d);
        double d2 = this.getRadians();
        String string = this.formatter == null ? this.defaultFormatAngle(d2) : this.formatter.formatAngle(d2);
        int n2 = this.cx - this.metrics.stringWidth(string) / 2;
        int n3 = n = d2 > Math.PI ? this.cy - 4 : this.cy + 2 + this.metrics.getMaxAscent();
        if (bl) {
            graphics.setColor(offFore);
        } else {
            graphics.setColor(foreColor);
        }
        graphics.drawString(string, n2, n);
        if (this.getPaintOrigAngle()) {
            string = this.formatter == null ? this.defaultFormatAngle(d) : this.formatter.formatAngle(d);
            n2 = this.cx - this.metrics.stringWidth(string) / 2;
            int n4 = n = d2 > Math.PI ? this.cy + 2 + this.metrics.getMaxAscent() : this.cy - 4;
            if (bl) {
                graphics.setColor(offFore);
            } else {
                graphics.setColor(ghostColor);
            }
            graphics.drawString(string, n2, n);
        }
        graphics2D.setStroke(this.pen2);
        if (bl) {
            graphics.setColor(offFore);
        } else if (this.isUpdating) {
            graphics.setColor(activeCurr);
        } else {
            graphics.setColor(currColor);
        }
        this.line2d.setLine(this.cx, this.cy, this.cx + (int)(0.5 * (double)this.size * Math.cos(d2)), this.cy - (int)(0.5 * (double)this.size * Math.sin(d2)));
        graphics2D.draw(this.line2d);
        graphics2D.setStroke(this.pen1);
        if (bl) {
            graphics.setColor(offFore);
        } else {
            graphics.setColor(foreColor);
        }
        graphics2D.draw(this.ellipse2d);
        int n5 = (int)(0.146 * (double)this.size) - 2;
        this.plusBtn.setBounds(this.left, this.top + this.size - n5, n5, n5);
        this.minusBtn.setBounds(this.left + this.size - n5, this.top + this.size - n5, n5, n5);
        graphics2D.setStroke(this.pen1);
        if (bl) {
            graphics.setColor(offBack);
        } else {
            graphics.setColor(backColor);
        }
        graphics2D.fill(this.plusBtn);
        graphics2D.fill(this.minusBtn);
        if (bl) {
            graphics.setColor(offFore);
        } else {
            graphics.setColor(foreColor);
        }
        graphics2D.draw(this.plusBtn);
        graphics2D.draw(this.minusBtn);
        graphics2D.setStroke(this.pen2);
        this.line2d.setLine(this.plusBtn.x + 3, (double)this.plusBtn.y + (double)this.plusBtn.height / 2.0, this.plusBtn.x + this.plusBtn.width - 3, (double)this.plusBtn.y + (double)this.plusBtn.height / 2.0);
        graphics2D.draw(this.line2d);
        this.line2d.setLine((double)this.plusBtn.x + (double)this.plusBtn.width / 2.0, this.plusBtn.y + 3, (double)this.plusBtn.x + (double)this.plusBtn.width / 2.0, this.plusBtn.y + this.plusBtn.height - 3);
        graphics2D.draw(this.line2d);
        this.line2d.setLine(this.minusBtn.x + 3, (double)this.minusBtn.y + (double)this.minusBtn.height / 2.0, this.minusBtn.x + this.minusBtn.width - 3, (double)this.minusBtn.y + (double)this.minusBtn.height / 2.0);
        graphics2D.draw(this.line2d);
    }

    protected String defaultFormatAngle(double d) {
        if ((d = Math.toDegrees(d)) > 180.0) {
            d -= 360.0;
        }
        return df1.format(d);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.plusBtn.contains(mouseEvent.getPoint())) {
            this.setDegrees(this.getDegrees() + 360.0 / (double)this.mouseSensitivity);
        } else if (this.minusBtn.contains(mouseEvent.getPoint())) {
            this.setDegrees(this.getDegrees() - 360.0 / (double)this.mouseSensitivity);
        } else if (this.isEnabled() && mouseEvent.getClickCount() == 2) {
            this.setRadians(this.getOrigRadians());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.isUpdating = true;
        this.dragStartAngle = this.getRadians();
        this.dragStartX = mouseEvent.getX();
        this.dragStartY = mouseEvent.getY();
        this.dragAngleOffset = Math.atan2(this.cy - this.dragStartY, this.dragStartX - this.cx);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.isUpdating = false;
        if (this.isEnabled() && this.getRadians() != this.dragStartAngle) {
            this.fireStateChanged();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.isShiftDown()) {
                int n = mouseEvent.getX() - this.dragStartX - (mouseEvent.getY() - this.dragStartY);
                this.setRadians(this.dragStartAngle + Math.PI * 2 * (double)n / (double)this.mouseSensitivity);
            } else {
                int n = mouseEvent.getX() - this.cx;
                int n2 = mouseEvent.getY() - this.cy;
                this.setRadians(this.dragStartAngle + Math.atan2(-n2, n) - this.dragAngleOffset);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
        this.repaint();
    }

    public double getRadians() {
        return this.currAngleValue;
    }

    public void setRadians(double d) {
        if ((d %= Math.PI * 2) < 0.0) {
            d += Math.PI * 2;
        }
        if (this.currAngleValue != d) {
            this.currAngleValue = d;
            this.fireStateChanged();
        }
    }

    public double getDegrees() {
        return Math.toDegrees(this.getRadians());
    }

    public void setDegrees(double d) {
        this.setRadians(Math.toRadians(d));
    }

    public double getOrigRadians() {
        return this.origAngleValue;
    }

    public void setOrigRadians(double d) {
        if ((d %= Math.PI * 2) < 0.0) {
            d += Math.PI * 2;
        }
        if (this.origAngleValue != d) {
            this.origAngleValue = d;
            this.fireStateChanged();
        }
    }

    public double getOrigDegrees() {
        return Math.toDegrees(this.getOrigRadians());
    }

    public void setOrigDegrees(double d) {
        this.setOrigRadians(Math.toRadians(d));
    }

    public int getSensitivity() {
        return this.mouseSensitivity;
    }

    public void setSensitivity(int n) {
        this.mouseSensitivity = n;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double d) {
        this.stepSize = d;
    }

    public boolean getPaintOrigAngle() {
        return this.paintOrigAngle;
    }

    public void setPaintOrigAngle(boolean bl) {
        this.paintOrigAngle = bl;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean getValueIsAdjusting() {
        return this.isUpdating;
    }

    public static interface Formatter {
        public String formatAngle(double var1);
    }
}

