/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class Alignment {
    public Object[] a;
    public Object[] b;

    private Alignment() {
    }

    public double score(Scorer scorer) {
        double d = 0.0;
        for (int i = 0; i < Math.max(this.a.length, this.b.length); ++i) {
            if (this.a[i] == null) {
                if (i == 0 || this.a[i - 1] != null) {
                    d += scorer.open_gap(this.b[i]);
                    continue;
                }
                d += scorer.extend_gap(this.b[i]);
                continue;
            }
            if (this.b[i] == null) {
                if (i == 0 || this.b[i - 1] != null) {
                    d += scorer.open_gap(this.a[i]);
                    continue;
                }
                d += scorer.extend_gap(this.a[i]);
                continue;
            }
            d += scorer.score(this.a[i], this.b[i]);
        }
        return d;
    }

    public static Alignment needlemanWunsch(Object[] objectArray, Object[] objectArray2, Scorer scorer) {
        int n;
        Object[] objectArray3 = objectArray;
        Object[] objectArray4 = objectArray2;
        double[][] dArray = new double[objectArray3.length + 1][objectArray4.length + 1];
        int[][] nArray = new int[objectArray3.length + 1][objectArray4.length + 1];
        dArray[0][0] = 0.0;
        for (n = 0; n < objectArray3.length; ++n) {
            dArray[n + 1][0] = dArray[n][0] + (n == 0 ? scorer.open_gap(objectArray3[n]) : scorer.extend_gap(objectArray3[n]));
            nArray[n + 1][0] = 2;
        }
        for (n = 0; n < objectArray4.length; ++n) {
            dArray[0][n + 1] = dArray[0][n] + (n == 0 ? scorer.open_gap(objectArray4[n]) : scorer.extend_gap(objectArray4[n]));
            nArray[0][n + 1] = 1;
        }
        for (n = 0; n < objectArray3.length; ++n) {
            for (int i = 0; i < objectArray4.length; ++i) {
                double d = dArray[n][i + 1] + (nArray[n][i + 1] == 2 ? scorer.extend_gap(objectArray3[n]) : scorer.open_gap(objectArray3[n]));
                double d2 = dArray[n + 1][i] + (nArray[n + 1][i] == 1 ? scorer.extend_gap(objectArray4[i]) : scorer.open_gap(objectArray4[i]));
                double d3 = dArray[n][i] + scorer.score(objectArray3[n], objectArray4[i]);
                if (d3 >= d && d3 >= d2) {
                    dArray[n + 1][i + 1] = d3;
                    nArray[n + 1][i + 1] = 4;
                    continue;
                }
                if (d >= d2) {
                    dArray[n + 1][i + 1] = d;
                    nArray[n + 1][i + 1] = 2;
                    continue;
                }
                dArray[n + 1][i + 1] = d2;
                nArray[n + 1][i + 1] = 1;
            }
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        int n2 = objectArray3.length - 1;
        int n3 = objectArray4.length - 1;
        while (n2 >= 0 && n3 >= 0) {
            if (nArray[n2 + 1][n3 + 1] == 4) {
                linkedList.addFirst(objectArray3[n2]);
                linkedList2.addFirst(objectArray4[n3]);
                --n2;
                --n3;
                continue;
            }
            if (nArray[n2 + 1][n3 + 1] == 2) {
                linkedList.addFirst(objectArray3[n2]);
                linkedList2.addFirst(null);
                --n2;
                continue;
            }
            linkedList.addFirst(null);
            linkedList2.addFirst(objectArray4[n3]);
            --n3;
        }
        while (n2 >= 0) {
            linkedList.addFirst(objectArray3[n2]);
            linkedList2.addFirst(null);
            --n2;
        }
        while (n3 >= 0) {
            linkedList.addFirst(null);
            linkedList2.addFirst(objectArray4[n3]);
            --n3;
        }
        Alignment alignment = new Alignment();
        alignment.a = linkedList.toArray();
        alignment.b = linkedList2.toArray();
        return alignment;
    }

    public static Alignment alignChains(Collection collection, Collection collection2, Aligner aligner, Scorer scorer) {
        int n;
        int n2;
        Alignment[][] alignmentArray = new Alignment[collection.size()][collection2.size()];
        double[][] dArray = new double[collection.size()][collection2.size()];
        int n3 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = ((Collection)iterator.next()).toArray();
            n2 = 0;
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                Object[] objectArray2 = ((Collection)iterator2.next()).toArray();
                alignmentArray[n3][n2] = aligner.align(objectArray, objectArray2, scorer);
                dArray[n3][n2] = alignmentArray[n3][n2].score(scorer);
                ++n2;
            }
            ++n3;
        }
        int n4 = collection.size();
        int n5 = collection2.size();
        n2 = Math.min(n4, n5);
        int n6 = Math.max(n4, n5);
        double d = Double.NEGATIVE_INFINITY;
        int[] nArray = new int[n6];
        int[] nArray2 = null;
        for (int i = 0; i < n6; ++i) {
            nArray[i] = Math.min(i, n2);
        }
        do {
            double d2 = 0.0;
            for (n = 0; n < n6; ++n) {
                if (nArray[n] >= n2) continue;
                if (n4 >= n5) {
                    d2 += dArray[n][nArray[n]];
                    continue;
                }
                d2 += dArray[nArray[n]][n];
            }
            if (nArray2 != null && !(d2 > d)) continue;
            d = d2;
            nArray2 = (int[])nArray.clone();
        } while (Alignment.next_permutation(nArray));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        nArray = nArray2;
        for (n = 0; n < n6; ++n) {
            if (nArray[n] >= n2) continue;
            if (n4 >= n5) {
                if (dArray[n][nArray[n]] <= 0.0) continue;
                arrayList.addAll(Arrays.asList(alignmentArray[n][nArray[n]].a));
                arrayList2.addAll(Arrays.asList(alignmentArray[n][nArray[n]].b));
                continue;
            }
            if (dArray[nArray[n]][n] <= 0.0) continue;
            arrayList.addAll(Arrays.asList(alignmentArray[nArray[n]][n].a));
            arrayList2.addAll(Arrays.asList(alignmentArray[nArray[n]][n].b));
        }
        Alignment alignment = new Alignment();
        alignment.a = arrayList.toArray();
        alignment.b = arrayList2.toArray();
        return alignment;
    }

    private static boolean next_permutation(int[] nArray) {
        if (nArray.length <= 1) {
            return false;
        }
        int n = nArray.length - 1;
        do {
            int n2;
            if (nArray[--n] >= nArray[n2]) continue;
            int n3 = nArray.length;
            while (nArray[n] >= nArray[--n3]) {
            }
            int n4 = nArray[n];
            nArray[n] = nArray[n3];
            nArray[n3] = n4;
            Alignment.reverse(nArray, n2, nArray.length);
            return true;
        } while (n != 0);
        Alignment.reverse(nArray, 0, nArray.length);
        return false;
    }

    private static void reverse(int[] nArray, int n, int n2) {
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            int n4 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = n4;
        }
    }

    public static void main(String[] stringArray) {
        Alignment alignment = Alignment.needlemanWunsch(Alignment.makeCharSet(stringArray[0]), Alignment.makeCharSet(stringArray[1]), new Scorer(){

            public double score(Object object, Object object2) {
                if (object.equals(object2)) {
                    return 1.0;
                }
                return 0.0;
            }

            public double open_gap(Object object) {
                return this.extend_gap(object);
            }

            public double extend_gap(Object object) {
                return -1.0;
            }
        });
        Alignment.printAlignedSet(alignment.a);
        Alignment.printAlignedSet(alignment.b);
    }

    static Object[] makeCharSet(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            arrayList.add(string.substring(i, i + 1));
        }
        return arrayList.toArray();
    }

    static void printAlignedSet(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                System.out.print("-");
                continue;
            }
            System.out.print(objectArray[i]);
        }
        System.out.println();
    }

    public static class NeedlemanWunsch
    implements Aligner {
        public Alignment align(Object[] objectArray, Object[] objectArray2, Scorer scorer) {
            return Alignment.needlemanWunsch(objectArray, objectArray2, scorer);
        }
    }

    public static interface Aligner {
        public Alignment align(Object[] var1, Object[] var2, Scorer var3);
    }

    public static interface Scorer {
        public double score(Object var1, Object var2);

        public double open_gap(Object var1);

        public double extend_gap(Object var1);
    }
}

