/*
 * Decompiled with CFR 0.152.
 */
package driftwood.parser;

import driftwood.parser.CharWindow;
import driftwood.parser.RegexTokenMatcher;
import driftwood.parser.TokenMatcher;
import java.io.IOException;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenWindow {
    CharWindow window;
    TokenMatcher matcher;
    int prevTokens = 0;
    int bufEnd = 0;
    int bufMask;
    String[] buffer;
    int[] winEnd;

    public TokenWindow(CharWindow charWindow, TokenMatcher tokenMatcher) {
        this(charWindow, tokenMatcher, 16);
    }

    public TokenWindow(CharWindow charWindow, TokenMatcher tokenMatcher, int n) {
        int n2;
        for (n2 = 4; n2 < n; n2 <<= 1) {
        }
        this.buffer = new String[n2];
        this.winEnd = new int[n2];
        this.bufMask = n2 - 1;
        this.window = charWindow;
        this.matcher = tokenMatcher;
    }

    public String token() throws ParseException {
        return this.tokenAt(0);
    }

    public String tokenAt(int n) throws ParseException {
        if (n < this.bufEnd - this.buffer.length) {
            throw new IndexOutOfBoundsException("Current range is [" + (this.bufEnd - this.buffer.length) + ", " + this.bufEnd + "); can't get " + n);
        }
        while (n >= this.bufEnd) {
            int n2;
            int n3;
            int n4;
            if ((n4 = this.winEnd[n3 = (n2 = this.prevTokens + this.bufEnd++ & this.bufMask) - 1 & this.bufMask]) >= this.window.length()) {
                this.buffer[n2] = null;
                this.winEnd[n2] = n4;
                continue;
            }
            if (this.matcher.match(this.window, n4)) {
                this.buffer[n2] = this.matcher.token();
                this.winEnd[n2] = this.matcher.end();
                continue;
            }
            throw this.syntaxError(this.matcher.end(), "bad token");
        }
        return this.buffer[this.prevTokens + n & this.bufMask];
    }

    public void advance() throws ParseException, IOException {
        this.advance(1);
    }

    public void advance(int n) throws ParseException, IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Can't advance backwards!");
        }
        this.tokenAt(n);
        int n2 = this.prevTokens + n - 1 & this.bufMask;
        int n3 = this.winEnd[n2];
        this.window.advance(n3);
        this.prevTokens += n;
        this.bufEnd -= n;
        for (int i = 0; i < this.buffer.length; ++i) {
            int n4 = this.prevTokens + i & this.bufMask;
            this.winEnd[n4] = this.winEnd[n4] - n3;
        }
    }

    public boolean accept(String string) throws ParseException, IOException {
        String string2 = this.token();
        if (string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            this.advance();
            return true;
        }
        return false;
    }

    public boolean accept(Matcher matcher) throws ParseException, IOException {
        String string = this.token();
        if (string == null) {
            return false;
        }
        if (matcher.reset(string).matches()) {
            this.advance();
            return true;
        }
        return false;
    }

    public void require(String string) throws ParseException, IOException {
        if (!this.accept(string)) {
            throw this.syntaxError("Expected '" + string + "', found '" + this.token() + "'");
        }
    }

    public void require(Matcher matcher) throws ParseException, IOException {
        if (!this.accept(matcher)) {
            throw this.syntaxError("Expected '" + matcher.pattern() + "', found '" + this.token() + "'");
        }
    }

    public ParseException syntaxError(int n, String string) {
        int n2 = this.prevTokens + n & this.bufMask;
        boolean bl = this.buffer[n2] == null;
        int n3 = n2 - 1 & this.bufMask;
        int n4 = this.winEnd[n3];
        int n5 = this.window.lineAt(n4);
        int n6 = this.window.columnAt(n4);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Syntax error at line " + n5 + ", column " + n6 + ": " + string + "\n");
        String string2 = this.window.contextAt(n4);
        stringBuffer.append("> " + string2 + "\n");
        if (n6 <= string2.length() || bl) {
            stringBuffer.append('>');
            for (int i = 0; i < n6; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("^\n");
        }
        return new ParseException(stringBuffer.toString(), n5);
    }

    public ParseException syntaxError(String string) {
        return this.syntaxError(0, string);
    }

    public static void main(String[] stringArray) throws Exception {
        Pattern[] patternArray = new Pattern[]{RegexTokenMatcher.UNSIGNED_REAL, RegexTokenMatcher.JAVA_WORD, RegexTokenMatcher.JAVA_PUNC, RegexTokenMatcher.SINGLE_QUOTED_STRING, RegexTokenMatcher.DOUBLE_QUOTED_STRING};
        Pattern[] patternArray2 = new Pattern[]{RegexTokenMatcher.WHITESPACE, RegexTokenMatcher.HASH_COMMENT, RegexTokenMatcher.DOUBLE_SLASH_COMMENT, RegexTokenMatcher.SLASH_STAR_COMMENT};
        RegexTokenMatcher regexTokenMatcher = new RegexTokenMatcher(RegexTokenMatcher.joinPatterns(patternArray), RegexTokenMatcher.joinPatterns(patternArray2));
        CharWindow charWindow = new CharWindow(System.in);
        TokenWindow tokenWindow = new TokenWindow(charWindow, regexTokenMatcher);
        while (tokenWindow.token() != null) {
            System.out.println(tokenWindow.token());
            System.out.println("-----");
            tokenWindow.advance();
        }
    }
}

