/*
 * Decompiled with CFR 0.152.
 */
package driftwood.r3;

import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Builder {
    Triple x1 = new Triple();
    Triple x2 = new Triple();
    Transform rot1 = new Transform();

    public Triple construct4(Tuple3 tuple3, Tuple3 tuple32, Tuple3 tuple33, double d, double d2, double d3) {
        Triple triple = new Triple().likeVector(tuple33, tuple32);
        triple.unit().mult(d);
        this.x1.likeVector(tuple32, tuple3);
        this.x2.likeVector(tuple32, tuple33);
        this.x1.cross(this.x2);
        this.rot1.likeRotation(this.x1, d2);
        this.rot1.transformVector(triple);
        this.rot1.likeRotation(this.x2, d3);
        this.rot1.transformVector(triple);
        return triple.add(tuple33);
    }

    public Transform dock3on3(Tuple3 tuple3, Tuple3 tuple32, Tuple3 tuple33, Tuple3 tuple34, Tuple3 tuple35, Tuple3 tuple36) {
        Transform transform = new Transform();
        this.x1.like(tuple3).sub(tuple34);
        this.rot1.likeTranslation(this.x1);
        transform.append(this.rot1);
        transform.transform(tuple35, this.x1);
        double d = Triple.angle(tuple32, tuple3, this.x1);
        this.x2.likeNormal(tuple32, tuple3, this.x1).add(tuple3);
        this.rot1.likeRotation(tuple3, this.x2, d);
        transform.append(this.rot1);
        transform.transform(tuple35, this.x1);
        transform.transform(tuple36, this.x2);
        double d2 = Triple.dihedral(tuple33, tuple3, this.x1, this.x2);
        this.rot1.likeRotation(tuple3, this.x1, -d2);
        transform.append(this.rot1);
        return transform;
    }

    public static double signedArea2(double d, double d2, double d3, double d4, double d5, double d6) {
        return (d3 - d) * (d6 - d2) - (d4 - d2) * (d5 - d);
    }

    public static boolean checkTriangle(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = Builder.signedArea2(d3, d4, d5, d6, d, d2);
        if (d9 == 0.0) {
            return true;
        }
        double d10 = Builder.signedArea2(d5, d6, d7, d8, d, d2);
        if (d10 == 0.0) {
            return true;
        }
        if (d9 < 0.0 != d10 < 0.0) {
            return false;
        }
        double d11 = Builder.signedArea2(d7, d8, d3, d4, d, d2);
        if (d11 == 0.0) {
            return true;
        }
        return d10 < 0.0 == d11 < 0.0;
    }

    public static Collection makeDotSphere(double d, double d2) {
        int n = (int)Math.floor(Math.PI * 4 * d2 * 1.0 * (d * d));
        ArrayList<Triple> arrayList = new ArrayList<Triple>(n);
        boolean bl = true;
        double d3 = 0.04363323129985824;
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        int n2 = (int)Math.floor(Math.sqrt((double)n * Math.PI));
        int n3 = n2 / 2;
        for (int i = 0; i <= n3; ++i) {
            double d6 = Math.PI * (double)i / (double)n3;
            double d7 = Math.cos(d6) * d;
            double d8 = Math.sin(d6) * d;
            int n4 = (int)Math.floor((double)n2 * Math.sin(d6));
            if (n4 < 1) {
                n4 = 1;
            }
            for (int j = 0; j < n4; ++j) {
                double d9 = bl ? (Math.PI * 2 * (double)j + 0.2) / (double)n4 : Math.PI * 2 * (double)j / (double)n4;
                double d10 = Math.cos(d9) * d8;
                double d11 = Math.sin(d9) * d8;
                Triple triple = new Triple(d10, d11 * d4 - d7 * d5, d11 * d5 + d7 * d4);
                arrayList.add(triple);
            }
            bl = !bl;
        }
        return arrayList;
    }

    public static Triple[] makeBoundingBox(Collection collection) {
        Triple triple = new Triple(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Triple triple2 = new Triple(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tuple3 tuple3 = (Tuple3)iterator.next();
            triple.setX(Math.min(triple.getX(), tuple3.getX()));
            triple.setY(Math.min(triple.getY(), tuple3.getY()));
            triple.setZ(Math.min(triple.getZ(), tuple3.getZ()));
            triple2.setX(Math.max(triple2.getX(), tuple3.getX()));
            triple2.setY(Math.max(triple2.getY(), tuple3.getY()));
            triple2.setZ(Math.max(triple2.getZ(), tuple3.getZ()));
        }
        return new Triple[]{triple, triple2};
    }

    public static Triple[] makeBoundingBox(Collection collection, double[] dArray) {
        if (collection.size() != dArray.length) {
            throw new IllegalArgumentException("Must have a radius for every sphere");
        }
        Triple triple = new Triple(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Triple triple2 = new Triple(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tuple3 tuple3 = (Tuple3)iterator.next();
            double d = dArray[n];
            triple.setX(Math.min(triple.getX(), tuple3.getX() - d));
            triple.setY(Math.min(triple.getY(), tuple3.getY() - d));
            triple.setZ(Math.min(triple.getZ(), tuple3.getZ() - d));
            triple2.setX(Math.max(triple2.getX(), tuple3.getX() + d));
            triple2.setY(Math.max(triple2.getY(), tuple3.getY() + d));
            triple2.setZ(Math.max(triple2.getZ(), tuple3.getZ() + d));
            ++n;
        }
        return new Triple[]{triple, triple2};
    }
}

