/*
 * Decompiled with CFR 0.152.
 */
package king;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import king.KMessage;
import king.KingMain;
import king.core.Kinemage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinStable
implements ListSelectionListener,
KMessage.Subscriber,
ActionListener {
    KingMain kMain = null;
    List<Kinemage> children;
    Kinemage currentKinemage = null;
    volatile boolean isLocked = false;
    Timer timer;
    JList kinChooser = null;

    public KinStable(KingMain kingMain) {
        this.kMain = kingMain;
        this.children = new ArrayList<Kinemage>();
        this.kinChooser = new JList(new DefaultListModel());
        this.kinChooser.setSelectionMode(0);
        this.kinChooser.setVisibleRowCount(4);
        this.kinChooser.setFixedCellWidth(100);
        this.kinChooser.addListSelectionListener(this);
        this.kMain.subscribe(this);
        this.timer = new Timer(33, this);
        this.timer.start();
    }

    public List<Kinemage> getKins() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.currentKinemage == null) {
            return;
        }
        this.timer.stop();
        int n = this.currentKinemage.queryKinChanged();
        if (n != 0) {
            this.kMain.publish(new KMessage(this.currentKinemage, n));
        }
        this.timer.start();
    }

    @Override
    public void deliverMessage(KMessage kMessage) {
        if (kMessage.testProg(1024L)) {
            this.closeAll();
        }
    }

    public void closeAll() {
        this.children.clear();
        this.currentKinemage = null;
        this.kinChooser.setModel(new DefaultListModel());
        this.kMain.publish(new KMessage(this, 16L));
    }

    public void closeCurrent() {
        Kinemage kinemage = this.currentKinemage;
        this.children.remove(this.currentKinemage);
        this.currentKinemage = null;
        int n = this.kinChooser.getSelectedIndex();
        Object e = this.kinChooser.getSelectedValue();
        DefaultListModel defaultListModel = (DefaultListModel)this.kinChooser.getModel();
        defaultListModel.removeElement(e);
        n = Math.min(n, this.kinChooser.getModel().getSize() - 1);
        if (n >= 0) {
            this.kinChooser.setSelectedIndex(n);
        }
        this.kMain.publish(new KMessage(this, 8L));
    }

    public void append(Collection<Kinemage> collection) {
        this.children.addAll(collection);
        DefaultListModel defaultListModel = (DefaultListModel)this.kinChooser.getModel();
        boolean bl = true;
        for (Kinemage kinemage : collection) {
            defaultListModel.addElement(kinemage);
            if (!bl) continue;
            this.currentKinemage = kinemage;
            this.kinChooser.setSelectedValue(kinemage, true);
            bl = false;
        }
        if (this.kinChooser.getSelectedIndex() == -1) {
            this.kinChooser.setSelectedIndex(0);
        }
        this.kMain.publish(new KMessage(this, 4L));
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.currentKinemage = (Kinemage)this.kinChooser.getSelectedValue();
        this.kMain.publish(new KMessage(this, 4L));
    }

    public synchronized void setLocked(boolean bl) {
        if (this.isLocked != bl) {
            this.isLocked = bl;
            this.kMain.publish(new KMessage(this, 4L));
        }
    }

    public synchronized Kinemage getKinemage() {
        if (this.isLocked) {
            return null;
        }
        return this.currentKinemage;
    }

    public Component getChooser() {
        return this.kinChooser;
    }

    public void changeCurrentKinemage(int n) {
        if (0 <= --n && n < this.children.size()) {
            this.kinChooser.setSelectedValue(this.children.get(n), true);
        }
    }
}

