/*
 * Decompiled with CFR 0.152.
 */
package king.points;

import driftwood.data.TinyMap;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import king.core.AHEImpl;
import king.core.Engine;
import king.core.KList;
import king.core.KPaint;
import king.core.KPalette;
import king.core.KPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPoint
extends AHEImpl<KList>
implements KPoint {
    public static final int TINYMAP_AND = 255;
    public static final int ASPECTS_KEY = 1;
    public static final int COMMENT_KEY = 2;
    public static final int COORDS_KEY = 4;
    public static final int ON_BIT = 0x40000000;
    public static final int UNPICKABLE = 0x20000000;
    public static final int SEQ_EVEN_BIT = 0x10000000;
    public static final int GHOST_BIT = 0x8000000;
    protected float x0 = 0.0f;
    protected float y0 = 0.0f;
    protected float z0 = 0.0f;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float z = 0.0f;
    protected KList parent = null;
    protected Object[] tmValues = null;
    protected int pm_mask = 0;
    protected KPaint color = null;
    protected int multi = 0x40000000;

    public AbstractPoint() {
        this("");
    }

    public AbstractPoint(String string) {
        this.setName(string);
    }

    @Override
    public KPoint clone() {
        try {
            return (KPoint)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone failed in cloneable object");
        }
    }

    @Override
    public double getX() {
        return this.x0;
    }

    @Override
    public double getY() {
        return this.y0;
    }

    @Override
    public double getZ() {
        return this.z0;
    }

    @Override
    public void setX(double d) {
        this.x0 = (float)d;
        this.fireKinChanged(4096);
    }

    @Override
    public void setY(double d) {
        this.y0 = (float)d;
        this.fireKinChanged(4096);
    }

    @Override
    public void setZ(double d) {
        this.z0 = (float)d;
        this.fireKinChanged(4096);
    }

    @Override
    public void setXYZ(double d, double d2, double d3) {
        this.x0 = (float)d;
        this.y0 = (float)d2;
        this.z0 = (float)d3;
        this.fireKinChanged(4096);
    }

    @Override
    public float getDrawX() {
        return this.x;
    }

    @Override
    public float getDrawY() {
        return this.y;
    }

    @Override
    public float getDrawZ() {
        return this.z;
    }

    protected void setDrawXYZ(Tuple3 tuple3) {
        this.x = (float)tuple3.getX();
        this.y = (float)tuple3.getY();
        this.z = (float)tuple3.getZ();
    }

    @Override
    public void setAllCoords(float[] fArray) {
        this.tmPut(4, fArray);
    }

    @Override
    public float[] getAllCoords() {
        return (float[])this.tmGet(4);
    }

    @Override
    public void useCoordsXYZ(int n, int n2, int n3) {
        float[] fArray = this.getAllCoords();
        if (fArray == null) {
            return;
        }
        if (n >= 0 && n < fArray.length) {
            this.setX(fArray[n]);
        }
        if (n2 >= 0 && n2 < fArray.length) {
            this.setY(fArray[n2]);
        }
        if (n3 >= 0 && n3 < fArray.length) {
            this.setZ(fArray[n3]);
        }
    }

    @Override
    public KList getParent() {
        return this.parent;
    }

    @Override
    public void setParent(KList kList) {
        this.parent = kList;
        this.fireKinChanged(512);
    }

    @Override
    public void setPrev(KPoint kPoint) {
        if (kPoint == null) {
            this.multi &= 0xEFFFFFFF;
        } else if (kPoint instanceof AbstractPoint) {
            AbstractPoint abstractPoint = (AbstractPoint)kPoint;
            this.multi = (abstractPoint.multi & 0x10000000) != 0 ? (this.multi &= 0xEFFFFFFF) : (this.multi |= 0x10000000);
        } else {
            this.multi &= 0xEFFFFFFF;
        }
        this.fireKinChanged(512);
    }

    @Override
    public KPoint getPrev() {
        return null;
    }

    @Override
    public boolean isBreak() {
        return false;
    }

    @Override
    public boolean isOn() {
        return (this.multi & 0x40000000) != 0;
    }

    @Override
    public void setOn(boolean bl) {
        this.multi = bl ? (this.multi |= 0x40000000) : (this.multi &= 0xBFFFFFFF);
        this.fireKinChanged(1024);
    }

    @Override
    public boolean isUnpickable() {
        return (this.multi & 0x20000000) != 0;
    }

    @Override
    public void setUnpickable(boolean bl) {
        this.multi = bl ? (this.multi |= 0x20000000) : (this.multi &= 0xDFFFFFFF);
        this.fireKinChanged(512);
    }

    @Override
    public boolean isGhost() {
        return (this.multi & 0x8000000) != 0;
    }

    @Override
    public void setGhost(boolean bl) {
        this.multi = bl ? (this.multi |= 0x8000000) : (this.multi &= 0xF7FFFFFF);
        this.fireKinChanged(512);
    }

    @Override
    public KPaint getColor() {
        return this.color;
    }

    @Override
    public void setColor(KPaint kPaint) {
        this.color = kPaint;
        this.fireKinChanged(512);
    }

    @Override
    public String getAspects() {
        return (String)this.tmGet(1);
    }

    @Override
    public void setAspects(String string) {
        this.tmPut(1, string);
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public void setWidth(int n) {
    }

    @Override
    public float getRadius() {
        return 0.0f;
    }

    @Override
    public void setRadius(float f) {
    }

    @Override
    public void setComment(String string) {
        this.tmPut(2, string);
    }

    @Override
    public String getComment() {
        return (String)this.tmGet(2);
    }

    @Override
    public KPaint getDrawingColor() {
        KPaint kPaint = null;
        if (!this.isOn()) {
            kPaint = KPalette.invisible;
        } else if (this.color != null) {
            kPaint = this.color;
        } else if (this.parent != null) {
            kPaint = this.parent.getColor();
        }
        if (kPaint == null) {
            kPaint = KPalette.defaultColor;
        }
        return kPaint;
    }

    @Override
    public KPaint getDrawingColor(Engine engine) {
        boolean bl;
        KPaint kPaint = null;
        KPaint kPaint2 = null;
        boolean bl2 = engine.colorByList && this.parent != null;
        String string = this.getAspects();
        boolean bl3 = bl = engine.activeAspect > 0 && string != null && string.length() >= engine.activeAspect;
        if (!this.isOn()) {
            kPaint = KPalette.invisible;
        } else if (bl2) {
            kPaint = this.parent.getColor();
        } else if (bl && (kPaint2 = KPalette.forAspect(string.charAt(engine.activeAspect - 1))) != null) {
            kPaint = kPaint2;
        } else if (this.color != null) {
            kPaint = this.color;
        } else if (this.parent != null) {
            kPaint = this.parent.getColor();
        }
        if (kPaint == null) {
            kPaint = KPalette.defaultColor;
        }
        return kPaint;
    }

    @Override
    public void pmHit(int n, int n2, boolean bl) {
        if (bl) {
            if ((n & this.pm_mask) != 0 && (n2 & this.pm_mask) == 0) {
                this.setOn(true);
            }
        } else if ((n & this.pm_mask) != 0) {
            this.setOn(false);
        }
    }

    @Override
    public boolean pmWouldHit(int n) {
        return (n & this.pm_mask) != 0;
    }

    @Override
    public int getPmMask() {
        return this.pm_mask;
    }

    @Override
    public void setPmMask(int n) {
        this.pm_mask = n;
        this.fireKinChanged(2048);
    }

    @Override
    public void calcBoundingBox(float[] fArray) {
        if (this.x0 < fArray[0]) {
            fArray[0] = this.x0;
        }
        if (this.y0 < fArray[1]) {
            fArray[1] = this.y0;
        }
        if (this.z0 < fArray[2]) {
            fArray[2] = this.z0;
        }
        if (this.x0 > fArray[3]) {
            fArray[3] = this.x0;
        }
        if (this.y0 > fArray[4]) {
            fArray[4] = this.y0;
        }
        if (this.z0 > fArray[5]) {
            fArray[5] = this.z0;
        }
    }

    @Override
    public float calcRadiusSq(float[] fArray) {
        float f = this.x0 - fArray[0];
        float f2 = this.y0 - fArray[1];
        float f3 = this.z0 - fArray[2];
        return f * f + f2 * f2 + f3 * f3;
    }

    @Override
    public void doTransform(Engine engine, Transform transform) {
        this.doTransform(engine, transform, 1.0);
    }

    @Override
    public void doTransform(Engine engine, Transform transform, double d) {
        if (this.parent.getScreen()) {
            double d2 = engine.pickingRect.getWidth();
            double d3 = engine.pickingRect.getHeight();
            this.setDrawXYZ(new Triple(this.getX() + d2 / 2.0, -this.getY() + d3 / 2.0, this.getZ()));
            engine.addPaintable(this, -100.0);
        } else {
            transform.transform(this, engine.work1);
            this.setDrawXYZ(engine.work1);
            engine.addPaintable(this, this.z);
        }
    }

    @Override
    public KPoint isPickedBy(float f, float f2, float f3, boolean bl) {
        return this._isPickedBy(f, f2, f3, bl);
    }

    protected KPoint _isPickedBy(float f, float f2, float f3, boolean bl) {
        float f4 = this.x - f;
        float f5 = this.y - f2;
        if (f4 * f4 + f5 * f5 <= f3 * f3) {
            return this;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof KPoint)) {
            return false;
        }
        KPoint kPoint = (KPoint)object;
        return this.getX() == kPoint.getX() && this.getY() == kPoint.getY() && this.getZ() == kPoint.getZ();
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.x0 * 6.6360896E8f);
        int n2 = Float.floatToIntBits(this.y0 * 6.6360896E8f);
        int n3 = Float.floatToIntBits(this.z0 * 6.6360896E8f);
        return n ^ (n2 << 11 | n2 >>> 21) ^ (n3 << 22 | n3 >>> 10);
    }

    protected Object tmGet(int n) {
        int n2 = this.multi & 0xFF;
        if (!TinyMap.contains(n, n2)) {
            return null;
        }
        return this.tmValues[TinyMap.indexOf(n, n2)];
    }

    protected Object tmPut(int n, Object object) {
        int n2;
        int n3 = this.multi & 0xFF;
        int n4 = TinyMap.indexOf(n, n3);
        if (TinyMap.contains(n, n3)) {
            Object object2 = this.tmValues[n4];
            this.tmValues[n4] = object;
            this.fireKinChanged(512);
            return object2;
        }
        int n5 = TinyMap.size(n3);
        this.multi |= 1 << n & 0xFF;
        Object[] objectArray = new Object[n5 + 1];
        for (n2 = 0; n2 < n4; ++n2) {
            objectArray[n2] = this.tmValues[n2];
        }
        objectArray[n4] = object;
        for (n2 = n4; n2 < n5; ++n2) {
            objectArray[n2 + 1] = this.tmValues[n2];
        }
        this.tmValues = objectArray;
        this.fireKinChanged(512);
        return null;
    }

    protected Object tmRemove(int n) {
        int n2;
        int n3 = this.multi & 0xFF;
        if (!TinyMap.contains(n, n3)) {
            return null;
        }
        int n4 = TinyMap.indexOf(n, n3);
        Object object = this.tmValues[n4];
        this.multi &= ~(1 << n & 0xFF);
        Object[] objectArray = new Object[this.tmValues.length - 1];
        for (n2 = 0; n2 < n4; ++n2) {
            objectArray[n2] = this.tmValues[n2];
        }
        for (n2 = n4 + 1; n2 < this.tmValues.length; ++n2) {
            objectArray[n2 - 1] = this.tmValues[n2];
        }
        this.tmValues = objectArray;
        if (this.tmValues.length == 0) {
            this.tmValues = null;
        }
        return object;
    }
}

