# TRADEMARK GUIDELINES

This document outlines the policy for allowable uses of trademarks owned by Bitwarden, Inc.
(“Bitwarden") by other parties.

Bitwarden owns all Bitwarden-related trademarks, service marks, and logos and the names of
all Bitwarden® projects are trademarks of Bitwarden.

The role of trademarks is to provide assurance about the source and quality of the products or
services with which the trademark is associated. We want to allow members of the Bitwarden
community to discuss our products and services and to accurately describe their affiliation with
Bitwarden. Bitwarden has established this Policy to encourage others to make accurate,
non-confusing use of the Bitwarden trademarks, while also ensuring that those trademarks
maintain their distinctiveness and strength as reliable indicators of the source and quality of
Bitwarden products and services. Although some Bitwarden projects may be available under
free and open licenses, those licenses cover copyright only and do not include any express or
implied right to use our trademarks. Bitwarden does not allow third parties to use its
trademarks without a written agreement or express permission. Thus, Bitwarden projects that
are available under open source licenses may be copied, modified, distributed or sold by third
parties in accordance with the terms of the applicable open source license, but they cannot be
branded or marketed with Bitwarden trademarks in the absence of a trademark license.

While open-source licenses allow modification of copyrighted software and distribution in
original or modified form, such distribution could be misleading if distributed under the same
name as the source project. This could cause confusion among consumers of the software as to
source. The consumers may mistakenly believe they are receiving software that is produced or
supported by Bitwarden. This Policy describes the circumstances under which you may use our
trademarks, regardless of the type of license you may have from Bitwarden. In this Policy we
are not trying to limit the lawful use of our trademarks, but rather describe for you what we
consider the parameters of lawful use to be. Trademark law can be ambiguous, so we hope to
provide enough clarity for you to understand whether we will consider your use licensed or
non-infringing.

## Our Trademarks

This Policy covers the following non-exhaustive list of our trademarks:

1. Our trademarks and service marks (the "Marks"):
    
    - Bitwarden®
    - ![Logo](https://i.imgur.com/FIv4bYq.png)

2. The unique visual styling of our website and elements used in or otherwise related to
    the products and services we offer (the "Trade Dress"). See our Style Guide for further
    information.

This Policy encompasses all trademarks and service marks, whether Word Marks, Logos or Trade
Dress, which are collectively referred to as the "Marks." Some Marks may not be registered, but
registration is not necessarily required for ownership of trademarks. This Policy covers our
Marks whether they are registered or not.

## Universal Considerations for All Uses

The following guidelines show proper (and improper) use of Marks. Any use of the Marks must
be licensed and comply with these guidelines. Whenever you use one of the Marks, you must
always do so in a way that does not mislead anyone, either directly or by omission, about
exactly what they are getting and from whom. For example, you cannot say you are distributing
the Bitwarden® software when you're distributing a modified version of it, because people
would be confused when they are not getting the same features and functionality they would
get if they downloaded the software directly from us. You also cannot distribute Bitwarden®
software using the Marks if you do not have a license from us, because that would imply that
your distribution comes from or is supported by Bitwarden. You cannot use our Marks on your
website in a way that suggests that your website is an official website or that we endorse your
website, unless permitted in a written agreement with us. You can, though, say you like the
Bitwarden® software, say that you participate in the Bitwarden® community, or refer to
Bitwarden® products and services if these statements are true.

This fundamental requirement, that it is always clear to people what they are getting and from
whom, is reflected throughout this Policy. It should also serve as your guide if you are not sure
about how you are using the Marks.

## Standards for Use

All uses of Bitwarden Marks must conform to the following principles:

1. You may use the Marks only to identify and distinguish Bitwarden products and services.
    Our Marks may not be applied to products or services provided by anyone else.

2. If you are self-hosting the Bitwarden software or using the Bitwarden software
    on-premise, in each case under a subscription or license agreement with Bitwarden, you
    may use the Bitwarden Marks to describe or reference the password management
    platform or use the Bitwarden login page shown below for your users or organization:
    
    ![Login page](https://i.imgur.com/J0o51cO.png)

3. You may not use or register, in whole or in part, the Marks as part of your own
    trademark, service mark, domain name, company name, trade name, product name,
    service name or social media handle/account.

4. Trademark law does not allow your use of names or trademarks that are too similar to
    ours. You therefore may not use an obvious variation of any of our Marks or any
    phonetic equivalent, foreign language equivalent, takeoff, or abbreviation for a similar or
    compatible product or service. This includes combinations or integrations of all or
    portions of the Marks in a way that the public may think of the use as a new mark (e.g.
    SuperBitwarden, or Bitwarden2.0).

5. You may not use the Marks in a way that disparages or harms Bitwarden or our products
    or services. You also may not use our Marks in connection with harmful or
    objectionable materials of any sort.

6. We reserve the right to object to any use of our Marks that we view as non-compliant
    with these Trademark Guidelines or applicable law. By using our brand materials, you
    agree to take all necessary steps to resolve any objections we have. You also
    acknowledge that Bitwarden is the sole owner of Bitwarden Marks and goodwill derived
    from their use accrues only to Bitwarden.

7. Provided that you have obtained a license from Bitwarden, you can use the word mark in
    books and articles as long as the use does not suggest that we have published, endorse,
    or agree with your work.

You agree that you will not acquire any rights in the Marks and that any goodwill generated by
your use of the Marks inures solely to our benefit.

## Proper Use of the Marks

Always use the Word Marks in a manner distinguished from surrounding text, with initial capital
letters, and in the exact form with the correct spelling (neither abbreviated, hyphenated, or
combined with any other word or words).

**Correct**

- Bitwarden®

**Incorrect**

- BITWARDEN
- BitWarden
- Bitward

### Use Marks as Proper Adjectives Followed by a Generic Term.

Trademarks should be used as adjectives followed by a generic modifier, and not as nouns
or verbs. For example:

**Correct**

- The Bitwarden® platform is widely used in many industries.
- I was able to quickly gain control over my organization's sensitive data with Bitwarden®
    password management software.
- I use the Bitwarden® application to manage my passwords.

**Incorrect**

- Bitwarden® is widely used.

### Do Not Use Marks in the Possessive Form.

Because trademarks are not nouns, they should not be used in the possessive form.
For example:

**Correct**

- The Bitwarden® platform safely stores and protects passwords.

**Incorrect**

- Bitwarden's platform safely stores and protects passwords.

### Do Not Use Marks to Suggest Endorsement by Bitwarden.

**Correct**

- Our platform was developed using Bitwarden® open source software

**Incorrect**

- "Open Bitwarden"
- XYZ ENTERPRISE 3.4.9 (FREE AND OPEN UNRESTRICTED BITWARDEN ENTERPRISE FORK)

## Use of Logos

You may not use our logos unless you have obtained written permission. If you have obtained a
separate license to use our logos, you may not change any logo except to scale it proportionally.
This means you may not add decorative elements, change the colors, change the proportions,
distort it, add elements, or combine it with other logos. The logo may only be used displaying
the exact colors shown in our Style Guide.

## Mark Attribution and Notices

The first or most prominent mention of a Mark on a webpage, document, packaging, or
documentation should be accompanied by a symbol indicating whether the Mark is a registered
trademark ("®") or an unregistered trademark ("™"). Also, if you are using our Marks for uses
for which we are granting a separate license, please put the following notice at the foot of the
page where you have used the Mark (or, if in a book, on the credits page), on any packaging or
labeling, and on advertising or marketing materials: "Bitwarden is a trademark or registered
trademark of Bitwarden, Inc. in the United States and/or other countries."

## Possible Infringement

If you are aware of any confusing use or misuse of the Marks in any way, we would appreciate
you bringing this to our attention. Please contact us at <support@bitwarden.com> so that we can
investigate it further.

## Updates

Bitwarden reserves the right to modify or update this Policy at any time. You should review this
Policy from time to time so that you will be aware of any modifications or updates as they will
apply as soon as they are posted on this page.

## Further Information

Bitwarden has tried to make this Trademark Policy as comprehensive and understandable as
possible. If you have any questions about this Policy, please contact us.
