﻿using BenchmarkDotNet.Attributes;
using Bit.Core.Utilities;

namespace Bit.MicroBenchmarks.Core;

[MemoryDiagnoser]
public class EncryptedStringAttributeTests
{
    private readonly EncryptedStringAttribute _encryptedStringAttribute;
    public EncryptedStringAttributeTests()
    {
        _encryptedStringAttribute = new EncryptedStringAttribute();
    }

    public const string Short = @"2.QmFzZTY0UGFydA==|QmFzZTY0UGFydA==|QmFzZTY0UGFydA==";
    public const string Long = @"2.KllcSp3E124kblnMlCNQuQ==|G0jvyocNBOEzCyJ/f951Pz348MPi2RLzmsbfOAOtszi5L9WAkWe4L5T2gJukRMgDSvdE76MVUqREsgQZME52t8JFpVzsQU7Ee56szoJu\u002BAHHQkBNd5J2WirgprDRmIGiSdbvv2GoCszr1b2Ox/Pc\u002B9wjjzMjR6ZA3xhvy1UPyFdT5edQvIFVRSOEG7ivtV7RmGxiq7buP/g\u002BL/epeuiljkjU7KU8JbZRKaxhGLSiofEMlBtaTZtTGh3VKAHslUgPnRIRlHpjPDaT1Yw3la4YHbEOs4Y/XJ5sI4q5xXlK60gMgAlvlyH0mspezaBy367WBLu\u002BWC/4GqGBudhftSOED/aIS4PoCUvMdftwHunXjE2s5zDUwT66w30lvEvJbs7m/36fKAj9ujqOv9vEm1Ukjxhzk\u002BHHkLUcjrD57Zfn0P\u002BzK6wbneYBORObF70gUhcINv64GqgLFlEUecmKjK0ZgcmTXp8XuG2ZfplXAN1y8gySM3UAREhFj4oQtZq/QB64SlnOTAPkRjqy0khqWCmySqSSqKYCnzTfE7RUhR6FAgpWTo9qHZHkwNVk2EBWvMN0UctjmYIpoUBtqKPF2Oidhjnck\u002BqCa7jGIqGetERq9Cdg\u002Btk6bvzLexj/bVEJpiK53ghrDJKs5Ncox7cmLjIfoL5cb3ZUgiV3g\u002Bzqpq2RWn16d85Edmir4zlJPSA77BEGhFzZET3PyYqdWWcaAlDQbqeQ39zyuKUzRI0JH6yXsfCcTqZmsQ9Mj5OpqQdcgVlMXyvsY/mCsocpGKA0\u002BcQGQPZGgZ3cDcN13K4MTjiZ8BO9P7aLvgk5k5a3GFFsYVhe2lgbPeoASDHY48AX9yTnPTXGCHAB\u002BHiybFRyIabXhSnU491vRxPyCsEBMbL/GTUr0oulzixdOMYCKBYw3WcLGuA2gG1JyAl\u002BEzS/iU1G97bWvi8yMG6QsDhiAvgAt3BjU1C7kgHseM\u002BZHdpe1cwyFV\u002BzSfS0Hn5iVYcJVnkO7JiiTaMSQEjIk0q54stRGJ\u002BHC81F2kaf\u002Bi4aQ4rpq82yAJJMoGsdSyzeC8P2jR4HpsfJroJRYAPHUl8CIe0ZeWdvWjFwKGqxmPeFU2lazMEyyMZGFB1/8zP4Gxu2KarubWG1NRQY1sGCnH1\u002BvBsQrKtyBxyuwshNrUCN9UifOZDmYZ2FPHHdnNdGiaHyQVSDYqx/EpWkgkNl6h1Itpkb7sW/ByAu2EhHUJODfciYgyF4CsCs2iNboZNoMctY5H0VT704tt3AuS369PMWJzwKum\u002BHUrpLEyav0SUUSUlhWUvkWfW1O/Q3bADW72IXWS\u002BHUZ0E96tjpUDv60V7X0qLOCcjlhxRgGwPVw1V4FuxhmkX8UxSwlU39/aQUj8gpGr8Um8LWxIYw/mkV1ItTPh4IxpXxSnuGAIBjEBlRlqedFLF97tVDzYLddEh6SlIEh6ppdpDS6ghSpiylyh4JsaXtp1QGpoPUfkwcl1jWrRarj5G2hbQW3gkuug8cfGB0zHxfLwmKSHswFPa1Ne2kqf7jlO19ckIxqmHpbrn9myVcnqPQLhSxtzIjJUN6HG7xQdJ7Q7Tumj8gN9dN06IUEfhoYhUxcabTqm9jTspVQ7iXsvml3YeF8qJX/d\u002BnSUqcOmOod6/B1k54Dd9mhosi0So9XTGuVmgKz82r185wTx7mVgcaKPQZXIVxIPqxtsk1UI6IK5wpyWhB77nS3L83KGdxpdRTbPAhAj8tIKDrELzr3u5WytStGeH8melF7KnIzWmAs2vUJIlByFxgjm26u0C4Eid0DQVJJ4xWp5yt62WodZ80B3dUyjXUUuTyyVL8Y26zRZNuF/3G\u002BKc\u002BkN/lja44BPG5/FoDofgto3IlWvYzkoKB8oXhhL58Rc8fNr5LZIz\u002BTrweFXO2eoSP1xIcEuq2J\u002BZGLHElEmkwQA1u3UE\u002BySsElNAeWlx\u002BkQ0f\u002B0AqZzhei1PJ0VHqRXvwxYTqkeBQA2/95UTyKv15R/cbHVHexttqrc40oRwp7Cl\u002BzIJcRvKSUdfXa6MiQ13HvBpiG\u002BBoyvC2RHLlg\u002BwToSmCZFoPDt5wEP9TOMmG2HbCab1fLGkfQ2Sov1cRnPWt6SgtZFsIRyxxOglr44O\u002B56\u002B9QH7KmpEHjXANdOhYnNsw47TQEoMy9v8r23CUu\u002BX2yUcLxplTDxQXb5pNo5PXH0DlhIu3SGp/xu5tU5I7UXNdO85I9za/1wp/ylcl1PjXXnKx0E5FvXsOdUndgSE8TNxD8u6hfrbizTuAnFiJWCQzbDBMCT1SLggoq03iN\u002BKTSEWoh4l28GF\u002BwJsVU5PygNLuZVaDjlHVgeU5u5AhPO/0clIsFvJPaJ5WhstDlxGRXq0\u002BRBrx1ikMDXwFLfdbtj/U7O8cPCeU0UIJRzjjd9mG1Uyk2UNccJHzXt7RWKk7pCuNhG7cVOo55cICvndT1n6hwTC6mpXXv1pHiB8Ddg1csw7p2E6BVj0YhV1vTWTlKHYrNjv2F2f1NNPtRsCzOh2rOd7UCtV5wfB92PorADP9r3FNAQupVwCVkYymMPfaOPm5lpvT1WdORQZbKQRc10OzTnnOtFNaKWI4DffPuIR93wHj7JByG7MGmRkW1sAnmOuif24sMOYULcjTS0SdvUQhvvkCMfl/rtsFYDXnnCrzhcWPQ\u002BS2nIKt89h5rtjk73/rOmvAnIC8f\u002Bl84yM54Ifm2jGC8H1VZS6HmEFAJmciKsPHaBEGRxBL9FxTOzPM3KKXEUFANvm0lGQrzrpl4PlhauSf04BwxM9s9iikCVtEVA1E9e4dNs/MZmwNzwQLN36ZkABdu8ZVzfW4CpXO0aA3ZXbtNQuEpDWvpIsMTZUL9IYcLFtLI9ITuEhrluPVX6vnzRghM/DmSLr5zH\u002BDat9saZxvzpDpq4JW\u002BXcJ\u002Bk1D469N4grVNvbcymcQ8ZinJbyOOQS9t7H5hOG7zWbYb/paRQChCeCqGindCxnxjymGRnbShGtKzDq8GZHKDkkS0pm6g3laV6pPBlF0FMwzTm6IDFrWUXOjRgkPTr46t8PRkdEMKXHSNWMn4QiWC5\u002BiKUEvqt\u002BjeY1RzKQB2gd1xBfI9hLs2L\u002BK7S3GOblvM/R1FAK3Rnd3oZ41hZ2wHSH4x1mvLjDWVWmLOQt9pzn3DSX7\u002BJqhnWtF6nYNm\u002BIyu5bZRtyBz1tpo1FezJxx1o2r1QTi3M1FTLLndAaxtXCwzcBLBxG7PZKI0rfVExcK3FYO2bUYZS/HpALLVkuWg\u002BTuaZPmkDyUkxSsXIU9ERIVOz0\u002BYgsCQrBj/Z/xY38jy5jCVvXAbmAwv1ZsyZOp657LXHUTz6EmQAVWDuMZfX97WyIn5stWtT\u002B8Ppeda82TecJBVVKaDduMwvBb3jRNTtCappRoQm2ea1rBjvpWXEtGsAZcIu74Exz\u002BmS\u002BpKEOR0JAElqMIRLTNmCXVSXEjF5Oo1s3vIR4IZ2XGm9EF0Lm9Gld5OR1ganZR1AyPJpHOGclq2FGKSlamwyh6TzZDUnnExsyaQjr9Dkuy5mQdIeg8RdsjjvMqeCVZXV/jIo//dwkGm9nCVLud9jsKOdyl5ELhKyNHryXkyZVngF7qL\u002BWpoEQkW9G5j5aO5FrIt\u002B3fgqDr5KP/wJkdfKQM0GG0FI989t6CzzajfGxWgn\u002B1nUhkjOyHBee6zBtoT8GA/K0g8SvrKCJQeaic1UFC\u002BXZ1UcwbFZK43pc9iYyoxMboxi\u002Bq5ZX0nQXseiv8OsijrFmm5d/0R\u002BRpSLeHIz9uetBKZpSbLJnCNvugTVlFmYgocPC1zqWAj2MrqdYaf5Vzy0uXj5gKMZxAD9ZYeTatiL5C/GuMsaidvb8bh1E7XV5apf3lgLAKxHnqjE5CJzU9I/itBTHXysMeCZrkhDeAS0UhtRyNiMoahKBc6qFkiphnPi1kM0x0lzZRRnBz8cgkvdEt769c3BYqHa7gWC3DlDjaHKuvqSd1t4eDjSlU2PeI7RYwJwBfF5LdPLevsAkyvGCIHKmfjX38SeSrlgL9E2JsRQpeypKWiVpRunM9he/9jADAVFwEpck3bBz/ANo2c6gX3/haAw1xXunkq6\u002BIp80XVLeoys44vFv3QPvZ6GZ5QCSJ/AP42fSdENTYkB7MhBwMgLmcyATVFYA16yS7q8dIAowO5GL3/vCTe4\u002B47Sg6U9vgclFw1T55oZ/apQ5bdPCZ7N4M2nD5DfI74XuoQPfrDkXIhCP\u002BHh/v8BV9t2mPH0LyXGviwl4ewrtrtsOCV3H4/KsxiMPVkTFofHjjXU30WkcBaCB985p1oPWii4d4QJvnubN3z4\u002B51mhYPMCs7Uu05we9zEDH0tPfWC2Jm9C7Hv\u002BT5LgWFOV/d7\u002BYR0AajpF3xKWulZu\u002BwDXruRAHhLqCwsGxq9GlLal8DURCGxQG6Keyx/PTv9L6yEZmMIlNdP3xNEOPaDNwNIWczPC6CkuPbufgsFxn9I3krlZS2x/5/ZuIdoZu9CqPr5af7TIqsXWdczEQZ7NhefA0\u002BXeImBoflGx2I45UG8CeiF0FMnX16rzpF48rx/YZkl/PFwQYcN\u002BVrQmXrqD6eSzyHvRWSi8KQP7te2LqBFw1p5dxgREbCTLlcvQckcGgiyctDjS1wYe1VaagedfrsQpYXdQkOxhL9aE6r1\u002Bj8eHenC6ezxMc6LnsLog2wDMAXlzmq9KkladqyltzL2sgTyg7R57agFrjJtGQfLb0IY0O8vhkwqq2KYhWJ7jOJA\u002BR0k62HZEeNMsreNBNO5l0QCQ0\u002BUGKpEtvX/F5DNj07Swz\u002BoiHWq2933yQ4pzXnYnIfNgb8Ni5Js/GMn5HNJFvsNgYQ/xV1iKnIH43qDoyw55t22Sg4kcHhQBSBSWEZ7u/iVHCSN3hW7ma5Eabbk15/Jg4TurDpthtufZqZ2ZAiOWBaiOUC/OHUI8PjquycGpOGrTauVh\u002BCiS47S5nMPrF6ROVTT\u002BjrfaC9cw0\u002BIf0wEMG/W/p57n5YE7JnLr5kwKEDHCk3mMdxqhYzIoRBiKndblcM1\u002B7Glm5dN78R4mgt2QUGERnVkP\u002BoDxszTshjeZ0EX1l9zuF3V2zt1WzzDH8BiY/zVrhuJsRGSwLsVCpBKZArSfa1cLIufuF9cj5QtYu9NyKi2aVDILdN1fsFqaZ9i5Zsg8ohsLHzYQtY1RZVhNrmI=|MiBu248yFOf9eakCDaO\u002BK7aU2gu/T9R8YSbf7kkHuXg=";

    [Params(Short, Long)]
    public string EncryptedString { get; set; } = null!;

    [Benchmark]
    public bool IsValid() => _encryptedStringAttribute.IsValid(EncryptedString);
}
