-- Create OrganizationDomain delete by OrganizationId
CREATE OR ALTER PROCEDURE [dbo].[OrganizationDomain_OrganizationDeleted]
    @OrganizationId UNIQUEIDENTIFIER
AS
BEGIN
    SET NOCOUNT ON

DELETE
FROM
    [dbo].[OrganizationDomain]
WHERE
    [OrganizationId] = @OrganizationId
END
GO

-- Update Organization Delete By Id to include OrganizationDomain_OrganizationDeleted
CREATE OR ALTER PROCEDURE [dbo].[Organization_DeleteById]
    @Id UNIQUEIDENTIFIER
AS
BEGIN
    SET NOCOUNT ON

    EXEC [dbo].[User_BumpAccountRevisionDateByOrganizationId] @Id

    DECLARE @BatchSize INT = 100
    WHILE @BatchSize > 0
BEGIN
BEGIN TRANSACTION Organization_DeleteById_Ciphers

        DELETE TOP(@BatchSize)
        FROM
            [dbo].[Cipher]
        WHERE
            [UserId] IS NULL
            AND [OrganizationId] = @Id

        SET @BatchSize = @@ROWCOUNT

        COMMIT TRANSACTION Organization_DeleteById_Ciphers
END

BEGIN TRANSACTION Organization_DeleteById

DELETE
FROM
    [dbo].[SsoUser]
WHERE
    [OrganizationId] = @Id

DELETE
FROM
    [dbo].[SsoConfig]
WHERE
    [OrganizationId] = @Id

DELETE CU
    FROM 
        [dbo].[CollectionUser] CU
    INNER JOIN 
        [dbo].[OrganizationUser] OU ON [CU].[OrganizationUserId] = [OU].[Id]
    WHERE 
        [OU].[OrganizationId] = @Id

DELETE
FROM
    [dbo].[OrganizationUser]
WHERE
    [OrganizationId] = @Id

DELETE
FROM
    [dbo].[ProviderOrganization]
WHERE
    [OrganizationId] = @Id

    EXEC [dbo].[OrganizationApiKey_OrganizationDeleted] @Id
    EXEC [dbo].[OrganizationConnection_OrganizationDeleted] @Id
    EXEC [dbo].[OrganizationSponsorship_OrganizationDeleted] @Id
    EXEC [dbo].[OrganizationDomain_OrganizationDeleted] @Id

DELETE
FROM
    [dbo].[Project]
WHERE
    [OrganizationId] = @Id

DELETE
FROM
    [dbo].[Secret]
WHERE
    [OrganizationId] = @Id

DELETE AK
    FROM
        [dbo].[ApiKey] AK
    INNER JOIN
        [dbo].[ServiceAccount] SA ON [AK].[ServiceAccountId] = [SA].[Id]
    WHERE
        [SA].[OrganizationId] = @Id

DELETE
FROM
    [dbo].[ServiceAccount]
WHERE
    [OrganizationId] = @Id

DELETE
FROM
    [dbo].[Organization]
WHERE
    [Id] = @Id

    COMMIT TRANSACTION Organization_DeleteById
END
