CREATE TABLE [dbo].[OrganizationDomain] (
    [Id]                UNIQUEIDENTIFIER NOT NULL,
    [OrganizationId]    UNIQUEIDENTIFIER NOT NULL,
    [Txt]               VARCHAR(MAX)     NOT NULL,
    [DomainName]        NVARCHAR(255)    NOT NULL,
    [CreationDate]      DATETIME2(7)     NOT NULL,
    [VerifiedDate]      DATETIME2(7)     NULL,
    [LastCheckedDate]   DATETIME2(7)     NULL,
    [NextRunDate]       DATETIME2(7)     NOT NULL,
    [JobRunCount]      TINYINT          NOT NULL
    CONSTRAINT [PK_OrganizationDomain] PRIMARY KEY CLUSTERED ([Id] ASC),
    CONSTRAINT [FK_OrganzationDomain_Organization] FOREIGN KEY ([OrganizationId]) REFERENCES [dbo].[Organization] ([Id])
);

GO

CREATE NONCLUSTERED INDEX [IX_OrganizationDomain_OrganizationIdVerifiedDate]
    ON [dbo].[OrganizationDomain] ([OrganizationId],[VerifiedDate]);
GO

CREATE NONCLUSTERED INDEX [IX_OrganizationDomain_VerifiedDate]
    ON [dbo].[OrganizationDomain] ([VerifiedDate])
    INCLUDE ([OrganizationId],[DomainName]);
GO

CREATE NONCLUSTERED INDEX [IX_OrganizationDomain_DomainNameVerifiedDateOrganizationId]
    ON [dbo].[OrganizationDomain] ([DomainName],[VerifiedDate])
    INCLUDE ([OrganizationId]);
GO

CREATE NONCLUSTERED INDEX [IX_OrganizationDomain_OrganizationId_VerifiedDate]
    ON [dbo].[OrganizationDomain] ([OrganizationId], [VerifiedDate])
    INCLUDE ([DomainName])
    WHERE [VerifiedDate] IS NOT NULL;
GO
