CREATE OR ALTER PROCEDURE [dbo].[Organization_ReadManyByIds] @OrganizationIds AS [dbo].[GuidIdArray] READONLY
AS
BEGIN
    SET NOCOUNT ON

    SELECT o.[Id],
           o.[Identifier],
           o.[Name],
           o.[BusinessName],
           o.[BusinessAddress1],
           o.[BusinessAddress2],
           o.[BusinessAddress3],
           o.[BusinessCountry],
           o.[BusinessTaxNumber],
           o.[BillingEmail],
           o.[Plan],
           o.[PlanType],
           o.[Seats],
           o.[MaxCollections],
           o.[UsePolicies],
           o.[UseSso],
           o.[UseGroups],
           o.[UseDirectory],
           o.[UseEvents],
           o.[UseTotp],
           o.[Use2fa],
           o.[UseApi],
           o.[UseResetPassword],
           o.[SelfHost],
           o.[UsersGetPremium],
           o.[Storage],
           o.[MaxStorageGb],
           o.[Gateway],
           o.[GatewayCustomerId],
           o.[GatewaySubscriptionId],
           o.[ReferenceData],
           o.[Enabled],
           o.[LicenseKey],
           o.[PublicKey],
           o.[PrivateKey],
           o.[TwoFactorProviders],
           o.[ExpirationDate],
           o.[CreationDate],
           o.[RevisionDate],
           o.[OwnersNotifiedOfAutoscaling],
           o.[MaxAutoscaleSeats],
           o.[UseKeyConnector],
           o.[UseScim],
           o.[UseCustomPermissions],
           o.[UseSecretsManager],
           o.[Status],
           o.[UsePasswordManager],
           o.[SmSeats],
           o.[SmServiceAccounts],
           o.[MaxAutoscaleSmSeats],
           o.[MaxAutoscaleSmServiceAccounts],
           o.[SecretsManagerBeta],
           o.[LimitCollectionCreation],
           o.[LimitCollectionDeletion],
           o.[LimitItemDeletion],
           o.[AllowAdminAccessToAllCollectionItems],
           o.[UseRiskInsights]
    FROM [dbo].[OrganizationView] o
             INNER JOIN @OrganizationIds ids ON o.[Id] = ids.[Id]
END

