var EventEmitter = require('events').EventEmitter
  , Slide = require('../../../src/remark/models/slide')
  , SlideView = require('../../../src/remark/views/slideView')
  , utils = require('../../../src/remark/utils')
  ;

describe('SlideView', function () {
  var slideshow = {
        slides: []
      , getHighlightStyle: function () { return 'default'; }
      , getSlides: function () { return this.slides; }
      , getLinks: function () { return {}; }
      , getHighlightLanguage: function () { }
      , getSlideNumberFormat: function () { return '%current% / %total%'; }
      }
    , scaler = {
        dimensions: {width: 10, height: 10}
      }
    ;

  describe('background', function () {
    it('should be set from background slide property', function () {
      var slide = new Slide(1, {
            source: '',
            properties: {'background-image': 'url(image.jpg)'}
          });

      slideshow.slides.push(slide);
      var slideView = new SlideView(new EventEmitter(), slideshow, scaler, slide);

      slideView.contentElement.style.backgroundImage.should.match(/^url\(.*image\.jpg\)$/);
    });
  });

  describe('classes', function () {
    it('should contain "content" class by default', function () {
      var slide = new Slide(1, {source: ''});

      slideshow.slides.push(slide);
      var slideView = new SlideView(new EventEmitter(), slideshow, scaler, slide);
      var classes = utils.getClasses(slideView.contentElement)

      classes.should.include('remark-slide-content');
    });

    it('should contain additional classes from slide properties', function () {
      var slide = new Slide(1, {
            source: '',
            properties: {'class': 'middle, center'}
          });

      slideshow.slides.push(slide);
      var slideView = new SlideView(new EventEmitter(), slideshow, scaler, slide);
      var classes = utils.getClasses(slideView.contentElement)

      classes.should.include('remark-slide-content');
      classes.should.include('middle');
      classes.should.include('center');
    });
  });

  describe('empty paragraph removal', function () {
    it('should have empty paragraphs removed', function () {
      var slide = new Slide(1, {source: '&lt;p&gt; &lt;/p&gt;'})

      slideshow.slides.push(slide);
      var slideView = new SlideView(new EventEmitter(), slideshow, scaler, slide);

      slideView.contentElement.innerHTML.should.not.include('<p></p>');
    });
  });

  describe('show slide', function () {
    it('should set the slide visible', function () {
      var slide = new Slide(1, {source: ''});

      slideshow.slides.push(slide);
      var slideView = new SlideView(new EventEmitter(), slideshow, scaler, slide);
      slideView.show();

      var classes = utils.getClasses(slideView.containerElement);
      classes.should.include('remark-visible');
      classes.should.not.include('remark-fading');
    });

    it('should remove any fading element', function () {
      var slide = new Slide(1, {source: ''});

      slideshow.slides.push(slide);
      var slideView = new SlideView(new EventEmitter(), slideshow, scaler, slide);

      utils.addClass(slideView.containerElement, 'remark-fading');
      slideView.show();

      var classes = utils.getClasses(slideView.containerElement);
      classes.should.include('remark-visible');
      classes.should.not.include('remark-fading');
    });
  });

  describe('hide slide', function () {
    it('should mark the slide as fading', function () {
      var slide = new Slide(1, {source: ''});

      slideshow.slides.push(slide);
      var slideView = new SlideView(new EventEmitter(), slideshow, scaler, slide);

      utils.addClass(slideView.containerElement, 'remark-visible');
      slideView.hide();

      var classes = utils.getClasses(slideView.containerElement);
      classes.should.not.include('remark-visible');
      classes.should.include('remark-fading');
    });
  });

  describe('code line highlighting', function () {
    it('should add class to prefixed lines', function () {
      var slide = new Slide(1, { content: ['```\nline 1\n* line 2\nline 3\n```'] })
        , slideView = new SlideView(new EventEmitter(), slideshow, scaler, slide)
        ;

      var lines = slideView.element.getElementsByClassName('remark-code-line-highlighted');

      lines.length.should.equal(1);
      lines[0].innerHTML.should.equal('  line 2');
    });
  });
});
