/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// NFSLister helps list NFSs.
type NFSLister interface {
	// List lists all NFSs in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.NFS, err error)
	// NFSs returns an object that can list and get NFSs.
	NFSs(namespace string) NFSNamespaceLister
	NFSListerExpansion
}

// nFSLister implements the NFSLister interface.
type nFSLister struct {
	indexer cache.Indexer
}

// NewNFSLister returns a new NFSLister.
func NewNFSLister(indexer cache.Indexer) NFSLister {
	return &nFSLister{indexer: indexer}
}

// List lists all NFSs in the indexer.
func (s *nFSLister) List(selector labels.Selector) (ret []*v1beta1.NFS, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.NFS))
	})
	return ret, err
}

// NFSs returns an object that can list and get NFSs.
func (s *nFSLister) NFSs(namespace string) NFSNamespaceLister {
	return nFSNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// NFSNamespaceLister helps list and get NFSs.
type NFSNamespaceLister interface {
	// List lists all NFSs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta1.NFS, err error)
	// Get retrieves the NFS from the indexer for a given namespace and name.
	Get(name string) (*v1beta1.NFS, error)
	NFSNamespaceListerExpansion
}

// nFSNamespaceLister implements the NFSNamespaceLister
// interface.
type nFSNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all NFSs in the indexer for a given namespace.
func (s nFSNamespaceLister) List(selector labels.Selector) (ret []*v1beta1.NFS, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.NFS))
	})
	return ret, err
}

// Get retrieves the NFS from the indexer for a given namespace and name.
func (s nFSNamespaceLister) Get(name string) (*v1beta1.NFS, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("nfs"), name)
	}
	return obj.(*v1beta1.NFS), nil
}
