/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class IterableSubject<S extends IterableSubject<S, T, C>, T, C extends Iterable<T>>
extends Subject<S, C> {
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    static <T, C extends Iterable<T>> IterableSubject<? extends IterableSubject<?, T, C>, T, C> create(FailureStrategy failureStrategy, @Nullable Iterable<T> list) {
        return new IterableSubject(failureStrategy, list);
    }

    protected IterableSubject(FailureStrategy failureStrategy, @Nullable C list) {
        super(failureStrategy, list);
    }

    public final void isEmpty() {
        if (!Iterables.isEmpty((Iterable)((Iterable)this.getSubject()))) {
            this.fail("is empty");
        }
    }

    public final void isNotEmpty() {
        if (Iterables.isEmpty((Iterable)((Iterable)this.getSubject()))) {
            this.fail("is not empty");
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (Object[])new Object[]{expectedSize});
        int actualSize = Iterables.size((Iterable)((Iterable)this.getSubject()));
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public final void contains(@Nullable Object element) {
        if (!Iterables.contains((Iterable)((Iterable)this.getSubject()), (Object)element)) {
            this.failWithRawMessage("%s should have contained <%s>", this.getDisplaySubject(), element);
        }
    }

    public final void doesNotContain(@Nullable Object element) {
        if (Iterables.contains((Iterable)((Iterable)this.getSubject()), (Object)element)) {
            this.failWithRawMessage("%s should not have contained <%s>", this.getDisplaySubject(), element);
        }
    }

    public final void containsNoDuplicates() {
        ArrayList duplicates = Lists.newArrayList();
        for (Multiset.Entry entry : LinkedHashMultiset.create((Iterable)((Iterable)this.getSubject())).entrySet()) {
            if (entry.getCount() <= 1) continue;
            duplicates.add(entry);
        }
        if (!duplicates.isEmpty()) {
            this.failWithRawMessage("%s has the following duplicates: <%s>", this.getDisplaySubject(), duplicates);
        }
    }

    public final void containsAnyOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.containsAny("contains any of", SubjectUtils.accumulate(first, second, rest));
    }

    public final void containsAnyIn(Iterable<?> expected) {
        this.containsAny("contains any element in", expected);
    }

    private void containsAny(String failVerb, Iterable<?> expected) {
        Collection subject = this.getSubject() instanceof Collection ? (Collection)this.getSubject() : Lists.newArrayList((Iterable)((Iterable)this.getSubject()));
        for (Object item : expected) {
            if (!subject.contains(item)) continue;
            return;
        }
        this.fail(failVerb, (Object)expected);
    }

    public final Ordered containsAllOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        return this.containsAll("contains all of", SubjectUtils.accumulate(first, second, rest));
    }

    public final Ordered containsAllIn(Iterable<?> expected) {
        return this.containsAll("contains all elements in", expected);
    }

    private Ordered containsAll(String failVerb, Iterable<?> expectedIterable) {
        LinkedList actual = Lists.newLinkedList((Iterable)((Iterable)this.getSubject()));
        ArrayList expected = Lists.newArrayList(expectedIterable);
        ArrayList missing = Lists.newArrayList();
        ArrayList actualNotInOrder = Lists.newArrayList();
        boolean ordered = true;
        for (Object e : expected) {
            int index = actual.indexOf(e);
            if (index != -1) {
                IterableSubject.moveElements(actual, actualNotInOrder, index);
                actual.remove(0);
                continue;
            }
            if (actualNotInOrder.remove(e)) {
                ordered = false;
                continue;
            }
            missing.add(e);
        }
        if (!missing.isEmpty()) {
            this.failWithBadResults(failVerb, expected, "is missing", SubjectUtils.countDuplicates(missing));
        }
        return ordered ? IN_ORDER : new NotInOrder("contains all elements in order", expected);
    }

    private static void moveElements(List<?> input, Collection<Object> output, int maxElements) {
        for (int i = 0; i < maxElements; ++i) {
            output.add(input.remove(0));
        }
    }

    public final Ordered containsExactly(Object ... varargs) {
        ArrayList expected = varargs == null ? Lists.newArrayList((Object[])new Object[]{null}) : Arrays.asList(varargs);
        return this.containsExactly("contains exactly", expected, varargs != null && varargs.length == 1 && varargs[0] instanceof Iterable);
    }

    public final Ordered containsExactlyElementsIn(Iterable<?> expected) {
        return this.containsExactly("contains exactly", expected, false);
    }

    private Ordered containsExactly(String failVerb, Iterable<?> required, boolean addElementsInWarning) {
        String failSuffix = addElementsInWarning ? ". Passing an iterable to the varargs method containsExactly(Object...) is often not the correct thing to do. Did you mean to call containsExactlyElementsIn(Iterable) instead?" : "";
        Iterator actualIter = ((Iterable)this.getSubject()).iterator();
        Iterator<?> requiredIter = required.iterator();
        while (actualIter.hasNext() && requiredIter.hasNext()) {
            Object requiredElement;
            Object actualElement = actualIter.next();
            if (Objects.equal(actualElement, requiredElement = requiredIter.next())) continue;
            ArrayList missing = Lists.newArrayList();
            missing.add(requiredElement);
            Iterators.addAll((Collection)missing, requiredIter);
            ArrayList extra = Lists.newArrayList();
            if (!missing.remove(actualElement)) {
                extra.add(actualElement);
            }
            while (actualIter.hasNext()) {
                Object item = actualIter.next();
                if (missing.remove(item)) continue;
                extra.add(item);
            }
            if (!missing.isEmpty()) {
                if (!extra.isEmpty()) {
                    this.failWithRawMessage("Not true that %s %s <%s>. It is missing <%s> and has unexpected items <%s>%s", this.getDisplaySubject(), failVerb, required, SubjectUtils.countDuplicates(missing), SubjectUtils.countDuplicates(extra), failSuffix);
                } else {
                    this.failWithBadResultsAndSuffix(failVerb, required, "is missing", SubjectUtils.countDuplicates(missing), failSuffix);
                }
            }
            if (!extra.isEmpty()) {
                this.failWithBadResultsAndSuffix(failVerb, required, "has unexpected items", SubjectUtils.countDuplicates(extra), failSuffix);
            }
            return new NotInOrder("contains only these elements in order", required);
        }
        if (actualIter.hasNext()) {
            this.failWithBadResultsAndSuffix(failVerb, required, "has unexpected items", SubjectUtils.countDuplicates(Lists.newArrayList(actualIter)), failSuffix);
        } else if (requiredIter.hasNext()) {
            this.failWithBadResultsAndSuffix(failVerb, required, "is missing", SubjectUtils.countDuplicates(Lists.newArrayList(requiredIter)), failSuffix);
        }
        return IN_ORDER;
    }

    protected final void failWithBadResultsAndSuffix(String verb, Object expected, String failVerb, Object actual, String suffix) {
        this.failWithRawMessage("Not true that %s %s <%s>. It %s <%s>%s", this.getDisplaySubject(), verb, expected, failVerb, actual == null ? "null reference" : actual, suffix);
    }

    public final void containsNoneOf(@Nullable Object first, @Nullable Object second, Object ... rest) {
        this.containsNone("contains none of", SubjectUtils.accumulate(first, second, rest));
    }

    public final void containsNoneIn(Iterable<?> excluded) {
        this.containsNone("contains no elements in", excluded);
    }

    private void containsNone(String failVerb, Iterable<?> excluded) {
        ArrayList present = new ArrayList();
        for (Object item : Sets.newLinkedHashSet(excluded)) {
            if (!Iterables.contains((Iterable)((Iterable)this.getSubject()), item)) continue;
            present.add(item);
        }
        if (!present.isEmpty()) {
            this.failWithBadResults(failVerb, excluded, "contains", present);
        }
    }

    public final void isStrictlyOrdered() {
        this.isStrictlyOrdered((Comparator<? super T>)Ordering.natural());
    }

    public final void isStrictlyOrdered(final Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck(new PairwiseChecker<T>(){

            @Override
            public void check(T prev, T next) {
                if (comparator.compare(prev, next) >= 0) {
                    IterableSubject.this.fail("is strictly ordered", prev, next);
                }
            }
        });
    }

    public final void isPartiallyOrdered() {
        this.isPartiallyOrdered((Comparator<? super T>)Ordering.natural());
    }

    public final void isPartiallyOrdered(final Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator);
        this.pairwiseCheck(new PairwiseChecker<T>(){

            @Override
            public void check(T prev, T next) {
                if (comparator.compare(prev, next) > 0) {
                    IterableSubject.this.fail("is partially ordered", prev, next);
                }
            }
        });
    }

    private void pairwiseCheck(PairwiseChecker<T> checker) {
        Iterator iterator = ((Iterable)this.getSubject()).iterator();
        if (iterator.hasNext()) {
            Object prev = iterator.next();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                checker.check(prev, next);
                prev = next;
            }
        }
    }

    private static interface PairwiseChecker<T> {
        public void check(T var1, T var2);
    }

    private class NotInOrder
    implements Ordered {
        private final String check;
        private final Iterable<?> required;

        NotInOrder(String check, Iterable<?> required) {
            this.check = check;
            this.required = required;
        }

        @Override
        public void inOrder() {
            IterableSubject.this.fail(this.check, (Object)this.required);
        }
    }
}

