/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneOptions;
import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Queue;

public class ErrorProneJavacJavaCompiler
extends JavaCompiler {
    private final ErrorProneAnalyzer errorProneAnalyzer;

    public static void setupMessageBundle(Context context) {
        JavacMessages.instance(context).add("com.google.errorprone.errors");
    }

    private ErrorProneJavacJavaCompiler(Context context, CodeTransformer transformer, ErrorProneOptions errorProneOptions) {
        super(context);
        Preconditions.checkNotNull((Object)transformer);
        ErrorProneJavacJavaCompiler.setupMessageBundle(context);
        this.errorProneAnalyzer = ErrorProneAnalyzer.create(transformer).init(context, errorProneOptions);
    }

    public static void preRegister(Context context, final CodeTransformer transformer, final ErrorProneOptions errorProneOptions) {
        context.put(compilerKey, new Context.Factory<JavaCompiler>(){

            @Override
            public JavaCompiler make(Context ctx) {
                return new ErrorProneJavacJavaCompiler(ctx, transformer, errorProneOptions);
            }
        });
    }

    @Override
    protected void flow(Env<AttrContext> env, Queue<Env<AttrContext>> results) {
        if (this.compileStates.isDone(env, CompileStates.CompileState.FLOW)) {
            super.flow(env, results);
            return;
        }
        super.flow(env, results);
        try {
            this.postFlow(env);
        }
        catch (Throwable e) {
            String version = (String)this.loadVersionFromPom().or((Object)"unknown version");
            this.log.error("error.prone.crash", Throwables.getStackTraceAsString((Throwable)e), version);
        }
    }

    private Optional<String> loadVersionFromPom() {
        InputStream stream = this.getClass().getResourceAsStream("/META-INF/maven/com.google.errorprone/error_prone_core/pom.properties");
        if (stream == null) {
            return Optional.absent();
        }
        Properties mavenProperties = new Properties();
        try {
            mavenProperties.load(stream);
        }
        catch (IOException expected) {
            return Optional.absent();
        }
        return Optional.of((Object)mavenProperties.getProperty("version"));
    }

    public void postFlow(Env<AttrContext> env) {
        this.errorProneAnalyzer.finished(new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym));
    }
}

