/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.apply.Diff;
import com.google.errorprone.apply.DiffNotApplicableException;
import com.google.errorprone.apply.ImportStatements;
import com.google.errorprone.apply.SourceFile;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.matchers.Description;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class DescriptionBasedDiff
implements DescriptionListener,
Diff {
    private final String sourcePath;
    private final JCTree.JCCompilationUnit compilationUnit;
    private final Set<String> importsToAdd;
    private final Set<String> importsToRemove;
    private final EndPosTable endPositions;
    private final RangeMap<Integer, Replacement> replacements;

    public static DescriptionBasedDiff create(JCTree.JCCompilationUnit compilationUnit) {
        return new DescriptionBasedDiff(compilationUnit);
    }

    private DescriptionBasedDiff(JCTree.JCCompilationUnit compilationUnit) {
        this.compilationUnit = (JCTree.JCCompilationUnit)Preconditions.checkNotNull((Object)compilationUnit);
        this.sourcePath = compilationUnit.getSourceFile().toUri().getPath();
        this.importsToAdd = new HashSet<String>();
        this.importsToRemove = new HashSet<String>();
        this.endPositions = compilationUnit.endPositions;
        this.replacements = TreeRangeMap.create();
    }

    @Override
    public String getRelevantFileName() {
        return this.sourcePath;
    }

    public boolean isEmpty() {
        return this.importsToAdd.isEmpty() && this.importsToRemove.isEmpty() && this.replacements.asMapOfRanges().isEmpty();
    }

    @Override
    public void onDescribed(Description description) {
        if (description.fixes.size() > 0) {
            Fix fix = (Fix)description.fixes.get(0);
            this.importsToAdd.addAll(fix.getImportsToAdd());
            this.importsToRemove.removeAll(fix.getImportsToRemove());
            for (Replacement replacement : fix.getReplacements(this.endPositions)) {
                this.addReplacement(replacement);
            }
        }
    }

    private void addReplacement(Replacement replacement) {
        Preconditions.checkNotNull((Object)replacement);
        Range range = Range.closedOpen((Comparable)Integer.valueOf(replacement.startPosition()), (Comparable)Integer.valueOf(replacement.endPosition()));
        RangeMap overlaps = this.replacements.subRangeMap(range);
        Preconditions.checkArgument((boolean)overlaps.asMapOfRanges().isEmpty(), (String)"Replacement %s overlaps with %s", (Object[])new Object[]{replacement, overlaps});
        this.replacements.put(range, (Object)replacement);
    }

    @Override
    public void applyDifferences(SourceFile sourceFile) throws DiffNotApplicableException {
        ArrayList replacementsInOrder = new ArrayList(this.replacements.asMapOfRanges().values());
        Collections.reverse(replacementsInOrder);
        if (!this.importsToAdd.isEmpty() || !this.importsToRemove.isEmpty()) {
            ImportStatements importStatements = ImportStatements.create(this.compilationUnit);
            importStatements.addAll(this.importsToAdd);
            importStatements.removeAll(this.importsToRemove);
            replacementsInOrder.add(Replacement.create(importStatements.getStartPos(), importStatements.getEndPos(), importStatements.toString()));
        }
        for (Replacement replacement : replacementsInOrder) {
            sourceFile.replaceChars(replacement.startPosition(), replacement.endPosition(), replacement.replaceWith());
        }
    }
}

