/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AssertTree;

@BugPattern(name="AssertFalse", summary="Assertions may be disabled at runtime and do not guarantee that execution will halt here; consider throwing an exception instead", explanation="Java assertions do not necessarily execute at runtime; they may be enabled and disabled depending on which options are passed to the JVM invocation. An assert false statement may be intended to ensure that the program never proceeds beyond that statement. If the correct execution of the program depends on that being the case, consider throwing an exception instead, so that execution is halted regardless of runtime configuration.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class AssertFalse
extends BugChecker
implements BugChecker.AssertTreeMatcher {
    private static final Matcher<AssertTree> ASSERT_FALSE_MATCHER = Matchers.assertionWithCondition(Matchers.booleanLiteral(false));

    @Override
    public Description matchAssert(AssertTree tree, VisitorState state) {
        if (!ASSERT_FALSE_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, SuggestedFix.replace(tree, "throw new AssertionError()"));
    }
}

