/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.TypeElement;

@BugPattern(name="OverridesGuiceInjectableMethod", summary="This method is not annotated with @Inject, but it overrides a method that is annotated with @com.google.inject.Inject. Guice will inject this method,and it is recommended to annotate it explicitly.", explanation="Unlike with @javax.inject.Inject, if a method overrides a method annoatated with @com.google.inject.Inject, Guice will inject it even if it itself is not annotated. This differs from the behavior of methods that override @javax.inject.Inject methods since according to the JSR-330 spec, a method that overrides a method annotated with javax.inject.Inject will not be injected unless it iself is annotated with @Inject. Because of this difference, it is recommended that you annotate this method explicitly.", category=BugPattern.Category.GUICE, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class GuiceOverridesGuiceInjectableMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String OVERRIDE_ANNOTATION = "java.lang.Override";
    private static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    private static final Matcher<MethodTree> INJECTABLE_METHOD_MATCHER = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.Inject"), Matchers.hasAnnotation("javax.inject.Inject"));
    private static final Matcher<MethodTree> OVERRIDE_METHOD_MATCHER = Matchers.hasAnnotation("java.lang.Override");

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!INJECTABLE_METHOD_MATCHER.matches(methodTree, state) && OVERRIDE_METHOD_MATCHER.matches(methodTree, state)) {
            Symbol.MethodSymbol method = ASTHelpers.getSymbol(methodTree);
            Symbol.MethodSymbol superMethod = null;
            boolean checkSuperClass = true;
            while (checkSuperClass) {
                superMethod = ASTHelpers.findSuperMethod(method, state.getTypes());
                if (GuiceOverridesGuiceInjectableMethod.isAnnotatedWith(superMethod, GUICE_INJECT_ANNOTATION)) {
                    return this.describeMatch(methodTree, SuggestedFix.builder().addImport(JAVAX_INJECT_ANNOTATION).prefixWith(methodTree, "@Inject\n").build());
                }
                checkSuperClass = GuiceOverridesGuiceInjectableMethod.isAnnotatedWith(superMethod, OVERRIDE_ANNOTATION);
                method = superMethod;
            }
        }
        return Description.NO_MATCH;
    }

    private static boolean isAnnotatedWith(Symbol.MethodSymbol method, String annotation) {
        for (Attribute.Compound c : method.getAnnotationMirrors()) {
            if (!((TypeElement)c.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotation)) continue;
            return true;
        }
        return false;
    }
}

