/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="InsecureCipherMode", summary="Cipher.getInstance() is invoked using either the default settings or ECB mode", explanation="This error is triggered when a Cipher instance is created using either the default settings or the notoriously insecure ECB mode. In particular, Java's default `Cipher.getInstance(\"AES\")` returns a cipher object that operates in ECB mode. Dynamically constructed transformation strings are also flagged, as they may conceal an instance of ECB mode. The problem with ECB mode is that encrypting the same block of plaintext always yields the same block of ciphertext. Hence, repetitions in the plaintext translate into repetitions in the ciphertext, which can be readily used to conduct cryptanalysis.\n\n", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, documentSuppression=false, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InsecureCipherMode
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String MESSAGE_BASE = "Insecure usage of Cipher.getInstance(): ";
    private static final Matcher<ExpressionTree> GETINSTANCE_MATCHER = MethodMatchers.staticMethod().onClass("javax.crypto.Cipher").named("getInstance");

    private Description buildErrorMessage(MethodInvocationTree tree, String explanation) {
        Description.Builder description = this.buildDescription(tree);
        description.setMessage(MESSAGE_BASE + explanation + ".");
        return description.build();
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!GETINSTANCE_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Object argument = ASTHelpers.constValue((JCTree)((Object)tree.getArguments().get(0)));
        if (argument == null) {
            return this.buildErrorMessage(tree, "the transformation is not a compile-time constant expression");
        }
        String transformation = (String)argument;
        if (transformation.matches("ARCFOUR.*") || transformation.matches("ARC4.*") || transformation.matches("RC4.*")) {
            return Description.NO_MATCH;
        }
        if (!transformation.matches(".*/.*/.*")) {
            return this.buildErrorMessage(tree, "the mode and padding must be explicitly specified");
        }
        if (transformation.matches(".*/ECB/.*") && !transformation.matches("RSA/.*") && !transformation.matches("AESWrap/.*")) {
            return this.buildErrorMessage(tree, "ECB mode must not be used");
        }
        return Description.NO_MATCH;
    }
}

