/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="NullablePrimitive", summary="@Nullable should not be used for primitive types.", explanation="Primitives can never be null, annotating a primitive with @Nullable may be hinting at an intent that cannot be fulfilled.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class NullablePrimitive
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String NULLABLE_ANNOTATION_SIMPLE_NAME = "Nullable";
    private static final Matcher<Tree> IS_PRIMITIVE_TYPE_MATCHER = Matchers.isPrimitiveType();
    private static final Matcher<AnnotationTree> NULLABLE_ANNOTATION_MATCHER = Matchers.annotationHasSimpleName("Nullable");
    private static final Matcher<MethodTree> METHOD_RETURNS_NON_PRIMITIVE_TYPE_MATCHER = Matchers.methodReturnsNonPrimitiveType();

    @Override
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (NULLABLE_ANNOTATION_MATCHER.matches(tree, state)) {
            Tree annotatedNode = NullablePrimitive.getAnnotatedNode(state);
            if (IS_PRIMITIVE_TYPE_MATCHER.matches(annotatedNode, state)) {
                return this.describeMatch(tree, SuggestedFix.delete(tree));
            }
            if (NullablePrimitive.isMethod(annotatedNode) && !METHOD_RETURNS_NON_PRIMITIVE_TYPE_MATCHER.matches((MethodTree)annotatedNode, state)) {
                return this.describeMatch(tree, SuggestedFix.delete(tree));
            }
        }
        return Description.NO_MATCH;
    }

    private static Tree getAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }

    private static boolean isMethod(Tree tree) {
        return tree.getKind().equals((Object)Tree.Kind.METHOD);
    }
}

