/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="StringEquality", summary="String comparison using reference equality instead of value equality", explanation="Strings are compared for reference equality/inequality using == or !=instead of for value equality using .equals()", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class StringEquality
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private final NullnessAnalysis nullnessAnalysis = new NullnessAnalysis();
    private static final Matcher<BinaryTree> STRING_OPERANDS = new Matcher<BinaryTree>(){

        @Override
        public boolean matches(BinaryTree tree, VisitorState state) {
            Type stringType = state.getSymtab().stringType;
            ExpressionTree leftOperand = tree.getLeftOperand();
            Type leftType = ((JCTree.JCExpression)leftOperand).type;
            if (!state.getTypes().isSameType(leftType, stringType)) {
                return false;
            }
            ExpressionTree rightOperand = tree.getRightOperand();
            Type rightType = ((JCTree.JCExpression)rightOperand).type;
            return state.getTypes().isSameType(rightType, stringType);
        }
    };
    public static final Matcher<BinaryTree> MATCHER = Matchers.allOf(Matchers.anyOf(Matchers.kindIs(Tree.Kind.EQUAL_TO), Matchers.kindIs(Tree.Kind.NOT_EQUAL_TO)), STRING_OPERANDS);

    @Override
    public Description matchBinary(BinaryTree tree, final VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        StringBuilder fixExpr = StringEquality.considerOneOf(tree.getLeftOperand(), tree.getRightOperand(), new HandleChoice<ExpressionTree, StringBuilder>(){

            @Override
            public StringBuilder apply(ExpressionTree it, ExpressionTree other) {
                return "".equals(ASTHelpers.constValue((JCTree)((Object)it))) && StringEquality.this.isNonNull(other, state) ? StringEquality.methodCall(other, "isEmpty", new ExpressionTree[0]) : null;
            }
        });
        if (fixExpr == null && (fixExpr = StringEquality.considerOneOf(tree.getLeftOperand(), tree.getRightOperand(), new HandleChoice<ExpressionTree, StringBuilder>(){

            @Override
            public StringBuilder apply(ExpressionTree it, ExpressionTree other) {
                return StringEquality.this.isNonNull(it, state) ? StringEquality.methodCall(it, "equals", new ExpressionTree[]{other}) : null;
            }
        })) == null) {
            fixExpr = StringEquality.methodCall(null, "Objects.equals", tree.getLeftOperand(), tree.getRightOperand());
            fix.addImport("java.util.Objects");
        }
        if (tree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
            fixExpr.insert(0, "!");
        }
        fix.replace(tree, fixExpr.toString());
        return this.describeMatch(tree, fix.build());
    }

    private static <T, R> R considerOneOf(T a, T b, HandleChoice<T, R> f) {
        R r = f.apply(a, b);
        return r == null ? f.apply(b, a) : r;
    }

    private boolean isNonNull(ExpressionTree expr, VisitorState state) {
        TreePath pathToExpr = new TreePath(state.getPath(), expr);
        return this.nullnessAnalysis.getNullness(pathToExpr, state.context) == Nullness.NONNULL;
    }

    private static StringBuilder methodCall(ExpressionTree receiver, String methodName, ExpressionTree ... params) {
        StringBuilder fixedExpression = new StringBuilder();
        if (receiver != null) {
            boolean isBinop = receiver instanceof BinaryTree;
            if (isBinop) {
                fixedExpression.append("(");
            }
            fixedExpression.append(receiver);
            if (isBinop) {
                fixedExpression.append(")");
            }
            fixedExpression.append(".");
        }
        fixedExpression.append(methodName);
        fixedExpression.append("(");
        fixedExpression.append(Joiner.on((String)", ").join((Object[])params));
        fixedExpression.append(")");
        return fixedExpression;
    }

    private static interface HandleChoice<T, R> {
        public R apply(T var1, T var2);
    }
}

