/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.base.Preconditions;
import com.google.errorprone.dataflow.LocalStore;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessPropagationTransfer;
import com.sun.source.tree.MethodInvocationTree;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.ArrayTypeNode;
import org.checkerframework.dataflow.cfg.node.AssertionErrorNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.dataflow.cfg.node.CaseNode;
import org.checkerframework.dataflow.cfg.node.CharacterLiteralNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.dataflow.cfg.node.DoubleLiteralNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.FloatLiteralNode;
import org.checkerframework.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.dataflow.cfg.node.LessThanNode;
import org.checkerframework.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.LongLiteralNode;
import org.checkerframework.dataflow.cfg.node.MarkerNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.NullChkNode;
import org.checkerframework.dataflow.cfg.node.NullLiteralNode;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.PackageNameNode;
import org.checkerframework.dataflow.cfg.node.ParameterizedTypeNode;
import org.checkerframework.dataflow.cfg.node.PrimitiveTypeNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.cfg.node.ShortLiteralNode;
import org.checkerframework.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.StringLiteralNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.cfg.node.ThrowNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;

abstract class AbstractNullnessPropagationTransfer
implements TransferFunction<Nullness, LocalStore<Nullness>> {
    private static final boolean NO_STORE_CHANGE = false;

    AbstractNullnessPropagationTransfer() {
    }

    public final LocalStore<Nullness> initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        return LocalStore.empty();
    }

    Nullness visitValueLiteral() {
        return Nullness.NULLABLE;
    }

    Nullness visitBitwiseOperation() {
        return Nullness.NULLABLE;
    }

    Nullness visitNumericalComparison() {
        return Nullness.NULLABLE;
    }

    Nullness visitNumericalOperation() {
        return Nullness.NULLABLE;
    }

    Nullness visitThisLiteral() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNullLiteral(NullLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitNullLiteral();
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitNullLiteral() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitTypeCast(TypeCastNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitTypeCast(node, AbstractNullnessPropagationTransfer.values(input));
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitTypeCast(TypeCastNode node, SubNodeValues inputs) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNumericalAddition(NumericalAdditionNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitNumericalAddition();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitNumericalAddition() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNarrowingConversion(NarrowingConversionNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitNarrowingConversion();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitNarrowingConversion() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitEqualTo(EqualToNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates thenUpdates = new ReadableLocalVariableUpdates();
        ReadableLocalVariableUpdates elseUpdates = new ReadableLocalVariableUpdates();
        this.visitEqualTo(node, AbstractNullnessPropagationTransfer.values(input), thenUpdates, elseUpdates);
        ResultingStore thenStore = AbstractNullnessPropagationTransfer.updateStore((LocalStore)input.getThenStore(), thenUpdates);
        ResultingStore elseStore = AbstractNullnessPropagationTransfer.updateStore((LocalStore)input.getElseStore(), elseUpdates);
        return AbstractNullnessPropagationTransfer.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged | elseStore.storeChanged);
    }

    void visitEqualTo(EqualToNode node, SubNodeValues inputs, LocalVariableUpdates thenUpdates, LocalVariableUpdates elseUpdates) {
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNotEqual(NotEqualNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates thenUpdates = new ReadableLocalVariableUpdates();
        ReadableLocalVariableUpdates elseUpdates = new ReadableLocalVariableUpdates();
        this.visitNotEqual(node, AbstractNullnessPropagationTransfer.values(input), thenUpdates, elseUpdates);
        ResultingStore thenStore = AbstractNullnessPropagationTransfer.updateStore((LocalStore)input.getThenStore(), thenUpdates);
        ResultingStore elseStore = AbstractNullnessPropagationTransfer.updateStore((LocalStore)input.getElseStore(), elseUpdates);
        return AbstractNullnessPropagationTransfer.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged | elseStore.storeChanged);
    }

    void visitNotEqual(NotEqualNode node, SubNodeValues inputs, LocalVariableUpdates thenUpdates, LocalVariableUpdates elseUpdates) {
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitAssignment(AssignmentNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitAssignment(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitAssignment(AssignmentNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitLocalVariable(LocalVariableNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitLocalVariable(node, AbstractNullnessPropagationTransfer.values((LocalStore)input.getRegularStore()));
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitLocalVariable(LocalVariableNode node, LocalVariableValues store) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitFieldAccess(FieldAccessNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitFieldAccess(node, updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitFieldAccess(FieldAccessNode node, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitMethodInvocation(MethodInvocationNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates thenUpdates = new ReadableLocalVariableUpdates();
        ReadableLocalVariableUpdates elseUpdates = new ReadableLocalVariableUpdates();
        ReadableLocalVariableUpdates bothUpdates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitMethodInvocation(node, thenUpdates, elseUpdates, bothUpdates);
        if (NullnessPropagationTransfer.tryGetMethodSymbol((MethodInvocationTree)node.getTree()).isBoolean) {
            ResultingStore thenStore = AbstractNullnessPropagationTransfer.updateStore((LocalStore)input.getThenStore(), thenUpdates, bothUpdates);
            ResultingStore elseStore = AbstractNullnessPropagationTransfer.updateStore((LocalStore)input.getElseStore(), elseUpdates, bothUpdates);
            return AbstractNullnessPropagationTransfer.conditionalResult(thenStore.store, elseStore.store, thenStore.storeChanged | elseStore.storeChanged);
        }
        return this.updateRegularStore(result, input, bothUpdates);
    }

    Nullness visitMethodInvocation(MethodInvocationNode node, LocalVariableUpdates thenUpdates, LocalVariableUpdates elseUpdates, LocalVariableUpdates bothUpdates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitConditionalAnd(ConditionalAndNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        return AbstractNullnessPropagationTransfer.conditionalResult((LocalStore)input.getThenStore(), (LocalStore)input.getElseStore(), false);
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitConditionalOr(ConditionalOrNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        return AbstractNullnessPropagationTransfer.conditionalResult((LocalStore)input.getThenStore(), (LocalStore)input.getElseStore(), false);
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitConditionalNot(ConditionalNotNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        boolean storeChanged = !((LocalStore)input.getThenStore()).equals(input.getElseStore());
        return AbstractNullnessPropagationTransfer.conditionalResult((LocalStore)input.getElseStore(), (LocalStore)input.getThenStore(), storeChanged);
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitObjectCreation(ObjectCreationNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitObjectCreation();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitObjectCreation() {
        return Nullness.NULLABLE;
    }

    private static TransferResult<Nullness, LocalStore<Nullness>> noStoreChanges(Nullness value, TransferInput<?, LocalStore<Nullness>> input) {
        return new RegularTransferResult((AbstractValue)value, input.getRegularStore());
    }

    @CheckReturnValue
    private TransferResult<Nullness, LocalStore<Nullness>> updateRegularStore(Nullness value, TransferInput<?, LocalStore<Nullness>> input, ReadableLocalVariableUpdates updates) {
        ResultingStore newStore = AbstractNullnessPropagationTransfer.updateStore((LocalStore)input.getRegularStore(), updates);
        return new RegularTransferResult((AbstractValue)value, newStore.store, newStore.storeChanged);
    }

    private static TransferResult<Nullness, LocalStore<Nullness>> conditionalResult(LocalStore<Nullness> thenStore, LocalStore<Nullness> elseStore, boolean storeChanged) {
        return new ConditionalTransferResult((AbstractValue)Nullness.NONNULL, thenStore, elseStore, storeChanged);
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitShortLiteral(ShortLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitShortLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitShortLiteral() {
        return this.visitValueLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitIntegerLiteral(IntegerLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitIntegerLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitIntegerLiteral() {
        return this.visitValueLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitLongLiteral(LongLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitLongLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitLongLiteral() {
        return this.visitValueLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitFloatLiteral(FloatLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitFloatLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitFloatLiteral() {
        return this.visitValueLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitDoubleLiteral(DoubleLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitDoubleLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitDoubleLiteral() {
        return this.visitValueLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitBooleanLiteral(BooleanLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitBooleanLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitBooleanLiteral() {
        return this.visitValueLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitCharacterLiteral(CharacterLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitCharacterLiteral(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitCharacterLiteral(CharacterLiteralNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return this.visitValueLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitStringLiteral(StringLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitStringLiteral(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitStringLiteral(StringLiteralNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return this.visitValueLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNumericalMinus(NumericalMinusNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitNumericalMinus();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNumericalMinus() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNumericalPlus(NumericalPlusNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitNumericalPlus();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNumericalPlus() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitBitwiseComplement(BitwiseComplementNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitBitwiseComplement();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitBitwiseComplement() {
        return this.visitBitwiseOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNullChk(NullChkNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitNullChk();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNullChk() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitStringConcatenate(StringConcatenateNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitStringConcatenate();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitStringConcatenate() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNumericalSubtraction(NumericalSubtractionNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitNumericalSubtraction();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNumericalSubtraction() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitNumericalMultiplication(NumericalMultiplicationNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitNumericalMultiplication();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitNumericalMultiplication() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitIntegerDivision(IntegerDivisionNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitIntegerDivision();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitIntegerDivision() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitFloatingDivision(FloatingDivisionNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitFloatingDivision();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitFloatingDivision() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitIntegerRemainder(IntegerRemainderNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitIntegerRemainder();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitIntegerRemainder() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitFloatingRemainder(FloatingRemainderNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitFloatingRemainder();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitFloatingRemainder() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitLeftShift(LeftShiftNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitLeftShift();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitLeftShift() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitSignedRightShift(SignedRightShiftNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitSignedRightShift();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitSignedRightShift() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitUnsignedRightShift(UnsignedRightShiftNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitUnsignedRightShift();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitUnsignedRightShift() {
        return this.visitNumericalOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitBitwiseAnd(BitwiseAndNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitBitwiseAnd();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitBitwiseAnd() {
        return this.visitBitwiseOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitBitwiseOr(BitwiseOrNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitBitwiseOr();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitBitwiseOr() {
        return this.visitBitwiseOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitBitwiseXor(BitwiseXorNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitBitwiseXor();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitBitwiseXor() {
        return this.visitBitwiseOperation();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitStringConcatenateAssignment(StringConcatenateAssignmentNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitStringConcatenateAssignment();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitStringConcatenateAssignment() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitLessThan(LessThanNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitLessThan();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitLessThan() {
        return this.visitNumericalComparison();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitLessThanOrEqual(LessThanOrEqualNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitLessThanOrEqual();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitLessThanOrEqual() {
        return this.visitNumericalComparison();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitGreaterThan(GreaterThanNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitGreaterThan();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitGreaterThan() {
        return this.visitNumericalComparison();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitGreaterThanOrEqual(GreaterThanOrEqualNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitGreaterThanOrEqual();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitGreaterThanOrEqual() {
        return this.visitNumericalComparison();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitTernaryExpression(TernaryExpressionNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness result = this.visitTernaryExpression(node, AbstractNullnessPropagationTransfer.values(input));
        return AbstractNullnessPropagationTransfer.noStoreChanges(result, input);
    }

    Nullness visitTernaryExpression(TernaryExpressionNode node, SubNodeValues inputs) {
        return inputs.valueOfSubNode(node.getThenOperand()).leastUpperBound(inputs.valueOfSubNode(node.getElseOperand()));
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitVariableDeclaration(VariableDeclarationNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitVariableDeclaration();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitVariableDeclaration() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitMethodAccess(MethodAccessNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitMethodAccess();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitMethodAccess() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitArrayAccess(ArrayAccessNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitArrayAccess(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitArrayAccess(ArrayAccessNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitImplicitThisLiteral(ImplicitThisLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitImplicitThisLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitImplicitThisLiteral() {
        return this.visitThisLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitExplicitThisLiteral(ExplicitThisLiteralNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitExplicitThisLiteral();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitExplicitThisLiteral() {
        return this.visitThisLiteral();
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitSuper(SuperNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitSuper();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitSuper() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitReturn(ReturnNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitReturn();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitReturn() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitStringConversion(StringConversionNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitStringConversion();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitStringConversion() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitWideningConversion(WideningConversionNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitWideningConversion();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitWideningConversion() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitInstanceOf(InstanceOfNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitInstanceOf(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitInstanceOf(InstanceOfNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitSynchronized(SynchronizedNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitSynchronized(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitSynchronized(SynchronizedNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitAssertionError(AssertionErrorNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitAssertionError();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitAssertionError() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitThrow(ThrowNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitThrow(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitThrow(ThrowNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitCase(CaseNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitCase();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitCase() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitMemberReference(FunctionalInterfaceNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitMemberReference(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitMemberReference(FunctionalInterfaceNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitArrayCreation(ArrayCreationNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitArrayCreation(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitArrayCreation(ArrayCreationNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitArrayType(ArrayTypeNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitArrayType();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitArrayType() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitPrimitiveType(PrimitiveTypeNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitPrimitiveType();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitPrimitiveType() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitClassName(ClassNameNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitClassName();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitClassName() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitPackageName(PackageNameNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitPackageName();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitPackageName() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitParameterizedType(ParameterizedTypeNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        Nullness value = this.visitParameterizedType();
        return AbstractNullnessPropagationTransfer.noStoreChanges(value, input);
    }

    Nullness visitParameterizedType() {
        return Nullness.NULLABLE;
    }

    public final TransferResult<Nullness, LocalStore<Nullness>> visitMarker(MarkerNode node, TransferInput<Nullness, LocalStore<Nullness>> input) {
        ReadableLocalVariableUpdates updates = new ReadableLocalVariableUpdates();
        Nullness result = this.visitMarker(node, AbstractNullnessPropagationTransfer.values(input), updates);
        return this.updateRegularStore(result, input, updates);
    }

    Nullness visitMarker(MarkerNode node, SubNodeValues inputs, LocalVariableUpdates updates) {
        return Nullness.NULLABLE;
    }

    @CheckReturnValue
    private static ResultingStore updateStore(LocalStore<Nullness> oldStore, ReadableLocalVariableUpdates ... updates) {
        LocalStore<Nullness> newStore;
        LocalStore.Builder<Nullness> builder = oldStore.toBuilder();
        for (ReadableLocalVariableUpdates update : updates) {
            for (Map.Entry<LocalVariableNode, Nullness> entry : update.values.entrySet()) {
                builder.setInformation((Node)entry.getKey(), (Nullness)((AbstractValue)entry.getValue()));
            }
        }
        return new ResultingStore(newStore, !(newStore = builder.build()).equals(oldStore));
    }

    private static SubNodeValues values(final TransferInput<Nullness, LocalStore<Nullness>> input) {
        return new SubNodeValues(){

            @Override
            public Nullness valueOfSubNode(Node node) {
                return (Nullness)input.getValueOfSubNode(node);
            }
        };
    }

    private static LocalVariableValues values(final LocalStore<Nullness> store) {
        return new LocalVariableValues(){

            @Override
            public Nullness valueOfLocalVariable(LocalVariableNode node) {
                return AbstractNullnessPropagationTransfer.orNullable((Nullness)((Object)store.getInformation((Node)node)));
            }
        };
    }

    private static Nullness orNullable(Nullness nullnessValue) {
        return nullnessValue != null ? nullnessValue : Nullness.NULLABLE;
    }

    private static final class ResultingStore {
        final LocalStore<Nullness> store;
        final boolean storeChanged;

        ResultingStore(LocalStore<Nullness> store, boolean storeChanged) {
            this.store = store;
            this.storeChanged = storeChanged;
        }
    }

    private static final class ReadableLocalVariableUpdates
    implements LocalVariableUpdates {
        final Map<LocalVariableNode, Nullness> values = new HashMap<LocalVariableNode, Nullness>();

        private ReadableLocalVariableUpdates() {
        }

        @Override
        public void set(LocalVariableNode node, Nullness value) {
            this.values.put((LocalVariableNode)Preconditions.checkNotNull((Object)node), (Nullness)((Object)Preconditions.checkNotNull((Object)((Object)value))));
        }
    }

    static interface LocalVariableUpdates {
        public void set(LocalVariableNode var1, Nullness var2);
    }

    static interface LocalVariableValues {
        public Nullness valueOfLocalVariable(LocalVariableNode var1);
    }

    static interface SubNodeValues {
        public Nullness valueOfSubNode(Node var1);
    }
}

