/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.AdjustedPosition;
import com.google.errorprone.fixes.AutoValue_SuggestedFix_TokInfo;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.IndexedPosition;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

public class SuggestedFix
implements Fix {
    private final ImmutableList<FixOperation> fixes;
    private final ImmutableList<String> importsToAdd;
    private final ImmutableList<String> importsToRemove;

    private SuggestedFix(List<FixOperation> fixes, List<String> importsToAdd, List<String> importsToRemove) {
        this.fixes = ImmutableList.copyOf(fixes);
        this.importsToAdd = ImmutableList.copyOf(importsToAdd);
        this.importsToRemove = ImmutableList.copyOf(importsToRemove);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Collection<String> getImportsToAdd() {
        return this.importsToAdd;
    }

    @Override
    public Collection<String> getImportsToRemove() {
        return this.importsToRemove;
    }

    @Override
    public String toString(JCTree.JCCompilationUnit compilationUnit) {
        StringBuilder result = new StringBuilder("replace ");
        for (Replacement replacement : this.getReplacements(compilationUnit.endPositions)) {
            result.append("position " + replacement.startPosition() + ":" + replacement.endPosition()).append(" with \"" + replacement.replaceWith() + "\" ");
        }
        return result.toString();
    }

    @Override
    public Set<Replacement> getReplacements(EndPosTable endPositions) {
        if (endPositions == null) {
            throw new IllegalArgumentException("Cannot produce correct replacements without endPositions.");
        }
        TreeSet<Replacement> replacements = new TreeSet<Replacement>(new Comparator<Replacement>(){

            @Override
            public int compare(Replacement o1, Replacement o2) {
                return Integer.compare(o2.startPosition(), o1.startPosition());
            }
        });
        for (FixOperation fix : this.fixes) {
            replacements.add(fix.getReplacement(endPositions));
        }
        return replacements;
    }

    public static Fix replace(Tree tree, String replaceWith) {
        return SuggestedFix.builder().replace(tree, replaceWith).build();
    }

    public static Fix replace(int startPos, int endPos, String replaceWith) {
        return SuggestedFix.builder().replace(startPos, endPos, replaceWith).build();
    }

    public static Fix replace(Tree node, String replaceWith, int startPosAdjustment, int endPosAdjustment) {
        return SuggestedFix.builder().replace(node, replaceWith, startPosAdjustment, endPosAdjustment).build();
    }

    public static Fix prefixWith(Tree node, String prefix) {
        return SuggestedFix.builder().prefixWith(node, prefix).build();
    }

    public static Fix postfixWith(Tree node, String postfix) {
        return SuggestedFix.builder().postfixWith(node, postfix).build();
    }

    public static Fix delete(Tree node) {
        return SuggestedFix.builder().delete(node).build();
    }

    public static Fix swap(Tree node1, Tree node2) {
        return SuggestedFix.builder().swap(node1, node2).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static int modifierOrder(Modifier mod) {
        switch (mod) {
            case PUBLIC: {
                return 1;
            }
            case PROTECTED: {
                return 2;
            }
            case PRIVATE: {
                return 3;
            }
            case ABSTRACT: {
                return 4;
            }
            case STATIC: {
                return 6;
            }
            case FINAL: {
                return 7;
            }
            case TRANSIENT: {
                return 8;
            }
            case VOLATILE: {
                return 9;
            }
            case SYNCHRONIZED: {
                return 10;
            }
            case NATIVE: {
                return 11;
            }
            case STRICTFP: {
                return 12;
            }
        }
        throw new AssertionError((Object)mod);
    }

    @Nullable
    private static Modifier getTokModifierKind(ErrorProneToken tok) {
        switch (tok.kind()) {
            case PUBLIC: {
                return Modifier.PUBLIC;
            }
            case PROTECTED: {
                return Modifier.PROTECTED;
            }
            case PRIVATE: {
                return Modifier.PRIVATE;
            }
            case ABSTRACT: {
                return Modifier.ABSTRACT;
            }
            case STATIC: {
                return Modifier.STATIC;
            }
            case FINAL: {
                return Modifier.FINAL;
            }
            case TRANSIENT: {
                return Modifier.TRANSIENT;
            }
            case VOLATILE: {
                return Modifier.VOLATILE;
            }
            case SYNCHRONIZED: {
                return Modifier.SYNCHRONIZED;
            }
            case NATIVE: {
                return Modifier.NATIVE;
            }
            case STRICTFP: {
                return Modifier.STRICTFP;
            }
        }
        return null;
    }

    @Nullable
    public static Fix addModifier(Tree tree, Modifier modifier, VisitorState state) {
        ModifiersTree originalModifiers = ASTHelpers.getModifiers(tree);
        if (originalModifiers == null) {
            return null;
        }
        ImmutableList<ErrorProneToken> tokens = state.getTokensForNode((JCTree)((Object)originalModifiers));
        ArrayList<TokInfo> infos = new ArrayList<TokInfo>();
        for (Object tok : tokens) {
            Modifier mod = SuggestedFix.getTokModifierKind((ErrorProneToken)tok);
            if (mod == null) continue;
            infos.add(TokInfo.create((ErrorProneToken)tok, mod));
        }
        Collections.sort(infos);
        TokInfo prev = null;
        for (TokInfo info : infos) {
            int c = info.mod().compareTo(modifier);
            if (c < 0) {
                prev = info;
                continue;
            }
            if (c != 0) continue;
            return null;
        }
        JCTree posTree = (JCTree)((Object)originalModifiers);
        if (posTree.getStartPosition() < 0) {
            posTree = (JCTree)tree;
        }
        if (prev != null) {
            int pos = posTree.getStartPosition() + prev.token().pos() + prev.mod().toString().length();
            return SuggestedFix.replace(pos, pos, " " + (Object)((Object)modifier));
        }
        return SuggestedFix.prefixWith(posTree, (Object)((Object)modifier) + " ");
    }

    @Nullable
    public static Fix removeModifier(Tree tree, Modifier modifier, VisitorState state) {
        ModifiersTree originalModifiers = ASTHelpers.getModifiers(tree);
        if (originalModifiers == null) {
            return null;
        }
        ImmutableList<ErrorProneToken> tokens = state.getTokensForNode((JCTree)((Object)originalModifiers));
        ErrorProneToken toRemove = null;
        for (ErrorProneToken tok : tokens) {
            Modifier mod = SuggestedFix.getTokModifierKind(tok);
            if (mod != modifier) continue;
            toRemove = tok;
            break;
        }
        if (toRemove == null) {
            return null;
        }
        JCTree posTree = (JCTree)((Object)originalModifiers);
        int startPosition = posTree.getStartPosition() + toRemove.pos();
        int endPosition = posTree.getStartPosition() + toRemove.endPos() + 1;
        return SuggestedFix.replace(startPosition, endPosition, "");
    }

    static abstract class TokInfo
    implements Comparable<TokInfo> {
        TokInfo() {
        }

        abstract ErrorProneToken token();

        abstract Modifier mod();

        public static TokInfo create(ErrorProneToken tree, Modifier mod) {
            return new AutoValue_SuggestedFix_TokInfo(tree, mod);
        }

        @Override
        public int compareTo(TokInfo o) {
            return Integer.compare(SuggestedFix.modifierOrder(this.mod()), SuggestedFix.modifierOrder(o.mod()));
        }
    }

    private static class ReplacementFix
    implements FixOperation {
        private final JCDiagnostic.DiagnosticPosition original;
        private final String replacement;

        public ReplacementFix(JCDiagnostic.DiagnosticPosition original, String replacement) {
            this.original = original;
            this.replacement = replacement;
        }

        @Override
        public Replacement getReplacement(EndPosTable endPositions) {
            return Replacement.create(this.original.getStartPosition(), this.original.getEndPosition(endPositions), this.replacement);
        }
    }

    private static class PrefixInsertion
    extends InsertionFix {
        public PrefixInsertion(JCDiagnostic.DiagnosticPosition tree, String insertion) {
            super(tree, insertion);
        }

        @Override
        protected int getInsertionIndex(EndPosTable endPositions) {
            return this.tree.getStartPosition();
        }
    }

    private static class PostfixInsertion
    extends InsertionFix {
        public PostfixInsertion(JCDiagnostic.DiagnosticPosition tree, String insertion) {
            super(tree, insertion);
        }

        @Override
        protected int getInsertionIndex(EndPosTable endPositions) {
            return this.tree.getEndPosition(endPositions);
        }
    }

    private static abstract class InsertionFix
    implements FixOperation {
        protected final JCDiagnostic.DiagnosticPosition tree;
        protected final String insertion;

        protected abstract int getInsertionIndex(EndPosTable var1);

        protected InsertionFix(JCDiagnostic.DiagnosticPosition tree, String insertion) {
            this.tree = tree;
            this.insertion = insertion;
        }

        @Override
        public Replacement getReplacement(EndPosTable endPositions) {
            int insertionIndex = this.getInsertionIndex(endPositions);
            return Replacement.create(insertionIndex, insertionIndex, this.insertion);
        }
    }

    private static interface FixOperation {
        public Replacement getReplacement(EndPosTable var1);
    }

    public static class Builder {
        private final List<FixOperation> fixes = new ArrayList<FixOperation>();
        private final List<String> importsToAdd = new ArrayList<String>();
        private final List<String> importsToRemove = new ArrayList<String>();

        protected Builder() {
        }

        public boolean isEmpty() {
            return this.fixes.isEmpty() && this.importsToAdd.isEmpty() && this.importsToRemove.isEmpty();
        }

        public Fix build() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Empty fixes are not supported.");
            }
            return new SuggestedFix(this.fixes, this.importsToAdd, this.importsToRemove);
        }

        private Builder with(FixOperation fix) {
            this.fixes.add(fix);
            return this;
        }

        public Builder replace(Tree node, String replaceWith) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(new ReplacementFix((JCDiagnostic.DiagnosticPosition)((Object)node), replaceWith));
        }

        public Builder replace(int startPos, int endPos, String replaceWith) {
            IndexedPosition pos = new IndexedPosition(startPos, endPos);
            return this.with(new ReplacementFix(pos, replaceWith));
        }

        public Builder replace(Tree node, String replaceWith, int startPosAdjustment, int endPosAdjustment) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(new ReplacementFix(new AdjustedPosition((JCTree)node, startPosAdjustment, endPosAdjustment), replaceWith));
        }

        public Builder prefixWith(Tree node, String prefix) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(new PrefixInsertion((JCDiagnostic.DiagnosticPosition)((Object)node), prefix));
        }

        public Builder postfixWith(Tree node, String postfix) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(new PostfixInsertion((JCDiagnostic.DiagnosticPosition)((Object)node), postfix));
        }

        public Builder delete(Tree node) {
            Builder.checkNotSyntheticConstructor(node);
            return this.replace(node, "");
        }

        public Builder swap(Tree node1, Tree node2) {
            Builder.checkNotSyntheticConstructor(node1);
            Builder.checkNotSyntheticConstructor(node2);
            this.fixes.add(new ReplacementFix((JCDiagnostic.DiagnosticPosition)((Object)node1), node2.toString()));
            this.fixes.add(new ReplacementFix((JCDiagnostic.DiagnosticPosition)((Object)node2), node1.toString()));
            return this;
        }

        public Builder addImport(String importString) {
            this.importsToAdd.add("import " + importString);
            return this;
        }

        public Builder addStaticImport(String importString) {
            this.importsToAdd.add("import static " + importString);
            return this;
        }

        public Builder removeImport(String importString) {
            this.importsToRemove.add("import " + importString);
            return this;
        }

        public Builder removeStaticImport(String importString) {
            this.importsToRemove.add("import static " + importString);
            return this;
        }

        public Builder merge(Builder other) {
            Preconditions.checkNotNull((Object)other);
            this.fixes.addAll(other.fixes);
            this.importsToAdd.addAll(other.importsToAdd);
            this.importsToRemove.addAll(other.importsToRemove);
            return this;
        }

        private static void checkNotSyntheticConstructor(Tree tree) {
            if (tree instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)tree)) {
                throw new AssertionError((Object)"Cannot edit synthetic AST nodes");
            }
        }
    }
}

