/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.refaster.AutoValue_UPrimitiveType;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.Unifier;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import javax.lang.model.type.TypeKind;

abstract class UPrimitiveType
extends UType {
    private static final ImmutableSet<TypeKind> HONORARY_PRIMITIVES = ImmutableSet.of((Object)((Object)TypeKind.VOID), (Object)((Object)TypeKind.NULL));
    public static final UPrimitiveType BYTE = UPrimitiveType.create(TypeKind.BYTE);
    public static final UPrimitiveType SHORT = UPrimitiveType.create(TypeKind.SHORT);
    public static final UPrimitiveType INT = UPrimitiveType.create(TypeKind.INT);
    public static final UPrimitiveType LONG = UPrimitiveType.create(TypeKind.LONG);
    public static final UPrimitiveType FLOAT = UPrimitiveType.create(TypeKind.FLOAT);
    public static final UPrimitiveType DOUBLE = UPrimitiveType.create(TypeKind.DOUBLE);
    public static final UPrimitiveType BOOLEAN = UPrimitiveType.create(TypeKind.BOOLEAN);
    public static final UPrimitiveType CHAR = UPrimitiveType.create(TypeKind.CHAR);
    public static final UPrimitiveType NULL = UPrimitiveType.create(TypeKind.NULL);
    public static final UPrimitiveType VOID = UPrimitiveType.create(TypeKind.VOID);

    UPrimitiveType() {
    }

    public static UPrimitiveType create(TypeKind typeKind) {
        Preconditions.checkArgument((boolean)UPrimitiveType.isDeFactoPrimitive(typeKind), (String)"Non-primitive type %s passed to UPrimitiveType", (Object[])new Object[]{typeKind});
        return new AutoValue_UPrimitiveType(typeKind);
    }

    public abstract TypeKind getKind();

    public static boolean isDeFactoPrimitive(TypeKind kind) {
        return kind.isPrimitive() || HONORARY_PRIMITIVES.contains((Object)kind);
    }

    @Override
    public Choice<Unifier> visitType(Type target, Unifier unifier) {
        return Choice.condition(this.getKind().equals((Object)target.getKind()), unifier);
    }

    @Override
    public Type inline(Inliner inliner) {
        Symtab symtab = inliner.symtab();
        switch (this.getKind()) {
            case BYTE: {
                return symtab.byteType;
            }
            case SHORT: {
                return symtab.shortType;
            }
            case INT: {
                return symtab.intType;
            }
            case LONG: {
                return symtab.longType;
            }
            case FLOAT: {
                return symtab.floatType;
            }
            case DOUBLE: {
                return symtab.doubleType;
            }
            case BOOLEAN: {
                return symtab.booleanType;
            }
            case CHAR: {
                return symtab.charType;
            }
            case VOID: {
                return symtab.voidType;
            }
            case NULL: {
                return symtab.botType;
            }
        }
        throw new AssertionError();
    }
}

