# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

<a name="0.10.2"></a>
## [0.10.2](https://github.com/pedronauck/docz/compare/v0.10.1...v0.10.2) (2018-08-13)


### Bug Fixes

* prevent codemirror bug on build ([3d0894e](https://github.com/pedronauck/docz/commit/3d0894e))
* **docz-core:** remove data server cache :confused: ([9683280](https://github.com/pedronauck/docz/commit/9683280))
* **docz-core:** try catch on get repo info ([bdfbf0b](https://github.com/pedronauck/docz/commit/bdfbf0b))




<a name="0.10.1"></a>
## [0.10.1](https://github.com/pedronauck/docz/compare/v0.10.0...v0.10.1) (2018-08-13)


### Bug Fixes

* **docz-core:** prevent crash when not have cache ([cd3609a](https://github.com/pedronauck/docz/commit/cd3609a))
* **docz-example-flow:** scale and outline props ([#211](https://github.com/pedronauck/docz/issues/211)) ([c8a4195](https://github.com/pedronauck/docz/commit/c8a4195))




<a name="0.10.0"></a>
# [0.10.0](https://github.com/pedronauck/docz/compare/v0.9.6...v0.10.0) (2018-08-13)


### Bug Fixes

* bug template typo ([#197](https://github.com/pedronauck/docz/issues/197)) ([497fcfb](https://github.com/pedronauck/docz/commit/497fcfb))
* bug template typo ([#197](https://github.com/pedronauck/docz/issues/197)) ([fce98c4](https://github.com/pedronauck/docz/commit/fce98c4))
* **docz:** add initial loading as true ([3f05536](https://github.com/pedronauck/docz/commit/3f05536))
* **docz-core:** prevent crash on delete entry ([28e1728](https://github.com/pedronauck/docz/commit/28e1728))
* **docz-core:** prevent delete entire app folder on build ([e345896](https://github.com/pedronauck/docz/commit/e345896))
* **docz-theme-default:** playground overflow on mobile ([db1eb5b](https://github.com/pedronauck/docz/commit/db1eb5b))
* **rehype-docz:** add props on playground scope ([ee4b6c0](https://github.com/pedronauck/docz/commit/ee4b6c0))
* **rehype-docz:** allow ticks and backticks inside playground ([#203](https://github.com/pedronauck/docz/issues/203)) ([fa4ff40](https://github.com/pedronauck/docz/commit/fa4ff40))


### Features

* **docz:** fetch data on documents ([04ff0d6](https://github.com/pedronauck/docz/commit/04ff0d6))
* **docz-core:** add cache system for entries ([b90e598](https://github.com/pedronauck/docz/commit/b90e598))
* **docz-core:** add htmlContext and mini-html-webpack-plugin ([4b6ec0f](https://github.com/pedronauck/docz/commit/4b6ec0f))
* **docz-core:** resolve markdown files by default ([#210](https://github.com/pedronauck/docz/issues/210)) ([e0a95b3](https://github.com/pedronauck/docz/commit/e0a95b3))
* add github repository link ([78a19f6](https://github.com/pedronauck/docz/commit/78a19f6))
* allow edit code inside playground ([#205](https://github.com/pedronauck/docz/issues/205)) ([4f948f7](https://github.com/pedronauck/docz/commit/4f948f7))




<a name="0.9.6"></a>
## [0.9.6](https://github.com/pedronauck/docz/compare/v0.9.5...v0.9.6) (2018-08-06)


### Bug Fixes

* **docz-core:** remove [@babel](https://github.com/babel)/runtime alias ([0dbd8f0](https://github.com/pedronauck/docz/commit/0dbd8f0))
* **docz-theme-default:** using lodash.get to prevent classname crash ([befc643](https://github.com/pedronauck/docz/commit/befc643))




<a name="0.9.5"></a>
## [0.9.5](https://github.com/pedronauck/docz/compare/v0.9.4...v0.9.5) (2018-08-04)


### Bug Fixes

* **docz-theme-default:** copy html output ([#189](https://github.com/pedronauck/docz/issues/189)) ([2cb834c](https://github.com/pedronauck/docz/commit/2cb834c))




<a name="0.9.4"></a>
## [0.9.4](https://github.com/pedronauck/docz/compare/v0.9.4-beta.1...v0.9.4) (2018-08-04)


### Bug Fixes

* **docz-core:** use of src config in edit button link ([#186](https://github.com/pedronauck/docz/issues/186)) ([553f90c](https://github.com/pedronauck/docz/commit/553f90c))
* remove external deps ([470bdd3](https://github.com/pedronauck/docz/commit/470bdd3))




<a name="0.9.3"></a>
## [0.9.3](https://github.com/pedronauck/docz/compare/v0.9.2...v0.9.3) (2018-08-03)


### Bug Fixes

* **docz-core:** use of src config in edit button link ([#186](https://github.com/pedronauck/docz/issues/186)) ([553f90c](https://github.com/pedronauck/docz/commit/553f90c))




<a name="0.9.2"></a>
## [0.9.2](https://github.com/pedronauck/docz/compare/v0.9.1...v0.9.2) (2018-08-02)


### Bug Fixes

* **docz-core:** add isProd to remove hot client overlay on build ([83f2e36](https://github.com/pedronauck/docz/commit/83f2e36))




<a name="0.9.1"></a>
## [0.9.1](https://github.com/pedronauck/docz/compare/v0.9.0...v0.9.1) (2018-08-02)


### Bug Fixes

* **docz:** finish process after build ([58bebb6](https://github.com/pedronauck/docz/commit/58bebb6))




<a name="0.9.0"></a>
# [0.9.0](https://github.com/pedronauck/docz/compare/v0.9.0-beta.1...v0.9.0) (2018-08-02)


### Bug Fixes

* **docz:** transform and merge theme config ([999ab73](https://github.com/pedronauck/docz/commit/999ab73))
* **docz:** using context for imports to prevent disposed hmr ([b37284c](https://github.com/pedronauck/docz/commit/b37284c))
* **docz-plugin-babel6:** change babel syntax dynamic import when needed ([8cb278a](https://github.com/pedronauck/docz/commit/8cb278a))
* **docz-plugin-css:** pass default parameter ([389979a](https://github.com/pedronauck/docz/commit/389979a))
* **docz-theme-default:** support chinese input method ([#182](https://github.com/pedronauck/docz/issues/182)) ([94544a6](https://github.com/pedronauck/docz/commit/94544a6))
* **docz-theme-default:** table layout adjustment ([e8e8ec8](https://github.com/pedronauck/docz/commit/e8e8ec8))
* **docz-theme-default:** use docz link when href is internal ([00deef5](https://github.com/pedronauck/docz/commit/00deef5))




<a name="0.9.0-beta.1"></a>
# [0.9.0-beta.1](https://github.com/pedronauck/docz/compare/v0.9.0-beta.0...v0.9.0-beta.1) (2018-08-01)




**Note:** Version bump only for package undefined

<a name="0.9.0-beta.0"></a>
# [0.9.0-beta.0](https://github.com/pedronauck/docz/compare/v0.8.0...v0.9.0-beta.0) (2018-08-01)


### Bug Fixes

* **docz:** add playground wrapper just around children ([66abfe8](https://github.com/pedronauck/docz/commit/66abfe8))
* **docz-core:** remove babel plugin/presets when needed ([011baad](https://github.com/pedronauck/docz/commit/011baad))
* **docz-theme-default:** hot reload on fullscreen mode ([1c68e2d](https://github.com/pedronauck/docz/commit/1c68e2d))
* **docz-theme-default:** not found typo ([#173](https://github.com/pedronauck/docz/issues/173)) ([8c9f74e](https://github.com/pedronauck/docz/commit/8c9f74e))
* **docz-theme-default:** resolve emotion theming conflict ([659cd79](https://github.com/pedronauck/docz/commit/659cd79))


### Features

* **docz-core:** add webpack-serve-overlay as error overlay ([263badf](https://github.com/pedronauck/docz/commit/263badf))
* **docz-core:** support env files to set configuration ([#171](https://github.com/pedronauck/docz/issues/171)) ([259b72d](https://github.com/pedronauck/docz/commit/259b72d)), closes [#140](https://github.com/pedronauck/docz/issues/140)
* **docz-plugin-svgr:** add initial version of plugin ([1ac1ea8](https://github.com/pedronauck/docz/commit/1ac1ea8))
* **docz-theme-default:** add edit button for document ([#180](https://github.com/pedronauck/docz/issues/180)) ([e125a4f](https://github.com/pedronauck/docz/commit/e125a4f))




<a name="0.8.0"></a>
# [0.8.0](https://github.com/pedronauck/docz/compare/v0.7.1...v0.8.0) (2018-07-28)


### Bug Fixes

* change link on readme ([#168](https://github.com/pedronauck/docz/issues/168)) ([30a9390](https://github.com/pedronauck/docz/commit/30a9390))
* **docz:** humanize array type of flow (fix [#167](https://github.com/pedronauck/docz/issues/167)) ([18798bc](https://github.com/pedronauck/docz/commit/18798bc))
* **docz-theme-default:** get fullscreen from localstorage ([0f8aa56](https://github.com/pedronauck/docz/commit/0f8aa56))


### Features

* **docz-theme-default:** add html output on playground ([be7a749](https://github.com/pedronauck/docz/commit/be7a749))




<a name="0.7.1"></a>
## [0.7.1](https://github.com/pedronauck/docz/compare/v0.7.0...v0.7.1) (2018-07-24)


### Bug Fixes

* **docz:** add wrapper prop on Playground ([566aaf8](https://github.com/pedronauck/docz/commit/566aaf8))
* **docz:** sort algorithm off docs and menus ([dad83ce](https://github.com/pedronauck/docz/commit/dad83ce))
* **docz-plugin-css:** allow css from node_modules ([c21929a](https://github.com/pedronauck/docz/commit/c21929a))




<a name="0.7.0"></a>
# [0.7.0](https://github.com/pedronauck/docz/compare/v0.6.2...v0.7.0) (2018-07-23)


### Bug Fixes

* **docz:** humanize prop types on PropTable ([c1f4c6f](https://github.com/pedronauck/docz/commit/c1f4c6f))
* **docz-plugin-css:** css modules applied logic ([c5fa378](https://github.com/pedronauck/docz/commit/c5fa378))
* **docz-theme-default:** not found page ([fb1ac49](https://github.com/pedronauck/docz/commit/fb1ac49))
* **docz-theme-default:** resize bar style ([df0ae82](https://github.com/pedronauck/docz/commit/df0ae82))


### Features

* **docz:** add rawCode for Playground ([70d4735](https://github.com/pedronauck/docz/commit/70d4735))
* **docz-theme-default:** add close on esc on playground fullscreen ([4ebf202](https://github.com/pedronauck/docz/commit/4ebf202))
* **docz-theme-default:** add copy to clipboard on pre ([78149ad](https://github.com/pedronauck/docz/commit/78149ad))
* **docz-theme-default:** add fullpage support for docs ([af88d0e](https://github.com/pedronauck/docz/commit/af88d0e))
* **docz-theme-default:** add line numbers on Playground ([204f1bb](https://github.com/pedronauck/docz/commit/204f1bb))
* **docz-theme-default:** add resize bar for fullscreen playground ([392009f](https://github.com/pedronauck/docz/commit/392009f))
* **docz-theme-default:** add responsive mode for playground ([e04452e](https://github.com/pedronauck/docz/commit/e04452e))




<a name="0.6.2"></a>
## [0.6.2](https://github.com/pedronauck/docz/compare/v0.6.1...v0.6.2) (2018-07-20)


### Bug Fixes

* **docz-core:** set env vars for commands ([29f0098](https://github.com/pedronauck/docz/commit/29f0098))




<a name="0.6.1"></a>
## [0.6.1](https://github.com/pedronauck/docz/compare/v0.6.0...v0.6.1) (2018-07-19)


### Bug Fixes

* **docz:** default DocPreview components ([ff7cf32](https://github.com/pedronauck/docz/commit/ff7cf32))
* **docz-theme-default:** add background and color on NotFound ([f0bd532](https://github.com/pedronauck/docz/commit/f0bd532))




<a name="0.6.0"></a>
# [0.6.0](https://github.com/pedronauck/docz/compare/v0.5.9...v0.6.0) (2018-07-19)


### Bug Fixes

* **docz:** prevent default components object with no render ([4535aef](https://github.com/pedronauck/docz/commit/4535aef))
* **docz-core:** add error when dest is working directory ([b1c87b5](https://github.com/pedronauck/docz/commit/b1c87b5))
* **docz-core:** process.env vars for scripts ([f6b6260](https://github.com/pedronauck/docz/commit/f6b6260))
* **docz-core:** serve static files from public ([c866856](https://github.com/pedronauck/docz/commit/c866856))
* **docz-theme-default:** open menu if has some link active ([8399aad](https://github.com/pedronauck/docz/commit/8399aad))


### Features

* **docz-core:** add onCreateApp plugin method ([13c07e7](https://github.com/pedronauck/docz/commit/13c07e7))




<a name="0.5.9"></a>
## [0.5.9](https://github.com/pedronauck/docz/compare/v0.5.8...v0.5.9) (2018-07-16)


### Bug Fixes

* **docz-theme-default:** add overflow config on Pre component ([#146](https://github.com/pedronauck/docz/issues/146)) ([9d4ce59](https://github.com/pedronauck/docz/commit/9d4ce59))




<a name="0.5.8"></a>
## [0.5.8](https://github.com/pedronauck/docz/compare/v0.5.7...v0.5.8) (2018-07-11)


### Bug Fixes

* **docz-theme-default:** config transform function ([fdb3118](https://github.com/pedronauck/docz/commit/fdb3118))




<a name="0.5.7"></a>
## [0.5.7](https://github.com/pedronauck/docz/compare/v0.5.6...v0.5.7) (2018-07-11)


### Bug Fixes

* **docz-plugin-babel6:** props parsing when typescript is enable ([0564bdf](https://github.com/pedronauck/docz/commit/0564bdf))




<a name="0.5.6"></a>
## [0.5.6](https://github.com/pedronauck/docz/compare/v0.5.5...v0.5.6) (2018-07-11)


### Bug Fixes

* **docz:** add theme config transform before merge ([dc3448a](https://github.com/pedronauck/docz/commit/dc3448a))
* **docz-theme-default:** sidebar search ([8fd77ec](https://github.com/pedronauck/docz/commit/8fd77ec))


### Features

* **docz:** add classname and style props for Playground ([1b64ed3](https://github.com/pedronauck/docz/commit/1b64ed3))
* **docz-core:** add webpack-serve-waitpage ([83c493b](https://github.com/pedronauck/docz/commit/83c493b))




<a name="0.5.5"></a>
## [0.5.5](https://github.com/pedronauck/docz/compare/v0.5.4...v0.5.5) (2018-07-07)


### Bug Fixes

* **docz-core:** add ordering to initial config data object ([2926ade](https://github.com/pedronauck/docz/commit/2926ade))
* **docz-theme-default:** padding on sidebar footer ([df25fa1](https://github.com/pedronauck/docz/commit/df25fa1))




<a name="0.5.4"></a>
## [0.5.4](https://github.com/pedronauck/docz/compare/v0.5.3...v0.5.4) (2018-07-07)




**Note:** Version bump only for package undefined

<a name="0.5.3"></a>
## [0.5.3](https://github.com/pedronauck/docz/compare/v0.5.2...v0.5.3) (2018-07-05)


### Bug Fixes

* **docz-theme-default:** link isActive logic ([205ea8d](https://github.com/pedronauck/docz/commit/205ea8d))




<a name="0.5.2"></a>
## [0.5.2](https://github.com/pedronauck/docz/compare/v0.5.1...v0.5.2) (2018-07-05)


### Bug Fixes

* props table css class ([#116](https://github.com/pedronauck/docz/issues/116)) ([065473c](https://github.com/pedronauck/docz/commit/065473c))
* **docz-core:** remove unnescessary Entry.check ([1871db8](https://github.com/pedronauck/docz/commit/1871db8))




<a name="0.5.1"></a>
## [0.5.1](https://github.com/pedronauck/docz/compare/v0.3.4...v0.5.1) (2018-07-03)


### Bug Fixes

* broken links to examples ([#101](https://github.com/pedronauck/docz/issues/101)) ([26458f2](https://github.com/pedronauck/docz/commit/26458f2))
* **docz-core:** add a fallback name on Entry ([ec38139](https://github.com/pedronauck/docz/commit/ec38139))
* **docz-core:** app running port message ([4aec595](https://github.com/pedronauck/docz/commit/4aec595))
* CHANGELOG.md ([8be3724](https://github.com/pedronauck/docz/commit/8be3724))
* **docz-core:** check name on package json ([6cdbebc](https://github.com/pedronauck/docz/commit/6cdbebc))
* **docz-theme-default:** add overflow auto to nav ([4cdbcfd](https://github.com/pedronauck/docz/commit/4cdbcfd))


### Features

* **docz-core:** add ordering property for config ([efd215e](https://github.com/pedronauck/docz/commit/efd215e))
* **docz-core:** read name from package.json to populate initial title ([1eeb049](https://github.com/pedronauck/docz/commit/1eeb049))
* **docz-theme-default:** add automatic table of content ([#106](https://github.com/pedronauck/docz/issues/106)) ([6ce9e84](https://github.com/pedronauck/docz/commit/6ce9e84))
* **docz-theme-default:** add sidebar search ([7886e75](https://github.com/pedronauck/docz/commit/7886e75))




<a name="0.5.0"></a>
# [0.5.0](https://github.com/pedronauck/docz/compare/v0.3.4...v0.5.0) (2018-07-03)


### Bug Fixes
* **docz-core:** app running port message ([1b94114](https://github.com/pedronauck/docz/commit/1b94114))


### Features

* **docz-core:** add ordering property for config ([a6c307d](https://github.com/pedronauck/docz/commit/a6c307d))
* **docz-core:** read name from package.json to populate initial title ([4f10a6d](https://github.com/pedronauck/docz/commit/4f10a6d))
* **docz-theme-default:** add automatic table of content ([#106](https://github.com/pedronauck/docz/issues/106)) ([6ce9e84](https://github.com/pedronauck/docz/commit/6ce9e84))
* **docz-theme-default:** add sidebar search ([8218dc1](https://github.com/pedronauck/docz/commit/8218dc1))




<a name="0.4.0"></a>
# [0.4.0](https://github.com/pedronauck/docz/compare/v0.3.4...v0.4.0) (2018-06-30)


### Bug Fixes

* broken links to examples ([#101](https://github.com/pedronauck/docz/issues/101)) ([26458f2](https://github.com/pedronauck/docz/commit/26458f2))
* **docz-core:** add a fallback name on Entry ([ec38139](https://github.com/pedronauck/docz/commit/ec38139))
* **docz-theme-default:** add overflow auto to nav ([4cdbcfd](https://github.com/pedronauck/docz/commit/4cdbcfd))


### Features

* **docz-theme-default:** add automatic table of content ([#106](https://github.com/pedronauck/docz/issues/106)) ([6ce9e84](https://github.com/pedronauck/docz/commit/6ce9e84))




<a name="0.3.4"></a>
## [0.3.4](https://github.com/pedronauck/docz/compare/v0.3.3...v0.3.4) (2018-06-26)


### Bug Fixes

* remove color transparent on body ([#93](https://github.com/pedronauck/docz/issues/93)) ([a1942ef](https://github.com/pedronauck/docz/commit/a1942ef))
* unclosed tag in README.md ([#89](https://github.com/pedronauck/docz/issues/89)) ([0552351](https://github.com/pedronauck/docz/commit/0552351))



<a name="0.3.0"></a>
# [0.3.0](https://github.com/pedronauck/docz/compare/v0.3.0-beta.0...v0.3.0) (2018-06-25)


### Bug Fixes

* **docz-theme-default:** prettier format ([cb5643d](https://github.com/pedronauck/docz/commit/cb5643d))



<a name="0.3.0-beta.0"></a>
# [0.3.0-beta.0](https://github.com/pedronauck/docz/compare/v0.2.11...v0.3.0-beta.0) (2018-06-25)


### Bug Fixes

* **docz-theme-default:** change background based on toggle ([2241f8b](https://github.com/pedronauck/docz/commit/2241f8b))
* **docz-theme-default:** change chevronDown to burguer icon with animation ([8649938](https://github.com/pedronauck/docz/commit/8649938))
* **docz-theme-default:** include breakpoints as const ([43490bb](https://github.com/pedronauck/docz/commit/43490bb))
* **docz-theme-default:** lint code ([7c97a41](https://github.com/pedronauck/docz/commit/7c97a41))
* **docz-theme-default:** made container responsive ([ddf078d](https://github.com/pedronauck/docz/commit/ddf078d))
* **docz-theme-default:** responsive position for wrapper ([bb56449](https://github.com/pedronauck/docz/commit/bb56449))
* **docz-theme-default:** sidebar toggle for links and sub-links ([9cd6321](https://github.com/pedronauck/docz/commit/9cd6321))


### Features

* **docz-theme-default:** add dark mode 🌚 ([#81](https://github.com/pedronauck/docz/issues/81)) ([964cf4d](https://github.com/pedronauck/docz/commit/964cf4d))
* **docz-theme-default:** include breakpoints reactive on sidebar ([d3911b4](https://github.com/pedronauck/docz/commit/d3911b4))
* **docz-theme-default:** include media queries facepaint ([5f78734](https://github.com/pedronauck/docz/commit/5f78734))
* **docz-theme-default:** include toggle to sidebar ([a94e517](https://github.com/pedronauck/docz/commit/a94e517))
* **docz-theme-default:** include ToggleBackground ([cac7ecd](https://github.com/pedronauck/docz/commit/cac7ecd))
* **docz-theme-default:** table responsive ([0580a77](https://github.com/pedronauck/docz/commit/0580a77))




<a name="0.3.3"></a>
## [0.3.3](https://github.com/pedronauck/docz/compare/v0.3.2...v0.3.3) (2018-06-26)


### Bug Fixes

* **docz-core:** copy templates files for dist ([#88](https://github.com/pedronauck/docz/issues/88)) ([5e4b98d](https://github.com/pedronauck/docz/commit/5e4b98d))




<a name="0.3.2"></a>
## [0.3.2](https://github.com/pedronauck/docz/compare/v0.3.1...v0.3.2) (2018-06-25)


### Bug Fixes

* **docz:** mdxtag import ([4ed20bf](https://github.com/pedronauck/docz/commit/4ed20bf))




<a name="0.3.1"></a>
## [0.3.1](https://github.com/pedronauck/docz/compare/v0.2.11...v0.3.1) (2018-06-25)


### Bug Fixes

* **docz:** mdx provider import ([ded8cbb](https://github.com/pedronauck/docz/commit/ded8cbb))
* use docz-theme-default as docz-core dependency ([1a2fb67](https://github.com/pedronauck/docz/commit/1a2fb67))


### Features

* **docz-default-theme:** dark mode and responsiveness ([#87](https://github.com/pedronauck/docz/issues/87)) ([a4db115](https://github.com/pedronauck/docz/commit/a4db115)), closes [#81](https://github.com/pedronauck/docz/issues/81)




<a name="0.3.0"></a>
# [0.3.0](https://github.com/pedronauck/docz/compare/v0.3.0-beta.0...v0.3.0) (2018-06-25)


### Bug Fixes

* **docz-theme-default:** prettier format ([cb5643d](https://github.com/pedronauck/docz/commit/cb5643d))




<a name="0.3.0-beta.0"></a>
# [0.3.0-beta.0](https://github.com/pedronauck/docz/compare/v0.2.11...v0.3.0-beta.0) (2018-06-25)


### Bug Fixes

* **docz-theme-default:** change background based on toggle ([2241f8b](https://github.com/pedronauck/docz/commit/2241f8b))
* **docz-theme-default:** change chevronDown to burguer icon with animation ([8649938](https://github.com/pedronauck/docz/commit/8649938))
* **docz-theme-default:** include breakpoints as const ([43490bb](https://github.com/pedronauck/docz/commit/43490bb))
* **docz-theme-default:** lint code ([7c97a41](https://github.com/pedronauck/docz/commit/7c97a41))
* **docz-theme-default:** made container responsive ([ddf078d](https://github.com/pedronauck/docz/commit/ddf078d))
* **docz-theme-default:** responsive position for wrapper ([bb56449](https://github.com/pedronauck/docz/commit/bb56449))
* **docz-theme-default:** sidebar toggle for links and sub-links ([9cd6321](https://github.com/pedronauck/docz/commit/9cd6321))


### Features

* **docz-theme-default:** add dark mode 🌚 ([#81](https://github.com/pedronauck/docz/issues/81)) ([964cf4d](https://github.com/pedronauck/docz/commit/964cf4d))
* **docz-theme-default:** include breakpoints reactive on sidebar ([d3911b4](https://github.com/pedronauck/docz/commit/d3911b4))
* **docz-theme-default:** include media queries facepaint ([5f78734](https://github.com/pedronauck/docz/commit/5f78734))
* **docz-theme-default:** include toggle to sidebar ([a94e517](https://github.com/pedronauck/docz/commit/a94e517))
* **docz-theme-default:** include ToggleBackground ([cac7ecd](https://github.com/pedronauck/docz/commit/cac7ecd))
* **docz-theme-default:** table responsive ([0580a77](https://github.com/pedronauck/docz/commit/0580a77))




<a name="0.2.11"></a>
## [0.2.11](https://github.com/pedronauck/docz/compare/v0.2.10...v0.2.11) (2018-06-22)


### Bug Fixes

* **docz-core:** node env for production ([615aa1f](https://github.com/pedronauck/docz/commit/615aa1f))
* **docz-plugin-css:** production build ([1a66d8a](https://github.com/pedronauck/docz/commit/1a66d8a))
* **docz-theme-default:** use webfontloader instead of css import ([5973969](https://github.com/pedronauck/docz/commit/5973969))
* some changes on css examples ([058660f](https://github.com/pedronauck/docz/commit/058660f))




<a name="0.2.10"></a>
## [0.2.10](https://github.com/pedronauck/docz/compare/v0.2.9...v0.2.10) (2018-06-21)


### Features

* **docz-plugin-css:** add initial version ([#78](https://github.com/pedronauck/docz/issues/78)) ([299372e](https://github.com/pedronauck/docz/commit/299372e))




<a name="0.2.9"></a>
## [0.2.9](https://github.com/pedronauck/docz/compare/v0.2.8...v0.2.9) (2018-06-21)




**Note:** Version bump only for package undefined

<a name="0.2.8"></a>
## [0.2.8](https://github.com/pedronauck/docz/compare/v0.2.7...v0.2.8) (2018-06-21)


### Bug Fixes

* **docz-core:** typescript resolve extensions ([689b057](https://github.com/pedronauck/docz/commit/689b057))




<a name="0.2.7"></a>
## [0.2.7](https://github.com/pedronauck/docz/compare/v0.2.6...v0.2.7) (2018-06-20)


### Bug Fixes

* **docz:** typo ([#63](https://github.com/pedronauck/docz/issues/63)) ([6af5db2](https://github.com/pedronauck/docz/commit/6af5db2))
* **docz-plugin-babel6:** documentation for babel plugin ([#60](https://github.com/pedronauck/docz/issues/60)) ([8a14e2a](https://github.com/pedronauck/docz/commit/8a14e2a))
* **docz-plugin-babel6:** readme typo ([b77e986](https://github.com/pedronauck/docz/commit/b77e986))
* **docz-plugin-babel6:** typo ([d2f92b7](https://github.com/pedronauck/docz/commit/d2f92b7))
* **docz-theme-default:** improve spacing on jsx attributes ([#54](https://github.com/pedronauck/docz/issues/54)) ([49fe0b8](https://github.com/pedronauck/docz/commit/49fe0b8))




<a name="0.2.6"></a>
## [0.2.6](https://github.com/pedronauck/docz/compare/v0.2.5...v0.2.6) (2018-06-17)


### Bug Fixes

* **docz-core:** change filepath entry for windows ([#31](https://github.com/pedronauck/docz/issues/31)) ([14bf0e2](https://github.com/pedronauck/docz/commit/14bf0e2))


### Features

* **docz-example-babel6:** add package ([92ead5a](https://github.com/pedronauck/docz/commit/92ead5a))
* **docz-plugin-babel6:** add package ([68e364a](https://github.com/pedronauck/docz/commit/68e364a))




<a name="0.2.5"></a>
## [0.2.5](https://github.com/pedronauck/docz/compare/v0.2.4...v0.2.5) (2018-06-15)


### Bug Fixes

* **docz:** add extractTypeDescribedValue to PropsTable ([#38](https://github.com/pedronauck/docz/issues/38)) ([cca862c](https://github.com/pedronauck/docz/commit/cca862c))
* **docz:** PropsTable component ([48638cc](https://github.com/pedronauck/docz/commit/48638cc))




<a name="0.2.4"></a>
## [0.2.4](https://github.com/pedronauck/docz/compare/v0.2.3...v0.2.4) (2018-06-13)




**Note:** Version bump only for package undefined

<a name="0.2.3"></a>
## [0.2.3](https://github.com/pedronauck/docz/compare/v0.2.2...v0.2.3) (2018-06-13)


### Bug Fixes

* **docz-core:** change config hosts to support windows os ([9e3c4f6](https://github.com/pedronauck/docz/commit/9e3c4f6))
* readme typo ([a13dc3c](https://github.com/pedronauck/docz/commit/a13dc3c))




<a name="0.2.2"></a>
## [0.2.2](https://github.com/pedronauck/docz/compare/v0.2.1...v0.2.2) (2018-06-12)




**Note:** Version bump only for package undefined

<a name="0.2.1"></a>
## [0.2.1](https://github.com/pedronauck/docz/compare/v0.2.0...v0.2.1) (2018-06-12)


### Bug Fixes

* corrections on readme [#2](https://github.com/pedronauck/docz/issues/2) ([bd1b7a6](https://github.com/pedronauck/docz/commit/bd1b7a6))
* playground component destructuring bug ([#4](https://github.com/pedronauck/docz/issues/4)) ([f9026cf](https://github.com/pedronauck/docz/commit/f9026cf))
* readme typos ([16662eb](https://github.com/pedronauck/docz/commit/16662eb))




<a name="0.2.0"></a>
# [0.2.0](https://github.com/pedronauck/docz/compare/v0.2.0-beta.2...v0.2.0) (2018-06-11)


### Bug Fixes

* readme image ([470b235](https://github.com/pedronauck/docz/commit/470b235))
* readme links ([61de7cd](https://github.com/pedronauck/docz/commit/61de7cd))
* readme links ([f7b1120](https://github.com/pedronauck/docz/commit/f7b1120))




<a name="0.2.0-beta.2"></a>
# [0.2.0-beta.2](https://github.com/doczjs/docz/compare/v0.2.0-beta.1...v0.2.0-beta.2) (2018-06-10)


### Bug Fixes

* **docz-core:** autolink headings ([0b8369d](https://github.com/doczjs/docz/commit/0b8369d))




<a name="0.2.0-beta.1"></a>
# [0.2.0-beta.1](https://github.com/doczjs/docz/compare/v0.2.0-beta.0...v0.2.0-beta.1) (2018-06-10)


### Features

* **docz-core:** add headings property for entries and autolink on headings ([7711c3c](https://github.com/doczjs/docz/commit/7711c3c))




<a name="0.2.0-beta.0"></a>
# [0.2.0-beta.0](https://github.com/doczjs/docz/compare/v0.1.2-beta.6...v0.2.0-beta.0) (2018-06-10)


### Features

* **docz-core:** add indexHtml property on project configuration ([6bb5167](https://github.com/doczjs/docz/commit/6bb5167))




<a name="0.1.2-beta.6"></a>
## [0.1.2-beta.6](https://github.com/doczjs/docz/compare/v0.1.2-beta.5...v0.1.2-beta.6) (2018-06-09)


### Bug Fixes

* **docz:** typing definition ([1a3648e](https://github.com/doczjs/docz/commit/1a3648e))




<a name="0.1.2-beta.5"></a>
## [0.1.2-beta.5](https://github.com/doczjs/docz/compare/v0.1.2-beta.4...v0.1.2-beta.5) (2018-06-09)


### Bug Fixes

* **docz-core:** build when base prop ([6001171](https://github.com/doczjs/docz/commit/6001171))
* **docz-theme-default:** loading component height ([b198075](https://github.com/doczjs/docz/commit/b198075))




<a name="0.1.2-beta.4"></a>
## [0.1.2-beta.4](https://github.com/doczjs/docz/compare/v0.1.2-beta.3...v0.1.2-beta.4) (2018-06-09)




**Note:** Version bump only for package undefined

<a name="0.1.2-beta.3"></a>
## [0.1.2-beta.3](https://github.com/doczjs/docz/compare/v0.1.2-beta.2...v0.1.2-beta.3) (2018-06-09)




**Note:** Version bump only for package undefined

<a name="0.1.2-beta.2"></a>
## [0.1.2-beta.2](https://github.com/doczjs/docz/compare/v0.1.2-beta.1...v0.1.2-beta.2) (2018-06-09)


### Features

* **docz:** add support for custom not found route ([455dcca](https://github.com/doczjs/docz/commit/455dcca))
* **docz-theme-default:** add custom not found component ([1773fe1](https://github.com/doczjs/docz/commit/1773fe1))




<a name="0.1.2-beta.1"></a>
## [0.1.2-beta.1](https://github.com/doczjs/docz/compare/v0.1.2-beta.0...v0.1.2-beta.1) (2018-06-09)


### Bug Fixes

* **docz-theme-default:** emotion typings ([270e38c](https://github.com/doczjs/docz/commit/270e38c))


### Features

* **docz:** add loading component setting for loadable ([4352ce3](https://github.com/doczjs/docz/commit/4352ce3))
* **docz-core:** add base config argument ([20f29c2](https://github.com/doczjs/docz/commit/20f29c2))
* **docz-core:** add dest config property ([d6c5506](https://github.com/doczjs/docz/commit/d6c5506))
* **docz-core:** add modifyBundlerConfig configuration property ([ec04bee](https://github.com/doczjs/docz/commit/ec04bee))
* **docz-core:** use html template as component ([b7a2dc0](https://github.com/doczjs/docz/commit/b7a2dc0))
* **docz-theme-default:** add Loading component for DocPreview ([97859e2](https://github.com/doczjs/docz/commit/97859e2))




<a name="0.1.2-beta.0"></a>
## [0.1.2-beta.0](https://github.com/doczjs/docz/compare/v0.1.1...v0.1.2-beta.0) (2018-06-02)




**Note:** Version bump only for package undefined

<a name="0.1.1-beta.6"></a>
## [0.1.1-beta.6](https://github.com/doczjs/docz/compare/v0.1.1-beta.5...v0.1.1-beta.6) (2018-06-01)


### Bug Fixes

* **docz:** add docz-theme-default as dependecy ([0dff6c0](https://github.com/doczjs/docz/commit/0dff6c0))




<a name="0.1.1-beta.5"></a>
## [0.1.1-beta.5](https://github.com/doczjs/docz/compare/v0.1.1-beta.4...v0.1.1-beta.5) (2018-06-01)


### Bug Fixes

* **docz:** link component ([7626982](https://github.com/doczjs/docz/commit/7626982))
* **load-cfg:** add namedExports options ([d36194d](https://github.com/doczjs/docz/commit/d36194d))


### Features

* **load-cfg:** add esm module loader ([12a7610](https://github.com/doczjs/docz/commit/12a7610))




<a name="0.1.1-beta.4"></a>
## [0.1.1-beta.4](https://github.com/doczjs/docz/compare/v0.1.1-beta.3...v0.1.1-beta.4) (2018-05-29)


### Bug Fixes

* **docz:** add isActive to Link components ([9cecc08](https://github.com/doczjs/docz/commit/9cecc08))
* **docz-core:** module rule test for typescript ([bdeffc1](https://github.com/doczjs/docz/commit/bdeffc1))




<a name="0.1.1-beta.3"></a>
## [0.1.1-beta.3](https://github.com/doczjs/docz/compare/v0.1.1-beta.2...v0.1.1-beta.3) (2018-05-29)




**Note:** Version bump only for package undefined

<a name="0.1.1-beta.2"></a>
## [0.1.1-beta.2](https://github.com/doczjs/docz/compare/v0.1.1-beta.0...v0.1.1-beta.2) (2018-05-29)


### Bug Fixes

* **docz:** set docz-core as dependency ([6c257e8](https://github.com/doczjs/docz/commit/6c257e8))




<a name="0.1.1-beta.1"></a>
## [0.1.1-beta.1](https://github.com/doczjs/docz/compare/v0.1.1-beta.0...v0.1.1-beta.1) (2018-05-29)




**Note:** Version bump only for package undefined

<a name="0.1.1-beta.0"></a>
## [0.1.1-beta.0](https://github.com/doczjs/docz/compare/v0.1.0...v0.1.1-beta.0) (2018-05-29)


### Bug Fixes

* **docz:** add bin folder for npm publish ([f463a98](https://github.com/doczjs/docz/commit/f463a98))




<a name="0.1.0"></a>
# 0.1.0 (2018-05-29)


### Bug Fixes

* **docz:**  Docs render props orders and types ([d7e9ee2](https://github.com/doczjs/docz/commit/d7e9ee2))
* **docz:** docs categories for themes ([687720c](https://github.com/doczjs/docz/commit/687720c))
* **docz:** flow props parser integration ([5a83610](https://github.com/doczjs/docz/commit/5a83610))
* **docz:** validate route passed for docs.route() ([48a0484](https://github.com/doczjs/docz/commit/48a0484))
* **docz-core:** async plugin ([ddfbcf1](https://github.com/doczjs/docz/commit/ddfbcf1))
* **docz-core:** check if found name exist when parse entry ([f75881e](https://github.com/doczjs/docz/commit/f75881e))
* **docz-core:** config watch for directory operations ([43fa7ab](https://github.com/doczjs/docz/commit/43fa7ab))
* **docz-core:** create plugin to fix paragraph parse on mdx ([42b4f05](https://github.com/doczjs/docz/commit/42b4f05))
* **docz-core:** data server class ([12c0558](https://github.com/doczjs/docz/commit/12c0558))
* **docz-core:** don't exit when catch prettier ([5423d96](https://github.com/doczjs/docz/commit/5423d96))
* **docz-core:** entries filepath ([e45fea0](https://github.com/doczjs/docz/commit/e45fea0))
* webpack errors message ([90f6064](https://github.com/doczjs/docz/commit/90f6064))
* **docz-core:** entries rewrite ([986ba65](https://github.com/doczjs/docz/commit/986ba65))
* **docz-core:** entries updates ([7147ac1](https://github.com/doczjs/docz/commit/7147ac1))
* **docz-core:** packages splitting ([d2e74ee](https://github.com/doczjs/docz/commit/d2e74ee))
* **docz-core:** templates files ([a5cda97](https://github.com/doczjs/docz/commit/a5cda97))
* **docz-core:** throw error when parse ast ([05138bf](https://github.com/doczjs/docz/commit/05138bf))
* **docz-example-basic:** package name ([dec5713](https://github.com/doczjs/docz/commit/dec5713))


### Features

* **docz-core:** add title and description on settings ([ad9ee58](https://github.com/doczjs/docz/commit/ad9ee58))
* add basic monorepo structure ([5a977ed](https://github.com/doczjs/docz/commit/5a977ed))
* **docz:** add a mvp version of project ([05ac064](https://github.com/doczjs/docz/commit/05ac064))
* **docz:** add components parser ([a4127d9](https://github.com/doczjs/docz/commit/a4127d9))
* **docz:** add custom routes for docs ([8458d91](https://github.com/doczjs/docz/commit/8458d91))
* **docz:** add doc page wrapper as component ([1150373](https://github.com/doczjs/docz/commit/1150373))
* **docz:** add groups feature ([9652b30](https://github.com/doczjs/docz/commit/9652b30))
* **docz:** add module declarations for typescript ([ae597af](https://github.com/doczjs/docz/commit/ae597af))
* **docz:** add routes from parsed entries ([fc37f73](https://github.com/doczjs/docz/commit/fc37f73))
* **docz:** add some improvements for default package ([51188d4](https://github.com/doczjs/docz/commit/51188d4))
* **docz:** make server bundler api concise ([ae5f0c0](https://github.com/doczjs/docz/commit/ae5f0c0))
* **docz:** some refactors ([7f6660c](https://github.com/doczjs/docz/commit/7f6660c))
* **docz:** use webpack 4 instead of parcel ([1e5742c](https://github.com/doczjs/docz/commit/1e5742c))
* **docz-bundler-webpack:** add bundler as package ([d7be8a9](https://github.com/doczjs/docz/commit/d7be8a9))
* **docz-bundler-webpack:** improve webpack config ([964832a](https://github.com/doczjs/docz/commit/964832a))
* **docz-core:** add basic plugin logic ([add17ad](https://github.com/doczjs/docz/commit/add17ad))
* **docz-core:** add build command ([ef7abd2](https://github.com/doczjs/docz/commit/ef7abd2))
* **docz-core:** add chokidar to watch new entries ([2f073d5](https://github.com/doczjs/docz/commit/2f073d5))
* **docz-core:** add entry settings field ([2ec5d66](https://github.com/doczjs/docz/commit/2ec5d66))
* **docz-core:** add hot reload ([9ebe65d](https://github.com/doczjs/docz/commit/9ebe65d))
* **docz-core:** add playground code parse section ([6bbf158](https://github.com/doczjs/docz/commit/6bbf158))
* **docz-core:** add setConfig method for Plugin ([9ba6507](https://github.com/doczjs/docz/commit/9ba6507))
* **docz-core:** add some improvements to work with server config ([8bf33bc](https://github.com/doczjs/docz/commit/8bf33bc))
* **docz-core:** add support for custom head or scripts ([69f4d56](https://github.com/doczjs/docz/commit/69f4d56))
* **docz-core:** add support for load custom themes ([ade98ce](https://github.com/doczjs/docz/commit/ade98ce))
* **docz-core:** add support for parse sections via ast ([6db0cd8](https://github.com/doczjs/docz/commit/6db0cd8))
* **docz-core:** add template using art-template ([7484267](https://github.com/doczjs/docz/commit/7484267))
* **docz-core:** add typescript support ([17dae8b](https://github.com/doczjs/docz/commit/17dae8b))
* **docz-core:** improve plugin and add support to modify babel ([cf3ec4e](https://github.com/doczjs/docz/commit/cf3ec4e))
* **docz-core:** pass theme config via websockets for dev ([5222de7](https://github.com/doczjs/docz/commit/5222de7))
* **docz-core:** set babel on the fly ([672be49](https://github.com/doczjs/docz/commit/672be49))
* **docz-core:** split bundler logic ([a7db904](https://github.com/doczjs/docz/commit/a7db904))
* **docz-core:** use websockets instead of generate json to process entries ([e0773a0](https://github.com/doczjs/docz/commit/e0773a0))
* **docz-core:** webpack middlewares ([68cbcba](https://github.com/doczjs/docz/commit/68cbcba))
* **docz-example-flow:** add example folder ([27002d8](https://github.com/doczjs/docz/commit/27002d8))
* refac to use mdx ([04b59e5](https://github.com/doczjs/docz/commit/04b59e5))
* **docz-example-typescript:** add new example ([9052d0f](https://github.com/doczjs/docz/commit/9052d0f))
* **docz-theme-default:** add default theme as a package ([108dc4c](https://github.com/doczjs/docz/commit/108dc4c))
* **docz-theme-default:** add highlight code on theme ([1126e67](https://github.com/doczjs/docz/commit/1126e67))
* **docz-theme-default:** add logo option ([435da9b](https://github.com/doczjs/docz/commit/435da9b))
* **docz-theme-default:** add sidebar footer ([ffc4b18](https://github.com/doczjs/docz/commit/ffc4b18))
* **docz-theme-default:** add tooltip on props ([dc3c4cd](https://github.com/doczjs/docz/commit/dc3c4cd))
* **docz-theme-default:** improve theme styles ([2ca5e21](https://github.com/doczjs/docz/commit/2ca5e21))
* **docz-theme-default:** start logic to create theme feature ([900cf2b](https://github.com/doczjs/docz/commit/900cf2b))
* **docz-theme-default:** use typescript instead of javascript ([4de326a](https://github.com/doczjs/docz/commit/4de326a))
* use custom render method on section ([8ccf99c](https://github.com/doczjs/docz/commit/8ccf99c))
* **load-cfg:** add script as package ([11e409c](https://github.com/doczjs/docz/commit/11e409c))
* **load-cfg:** set cache to require file ([c49fc64](https://github.com/doczjs/docz/commit/c49fc64))
* add component props parse feature ([987627d](https://github.com/doczjs/docz/commit/987627d))
* add support for highlight code sections ([19bf7ea](https://github.com/doczjs/docz/commit/19bf7ea))
* improve docz theme to use theme config ([9207ed2](https://github.com/doczjs/docz/commit/9207ed2))
* parse doc class to object ([e7f9cf0](https://github.com/doczjs/docz/commit/e7f9cf0))
