# System.IdentityModel.Tokens

``` diff
+namespace System.IdentityModel.Tokens {
+    public abstract class BinaryKeyIdentifierClause : SecurityKeyIdentifierClause {
+        protected BinaryKeyIdentifierClause(string clauseType, byte[] identificationData, bool cloneBuffer);
+        protected BinaryKeyIdentifierClause(string clauseType, byte[] identificationData, bool cloneBuffer, byte[] derivationNonce, int derivationLength);
+        public byte[] GetBuffer();
+        protected byte[] GetRawBuffer();
+        public bool Matches(byte[] data);
+        public bool Matches(byte[] data, int offset);
+        public override bool Matches(SecurityKeyIdentifierClause keyIdentifierClause);
+    }
+    public sealed class EncryptedKeyIdentifierClause : BinaryKeyIdentifierClause {
+        public EncryptedKeyIdentifierClause(byte[] encryptedKey, string encryptionMethod);
+        public EncryptedKeyIdentifierClause(byte[] encryptedKey, string encryptionMethod, SecurityKeyIdentifier encryptingKeyIdentifier);
+        public EncryptedKeyIdentifierClause(byte[] encryptedKey, string encryptionMethod, SecurityKeyIdentifier encryptingKeyIdentifier, string carriedKeyName);
+        public EncryptedKeyIdentifierClause(byte[] encryptedKey, string encryptionMethod, SecurityKeyIdentifier encryptingKeyIdentifier, string carriedKeyName, byte[] derivationNonce, int derivationLength);
+        public string CarriedKeyName { get; }
+        public SecurityKeyIdentifier EncryptingKeyIdentifier { get; }
+        public string EncryptionMethod { get; }
+        public byte[] GetEncryptedKey();
+        public bool Matches(byte[] encryptedKey, string encryptionMethod, string carriedKeyName);
+        public override bool Matches(SecurityKeyIdentifierClause keyIdentifierClause);
+        public override string ToString();
+    }
+    public class KerberosRequestorSecurityToken : SecurityToken {
+        public override string Id { get; }
+        public override ReadOnlyCollection<SecurityKey> SecurityKeys { get; }
+        public string ServicePrincipalName { get; }
+        public override DateTime ValidFrom { get; }
+        public override DateTime ValidTo { get; }
+    }
+    public class LocalIdKeyIdentifierClause : SecurityKeyIdentifierClause {
+        public LocalIdKeyIdentifierClause(string localId);
+        public LocalIdKeyIdentifierClause(string localId, byte[] derivationNonce, int derivationLength, Type ownerType);
+        public LocalIdKeyIdentifierClause(string localId, Type ownerType);
+        public string LocalId { get; }
+        public Type OwnerType { get; }
+        public override bool Matches(SecurityKeyIdentifierClause keyIdentifierClause);
+        public bool Matches(string localId, Type ownerType);
+        public override string ToString();
+    }
+    public class SamlSerializer {
+        public SamlSerializer();
+    }
+    public static class SecurityAlgorithms {
+        public const string Aes128Encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
+        public const string Aes128KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
+        public const string Aes192Encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
+        public const string Aes192KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
+        public const string Aes256Encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
+        public const string Aes256KeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
+        public const string DesEncryption = "http://www.w3.org/2001/04/xmlenc#des-cbc";
+        public const string DsaSha1Signature = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
+        public const string ExclusiveC14n = "http://www.w3.org/2001/10/xml-exc-c14n#";
+        public const string ExclusiveC14nWithComments = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
+        public const string HmacSha1Signature = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
+        public const string HmacSha256Signature = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
+        public const string Psha1KeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
+        public const string Psha1KeyDerivationDec2005 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk/p_sha1";
+        public const string Ripemd160Digest = "http://www.w3.org/2001/04/xmlenc#ripemd160";
+        public const string RsaOaepKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
+        public const string RsaSha1Signature = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
+        public const string RsaSha256Signature = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
+        public const string RsaV15KeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
+        public const string Sha1Digest = "http://www.w3.org/2000/09/xmldsig#sha1";
+        public const string Sha256Digest = "http://www.w3.org/2001/04/xmlenc#sha256";
+        public const string Sha512Digest = "http://www.w3.org/2001/04/xmlenc#sha512";
+        public const string StrTransform = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
+        public const string TlsSspiKeyWrap = "http://schemas.xmlsoap.org/2005/02/trust/tlsnego#TLS_Wrap";
+        public const string TripleDesEncryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
+        public const string TripleDesKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
+        public const string WindowsSspiKeyWrap = "http://schemas.xmlsoap.org/2005/02/trust/spnego#GSS_Wrap";
+    }
+    public abstract class SecurityKey {
+        protected SecurityKey();
+        public abstract int KeySize { get; }
+        public abstract byte[] DecryptKey(string algorithm, byte[] keyData);
+        public abstract byte[] EncryptKey(string algorithm, byte[] keyData);
+        public abstract bool IsAsymmetricAlgorithm(string algorithm);
+        public abstract bool IsSupportedAlgorithm(string algorithm);
+        public abstract bool IsSymmetricAlgorithm(string algorithm);
+    }
+    public class SecurityKeyIdentifier : IEnumerable, IEnumerable<SecurityKeyIdentifierClause> {
+        public SecurityKeyIdentifier();
+        public SecurityKeyIdentifier(params SecurityKeyIdentifierClause[] clauses);
+        public bool CanCreateKey { get; }
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public SecurityKeyIdentifierClause this[int index] { get; }
+        public void Add(SecurityKeyIdentifierClause clause);
+        public SecurityKey CreateKey();
+        public TClause Find<TClause>() where TClause : SecurityKeyIdentifierClause;
+        public IEnumerator<SecurityKeyIdentifierClause> GetEnumerator();
+        public void MakeReadOnly();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public override string ToString();
+        public bool TryFind<TClause>(out TClause clause) where TClause : SecurityKeyIdentifierClause;
+    }
+    public abstract class SecurityKeyIdentifierClause {
+        protected SecurityKeyIdentifierClause(string clauseType);
+        protected SecurityKeyIdentifierClause(string clauseType, byte[] nonce, int length);
+        public virtual bool CanCreateKey { get; }
+        public string ClauseType { get; }
+        public int DerivationLength { get; }
+        public string Id { get; set; }
+        public virtual SecurityKey CreateKey();
+        public byte[] GetDerivationNonce();
+        public virtual bool Matches(SecurityKeyIdentifierClause keyIdentifierClause);
+    }
+    public enum SecurityKeyType {
+        AsymmetricKey = 1,
+        BearerKey = 2,
+        SymmetricKey = 0,
+    }
+    public enum SecurityKeyUsage {
+        Exchange = 0,
+        Signature = 1,
+    }
+    public abstract class SecurityToken {
+        protected SecurityToken();
+        public abstract string Id { get; }
+        public abstract ReadOnlyCollection<SecurityKey> SecurityKeys { get; }
+        public abstract DateTime ValidFrom { get; }
+        public abstract DateTime ValidTo { get; }
+    }
+    public class SecurityTokenException : Exception {
+        public SecurityTokenException();
+        public SecurityTokenException(string message);
+        public SecurityTokenException(string message, Exception innerException);
+    }
+    public static class SecurityTokenTypes {
+        public static string Kerberos { get; }
+        public static string Rsa { get; }
+        public static string Saml { get; }
+        public static string UserName { get; }
+        public static string X509Certificate { get; }
+    }
+    public class SecurityTokenValidationException : SecurityTokenException {
+        public SecurityTokenValidationException();
+        public SecurityTokenValidationException(string message);
+        public SecurityTokenValidationException(string message, Exception innerException);
+    }
+    public class UserNameSecurityToken : SecurityToken {
+        public UserNameSecurityToken(string userName, string password);
+        public UserNameSecurityToken(string userName, string password, string id);
+        public override string Id { get; }
+        public string Password { get; }
+        public override ReadOnlyCollection<SecurityKey> SecurityKeys { get; }
+        public string UserName { get; }
+        public override DateTime ValidFrom { get; }
+        public override DateTime ValidTo { get; }
+    }
+    public class WindowsSecurityToken : SecurityToken, IDisposable {
+        protected WindowsSecurityToken();
+        public WindowsSecurityToken(WindowsIdentity windowsIdentity);
+        public WindowsSecurityToken(WindowsIdentity windowsIdentity, string id);
+        public WindowsSecurityToken(WindowsIdentity windowsIdentity, string id, string authenticationType);
+        public string AuthenticationType { get; }
+        public override string Id { get; }
+        public override ReadOnlyCollection<SecurityKey> SecurityKeys { get; }
+        public override DateTime ValidFrom { get; }
+        public override DateTime ValidTo { get; }
+        public virtual WindowsIdentity WindowsIdentity { get; }
+        public virtual void Dispose();
+        protected void Initialize(string id, DateTime effectiveTime, DateTime expirationTime, WindowsIdentity windowsIdentity, bool clone);
+        protected void Initialize(string id, string authenticationType, DateTime effectiveTime, DateTime expirationTime, WindowsIdentity windowsIdentity, bool clone);
+        protected void ThrowIfDisposed();
+    }
+    public class X509SecurityToken : SecurityToken, IDisposable {
+        public X509SecurityToken(X509Certificate2 certificate);
+        public X509SecurityToken(X509Certificate2 certificate, string id);
+        public X509Certificate2 Certificate { get; }
+        public override string Id { get; }
+        public override ReadOnlyCollection<SecurityKey> SecurityKeys { get; }
+        public override DateTime ValidFrom { get; }
+        public override DateTime ValidTo { get; }
+        public virtual void Dispose();
+        protected void ThrowIfDisposed();
+    }
+}
```

