[![Quarkus](https://design.jboss.org/quarkus/logo/final/PNG/quarkus_logo_horizontal_rgb_1280px_default.png#gh-light-mode-only)](https://quarkus.io/#gh-light-mode-only)
[![Quarkus](https://design.jboss.org/quarkus/logo/final/PNG/quarkus_logo_horizontal_rgb_1280px_reverse.png#gh-dark-mode-only)](https://quarkus.io/#gh-dark-mode-only)

[![Version](https://img.shields.io/maven-central/v/io.quarkus/quarkus-bom?logo=apache-maven&style=for-the-badge)](https://search.maven.org/artifact/io.quarkus/quarkus-bom)
[![GitHub Actions Status](<https://img.shields.io/github/actions/workflow/status/QuarkusIO/quarkus/ci-actions-incremental.yml?branch=main&logo=GitHub&style=for-the-badge>)](https://github.com/quarkusio/quarkus/actions?query=workflow%3A%22Quarkus+CI%22)
[![Commits](https://img.shields.io/github/commit-activity/m/quarkusio/quarkus.svg?label=commits&style=for-the-badge&logo=git&logoColor=white)](https://github.com/quarkusio/quarkus/pulse)
[![License](https://img.shields.io/github/license/quarkusio/quarkus?style=for-the-badge&logo=apache)](https://www.apache.org/licenses/LICENSE-2.0)
[![Project Chat](https://img.shields.io/badge/zulip-join_chat-brightgreen.svg?style=for-the-badge&logo=zulip)](https://quarkusio.zulipchat.com/)
[![Gitpod Ready-to-Code](https://img.shields.io/badge/Gitpod-Ready--to--Code-blue?style=for-the-badge&logo=gitpod&logoColor=white)](https://gitpod.io/#https://github.com/quarkusio/quarkus/-/tree/main/)
[![Supported JVM Versions](https://img.shields.io/badge/JVM-17--21-brightgreen.svg?style=for-the-badge&logo=openjdk)](https://github.com/quarkusio/quarkus/actions/runs/113853915/)
[![Develocity](https://img.shields.io/badge/Revved%20up%20by-Develocity-007EC5?style=for-the-badge&logo=gradle)](https://ge.quarkus.io/scans)
[![GitHub Repo stars](https://img.shields.io/github/stars/quarkusio/quarkus?style=for-the-badge)](https://github.com/quarkusio/quarkus/stargazers)
[![Gurubase](https://img.shields.io/badge/Gurubase-Ask%20Quarkus%20Guru-007EC5?style=for-the-badge)](https://gurubase.io/g/quarkus)

# Quarkus - Supersonic Subatomic Java

Quarkus is a Cloud Native, (Linux) Container First framework for writing Java applications.

* **Container First**:
Minimal footprint Java applications optimal for running in containers.
* **Cloud Native**:
Embraces [12 factor architecture](https://12factor.net) in environments like Kubernetes.
* **Unify imperative and reactive**:
Brings under one programming model non-blocking and imperative styles of development.
* **Standards-based**:
Based on the standards and frameworks you love and use (RESTEasy and JAX-RS, Hibernate ORM and JPA, Netty, Eclipse Vert.x, Eclipse MicroProfile, Apache Camel...).
* **Microservice First**:
Brings lightning fast startup time and code turnaround to Java apps.
* **Developer Joy**:
Development centric experience without compromise to bring your amazing apps to life in no time.

_All under ONE framework._

## Getting Started

* [Documentation](https://quarkus.io)
* [Wiki](https://github.com/quarkusio/quarkus/wiki)

## Migration Guides

We collect all the migration notes in our [migration guides](https://github.com/quarkusio/quarkus/wiki/Migration-Guides).

## Release Planning

Interested in when the next release is coming? Check our [release planning](https://github.com/quarkusio/quarkus/wiki/Release-Planning) document for details.

## How to build Quarkus

The build instructions are available in the [contribution guide](CONTRIBUTING.md).
