/******************************************************************************
 * Copyright (C) 2010-2016 CERN. All rights not expressly granted are reserved.
 *
 * This file is part of the CERN Control and Monitoring Platform 'C2MON'.
 * C2MON is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the license.
 *
 * C2MON is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with C2MON. If not, see <http://www.gnu.org/licenses/>.
 *****************************************************************************/
package cern.c2mon.server.cache.dbaccess.type;


import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import cern.c2mon.server.common.metadata.Metadata;

@MappedTypes(Metadata.class)
public class MetadataTypeHandler implements TypeHandler {

  @Override
  public Object getResult(ResultSet rs, String columnName) throws SQLException {

    String metadataString;
    Metadata metadata = new Metadata();
    Map<String, Object> dataSet;

    if ((metadataString = rs.getString(columnName)) != null) {
      dataSet = Metadata.fromJSON(metadataString);
      metadata.setMetadata(dataSet);
    }
    else {
      metadata = null;
    }
    return metadata;
  }

  @Override
  public Object getResult(CallableStatement arg0, int arg1) throws SQLException {
    return null;
  }

  @Override
  public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
    return null;
  }

  @Override
  public void setParameter(PreparedStatement ps, int parameterIndex, Object metadata, JdbcType arg3) throws SQLException {
    if (metadata != null) {
      ps.setString(parameterIndex, Metadata.toJSON((Metadata) metadata));
    } else {
      ps.setString(parameterIndex, null);
    }
  }
}
