
pub const EPERM = 1; /// Operation not permitted
pub const ENOENT = 2; /// No such file or directory
pub const ESRCH = 3; /// No such process
pub const EINTR = 4; /// Interrupted system call
pub const EIO = 5; /// Input/output error
pub const ENXIO = 6; /// Device not configured
pub const E2BIG = 7; /// Argument list too long
pub const ENOEXEC = 8; /// Exec format error
pub const EBADF = 9; /// Bad file descriptor
pub const ECHILD = 10; /// No child processes
pub const EDEADLK = 11; /// Resource deadlock avoided

pub const ENOMEM = 12; /// Cannot allocate memory
pub const EACCES = 13; /// Permission denied
pub const EFAULT = 14; /// Bad address
pub const ENOTBLK = 15; /// Block device required
pub const EBUSY = 16; /// Device / Resource busy
pub const EEXIST = 17; /// File exists
pub const EXDEV = 18; /// Cross-device link
pub const ENODEV = 19; /// Operation not supported by device
pub const ENOTDIR = 20; /// Not a directory
pub const EISDIR = 21; /// Is a directory
pub const EINVAL = 22; /// Invalid argument
pub const ENFILE = 23; /// Too many open files in system
pub const EMFILE = 24; /// Too many open files
pub const ENOTTY = 25; /// Inappropriate ioctl for device
pub const ETXTBSY = 26; /// Text file busy
pub const EFBIG = 27; /// File too large
pub const ENOSPC = 28; /// No space left on device
pub const ESPIPE = 29; /// Illegal seek
pub const EROFS = 30; /// Read-only file system
pub const EMLINK = 31; /// Too many links
pub const EPIPE = 32; /// Broken pipe

// math software
pub const EDOM = 33; /// Numerical argument out of domain
pub const ERANGE = 34; /// Result too large

// non-blocking and interrupt i/o
pub const EAGAIN = 35; /// Resource temporarily unavailable
pub const EWOULDBLOCK = EAGAIN; /// Operation would block
pub const EINPROGRESS = 36; /// Operation now in progress
pub const EALREADY = 37; /// Operation already in progress

// ipc/network software -- argument errors
pub const ENOTSOCK = 38; /// Socket operation on non-socket
pub const EDESTADDRREQ = 39; /// Destination address required
pub const EMSGSIZE = 40; /// Message too long
pub const EPROTOTYPE = 41; /// Protocol wrong type for socket
pub const ENOPROTOOPT = 42; /// Protocol not available
pub const EPROTONOSUPPORT = 43; /// Protocol not supported

pub const ESOCKTNOSUPPORT = 44; /// Socket type not supported

pub const ENOTSUP = 45; /// Operation not supported

pub const EPFNOSUPPORT = 46; /// Protocol family not supported
pub const EAFNOSUPPORT = 47; /// Address family not supported by protocol family
pub const EADDRINUSE = 48; /// Address already in use
pub const EADDRNOTAVAIL = 49; /// Can't assign requested address

// ipc/network software -- operational errors
pub const ENETDOWN = 50; /// Network is down
pub const ENETUNREACH = 51; /// Network is unreachable
pub const ENETRESET = 52; /// Network dropped connection on reset
pub const ECONNABORTED = 53; /// Software caused connection abort
pub const ECONNRESET = 54; /// Connection reset by peer
pub const ENOBUFS = 55; /// No buffer space available
pub const EISCONN = 56; /// Socket is already connected
pub const ENOTCONN = 57; /// Socket is not connected

pub const ESHUTDOWN = 58; /// Can't send after socket shutdown
pub const ETOOMANYREFS = 59; /// Too many references: can't splice

pub const ETIMEDOUT = 60; /// Operation timed out
pub const ECONNREFUSED = 61; /// Connection refused

pub const ELOOP = 62; /// Too many levels of symbolic links
pub const ENAMETOOLONG = 63; /// File name too long

pub const EHOSTDOWN = 64; /// Host is down
pub const EHOSTUNREACH = 65; /// No route to host
pub const ENOTEMPTY = 66; /// Directory not empty

// quotas & mush
pub const EPROCLIM = 67; /// Too many processes
pub const EUSERS = 68; /// Too many users
pub const EDQUOT = 69; /// Disc quota exceeded

// Network File System
pub const ESTALE = 70; /// Stale NFS file handle
pub const EREMOTE = 71; /// Too many levels of remote in path
pub const EBADRPC = 72; /// RPC struct is bad
pub const ERPCMISMATCH = 73; /// RPC version wrong
pub const EPROGUNAVAIL = 74; /// RPC prog. not avail
pub const EPROGMISMATCH = 75; /// Program version wrong
pub const EPROCUNAVAIL = 76; /// Bad procedure for program

pub const ENOLCK = 77; /// No locks available
pub const ENOSYS = 78; /// Function not implemented

pub const EFTYPE = 79; /// Inappropriate file type or format
pub const EAUTH = 80; /// Authentication error
pub const ENEEDAUTH = 81; /// Need authenticator

// Intelligent device errors
pub const EPWROFF = 82; /// Device power is off
pub const EDEVERR = 83; /// Device error, e.g. paper out

pub const EOVERFLOW = 84; /// Value too large to be stored in data type

// Program loading errors
pub const EBADEXEC = 85; /// Bad executable
pub const EBADARCH = 86; /// Bad CPU type in executable
pub const ESHLIBVERS = 87; /// Shared library version mismatch
pub const EBADMACHO = 88; /// Malformed Macho file

pub const ECANCELED = 89; /// Operation canceled

pub const EIDRM = 90; /// Identifier removed
pub const ENOMSG = 91; /// No message of desired type
pub const EILSEQ = 92; /// Illegal byte sequence
pub const ENOATTR = 93; /// Attribute not found

pub const EBADMSG = 94; /// Bad message
pub const EMULTIHOP = 95; /// Reserved
pub const ENODATA = 96; /// No message available on STREAM
pub const ENOLINK = 97; /// Reserved
pub const ENOSR = 98; /// No STREAM resources
pub const ENOSTR = 99; /// Not a STREAM
pub const EPROTO = 100; /// Protocol error
pub const ETIME = 101; /// STREAM ioctl timeout

pub const ENOPOLICY = 103; /// No such policy registered

pub const ENOTRECOVERABLE = 104; /// State not recoverable
pub const EOWNERDEAD = 105; /// Previous owner died

pub const EQFULL = 106; /// Interface output queue is full
pub const ELAST = 106; /// Must be equal largest errno

