pub const EPERM = 1; /// Operation not permitted
pub const ENOENT = 2; /// No such file or directory
pub const ESRCH = 3; /// No such process
pub const EINTR = 4; /// Interrupted system call
pub const EIO = 5; /// I/O error
pub const ENXIO = 6; /// No such device or address
pub const E2BIG = 7; /// Arg list too long
pub const ENOEXEC = 8; /// Exec format error
pub const EBADF = 9; /// Bad file number
pub const ECHILD = 10; /// No child processes
pub const EAGAIN = 11; /// Try again
pub const ENOMEM = 12; /// Out of memory
pub const EACCES = 13; /// Permission denied
pub const EFAULT = 14; /// Bad address
pub const ENOTBLK = 15; /// Block device required
pub const EBUSY = 16; /// Device or resource busy
pub const EEXIST = 17; /// File exists
pub const EXDEV = 18; /// Cross-device link
pub const ENODEV = 19; /// No such device
pub const ENOTDIR = 20; /// Not a directory
pub const EISDIR = 21; /// Is a directory
pub const EINVAL = 22; /// Invalid argument
pub const ENFILE = 23; /// File table overflow
pub const EMFILE = 24; /// Too many open files
pub const ENOTTY = 25; /// Not a typewriter
pub const ETXTBSY = 26; /// Text file busy
pub const EFBIG = 27; /// File too large
pub const ENOSPC = 28; /// No space left on device
pub const ESPIPE = 29; /// Illegal seek
pub const EROFS = 30; /// Read-only file system
pub const EMLINK = 31; /// Too many links
pub const EPIPE = 32; /// Broken pipe
pub const EDOM = 33; /// Math argument out of domain of func
pub const ERANGE = 34; /// Math result not representable
pub const EDEADLK = 35; /// Resource deadlock would occur
pub const ENAMETOOLONG = 36; /// File name too long
pub const ENOLCK = 37; /// No record locks available
pub const ENOSYS = 38; /// Function not implemented
pub const ENOTEMPTY = 39; /// Directory not empty
pub const ELOOP = 40; /// Too many symbolic links encountered
pub const EWOULDBLOCK = EAGAIN; /// Operation would block
pub const ENOMSG = 42; /// No message of desired type
pub const EIDRM = 43; /// Identifier removed
pub const ECHRNG = 44; /// Channel number out of range
pub const EL2NSYNC = 45; /// Level 2 not synchronized
pub const EL3HLT = 46; /// Level 3 halted
pub const EL3RST = 47; /// Level 3 reset
pub const ELNRNG = 48; /// Link number out of range
pub const EUNATCH = 49; /// Protocol driver not attached
pub const ENOCSI = 50; /// No CSI structure available
pub const EL2HLT = 51; /// Level 2 halted
pub const EBADE = 52; /// Invalid exchange
pub const EBADR = 53; /// Invalid request descriptor
pub const EXFULL = 54; /// Exchange full
pub const ENOANO = 55; /// No anode
pub const EBADRQC = 56; /// Invalid request code
pub const EBADSLT = 57; /// Invalid slot

pub const EBFONT = 59; /// Bad font file format
pub const ENOSTR = 60; /// Device not a stream
pub const ENODATA = 61; /// No data available
pub const ETIME = 62; /// Timer expired
pub const ENOSR = 63; /// Out of streams resources
pub const ENONET = 64; /// Machine is not on the network
pub const ENOPKG = 65; /// Package not installed
pub const EREMOTE = 66; /// Object is remote
pub const ENOLINK = 67; /// Link has been severed
pub const EADV = 68; /// Advertise error
pub const ESRMNT = 69; /// Srmount error
pub const ECOMM = 70; /// Communication error on send
pub const EPROTO = 71; /// Protocol error
pub const EMULTIHOP = 72; /// Multihop attempted
pub const EDOTDOT = 73; /// RFS specific error
pub const EBADMSG = 74; /// Not a data message
pub const EOVERFLOW = 75; /// Value too large for defined data type
pub const ENOTUNIQ = 76; /// Name not unique on network
pub const EBADFD = 77; /// File descriptor in bad state
pub const EREMCHG = 78; /// Remote address changed
pub const ELIBACC = 79; /// Can not access a needed shared library
pub const ELIBBAD = 80; /// Accessing a corrupted shared library
pub const ELIBSCN = 81; /// .lib section in a.out corrupted
pub const ELIBMAX = 82; /// Attempting to link in too many shared libraries
pub const ELIBEXEC = 83; /// Cannot exec a shared library directly
pub const EILSEQ = 84; /// Illegal byte sequence
pub const ERESTART = 85; /// Interrupted system call should be restarted
pub const ESTRPIPE = 86; /// Streams pipe error
pub const EUSERS = 87; /// Too many users
pub const ENOTSOCK = 88; /// Socket operation on non-socket
pub const EDESTADDRREQ = 89; /// Destination address required
pub const EMSGSIZE = 90; /// Message too long
pub const EPROTOTYPE = 91; /// Protocol wrong type for socket
pub const ENOPROTOOPT = 92; /// Protocol not available
pub const EPROTONOSUPPORT = 93; /// Protocol not supported
pub const ESOCKTNOSUPPORT = 94; /// Socket type not supported
pub const EOPNOTSUPP = 95; /// Operation not supported on transport endpoint
pub const EPFNOSUPPORT = 96; /// Protocol family not supported
pub const EAFNOSUPPORT = 97; /// Address family not supported by protocol
pub const EADDRINUSE = 98; /// Address already in use
pub const EADDRNOTAVAIL = 99; /// Cannot assign requested address
pub const ENETDOWN = 100; /// Network is down
pub const ENETUNREACH = 101; /// Network is unreachable
pub const ENETRESET = 102; /// Network dropped connection because of reset
pub const ECONNABORTED = 103; /// Software caused connection abort
pub const ECONNRESET = 104; /// Connection reset by peer
pub const ENOBUFS = 105; /// No buffer space available
pub const EISCONN = 106; /// Transport endpoint is already connected
pub const ENOTCONN = 107; /// Transport endpoint is not connected
pub const ESHUTDOWN = 108; /// Cannot send after transport endpoint shutdown
pub const ETOOMANYREFS = 109; /// Too many references: cannot splice
pub const ETIMEDOUT = 110; /// Connection timed out
pub const ECONNREFUSED = 111; /// Connection refused
pub const EHOSTDOWN = 112; /// Host is down
pub const EHOSTUNREACH = 113; /// No route to host
pub const EALREADY = 114; /// Operation already in progress
pub const EINPROGRESS = 115; /// Operation now in progress
pub const ESTALE = 116; /// Stale NFS file handle
pub const EUCLEAN = 117; /// Structure needs cleaning
pub const ENOTNAM = 118; /// Not a XENIX named type file
pub const ENAVAIL = 119; /// No XENIX semaphores available
pub const EISNAM = 120; /// Is a named type file
pub const EREMOTEIO = 121; /// Remote I/O error
pub const EDQUOT = 122; /// Quota exceeded

pub const ENOMEDIUM = 123; /// No medium found
pub const EMEDIUMTYPE = 124; /// Wrong medium type

// nameserver query return codes
pub const ENSROK = 0; /// DNS server returned answer with no data
pub const ENSRNODATA = 160; /// DNS server returned answer with no data
pub const ENSRFORMERR = 161; /// DNS server claims query was misformatted
pub const ENSRSERVFAIL = 162; /// DNS server returned general failure
pub const ENSRNOTFOUND = 163; /// Domain name not found
pub const ENSRNOTIMP = 164; /// DNS server does not implement requested operation
pub const ENSRREFUSED = 165; /// DNS server refused query
pub const ENSRBADQUERY = 166; /// Misformatted DNS query
pub const ENSRBADNAME = 167; /// Misformatted domain name
pub const ENSRBADFAMILY = 168; /// Unsupported address family
pub const ENSRBADRESP = 169; /// Misformatted DNS reply
pub const ENSRCONNREFUSED = 170; /// Could not contact DNS servers
pub const ENSRTIMEOUT = 171; /// Timeout while contacting DNS servers
pub const ENSROF = 172; /// End of file
pub const ENSRFILE = 173; /// Error reading file
pub const ENSRNOMEM = 174; /// Out of memory
pub const ENSRDESTRUCTION = 175; /// Application terminated lookup
pub const ENSRQUERYDOMAINTOOLONG = 176; /// Domain name is too long
pub const ENSRCNAMELOOP = 177; /// Domain name is too long
