const __fixunstfti = @import("fixunstfti.zig").__fixunstfti;
const assert = @import("../../debug.zig").assert;

fn test__fixunstfti(a: f128, expected: u128) {
    const x = __fixunstfti(a);
    assert(x == expected);
}

const inf128 = @bitCast(f128, u128(0x7fff0000000000000000000000000000));

test "fixunstfti" {
    test__fixunstfti(inf128, 0xffffffffffffffffffffffffffffffff);

    test__fixunstfti(0.0, 0);

    test__fixunstfti(0.5, 0);
    test__fixunstfti(0.99, 0);
    test__fixunstfti(1.0, 1);
    test__fixunstfti(1.5, 1);
    test__fixunstfti(1.99, 1);
    test__fixunstfti(2.0, 2);
    test__fixunstfti(2.01, 2);
    test__fixunstfti(-0.01, 0);
    test__fixunstfti(-0.99, 0);

    test__fixunstfti(0x1.p+128, 0xffffffffffffffffffffffffffffffff);

    test__fixunstfti(0x1.FFFFFEp+126, 0x7fffff80000000000000000000000000);
    test__fixunstfti(0x1.FFFFFEp+127, 0xffffff00000000000000000000000000);
    test__fixunstfti(0x1.FFFFFEp+128, 0xffffffffffffffffffffffffffffffff);
    test__fixunstfti(0x1.FFFFFEp+129, 0xffffffffffffffffffffffffffffffff);
}
