---
description: |
    The oracle-classic builder is able to create new custom images for use with
    Oracle Cloud Infrastructure Classic Compute.
layout: docs
page_title: 'Oracle Cloud Infrastructure Classic - Builders'
sidebar_current: 'docs-builders-oracle-classic'
---

# Oracle Cloud Infrastructure Classic Compute Builder

Type: `oracle-classic`

The `oracle-classic` Packer builder is able to create custom images for use
with [Oracle Cloud Infrastructure Classic
Compute](https://cloud.oracle.com/compute-classic). The builder takes a base
image, runs any provisioning necessary on the base image after launching it,
and finally snapshots it creating a reusable custom image.

It is recommended that you familiarise yourself with the [Key Concepts and
Terminology](https://docs.oracle.com/en/cloud/iaas/compute-iaas-cloud/stcsg/terminology.html)
prior to using this builder if you have not done so already.

The builder *does not* manage images. Once it creates an image, it is up to you
to use it or delete it.

## Authorization

This builder authenticates API calls to Oracle Cloud Infrastructure Classic
Compute using basic authentication (user name and password). To read more, see
the [authentication
documentation](https://docs.oracle.com/en/cloud/iaas/compute-iaas-cloud/stcsa/Authentication.html)

## Configuration Reference

There are many configuration options available for the `oracle-classic`
builder. This builder currently only works with the SSH communicator.

### Required

-   `api_endpoint` (string) - This is your custom API endpoint for sending
    requests. Instructions for determining your API endpoint can be found
    [here](https://docs.oracle.com/en/cloud/iaas/compute-iaas-cloud/stcsa/SendRequests.html)

-   `dest_image_list` (string) - Where to save the machine image to once you've
    provisioned it. If the provided image list does not exist, Packer will
    create it.

-   `identity_domain` (string) - This is your customer-specific identity domain
    as generated by Oracle. If you don't know what your identity domain is, ask
    your account administrator. For a little more information, see the Oracle
    [documentation](https://docs.oracle.com/en/cloud/get-started/subscriptions-cloud/ocuid/identity-domain-overview.html#GUID-7969F881-5F4D-443E-B86C-9044C8085B8A).

-   `source_image_list` (string) - This is what image you want to use as your
    base image. See the
    [documentation](https://docs.oracle.com/en/cloud/iaas/compute-iaas-cloud/stcsg/listing-machine-images.html)
    for more details. You may use either a public image list, or a private
    image list. To see what public image lists are available, you can use the
    CLI, as described
    [here](https://docs.oracle.com/en/cloud/iaas/compute-iaas-cloud/stopc/image-lists-stclr-and-nmcli.html#GUID-DB7E75FE-F752-4FF7-AB70-3C8DCDFCA0FA)

-   `source_image_list_entry` (string) - The entry identifying the machine
    image to use in the image list. Defaults to the latest available entry.

-   `password` (string) - Your account password.

-   `shape` (string) - The template that determines the number of CPUs, amount
    of memory, and other resources allocated to a newly created instance. For
    more information about shapes, see the documentation
    [here](https://docs.oracle.com/en/cloud/iaas/compute-iaas-cloud/stcsg/machine-images-and-shapes.html).

-   `username` (string) - Your account username.

### Optional

-   `attributes` (string) - (string) - Attributes to apply when launching the
    instance. Note that you need to be careful about escaping characters due to
    the templates being JSON. It is often more convenient to use
    `attributes_file`, instead. You may only define either `attributes` or
    `attributes_file`, not both.

-   `attributes_file` (string) - Path to a json file that will be used for the
    attributes when launching the instance. You may only define either
    `attributes` or `attributes_file`, not both.

-   `image_description` (string) - a description for your destination image
    list. If you don't provide one, Packer will provide a generic description.

-   `ssh_username` (string) - The username that Packer will use to SSH into the
    instance; defaults to `opc`, the default oracle user, which has sudo
    privileges. If you have already configured users on your machine, you may
    prompt Packer to use one of those instead. For more detail, see the
    [documentation](https://docs.oracle.com/en/cloud/iaas/compute-iaas-cloud/stcsg/accessing-oracle-linux-instance-using-ssh.html).

-   `image_name` (string) - The name to assign to the resulting custom image.

-   `persistent_volume_size` (int) - Size in gigabytes of the persistent boot
    storage volume to build the image on. Use this if you want a bigger volume
    than what instance storage provides. Note that using this option puts the
    builder into a "persistent volume" mode, which is substantially different
    than the default snapshot mode. Please see the configuration section below
    for additional configuration options.

-   `snapshot_timeout` (string) - How long to wait for a snapshot to be
    created. Expects a positive golang Time.Duration string, which is a
    sequence of decimal numbers and a unit suffix; valid suffixes are `ns`
    (nanoseconds), `us` (microseconds), `ms` (milliseconds), `s` (seconds), `m`
    (minutes), and `h` (hours). Examples of valid inputs: `100ms`, `250ms`,
    `1s`, `2.5s`, `2.5m`, `1m30s`. Example: `"snapshot_timeout": "15m"`.
    Default: `20m`.

### Persistent Volume Build

You will use this type of build if you've set the `persistent_volume_size`
option. If you need a bigger disk than what you normally get with instance
storage, you'll want to set this.

In the *persistent volume* mode, things are built a little differently.
Normally, we launch an instance, then provision it and take a snapshot, which
becomes your machine image. This relies on the disk of the created instance
being large enough to perform your entire provisioning process. If that disk
size isn't sufficient, we can build with a persistent volume of arbitrary size.

First, we create a persistent volume of the requested size. This volume is
bootable and initialized with your image list. We start an instance with this
volume as the boot volume. After this instance launches, we provision and
terminate it, leaving the persistent volume around.

Next, we create a second instance, the "builder", this time booting from
instance storage. We also attach a new persistent volume, making it twice the
size of the original. We connect to this instance and copy the contents of the
first volume into a tarball file on the second volume. We then upload this file
to Object Storage Classic, and create a new machine image with it.

For more details, see this [blog
post](https://blogs.oracle.com/cloudmarketplace/creating-an-oracle-compute-machine-image-from-an-instance-with-persistent-boot-storage),
which discusses the strategy used here.

If this is set, a few more options become available.

-   `builder_communicator` (communicator) - This represents an
    [`ssh communicator`](/docs/templates/communicator.html#ssh-communicator),
    and can be configured as such. If you use a different builder image, you
    may need to change the `ssh_username`, for example. That might look like this:

    ```json
    {
        "builders": [
            {
                "builder_communicator": {
                    "ssh_username": "soandso"
                },
                "type": "oracle-classic"
            }
        ]
    }
    ```

-   `builder_image_list` (string) - This is the image to use for the builder
    instance. This *must* be a linux image, and Oracle Linux is recommended.
    Default: `/oracle/public/OL_7.2_UEKR4_x86_64`.

-   `builder_image_list_entry` (string) - The entry identifying the machine
    image to use in the image list. If `builder_image_list` is unset, this
    defaults to `5`, which is a working image as of this time. Otherwise, it
    defaults to the latest entry. Set this to `0` to force it to use the latest
    entry when using the default `builder_image_list`.

-   `builder_shape` (string) - The template that determines the number of CPUs,
    amount of memory, and other resources allocated to the builder instance.
    Default: `oc3`.

*   `builder_upload_image_command` (string) - The command to run to upload the
    image to Object Storage Classic. This is for advanced users only, and you
    should consult the default in code to decide on the changes to make. For
    most users the default should suffice.

## Basic Example

Here is a basic example. Note that account specific configuration has been
obfuscated; you will need to add a working `username`, `password`,
`identity_domain`, and `api_endpoint` in order for the example to work.

``` json
{
    "builders": [
        {
            "type": "oracle-classic",
            "username": "myuser@myaccount.com",
            "password": "supersecretpasswordhere",
            "identity_domain": "#######",
            "api_endpoint": "https://api-###.compute.###.oraclecloud.com/",
            "source_image_list": "/oracle/public/OL_7.2_UEKR4_x86_64",
            "shape": "oc3",
            "image_name": "Packer_Builder_Test_{{timestamp}}",
            "attributes": "{\"userdata\": {\"pre-bootstrap\": {\"script\": [\"...\"]}}}",
            "dest_image_list": "Packer_Builder_Test_List"
        }
    ],
    "provisioners": [
        {
            "type": "shell",
            "inline": ["echo hello"]
        }
    ]
}
```

## Basic Example -- Windows

Attributes file is optional for connecting via ssh, but required for winrm.

The following file contains the bare minimum necessary to get winRM working;
you have to give it the password to give to the "Administrator" user, which
will be the one winrm connects to. You must also whitelist your computer to
connect via winRM -- the empty braces below whitelist any computer to access
winRM but you can make it more secure by only allowing your build machine
access. See the
[docs](https://docs.oracle.com/en/cloud/iaas/compute-iaas-cloud/stcsg/automating-instance-initialization-using-opc-init.html#GUID-A0A107D6-3B38-47F4-8FC8-96D50D99379B)
for more details on how to define a trusted host.

Save this file as `windows_attributes.json`:

``` json
{
    "userdata": {
        "administrator_password": "password",
        "winrm": {}
    }
}
```

Following is a minimal but working Packer config that references this
attributes file:

``` json
{
    "variables": {
        "opc_username": "{{ env `OPC_USERNAME`}}",
        "opc_password": "{{ env `OPC_PASSWORD`}}",
        "opc_identity_domain": "{{env `OPC_IDENTITY_DOMAIN`}}",
        "opc_api_endpoint": "{{ env `OPC_ENDPOINT`}}"
    },
    "builders": [
        {
            "type": "oracle-classic",
            "username": "{{ user `opc_username`}}",
            "password": "{{ user `opc_password`}}",
            "identity_domain": "{{ user `opc_identity_domain`}}",
            "api_endpoint": "{{ user `opc_api_endpoint`}}",
            "source_image_list": "/Compute-{{ user `opc_identity_domain` }}/{{ user `opc_username`}}/Microsoft_Windows_Server_2012_R2-17.3.6-20170930-124649",
            "attributes_file": "./windows_attributes.json",
            "shape": "oc3",
            "image_name": "Packer_Windows_Demo_{{timestamp}}",
            "dest_image_list": "Packer_Windows_Demo",
            "communicator": "winrm",
            "winrm_username": "Administrator",
            "winrm_password": "password"
        }
    ],
    "provisioners": [
        {
          "type": "powershell",
          "inline": "Write-Output(\"HELLO WORLD\")"
        }
    ]
}
```

## Persistent Volume Example

Here is an example using a persistent volume. Note the `persistent_volume_size`
setting.

```json
{
    "variables": {
        "opc_username": "{{ env `OPC_USERNAME`}}",
        "opc_password": "{{ env `OPC_PASSWORD`}}",
        "opc_identity_domain": "{{env `OPC_IDENTITY_DOMAIN`}}",
        "opc_api_endpoint": "{{ env `OPC_ENDPOINT`}}"
    },
    "builders": [
        {
            "type": "oracle-classic",
            "username": "{{ user `opc_username`}}",
            "password": "{{ user `opc_password`}}",
            "identity_domain": "{{ user `opc_identity_domain`}}",
            "api_endpoint": "{{ user `opc_api_endpoint`}}",
            "source_image_list": "/oracle/public/OL_7.2_UEKR4_x86_64",
            "persistent_volume_size": 15,
            "image_name": "Packer_Builder_Test_{{timestamp}}",
            "dest_image_list": "Packer_Builder_Test_List",
            "ssh_username": "opc",
            "shape": "oc3"
        }
    ],
    "provisioners": [
        {
            "type": "shell",
            "inline": ["echo hello"]
        }
    ]
}
```
